"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

require("../_global/inject-global-style");

var _react = _interopRequireDefault(require("react"));

var _icons = _interopRequireDefault(require("../icons"));

var _colors = _interopRequireDefault(require("../colors"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var red = _colors.default.red,
    green = _colors.default.green;
var ArrowUpOutlined = _icons.default.ArrowUpOutlined,
    ArrowDownOutlined = _icons.default.ArrowDownOutlined;
var ARROW_COLORS = [red.primary, green.primary];

var CustomTrend = function CustomTrend(_ref) {
  var children = _ref.children,
      flag = _ref.flag,
      reverseColor = _ref.reverseColor,
      rest = _objectWithoutProperties(_ref, ["children", "flag", "reverseColor"]);

  return /*#__PURE__*/_react.default.createElement("div", _extends({
    className: 'pcb-trend',
    flag: flag
  }, rest), /*#__PURE__*/_react.default.createElement("span", null, children), flag === 'up' && /*#__PURE__*/_react.default.createElement(ArrowUpOutlined, {
    style: {
      color: reverseColor ? ARROW_COLORS[1] : ARROW_COLORS[0]
    }
  }), flag === 'down' && /*#__PURE__*/_react.default.createElement(ArrowDownOutlined, {
    style: {
      color: reverseColor ? ARROW_COLORS[0] : ARROW_COLORS[1]
    }
  }));
};

var _default = CustomTrend;
exports.default = _default;