"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

require("../_global/inject-global-style");

require("./style.css");

var _react = _interopRequireDefault(require("react"));

var _result = _interopRequireDefault(require("antd/lib/result"));

var _icons = _interopRequireDefault(require("../icons"));

var _colors = _interopRequireDefault(require("../colors"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var red = _colors.default.red,
    green = _colors.default.green,
    gray = _colors.default.gray;
var CheckCircleFilled = _icons.default.CheckCircleFilled,
    InfoCircleFilled = _icons.default.InfoCircleFilled,
    WarningFilled = _icons.default.WarningFilled,
    CloseCircleFilled = _icons.default.CloseCircleFilled;

var Custom403 = function Custom403() {
  return /*#__PURE__*/_react.default.createElement("svg", {
    width: "323",
    height: "162",
    viewBox: "0 0 323 162",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, /*#__PURE__*/_react.default.createElement("path", {
    d: "M86.8 118.32H73.04V142H49.52V118.32H0.72V101.52L50.8 27.76H73.04V99.6H86.8V118.32ZM49.52 80.24C49.52 77.7867 49.5733 74.8 49.68 71.28C49.7867 67.76 49.8933 64.5067 50 61.52C50.2133 58.4267 50.3733 56.4 50.48 55.44H49.84C48.88 57.5733 47.8667 59.6533 46.8 61.68C45.7333 63.7067 44.4533 65.7867 42.96 67.92L22 99.6H49.52V80.24ZM318.847 53.36C318.847 61.2533 316.447 67.5467 311.647 72.24C306.954 76.9333 301.141 80.1333 294.207 81.84V82.32C303.381 83.3867 310.314 86.16 315.007 90.64C319.807 95.12 322.207 101.147 322.207 108.72C322.207 115.333 320.554 121.307 317.248 126.64C314.047 131.867 309.034 136.027 302.207 139.12C295.487 142.107 286.794 143.6 276.127 143.6C263.754 143.6 252.767 141.52 243.167 137.36V116.88C248.074 119.333 253.194 121.2 258.527 122.48C263.967 123.76 268.981 124.4 273.567 124.4C282.207 124.4 288.234 122.907 291.647 119.92C295.167 116.933 296.927 112.72 296.927 107.28C296.927 104.08 296.127 101.413 294.527 99.28C292.927 97.04 290.101 95.3867 286.047 94.32C282.101 93.1467 276.554 92.56 269.407 92.56H260.767V74H269.567C276.607 74 281.941 73.36 285.567 72.08C289.301 70.6933 291.807 68.88 293.087 66.64C294.474 64.2933 295.167 61.6267 295.167 58.64C295.167 54.5867 293.887 51.44 291.327 49.2C288.874 46.8533 284.714 45.68 278.847 45.68C273.407 45.68 268.661 46.64 264.607 48.56C260.661 50.3733 257.301 52.1867 254.527 54L243.327 37.36C247.807 34.16 253.034 31.4933 259.007 29.36C265.087 27.2267 272.287 26.16 280.607 26.16C292.341 26.16 301.621 28.56 308.447 33.36C315.381 38.0533 318.847 44.72 318.847 53.36Z",
    fill: gray[8]
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M213.625 73.4062H202.867V37.9687C202.867 26.7838 193.802 17.7188 182.617 17.7188H143.383C132.198 17.7188 123.133 26.7838 123.133 37.9687V73.4062H112.375C109.575 73.4062 107.312 75.6685 107.312 78.4687V139.219C107.312 142.019 109.575 144.281 112.375 144.281H213.625C216.425 144.281 218.687 142.019 218.687 139.219V78.4687C218.687 75.6685 216.425 73.4062 213.625 73.4062ZM134.523 37.9687C134.523 33.0803 138.494 29.1094 143.383 29.1094H182.617C187.506 29.1094 191.477 33.0803 191.477 37.9687V73.4062H134.523V37.9687ZM207.297 132.891H118.703V84.7969H207.297V132.891ZM158.57 110.9V119.285C158.57 119.981 159.14 120.551 159.836 120.551H166.164C166.86 120.551 167.43 119.981 167.43 119.285V110.9C168.736 109.963 169.71 108.635 170.214 107.108C170.717 105.581 170.723 103.934 170.23 102.404C169.738 100.873 168.772 99.5389 167.473 98.5921C166.174 97.6453 164.608 97.1352 163 97.1352C161.392 97.1352 159.826 97.6453 158.527 98.5921C157.228 99.5389 156.262 100.873 155.77 102.404C155.277 103.934 155.283 105.581 155.786 107.108C156.29 108.635 157.264 109.963 158.57 110.9Z",
    fill: red.primary
  }));
};

var Custom404 = function Custom404() {
  return /*#__PURE__*/_react.default.createElement("svg", {
    width: "326",
    height: "172",
    viewBox: "0 0 326 172",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, /*#__PURE__*/_react.default.createElement("path", {
    d: "M86.8 113.32H73.04V137H49.52V113.32H0.72V96.52L50.8 22.76H73.04V94.6H86.8V113.32ZM49.52 75.24C49.52 72.7867 49.5733 69.8 49.68 66.28C49.7867 62.76 49.8933 59.5067 50 56.52C50.2133 53.4267 50.3733 51.4 50.48 50.44H49.84C48.88 52.5733 47.8667 54.6533 46.8 56.68C45.7333 58.7067 44.4533 60.7867 42.96 62.92L22 94.6H49.52V75.24ZM325.887 113.32H312.127V137H288.607V113.32H239.807V96.52L289.887 22.76H312.127V94.6H325.887V113.32ZM288.607 75.24C288.607 72.7867 288.661 69.8 288.767 66.28C288.874 62.76 288.981 59.5067 289.087 56.52C289.301 53.4267 289.461 51.4 289.567 50.44H288.927C287.967 52.5733 286.954 54.6533 285.887 56.68C284.821 58.7067 283.541 60.7867 282.047 62.92L261.087 94.6H288.607V75.24Z",
    fill: gray[8]
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M243.784 143.529L200.163 99.9078C206.932 91.1566 210.594 80.457 210.594 69.2031C210.594 55.732 205.336 43.1008 195.829 33.577C186.322 24.0531 173.657 18.8125 160.203 18.8125C146.749 18.8125 134.084 24.0699 124.577 33.577C115.053 43.084 109.812 55.732 109.812 69.2031C109.812 82.6574 115.07 95.3223 124.577 104.829C134.084 114.353 146.732 119.594 160.203 119.594C171.457 119.594 182.14 115.932 190.891 109.18L234.513 152.784C234.64 152.912 234.792 153.014 234.959 153.083C235.127 153.152 235.306 153.188 235.487 153.188C235.668 153.188 235.847 153.152 236.014 153.083C236.181 153.014 236.333 152.912 236.461 152.784L243.784 145.478C243.912 145.35 244.014 145.198 244.083 145.031C244.152 144.864 244.188 144.684 244.188 144.504C244.188 144.323 244.152 144.143 244.083 143.976C244.014 143.809 243.912 143.657 243.784 143.529ZM186.809 95.8094C179.688 102.914 170.248 106.828 160.203 106.828C150.159 106.828 140.719 102.914 133.597 95.8094C126.492 88.6875 122.578 79.2477 122.578 69.2031C122.578 59.1586 126.492 49.702 133.597 42.5969C140.719 35.4918 150.159 31.5781 160.203 31.5781C170.248 31.5781 179.704 35.475 186.809 42.5969C193.914 49.7188 197.828 59.1586 197.828 69.2031C197.828 79.2477 193.914 88.7043 186.809 95.8094Z",
    fill: red.primary
  }));
};

var Custom500 = function Custom500() {
  return /*#__PURE__*/_react.default.createElement("svg", {
    width: "318",
    height: "156",
    viewBox: "0 0 318 156",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, /*#__PURE__*/_react.default.createElement("path", {
    d: "M41 66.04C47.9333 66.04 54.12 67.3733 59.56 70.04C65 72.7067 69.2667 76.6 72.36 81.72C75.56 86.84 77.16 93.1867 77.16 100.76C77.16 113.133 73.32 122.893 65.64 130.04C57.96 137.08 46.6 140.6 31.56 140.6C25.5867 140.6 19.9333 140.067 14.6 139C9.37333 137.933 4.78667 136.387 0.84 134.36V113.56C4.78667 115.587 9.53333 117.347 15.08 118.84C20.6267 120.227 25.8533 120.92 30.76 120.92C37.9067 120.92 43.3467 119.48 47.08 116.6C50.92 113.613 52.84 109.027 52.84 102.84C52.84 91.32 45.2133 85.56 29.96 85.56C26.9733 85.56 23.88 85.88 20.68 86.52C17.48 87.0533 14.8133 87.5867 12.68 88.12L3.08 83L7.4 24.76H69.32V45.24H28.52L26.44 67.64C28.2533 67.32 30.1733 67 32.2 66.68C34.3333 66.2533 37.2667 66.04 41 66.04ZM317.687 81.88C317.687 94.1467 316.354 104.653 313.688 113.4C311.127 122.147 306.914 128.867 301.047 133.56C295.287 138.253 287.501 140.6 277.687 140.6C263.927 140.6 253.847 135.427 247.447 125.08C241.047 114.627 237.847 100.227 237.847 81.88C237.847 69.5067 239.127 58.9467 241.687 50.2C244.247 41.4533 248.461 34.7333 254.327 30.04C260.194 25.3467 267.981 23 277.687 23C291.341 23 301.421 28.1733 307.927 38.52C314.434 48.8667 317.687 63.32 317.687 81.88ZM261.847 81.88C261.847 94.8933 262.967 104.707 265.207 111.32C267.447 117.827 271.607 121.08 277.687 121.08C283.661 121.08 287.821 117.827 290.167 111.32C292.514 104.813 293.687 95 293.687 81.88C293.687 68.8667 292.514 59.0533 290.167 52.44C287.821 45.8267 283.661 42.52 277.687 42.52C271.607 42.52 267.447 45.8267 265.207 52.44C262.967 59.0533 261.847 68.8667 261.847 81.88Z",
    fill: gray[8]
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M158 9.75C120.31 9.75 89.75 40.3102 89.75 78C89.75 115.69 120.31 146.25 158 146.25C195.69 146.25 226.25 115.69 226.25 78C226.25 40.3102 195.69 9.75 158 9.75ZM158 134.672C126.709 134.672 101.328 109.291 101.328 78C101.328 46.7086 126.709 21.3281 158 21.3281C189.291 21.3281 214.672 46.7086 214.672 78C214.672 109.291 189.291 134.672 158 134.672Z",
    fill: red.primary
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M150.688 104.812C150.688 106.752 151.458 108.612 152.829 109.983C154.201 111.355 156.061 112.125 158 112.125C159.939 112.125 161.799 111.355 163.171 109.983C164.542 108.612 165.312 106.752 165.312 104.812C165.312 102.873 164.542 101.013 163.171 99.6418C161.799 98.2704 159.939 97.5 158 97.5C156.061 97.5 154.201 98.2704 152.829 99.6418C151.458 101.013 150.688 102.873 150.688 104.812ZM154.344 87.75H161.656C162.327 87.75 162.875 87.2016 162.875 86.5312V45.0937C162.875 44.4234 162.327 43.875 161.656 43.875H154.344C153.673 43.875 153.125 44.4234 153.125 45.0937V86.5312C153.125 87.2016 153.673 87.75 154.344 87.75Z",
    fill: red.primary
  }));
};

var CustomResult = function CustomResult(_ref) {
  var children = _ref.children,
      status = _ref.status,
      className = _ref.className,
      rest = _objectWithoutProperties(_ref, ["children", "status", "className"]);

  var icon = rest.icon;
  return /*#__PURE__*/_react.default.createElement(_result.default, _extends({}, rest, {
    className: className + String(status) === 'success' ? 'ant-result-success' : String(status) === 'error' ? 'ant-result-error' : String(status) === 'info' ? 'ant-result-info' : String(status) === 'warning' ? 'ant-result-warning' : String(status) === '404' ? 'ant-result-404' : String(status) === '403' ? 'ant-result-403' : String(status) === '500' ? 'ant-result-500' : 'ant-result-info',
    icon: String(status) === 'success' ? /*#__PURE__*/_react.default.createElement(CheckCircleFilled, {
      style: {
        color: green.primary
      }
    }) : String(status) === 'error' ? /*#__PURE__*/_react.default.createElement(CloseCircleFilled, {
      style: {
        color: red.primary
      }
    }) : String(status) === 'info' ? /*#__PURE__*/_react.default.createElement(InfoCircleFilled, null) : String(status) === 'warning' ? /*#__PURE__*/_react.default.createElement(WarningFilled, null) : String(status) === '404' ? /*#__PURE__*/_react.default.createElement(Custom404, null) : String(status) === '403' ? /*#__PURE__*/_react.default.createElement(Custom403, null) : String(status) === '500' ? /*#__PURE__*/_react.default.createElement(Custom500, null) : icon || /*#__PURE__*/_react.default.createElement(InfoCircleFilled, null)
  }), children);
};

var _default = CustomResult;
exports.default = _default;