"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.itemRender = exports.default = void 0;

require("../_global/inject-global-style");

require("./style.css");

var _react = _interopRequireDefault(require("react"));

var _pagination = _interopRequireDefault(require("antd/lib/pagination"));

var _button = _interopRequireDefault(require("../button"));

var _icons = _interopRequireDefault(require("../icons"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

var ArrowLeftOutlined = _icons.default.ArrowLeftOutlined,
    ArrowRightOutlined = _icons.default.ArrowRightOutlined;

var itemRender = function itemRender(current, type, originalElement) {
  if (type === 'prev') {
    return /*#__PURE__*/_react.default.createElement(_button.default, {
      icon: /*#__PURE__*/_react.default.createElement(ArrowLeftOutlined, null)
    });
  }

  if (type === 'next') {
    return /*#__PURE__*/_react.default.createElement(_button.default, {
      icon: /*#__PURE__*/_react.default.createElement(ArrowRightOutlined, null)
    });
  }

  return originalElement;
};

exports.itemRender = itemRender;

var CustomPagination = function CustomPagination(props) {
  return /*#__PURE__*/_react.default.createElement(_pagination.default, _extends({
    itemRender: itemRender
  }, props));
};

var _default = CustomPagination;
exports.default = _default;