"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var UnSvg = function UnSvg() {
  return /*#__PURE__*/_react.default.createElement("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    xmlnsXlink: "http://www.w3.org/1999/xlink",
    width: "1em",
    height: "1em",
    viewBox: "0 0 640 480"
  }, /*#__PURE__*/_react.default.createElement("defs", null, /*#__PURE__*/_react.default.createElement("rect", {
    id: "a",
    width: "640",
    height: "480",
    x: "0",
    y: "0",
    rx: "48"
  })), /*#__PURE__*/_react.default.createElement("g", {
    fill: "none",
    fillRule: "evenodd"
  }, /*#__PURE__*/_react.default.createElement("mask", {
    id: "b",
    fill: "#fff"
  }, /*#__PURE__*/_react.default.createElement("use", {
    xlinkHref: "#a"
  })), /*#__PURE__*/_react.default.createElement("use", {
    fill: "#D8D8D8",
    xlinkHref: "#a"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#4B92DB",
    d: "M-1 1h640v480H-1z",
    mask: "url(#b)"
  }), /*#__PURE__*/_react.default.createElement("g", {
    fill: "#FFF",
    fillRule: "nonzero",
    mask: "url(#b)"
  }, /*#__PURE__*/_react.default.createElement("path", {
    d: "M356.74 353.2a42.6 42.6 0 01-5.7 5.16c-12.72-13.2-27.72-27.72-41.94-27.72-8.82 0-15.12 6.72-22.56 11.4-10.26 6.6-24.36 10.32-36.42 5.46a39.72 39.72 0 01-17.52-12 38.16 38.16 0 0034.5 3c11.82-4.92 23.94-11.46 37.44-11.46 19.92 0 38.88 13.5 52.2 26.16zm-147.36-41.4c13.2 15 34.74 10.2 52.32 13.92 2.46.6 4.8 1.38 7.44.96-2.1-1.32-4.92-1.5-7.32-2.4-13.68-5.16-15.78-19.8-23.28-29.82 9.6 6.36 17.46 15 26.4 23.22a44.28 44.28 0 0022.02 9.72c-1.92.72-4.44.6-6.6 1.08-14.4 3.6-30.36 9.24-45.72 4.2a45.24 45.24 0 01-25.2-20.88h-.06zM188.26 277c8.22 18.66 28.92 20.16 42.6 31.56a38.4 38.4 0 008.1 5.52l.18-.12a59.7 59.7 0 01-9.06-9.9c-7.86-11.4-5.28-27-11.34-39.12a85.2 85.2 0 0113.86 20.94c5.1 12.12 6.84 25.98 18.3 35.22-12.42-4.08-26.7-3.3-37.8-10.56-11.76-7.68-22.62-19.8-24.84-33.48V277zm-8.82-37.68c1.2 16.44 18.6 25.2 27 38.7 1.8 2.88 3.6 5.88 6.18 8.16-.42-1.74-1.8-3.3-2.64-4.98a37.68 37.68 0 01-3.18-19.38c.78-8.4 4.26-16.2 2.94-25.02 7.2 15.54 4.86 34.92 9 51.66.96 3.72 3.18 6.96 4.56 10.5-7.02-5.4-16.26-10.2-24-16.2a51.3 51.3 0 01-17.4-21.9 50.94 50.94 0 01-2.46-21.54zm.48-30.24c.84-3.66 1.5-7.44 3.06-10.8-3 15.48 7.32 26.64 10.8 40.08 1.32 5.04 1.8 10.38 3.84 15.12.18.06.36-.12.48-.24-5.1-14.28 2.4-27.48 9.6-38.7a33 33 0 003.72-9.9c.78 6.48-.6 13.92-1.8 20.58-1.5 8.58-4.44 16.62-6.78 24.9a39 39 0 00-.3 16.44l-.78-.6c-5.4-9.96-16.08-17.76-19.26-28.68a61.56 61.56 0 01-2.58-28.2zm5.7-16.68a47.4 47.4 0 0111.4-30c.18-.12.36-.3.6-.24-7.56 11.4-.66 25.92-1.68 38.94l-.96 13.32c.12.12.12.54.48.36.48-1.5.6-3.06.84-4.62 1.8-10.8 11.28-18.24 19.26-25.8a17.1 17.1 0 004.2-6.24c-.66 5.4-2.16 10.86-4.56 15.72-6.18 12.48-18.06 22.56-20.22 36.78-1.02-13.62-9.36-23.76-9.36-38.22zm19.8-39.54a27.6 27.6 0 0113.2-8.76c-9.9 6.78-9.36 18.84-12.36 28.92-1.08 3.66-2.7 7.14-3.6 10.92l.3.24a32.4 32.4 0 018.1-11.94c6.9-6.48 17.28-10.44 20.7-19.98-.18 13.26-11.46 23.34-21.78 31.14a37.56 37.56 0 00-10.92 13.08c.36-3.6.6-6.72.24-10.26-1.08-11.58-1.8-24.6 6.18-33.36h-.06zm39.9-22.26c-7.26 6.42-12.12 14.64-17.76 22.02-4.62 6.18-11.04 9.96-16.5 15.12 3-6.12 3.48-13.2 7.26-19.14 6.42-10.2 17.1-14.16 27-18z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M281.38 353.2a42.6 42.6 0 005.7 5.16c12.72-13.2 27.72-27.72 41.94-27.72 8.82 0 15.12 6.72 22.56 11.4 10.26 6.6 24.36 10.32 36.42 5.46a39.72 39.72 0 0017.52-12 38.16 38.16 0 01-34.5 3c-11.82-4.92-23.94-11.46-37.44-11.46-19.92 0-38.88 13.5-52.2 26.16zm147.36-41.4c-13.2 15-34.74 10.2-52.32 13.92-2.46.6-4.8 1.38-7.44.96 2.1-1.32 4.92-1.5 7.32-2.4 13.68-5.16 15.78-19.8 23.28-29.82-9.6 6.36-17.46 15-26.4 23.22a44.28 44.28 0 01-22.02 9.72c1.92.72 4.44.6 6.6 1.08 14.4 3.6 30.36 9.24 45.72 4.2a45.24 45.24 0 0025.2-20.88h.06zm21.12-34.8c-8.22 18.66-28.92 20.16-42.6 31.56a38.4 38.4 0 01-8.1 5.52l-.18-.12a59.7 59.7 0 009.06-9.9c7.86-11.4 5.28-27 11.34-39.12a85.2 85.2 0 00-13.86 20.94c-5.1 12.12-6.84 25.98-18.3 35.22 12.42-4.08 26.7-3.3 37.8-10.56 11.76-7.68 22.62-19.8 24.84-33.48V277zm8.82-37.68c-1.2 16.44-18.6 25.2-27 38.7-1.8 2.88-3.6 5.88-6.18 8.16.42-1.74 1.8-3.3 2.64-4.98a37.68 37.68 0 003.18-19.38c-.78-8.4-4.26-16.2-2.94-25.02-7.2 15.54-4.86 34.92-9 51.66-.96 3.72-3.18 6.96-4.56 10.5 7.02-5.4 16.26-10.2 24-16.2a51.3 51.3 0 0017.4-21.9 50.94 50.94 0 002.46-21.54zm-.48-30.24c-.84-3.66-1.5-7.44-3.06-10.8 3 15.48-7.32 26.64-10.8 40.08-1.32 5.04-1.8 10.38-3.84 15.12-.18.06-.36-.12-.48-.24 5.1-14.28-2.4-27.48-9.6-38.7a33 33 0 01-3.72-9.9c-.78 6.48.6 13.92 1.8 20.58 1.5 8.58 4.44 16.62 6.78 24.9a39 39 0 01.3 16.44l.78-.6c5.4-9.96 16.08-17.76 19.26-28.68a61.56 61.56 0 002.58-28.2zm-5.7-16.68a47.4 47.4 0 00-11.4-30c-.18-.12-.36-.3-.6-.24 7.56 11.4.66 25.92 1.68 38.94l.96 13.32c-.12.12-.12.54-.48.36-.48-1.5-.6-3.06-.84-4.62-1.8-10.8-11.28-18.24-19.26-25.8a17.1 17.1 0 01-4.2-6.24c.66 5.4 2.16 10.86 4.56 15.72 6.18 12.48 18.06 22.56 20.22 36.78 1.02-13.62 9.36-23.76 9.36-38.22zm-19.8-39.54a27.6 27.6 0 00-13.2-8.76c9.9 6.78 9.36 18.84 12.36 28.92 1.08 3.66 2.7 7.14 3.6 10.92l-.3.24a32.4 32.4 0 00-8.1-11.94c-6.9-6.48-17.28-10.44-20.7-19.98.18 13.26 11.46 23.34 21.78 31.14a37.56 37.56 0 0110.92 13.08c-.36-3.6-.6-6.72-.24-10.26 1.08-11.58 1.8-24.6-6.18-33.36h.06zm-39.9-22.26c7.26 6.42 12.12 14.64 17.76 22.02 4.62 6.18 11.04 9.96 16.5 15.12-3-6.12-3.48-13.2-7.26-19.14-6.42-10.2-17.1-14.16-27-18z"
  })), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#FFF",
    fillRule: "nonzero",
    d: "M408 263l-2.1-1.2a96.9 96.9 0 01-17.9 25.4l-12.5-12.6a78.7 78.7 0 0014.7-21.3l-2.1-1.2a76.5 76.5 0 01-14.4 20.8l-11.4-11.4a60 60 0 0011.6-17.1l-2.1-1.2a58 58 0 01-11.2 16.6l-12.5-12.5a39.8 39.8 0 008-12.6l-2.1-1.2a37.6 37.6 0 01-7.6 12l-11.5-11.4a21.2 21.2 0 005.4-13h16.2a37.3 37.3 0 01-2.5 12.4l2.1 1.2a39.8 39.8 0 002.8-13.6h17.8a57.4 57.4 0 01-5 22.1l2.2 1.2a60 60 0 005.2-23.3h16.2a75.8 75.8 0 01-7.2 31l2.1 1.2a78.3 78.3 0 007.4-32.2h17.9a95.9 95.9 0 01-9.6 40.7l2.1 1.2a98.5 98.5 0 0010-43 98.7 98.7 0 00-7.2-37.1l-2.2 1a96.3 96.3 0 017 34.9h-17.9a78.5 78.5 0 00-5.5-28l-2.2 1a76 76 0 015.4 27H379a60 60 0 00-4-20.6l-2.2 1a57.6 57.6 0 013.8 19.6H359a39.9 39.9 0 00-2.4-12.6l-2.2 1a37.5 37.5 0 012.2 11.6h-16.2a21.2 21.2 0 00-5.4-13l11.5-11.5a37.3 37.3 0 017.9 12.8l2.2-.9a39.7 39.7 0 00-8.4-13.6l12.6-12.6a57.5 57.5 0 0112.2 19.2l2.2-1a59.9 59.9 0 00-12.8-19.9l11.5-11.4a76 76 0 0116.1 25l2.2-1a78.5 78.5 0 00-16.7-25.7l12.6-12.6a96.2 96.2 0 0120.5 31.3l2.2-1a98.7 98.7 0 00-21.8-32.8 98.6 98.6 0 00-33-21.9l-.8 2.3a96.2 96.2 0 0131.3 20.4l-12.6 12.6a78.5 78.5 0 00-25.2-16.4l-1 2.2a76 76 0 0124.5 16l-11.4 11.4a60 60 0 00-19-12.4l-.8 2.2a57.6 57.6 0 0118 11.8l-12.5 12.6a39.8 39.8 0 00-12-7.8l-.9 2.3a37.4 37.4 0 0111.2 7.2L333.2 204a21.2 21.2 0 00-13-5.4v-16.2a37.4 37.4 0 0113.3 2.9l.9-2.2a39.8 39.8 0 00-14.2-3.1v-17.8a57.6 57.6 0 0120.7 4.2l.9-2.2a60 60 0 00-21.6-4.4v-16.2a76.1 76.1 0 0127.5 5.6l.8-2.2a78.5 78.5 0 00-28.3-5.7v-17.9a96.3 96.3 0 0134.9 7l.8-2.3a98.716 98.716 0 00-36.9-7 98.31 98.31 0 00-44.2 10.4l1 2a96 96 0 0142-10v17.8a78.1 78.1 0 00-33.7 8.1l1.1 2a75.9 75.9 0 0132.6-7.8v16.2a59.7 59.7 0 00-25 6l1 2.1a57.5 57.5 0 0124-5.7V180a39.7 39.7 0 00-15.7 3.8l1 2a37.4 37.4 0 0114.7-3.4v16.2a21.3 21.3 0 00-7 1.6l1 2a19 19 0 017.2-1.3 18.9 18.9 0 0113.4 5.5A18.9 18.9 0 01338 220c0 10.493-8.507 19-19 19a18.9 18.9 0 01-13.4-5.6A18.9 18.9 0 01300 220a18.9 18.9 0 015.6-13.5 19 19 0 016.2-4.1l-1.1-2.1a21.4 21.4 0 00-6 3.8l-11.4-11.5a37.5 37.5 0 019.9-6.7l-1.1-2a40 40 0 00-10.5 7L279 178.3a57.8 57.8 0 0114.8-10.3l-1-2a60.4 60.4 0 00-15.4 10.7L265.9 165a76.3 76.3 0 0119.3-13.6l-1-2a79 79 0 00-20 14l-12.6-12.7a96.6 96.6 0 0124.3-17.2l-1.1-2.1a99.5 99.5 0 00-44.5 44.8l2 1a96.6 96.6 0 0117.6-24.8l12.7 12.7a79 79 0 00-14.5 20.7l2 1.1a76.3 76.3 0 0114.1-20.2l11.5 11.4a60.3 60.3 0 00-11.3 16.5l2 1.1a57.6 57.6 0 0111-15.9l12.6 12.6a40 40 0 00-7.8 11.8l2.1 1.2a37.4 37.4 0 017.3-11.3l11.5 11.4a21.3 21.3 0 00-5.4 13.1h-16.2a37.5 37.5 0 012.8-13.2l-2-1.2a39.7 39.7 0 00-3.2 14.4h-17.8a57.5 57.5 0 015.2-22.9l-2-1a59.7 59.7 0 00-5.6 23.9h-16.2a76 76 0 017.5-31.7l-2.1-1.1a78.1 78.1 0 00-7.7 32.8h-17.9a96 96 0 019.9-41.3l-2.1-1.1a98.292 98.292 0 00-10.2 43.6 99.25 99.25 0 004 27.9l2.3-.6a96.8 96.8 0 01-3.9-26.1h17.9a78.8 78.8 0 003.3 21.7l2.3-.6a76.4 76.4 0 01-3.3-21.1H259a60.3 60.3 0 002.8 17.2l2.4-.6a57.8 57.8 0 01-2.8-16.6H279a40 40 0 002.3 12.2l2.3-.6a37.6 37.6 0 01-2.2-11.6h16.2a21.2 21.2 0 005.4 13l-11.5 11.5a37.4 37.4 0 01-7.9-12.9l-2.3.6a39.7 39.7 0 008.6 14l-12.7 12.6a57.5 57.5 0 01-13.2-22.2l-2.4.6a59.8 59.8 0 0014 23.3L264.2 273a75.8 75.8 0 01-18.1-30.8l-2.3.6a78.2 78.2 0 0018.7 31.9L250 287.3a96 96 0 01-23.5-40.1l-2.4.6a98.3 98.3 0 0025 42 99 99 0 0027.3 19.4l1.2-2.1a96.4 96.4 0 01-26-18.1l12.6-12.6a78.7 78.7 0 0022.1 15l1.2-2a76.3 76.3 0 01-21.6-14.7l11.4-11.4a60 60 0 0018.2 12l1.2-2.1a57.6 57.6 0 01-17.7-11.6l12.6-12.6a39.7 39.7 0 0014 8.5l1.1-2.1a37.4 37.4 0 01-13.4-8.1l11.5-11.5a21.2 21.2 0 0013 5.4v16.2a37.5 37.5 0 01-11-2l-1.3 2a39.8 39.8 0 0012.3 2.4v17.8a57.5 57.5 0 01-21.1-4.4l-1.2 2a60 60 0 0022.3 4.8v16.2a76 76 0 01-30.3-6.8l-1.2 2a78.4 78.4 0 0031.5 7.2v17.8a96 96 0 01-40.2-9.3l-1.2 2a98.5 98.5 0 0042.6 9.7c15.8 0 31-3.7 44.6-10.6l-1.2-2.2a95.8 95.8 0 01-42.2 10.4v-17.9a78.3 78.3 0 0034-8.3l-1-2.1a75.7 75.7 0 01-33 8v-16a59.8 59.8 0 0025.6-6.4l-1.1-2.1a57.4 57.4 0 01-24.5 6v-17.8a39.7 39.7 0 0016.3-4l-1-2.2a37.3 37.3 0 01-15.3 3.8v-16.2a21.2 21.2 0 0013-5.4l11.5 11.5a37.7 37.7 0 01-9.3 6.3l1.1 2.2a40 40 0 009.9-6.8l12.6 12.5a57.9 57.9 0 01-14.3 10.1l1 2.1a60.2 60.2 0 0015-10.5l11.4 11.4a76.5 76.5 0 01-19 13.5l1.2 2.1a78.7 78.7 0 0019.5-13.9l12.5 12.6a96.9 96.9 0 01-23.9 17.1l1.2 2.2a99 99 0 0025.3-18.4A99 99 0 00408 263z",
    mask: "url(#b)"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#FFF",
    fillRule: "nonzero",
    d: "M324.7 197h-.6v.7h.6v-.7zm-1.5-1h.8v.6h-.8v-.6zm-1.4-.2l.6.1.1-.6h-.7v.5zm-.6-.2h-.7v-.7l.8.1-.1.6zm-5.8-.8h.8v.6h-.8v-.6zm-1.7 1.2l.7.1v-.6h-.6l-.1.5zm0 1l-.7-.3v-.6l.9.3-.2.6zm-1.4.7v-.6l.5-.1.1.6-.6.1zm-78.6 61.6v-.5h-.5v1h.8v1.3h.6v-1.5l-.9-.3zm7.5 9l-1-1-.9-1.1-.4-1-.7-1.8 1.5.8.5 1.4.7.5.7 1.5-.4.7zm20.7 27.1l-.1-.9-.9-1.2 1.3.2 1.2 1.1.6 1.3-.8.4-.3-.6-1-.3zm54-91.9h-1l-.3-2.2.6-.4v-1.1h-3.5v-1.1l.4-.3-.8-.3-.6.8-.2.9-1 .2v.5h-.7v1.3l-2.8 2.3-5.6-.2c-.3 1-1.3 0-1.3 0-.3-.7-1.6 0-1.6 0 0 1-2-.6-2-.6l-3.4-2.5c-2-1.8-5 .5-5.1 1 0 1.4-2.3.3-2.3.3s-2-.6-2.3.2c-.3.8-1.6.6-1.6.6l-.2.4-1 .2-.2.6-1.2.2h3c.8-.2-.3 1.7-.8 1.6H279l-.5.6h-1.3l-.6.8-1.9-.1s-1 .9-1 1.2c.1.3-.2 1.2-.5 1.2s-.9 1-.7 1.2c.2.3-.6 1.3-.6 1.3l-.2 1-.6.3v2.7l-1.2.8v1.2l-1.8 2 .2 1.5-1.5 1.7.2 1.6-.9.3-.2.7-.4 2.1 1 .1c.5-.2.4 1.3 0 1.6-.4.2-1.5.6-.9 1s-1.6.3-1.6-.3c0-.7-1.2-1.2-1.5-1-.3.2-.8-.9-.8-.9-1-1-4.4.1-4.4.1l-.5 1.7c-1.1.1-1.8 2-1.8 2-1 .3-1.6 1.4-1.3 1.7.3.3-.5.4-.5.4v2.2l-.5.7v2.5c.7 0 .6 1 .6 1-1 .2-.8 1.5-.8 1.5l-2.1.7-.4.6h-2.6l-.7.6-.7-.7h-5l-.2-.5-1-.2v-1.1h-1.6l-.3.7-1.6.1c.1 1-1.6 2.5-1.8 2.1-.2-.4-1.3-1.5-.8-1.7a13 13 0 011.8-.4v-.7l-3.7-.1-.4.6-1.5.1v1.6l-.7.2c-.5.3.1 1.4.1 1.4.7.7 0 1.9 0 1.9-.7.6.4 1.7.4 1.7.8.2-.5.8-.5.8.2 1 .8 1.3.8 1.3-.6 1 .4 1.5.4 1.5l.1 1.7.7.4v1.2l.4.7h1.6v-2.6c-1.5-1.6 1.1-2 1.2-1.4.1.6 1.2 1 1.2 1 .2 1.5 2 2.4 2.4.8.5-1.5 1-.6 1.2.1.3.8 2.2 2.5 2.2 2.5h1.5l.2 1.4c1.7-.1 2.2 0 2.9 2.4a4.4 4.4 0 002.6 3l1.4-.1c0-1.3 1.4.2 1.4.8 0 .6 2.7 2.9 2.7 2.9l2.7.6 2.5 2 1.9-.2h.8c.5-1.7 2.9.1 3 .7.2.6 1.8 1.7 2 1.2.2-.5 1.3-.2 1.5 1.3.2 1.5 1 1.2 1 1.2l5.6-.1 2-1.7 5.1-.1c2.6-.1 1-3.7.5-3.7-.9-.7.3-3.6.3-3.6l-7.3-6.8c-1.7 0-.2-2.4-.2-2.4 1.3-.8-.3-2.2-.3-2.2.2-1.2-.7-2.6-.7-2.6-1.8-1.2-1.3-3.5-1.3-3.5V246c-1.5-1.4.6-1.6.6-1.6.7-1.2-.5-2.1-.5-2.1V241l-1.7-.2-.2-4.8-3.6-5.1c-.7-.2-.2-1.5-.2-1.5 1-.5-.2-1.7-.2-1.7v-2.2l2-.2.5-.8h1v-2.6c.4-1.4 1.6-.7 1.6-.7l1.4.1.8-1.5.2-1.2h-1c-1.3-.8-.7-3.4-.7-3.4 2-2.9 4.1-1.2 4.1-1.2l1.4-.1c2.1 1.4.2 4 .2 4-.4.6-.2 2.5-.2 2.5l.5 3.3-1.3 1c-1 .7-1 2.1.1 2.4.8.1.5 2-.7.7-1.8 0 1 1.6.2 1.2 1.8 1 1.4-.8 1.4-.8l2.4-1.9c1-.7 2.5 1.5 2.5 1.8 0 .3 4 .1 4 .1 1 .7 1.5 2.6 1.5 2.6 1-1.5 3.4-.1 1.7.7 1.6 1 1.6 1.9 1.6 1.9 1.3-.4 1.3.6 1.3.9l.4-1.5c-1.5-1.1 2-1.5 1 .5l-.6.9 1 .8v2.3c2.3-.2 1.7-2.9 1.7-2.9l1-.2c0-1 .7-.4.7-.4-.7-3.4 1.6-4 1.6-4 1.3-.4 1.4-3.1 1.4-3.1-1-.4-.4-1.8.6-.6 1 1.2-.6-2.4-.6-2.4l-.8-.7-1.1-.1-.1-1.1h-1.8l-.3 1.4-.7.2-.2-.4-.3 1H295l-.1-1.1 1-.3.5-.6.3-1.7h1.3l1.7-.5c0-1.7 1-1.3 1-1.3l.6.5.9.7v.6l-.5.3-.1.8.3 1.2h.7c.3-1.7 2.4-1.7 3-.6l.6-1.5c-1.4-.7 0-1.8.4-1.3s1.3-1.3 1.3-1.3.7 1 0-.3c-.7-1.2.5-1.8.5-1.8-.2-1.2 1.3-1 1.3-1l.1-1.7h-1.4c-.3 1.4-1.5.1-.9-.2.6-.3 1.2-.9 1.2-.9v-1l.6-.2.1-1h1.5l1.3-.6.3-.5 1.4-.1 2-1.8-.2-.8c-1.2 0 0-1 0-1l.2-1.5z",
    mask: "url(#b)"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#FFF",
    fillRule: "nonzero",
    d: "M275.7 223.6l-1.8-.2.1.7h.5c.8 1.4.1 4.8.1 4.8s-1.2.1-1.4-.5c-.2-.6-.7 1.3-.3 1.7.4.3 1.8 0 2 1 0 1.2.8-.6.8-.6v-7 .1z",
    mask: "url(#b)"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#FFF",
    fillRule: "nonzero",
    d: "M275.7 232.2l.6-.1.1-.7-1.5 1-1-.6v2.4l1.6 2.1.6-1.4.2-.9-.7-.3.1-1.5zm.8 6.4v-1h-.7v.9l.7.1zm-.9 4.8v-.7l-.8.1v.7l.8-.1zm1.2-3.1a.45.45 0 000-.9.4.4 0 00-.4.5c0 .2.2.4.4.4z",
    mask: "url(#b)"
  }), /*#__PURE__*/_react.default.createElement("circle", {
    cx: "277.5",
    cy: "242",
    r: "1",
    fill: "#FFF",
    fillRule: "nonzero",
    mask: "url(#b)"
  }), /*#__PURE__*/_react.default.createElement("circle", {
    cx: "277.5",
    cy: "230.4",
    r: "1",
    fill: "#FFF",
    fillRule: "nonzero",
    mask: "url(#b)"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#FFF",
    fillRule: "nonzero",
    d: "M311.4 215.5l-1-.1-.3.5h-.5v.8h.5l.1.6-.4.4-.2.5-.8.2-1.8 1.7v.8l-.6.7-.6 1.6h-2l-.5 1.9.3 1.5 1.8.7.2-1 .6-.3.1-1 .4-.7.6-.7.2-.8 1-.6 1.2-.3.5-.6.2-1.2v-.9l.5-.6 1.2-.5v-2h-.6l-.1-.6zm2.8 6.9v-1.5l-.2-1.3-1.5-.7-1 1-.3 1.4v1l-1 .2-.2 2.7-.8.3.1 1-1 .3-1.2.3-.2 1.3-.8.5-.4 1.3-.5 2.9s1 1.7 1.4.9c.5-.8 1.3-1 1.3-1l.3-.6h2.7c.2-1 1.5-.6 1.5-.1s1 0 1 0l.7-1h1.1l.1-1.3.5-.3V228c1.6-.5 1.4-2 1.4-2l.4-.5-.2-.7c-.8-.3-.4-1 .1-.8.5.2-.7-1-.7-1-.6.6-1-.5-1-.5h-1.6v-.1zm1.6 12.2c0 1.2-1.6 1.6-1.6 1.6l-1-.3-.7-.5V234l.8-.1.2.6 2.3.1zm5.4-6.5c.2 1 .2-1.4.6-1.3.4.1.1-1.4.1-1.4l-1.8 1.3c.9.1 1 1 1.1 1.4zm5.3-5.2c.4.9.3 2.2 1.8 3.2.5.3-.3 1-.8.7a15 15 0 01-2-2.5V223c.4-.8.8-.5 1-.1zm.3 31l.3.5.7-1-.6-.3-.7.5.3.3zM324 252v1.2-1.2zm14.4-1.4l.8-.5-.3-.6-.8.5.3.6zm28.9 21l.9.5v1.7c1.3 1.2 5.2.2 5.2-.1l-.2-3.8-.5-.5-.1-2.5c.4-1.3-2-3.2-2.1-2.8-.2.4-1.5 0-1.5.5 0 .4-.8 2.4-.4 3.1.4.7-.3.7-.4 1.4-.1.7-1.1 2-1 2.6l.1-.1zm-2.2-4c-.2.8-1 1.2-1.3 1-.4-.4.5.4.7.8.2.4.8.4 1 0 .2-.4 0-1.3.3-1.7.2-.4-.6-.5-.7 0v-.1zm-4.7-18.6h.7v2h-.7v-2zm10.4-19.4c-.5-.6 2-1.7 2.4-.4.4 1.2 0 1-.4.9-.4-.1-1.4.3-2-.5zm2.1-13.6v.6l1 .2.1-.6-1.1-.2zm-4.5 1.6l.8.5h.3l.6-.4v.2l.6-.2-.2-.5v-.3l-.4.1-.7.5-.7-.5-.3.6zM374 193h-1.5s.5.2-1-1.1c-1.3-1.3-2.2.3-2.2.3l-1.6.2v1.6l-.8.3v1h1.2s0 1.1.3.6c.3-.5 2.8.1 2.6 1.4-.1.5 2.5 1.8 2.2 3.4 1.3.2 1 1.5 1 1.5l1.7.2.5-1 .5.1v-.6l-1.1-.3-.2-3.3-.7-.5.2-.8-.8-.3.4-1.3-.7-1.4zm4.3 10.3h-.8l-1.8.2-1 2s.5.3 1 1c.3.7.5 4.8-.7 5.5-1.2.7.1.3.1.3l-.2 2.3c.3 1 .8.5 1.1 0 .3-.5.6-.6 1-1.1.4-.5 1-1.5 1.1-2.2.1-.7.6-1.8.3-2.1-.3-.3.3-1.7.3-1.7s.4-.8 0-1.6.1-1.8.4-2.2l-.8-.4zm1.2 4.2l.1-.8h.6v.8h-.7zm0 2.8l-.5-.3.3-.6.5.3-.3.6zm-.9-8l-.4-1s0-.8.2-1.2c.2-.4-.4-.8-.7-1-.3 0-.2-.8-.3-1.2 0-.4-.8-.7-.8-.7l-.2-1.9c0-.3-.9-.7-.6-1l.8-.9c.3-.2-.3-1.6.2-1.3.5.3.5.8.7 1.2.2.4 0 1.8.4 2.1.5.3 0 1.4.7 1.4.8 0 .3 1.9.3 1.9s-.2 1.4.3 1.5c.5.1.2 2.5.2 2.5l-.8-.5v.1zm-6.4-16.5c.3.4.9.7.9 1.1 0 .4-.2.7.4.8.6.1 1 0 1.2.4.2.5.2 1.4 0 1.8 0 .4.2 1 .7 1 .5 0 .6 0 .6.4 0 .3.6-1.1.6-1.1-.5-.4-1-1.3-1-1.3l-.4-1.7c0-.2-.7-.4-1-.5-.3 0-.8-1-.8-1l-1.2.1zm1-.9c-.3-.4-.6-.7-1-.9-.4-.2-.7-.4-1.1-.4a.7.7 0 01-.6-1c.2-.4-.3-.6-.3-1s.3-.4.8-.1c.5.3.4.4.8.9s.6 1 1 .9c.4-.1.7.9 1 .6.5-.3.4.7.4.7l-1 .3zm-11.7 11.4c.5.6-3 .4-3 0s.3-1.8 1.2-1.5c.9.3 1-1.8 1-1.8s-.8.1-.1-.3c.7-.4 0-1-.3-1.3l-.6-.8h1.4c.6-.4.8-2.3.8-2.3 1.2.4 1.8-.5 1.8-.5l.6 1.2c.4.5-1 .7-.5 1 .5.3.7 1.2.5 1.5-.2.3-1.3 0-1.3-.3s-.4.5 0 1-.5 1.2-.7 1.2c-.2 0-1.5.2-.4.8 1 .6 2.3.3 2.3.3s.9 0 1.2.4c.3.5-.1.6-.6.6l-3-.2s-.6.7-.3 1zm-6.4 1c.5-.1 1.7-.2 2 0 .1.4-.8.8-.8.8l-1.2.2c-.4-.5-.5-1 0-1zm12.9-8.5c.8-.4 2.5-.4 2.4-1-.1-.7 1-.9 1-.9l.3 1.2.9.7v1l-.7.2c-1.1.3-.4.8-.4.8H369l-.3-1-.8-1h.1zm-4-5.5c.7 0-.1 2.3 1.5 2.1 1.6-.2 0 .7 1.3.8 1.2.1.9-.9 1.3-1.6.4-.7.2-1.1-.5-1.3-.7-.2-.7-.2-1-1-.1-.8-1-1-1-1l-.2-1.2-1.3.8-1.3 1.7c0 1.3.7.7 1.3.7h-.1zm2.7 8.5l.3-.6.6.3-.3.6-.6-.3zm-1-1h.6v.8h-.6v-.8zm.5-13.4v.9h-.5l-.1-.8.6-.1zm-1.7 9.4h.6v.5h-.6v-.5zm-1.6 0v-.6h1v.5l-1 .1zm-8.2 9.8l-.6-.3.3-.7.6.3-.3.7zm-3.2-1.9v-.6h1v.5l-1 .1zm-17.3-.2l-2.2.1v.6h2.3l-.1-.7zm-3.6.9l-.2-.9.6-.1.2.9-.6.1zm-.4.6l-.2-.5.3-.1.2.5-.3.1zm5-1.7l-.1.7 1 .1s.5.4.5.7c0 .3.7.6 1.1.6.4 0 1.5-.8 1.5-.8s.5-1.4.1-1.3c-.4.1-1.2.7-1.3.1 0-.6-1.3-.3-1.3-.3l-1.6.2h.1zm5-1c0 .2-.3.6.3.7.6.1 1.7-.4 1.8.2.1.6.1 1 1 1.3a5 5 0 001.8.4l2-.2s1.3.3 1.6.5c1.1 1.2 1.8 1.5 2.1 1 .3-.5 0-1.7-.2-2 0-.5-1.5-2.4-2-2-.5.4-.6 0-1.5.3s-2.8.1-2.9-.3c0-.4-1.5-.6-1.5-1s-1-1-.9-.3c.1.6-.7.9-.9.7-.2-.2-.8.6-.8.6l.1.1zm22.9-13l.7-2.3c-1-.2-.8-1.3-.8-1.3-.1-1-1.5-2-2-1.6-.5.3-.3-2.1-.3-2.1s.9-.6 1.3-.3-3.4-5.1-4.2-4.6c-.8.5-2.6-.5-2.5-1.4.1-1-3.6-4-3.6-4s-1.2-.8-1.4-.2c-.2.6-.6 1 0 1.4.6.3.5-.5 1.2.2s2 1.6 1.5 2.2c-.5.6-1 .8-1 .8l.6.8h1.1l.2 1.7s1.2.6 1.5 1.3c.3.7.3 1.1 0 1.6-.3.4-.9 1-.8 1.8.1.7 1 1 1 1h.7l.6.4v1.3c.8-.2 2.1 1 2 1.6 0 .7.2.3 1.2 1s.7.8 1.4 1.4c.7.5 1.3.2 1.6-.8v.1z",
    mask: "url(#b)"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#FFF",
    fillRule: "nonzero",
    d: "M346.5 166.6c0-.4-.3-1.8.3-1.7.6 0 .2 0 1 .3s.7-.5.7-.5h1.1l1.4 1-.2 1h-1c-.5-.7-1.5-.4-1.3.3.2.7-.5 2-.9 2.1-.4.1-1.7.1-1.6-.5l.5-2zm-.8-2.7v-.9s0-.8-.6-.8-1.4-.6-1.2-1c.2-.4-1.7-.8-1.7-.8s-1.7-1.6-1-1.4c.5.2.2-.7.2-.7s-1.2.2-1.5 0c-.3 0-.2-1-.2-1s-1.2-.2-1.2 0 .4.4.6 1c.2.6.1 1.6 1 1.8 1 .2 1.1.4 1.2.8.1.4 1.2.5 1.2.5l.8.4 2.4 2v.1zM335 153.5l-.3-.8-.8-.2v1h1.1zm-.3-4.2c-1-.8 1.4.6 1.4.6.8 0 1.3.6 1.3.9 0 .3 1 .2 1 .2l.1-.7-.8-1-.7-.5s-1-.1-1-.4c0-.3-1 1.2-1.4.9h.1zm18.3.6c-.3.9-.4 2.1-.9 2.1s-.3 1.3-.3 1.3l1.7.1c.4.1.4 1.1.4 1.1 1.5 0 2.1 2 2 2.5-.3.5.5.5.5.5s0 1.6-.2 2c-.2.4 1.3.7 1.7 1.3.4.6-.2 2.6-.5 2.7-.3.2.8.5.7 1-.1.5.3 0 .4.8l.3 2.5 1.4.1c.2-1.3 2.8-1.4 3.2-1.2 1.7.6 3 3.2 3 3.8 0 .6-1.1.7-1.1.7l.2 3c1.7.5 3 3 2.9 3.3-.2.4 1.2.3 1.2.3.2-1.8 1.9-1.2 2-.6 0 .6.4 2 .4 2l.5.8.7.7h1l.4.6 1.2.2s1.1 1.2 1.2 1.5c.1.3 1.6.2 2 .3.4 0 1 .4 1.1.9.1.5.7 1.3.7 1.3s1.2.3 1.3.7l.6 1.3 1 .8.1 1h1.1l.3 1.3 1.8-.1 1-.7a6 6 0 002.3-2c.1-.5.3-2 1.3-1.7 1 .3.3-2.2.3-2.2s-1.4-1-1.3-1.5c.1-.5-1.4-1.5-1.3-2 .1-.3-1.3-1.2-1.2-1.6.1-.4-.7-1.5-.7-1.5L386 176l-.2-1h-1.2l-2.4-3 .1-.8h-.7V170l-.7-.4h-1l-2.3-2.5-.2-1.1h-1l.2-2.1c.7-1 .3-2.7.3-2.7s-1.4.7-2.1.4c-.7-.3.3-1 .3-1v-.8l-.6-.6s-1.7.2-1.8-.1l-.4-1.6-.1-1.7-.7-.3-.1-.7-1.1.1v-1.2l-.6-.2-.6-.3-.1-1.2-2.2-.1-.7-1-.8-1.2-2.5-.2-.6-.6-1-.2-.7-.3-.3.5h-2v.7c-1 .5-5 0-5 .4l-.2-.1zm10.5-2.7c-.2-.7 2-1.5 2.5-.9s1.9.7 2 3.8c.1 1-1.7-1.1-1.7-1.1l-1.5-.5c-.8-.2-1.2-.7-1.3-1.2v-.1zm-29.3 1.3l-.5-.3.4-.9.5.3-.4.9zm-5.1-10l-1.3-1.3v-1l-.4-.5-.4-1.4-1.3-.4-1.3.5-1.4.9-1.5.2-.8 1 3.2.2.6 1 2.3.2 1.5 1.5c1.3.5 1.6-.2.8-.9zm-.2-5c-.2-.8-1.5 1.2-.2 1.6 1.3.4 2.6 0 2.6 0l.3-.6 5 .1c.4-.4.6-1 .6-1s1.2-.4 1.7-.2 0-1.4-.4-1.2c-.5.2-1.5 0-1.5 0h-1.8c-.1-.6-1.7-.3-1.8 0-.1.5-.7.6-.7.6l-2.3.2c-.2.6-1.4 1-1.5.6v-.1zm-9.9 17.2c1.5.5 2.1 0 2.2-.3.1-.4.2-.5.8-.6.6-.1-.1-1.3-.7-1.2-.6 0-1.2-.2-1.3-.7-.1-.6-1.1-1.9-1.2-.9-.1 1-.7 1-.6 1.8.1.7.4 1.7.8 1.9zm-11.5 1.1c0-.4 2-.4 2.3-.1.3.3.1.8 1 .8s.5.6.4 1c0 .2-1 .1-1.2-.2 0-.3-1.6-.4-1.6-.4s-.8-.6-.9-1.1zm34-21.7l-.8.6-.5-.5-.5.5.7.7.2.2.2-.2 1-.8-.3-.5zm-5.5-1.8l-.7-.4-.3.5.8.5h.3l1.1-.7-.3-.5-.9.6zm-3.3 20.8h-.1l-1-.1v.6h.8l.6 1 .5-.3-.7-1-.1-.2zm-33 28.2l.1 1.1h1.5c.6 0-.5-.7-.5-.7s-1.2.1-1-.4h-.1zm2 0l.3-.4.6.5-.4.4-.5-.5zm-18.2-18.9l.4-.4.6.6-.4.4-.6-.6zm29 130.3l-1-.5-.3.5.6.3-.2.2.4.5.5-.5.3-.3-.3-.2zm-7.8-7.3l-.4-.5-.6.5-.3.3.4.2.7.5.3-.5-.4-.3.3-.2zm74.2-19.2c-.1-.5-.7-.7-.8-.8l-.2.6.2.1.1.5-.1.2.4.4c.4-.3.5-.7.4-1zm1-2h-1v-.9l1 .2v.7zm23-7.8c.5-.3 1-.8 1 .4-.1 1.1-.6.7-1 1.1-.3.4-.6-1.1 0-1.5zm5.1-4.3a.8.8 0 010-.1 1.6 1.6 0 00-.2-.7l-.5.3.1.4c0 .2 0 .4.2.5.1.1.2.1.4 0l-.1-.5.1.1zm-1.3.5l.4 1.2.5-.2a11.9 11.9 0 01-.3-1.2l-.6.2zm-2.2 2.4h-.6c0 .4 0 1 .5 1l.2-.5-.1-.5zm-2.6-12a.6.6 0 00-.4-.5c-.4-.2-1.1.1-1.5.4l.3.5c.4-.3.9-.4 1-.4l.6-.1v.1zm-27.7-32.4c-.4.4-1.3.6-1.3.6l-.3 1-.4.5v1c0 .7-1 1.1-1 1.1l-.4.5h-2.7c-1-.4-.3-1.6.3-1.5.6.1-.1-1.7-.1-1.7l.8-.1s0-1.8.4-1.8c.3 0-.1-.6-.5-1-.4-.3-1-1.3-1.3-1.2h-2l-.3.6-1.1.2-.1 1c-.6.8-3 2.3-2-.2l.4-.7v-.9h-1.8s-1-.4-1-.8v-.9l-2.1-2.3-2.5-.3-.2-.5-1.5-.2c-1.8-1-3.4-.1-3 1.4.2 1.5.7 2.1-.3 2.1s-1.2-.8-1.2-.8-.8-.3-.8.1-.3 1.2 0 1.6c.3.4-.4 1-.7.7-.3-.3-1-1.2-.9-1.5.2-.3-1.4-2.2.2-2.5 1.6-.3 0-1.2.5-1.4l.8-.4h.8l.5-.4-1.3-.2-.8-.1-1.5-.1a4.2 4.2 0 00-1.8 2.2c-.8 1.5-2.7-.6-2-1.4.7-.8-2.2-.1-2.7.3s-2 .2-2 .2c-.3.9-1.7-.1-1.3-.7.4-.6.4-1 .4-1l-.5-.2-.6 1.2c-1.3 0-1.7.8-1.5 1.3.3.5-.4-.1-.6.6-.1.7.2.7.7 1 .6.3-.3.3.1.8s1.6 0 1 .7c-.8.7-2.1.4-2.1.4-.1 1-2 .7-2.2.4l-1.7-2.1-2-.1c-.1-1.4 1-.7 1.4-1.8.4-1.1.6-3 .6-3s-1.6 0-1.7.4c-.1.5-1.1.9-1.1.9s-.8.3-.5.7c.3.4-.6.6-.6.6s.1.6-.1.9c-.8.8-2.8 0-3.1-.2l-1.2-.5-1.2-.8-1.4.6-.4.4h-1.5l-.1 1.2 2.7.3.2 2.5-1.1-.4h-.7l-.3-.6h-.6v2.1l.6.5.5.5 1 .1.2 1.3h2.5l.3.6h1.5l2.9 3-.2 1-.5.2c.2.7-1.3.3-1.3.3v.6l.7.1.7.4 1-1.7c1-.7 1.6.3 1.7 1 0 .5-.5.4-.5.4v1.5l.6.2c1 1.2-.4 1.9-.4 1.9l-.3 1c-.3.9-1.4.7-1.4.7l-.4.6-1.2.3 2.4.3c.2-.8.8-1 1-.6.4.4.4 1.1.4 1.1l.6.1-.1 1.1.6.2v3.3l.7.8c1.2-.5 1.2.3.6.7-.6.4-.2 2.2-.2 2.2l-.5.5v.8l-.6.4v1.2c-1-.5-2.2-.3-2.5 0-1-.6-2.8-.4-2.8 0 .6.9-.7 1-.7 1l-.7.9c.5 1-.5 1.1-.5 1.1v2l-1.2 1v2.7c0 .7 1.6.8 1.9.4.3-.4 1.5.8 1.5.8h.9l.2-1.8-.6-.3v-3l1-1c1.2-.5.8 2.5.8 2.8 0 1.2.6 1 1 .8 1-.4.3 1.2-.5 1-.8 0-.3 1-.3 1l.5.3-1 .7-.7.9-1-.3-1.2-.1-.4-.7-.7-.1-.1 1.4-.5.6-1.2 1.2c1.6 0-.2 1.1-.6 1.1.9.3-.1 1.2-2.4.5v.7l-.8.1.7.9h.8l-.3 1.8c0 1.3-3.3.4-3.6 0v2h-.7l.1 1.2v1.7l1-.2v.7l2.7.1 3.9-4.1 2.3-.5c.2-1 1.2.2 1.2.2 1-.1 1.2.6 1.2.6l1.3.2c1 .3.4.4.5.8 0 .6.6.4.6.4l.2-1.3.6.1-.6-.7-1.1-.5-1.2-.5c-.8-1.1.2-1 1-.8h1.3s1.5 2 1.5 2.5.7.6.7.6h.9l.3.6h.9l.3.6h1.8v-.9l-1.6-.3-.1-1-1.2-.3c-.4-1.7.3-2.2.8-1.4h.6l-.2-1.4.7-.2-.2-2.2-.6-.2v-.7l2.5.1c-.2-1.3 0-1.9 0-1.9h.8v.5l3.1.3 2.2-2.5c-.1-.2.2-.3 0-.5-.4-.3-.8 0-1.3-.3s0-2 0-2.5c-.2-.4 1.6-1 1.3 0-.3.8 0 1.3 0 1.3 1.3-1.3 2.4 0 2.3.4 0 .3.7.6 1.2.3s1.1.9 1 1.5c-.3.6-2 .5-2.2-.1 0-.6-.4-.4-.6-.1-.2.3-1 .5-1.6.2a.5.5 0 01-.1-.2l-2.2 2.5h.1c1.2.7.6 1.6.2 1.8-.4.2-1 .2-1 .2l-.3.4-2.6.2-.2 1c-1.2-.1-1.7 1.3-1.4 2 .3.7 0 1.3 0 1.3l1 .5 1.5-.4c.2-1 1-1.2 1.8-1.8.8-.6 2.1 1 1.7 1.9-.4.8-.4 1.1-.4 1.1l.1 1-1 .3-.8.4v.5h-2.8l-.4.5-1.3.1-.4.7h-1s-1.4.8-.8 1.6c.6.8-2.5.7-3.2-.4-.2 1-1.3 0-1.3 0l-1.1-.2-.1-1.5c-.2-1-2.1-1-2-.3 0 .7-3.6.3-3.6.3l-1.2.5-1.1.7-.1.5-1.8.2-.8.4-.3-.6h-.8l-.8 1c-2 .2-4 1.4-3.9 2 .2.4-.8 1-.8 1l-.9.2-.6 1-1.2.3-.2 2.2-.6.4v.9l-.7.2v.5h-1l.6 1.6.8.4c1.4.2.8 2 .8 2h.8l.4 1.1.8 1.7c.3 1.2 1.2.9 1.6.8.4-.1.8 1.2.8 1.2l4 .1s-.2.4.5.6c.7.2 5.3.4 5.5.1-.2-.9 2.5-1.1 3.6-.3 1 .8 2.6.3 2.6.3l1.5 1.8 1 2.3 1.7.5 1.2.3.4 1.7h.9l.3 1.2c1 .8-.3 2.5-.3 2.5v2.3l.8.4-.1.8 1.3 1.3h1.5l3.7 4.1 3 1 .5 1.6.8-.1.6-.5 2.4-.1 1.2-1.2 1.3-.2 11-9.4-1-.6v-2.2c1.9-1.3 2-3.7.3-3.9-1.3-.1-.7-1.5.5-1.7l.7-.3v-.9l2.3-2.1v-1.6l-5-4.2c-2.2-.8 0-5.7 1.5-5.6 1.5.1-.1-7.4-.1-7.4l-.8-.4.2-2.5h-1.1l-1.8 2.4-.5 1.6c-.2 2.1-6.4 1.7-6.7 1.4-.3-.3-2.4-1.2-2.4-1.2s-1.6-1.3-1.9-1c-.3.5-1.7-.4-1.7-.1 0 .3-1.3-.8-1.3-.8l-2-.7 1.5-.3-.3-1.2 2.6 1.3c.3.4 1.6.3 1.6.3l.4.5s.8 0 1.3.5c.5.7 3.1.2 3.1.2l.7.6 1.1.4h3.1l.1-1.9.6-.6v-1.2l.6-.6v-1l.6-.2.1-2.2.5-.1v-4.9l-1.5-1.4c-.1.5-1.7.5-1.7.5s-.4.7-.7.7c-.3 0 .4 1 .2 1.5-.2.6-1 .6-1 .6l-1.5.4-.4.5h-1.6l-.2-1.3 1.8-.5 1-.5.5-1c.1-1 1.3-.9 1.3-.9s2.3-2 2.4-2.8c.1-1 .9-3.5 2.3-3.5h2.6c1-.4.7-1.7.7-1.7l1.3-.2.2.7s1.8.2 2 0c.2-.4.6-1 1-.8.6.3 2.2-.7 2.2-.7 0-.7 2.6-.4 2.6-.4l.3-1s-1.7-2.3-2-2.3c-.3 0-2-1.4-2.1-.9-1.6-.4-1.5-2.6-1.5-2.6l-.6-1.4c0-.8-1.5-2.5-1.8-2.3a1.5 1.5 0 010-2.6c.4 0 1.4-1.5 1.4-1.5l.5-1.4 1.7-.5.2-1.3-1-.1s1-1.9 1.6-1.9c.6 0 3.8 0 4-.2.4-.2 1-1.8 1-2 0-.4.8-.5 1-.6.4 0 1-.9 1.3-1.3.2-.4-.5-3-1-2.5z",
    mask: "url(#b)"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#FFF",
    fillRule: "nonzero",
    d: "M319 243c.1 0 .3.5.6.4.3 0 .5.6.1.6-.2 0-.2.3-.2.5 0 .1 0 .5-.3.8-.2.2-.4 0-.7-.1-.3-.2-.5-.2-.9-.2-.3 0 0 .6 0 .6s-1.6 0-1.3-.3c.3-.2.6-.3.4-.4-.2-.2 0-.3 0-.6s.7-.2.5-.4c-.2-.2 0-1.1.4-.6l.2-.5c-.2-.3 0-.3-.5-.5s-.1-1-.1-1v-.7c.2-.7 1.7-.8 1.8-.1v1.1l.5.2s-.1.4-.5.4 0 .2-.2.5l.2.4v-.1zm-5 .8c.3-.4.8-2.4 1.4-1.8.6.6 1 0 1 0s.3.3.1 1c-.1.5-.3 1.1-.6 1.2-.4 0-.7.3-1.2.4-.4 0-.6-.8-.6-.8h-.1z",
    mask: "url(#b)"
  }), /*#__PURE__*/_react.default.createElement("rect", {
    width: "640",
    height: "480",
    stroke: "#FFF",
    strokeOpacity: "0.3",
    strokeWidth: "80",
    mask: "url(#b)",
    rx: "48"
  })));
};

var _default = UnSvg;
exports.default = _default;