"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var PeSvg = function PeSvg() {
  return /*#__PURE__*/_react.default.createElement("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    xmlnsXlink: "http://www.w3.org/1999/xlink",
    width: "1em",
    height: "1em",
    viewBox: "0 0 640 480"
  }, /*#__PURE__*/_react.default.createElement("defs", null, /*#__PURE__*/_react.default.createElement("rect", {
    id: "a",
    width: "640",
    height: "480",
    x: "0",
    y: "0",
    rx: "48"
  })), /*#__PURE__*/_react.default.createElement("g", {
    fill: "none",
    fillRule: "evenodd"
  }, /*#__PURE__*/_react.default.createElement("mask", {
    id: "b",
    fill: "#fff"
  }, /*#__PURE__*/_react.default.createElement("use", {
    xlinkHref: "#a"
  })), /*#__PURE__*/_react.default.createElement("use", {
    fill: "#D8D8D8",
    xlinkHref: "#a"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#D91023",
    fillRule: "nonzero",
    d: "M0 0h640v480H0z",
    mask: "url(#b)"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#FFF",
    fillRule: "nonzero",
    d: "M213.3 0h213.4v480H213.3z",
    mask: "url(#b)"
  }), /*#__PURE__*/_react.default.createElement("g", {
    mask: "url(#b)"
  }, /*#__PURE__*/_react.default.createElement("g", {
    fill: "#00A854",
    fillRule: "nonzero",
    stroke: "#D4AF37",
    strokeWidth: "0.5"
  }, /*#__PURE__*/_react.default.createElement("path", {
    d: "M325.74 159.195c3.707.69 7.487 1.529 10.541 3.583 4.81 3.404 7.786 9.12 7.431 15.18-.408 5.072-2.318 10.071-5.506 14.412a21.817 21.817 0 01-11.982 8.05c-1.786.462-3.628.66-5.435.863-.678.307-.658 1.227.05 1.21 6.319-.285 11.429-3.43 16.067-7.726 2.24-2.362 3.991-5.092 5.146-8.02 1.857-4.296 2.794-9.034 1.779-13.373-1.429-6.451-6.595-11.734-13.29-13.326a40.481 40.481 0 00-5.292-.984l.498.126-.007.005z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M320.647 201.338c-.63.331-.397 1.357.202 1.138.267-.265.278-1.298-.21-1.133l.008-.005zm4.08-42.843c-.57-.155-1.154.473-1.614.359-.494-.12-.062-.566-.447-.645-.37-.089-.639.253-1.16.14-.508-.11-.403-.56-.804-.6-.417-.05-.275.251-.78.147-.504-.104-.664-.756-1.254-.927-.573-.162-.752-.682-.292-.857.3-.118.555.053 1.008-.118.457-.164.453-.525.867-.465.402.058.405.579.89.733.484.154.485-.2.866-.045.386.161.317.41.66.666.341.256.75-.194 1.26.195.508.383.807 1.412.807 1.412l-.008.005z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M325.496 159.156c-1.518-1.466-4.41-2.477-7.25-2.745 1.636.065 5.026.54 7.374 2.647l-.124.098h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M322.462 157.342c-.433.008-.657.162-.91.287.213-.155.414-.313.747-.378l.163.091zm-1.927-.531c-.39.12-.557.33-.763.529.155-.212.303-.42.592-.568l.176.045-.005-.006zm.473.022c-.4-.265-.574-.536-.779-.805.158.262.31.529.602.788l.177.017zm1.763.552c-.396-.258-.57-.528-.779-.804.163.268.314.535.613.79l.166.014zm13.381 5.84c-.742.189-1.266.816-1.86.975-.641.17-.285-.619-.767-.477-.488.147-.508.86-1.174 1.056-.661.202-.889-.36-1.405-.158-.519.213-.165.778-.815.982-.642.2-1.074-.455-1.845-.276-.748.165-1.146-.324-.665-.821.328-.333.844-.357 1.334-.841.49-.484.145-.906.662-1.09.513-.19.766.477 1.4.33.635-.148.631-.865 1.145-.925.517-.054.426.612.92.685.507.075.477-.522 1.224-.397.752.132 1.846.956 1.846.956h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M337.171 163.464c-2.773-.602-6.073.05-9.605 1.553 1.984-.962 6.283-2.65 9.868-1.695l-.263.142z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M333.007 163.34c-.52.278-.74.597-1 .905.194-.312.382-.62.77-.907l.23.001zm-2.517.604c-.428.388-.566.739-.746 1.106.12-.347.225-.686.52-1.053l.226-.053zm.572-.275c-.574-.05-.893-.255-1.235-.445.293.212.567.427 1.015.54l.22-.095h0zm2.33-.476c-.567-.054-.879-.264-1.228-.45.289.25.634.434 1.015.54l.213-.09zm11.376 13.478c.286-.688.04-1.425.258-1.976.227-.585.707.094.865-.371.167-.453-.444-.834-.223-1.462.22-.627.848-.528.976-1.04.117-.514-.589-.525-.379-1.137.206-.618 1.045-.626 1.334-1.326.297-.686.97-.756 1.118-.124.1.43-.18.853-.05 1.49.14.637.702.573.57 1.078-.145.504-.882.363-1.132.944-.25.581.392.932.13 1.382-.248.44-.776.024-1.148.385-.36.363.178.632-.377 1.176a6.592 6.592 0 01-1.942.981h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M343.961 177.36c2.175-1.897 3.565-4.865 4.342-8.427-.332 2.071-1.394 6.34-4.37 8.706l.028-.28h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M346.548 174.115c.057-.56-.087-.896-.21-1.265.154.32.323.632.352 1.08l-.142.185zm.96-2.309c-.087-.54-.32-.82-.532-1.15.235.269.477.514.615.938l-.086.206.004.006zm-.096.594c.387-.435.753-.578 1.124-.762-.355.127-.713.236-1.08.538l-.048.218.004.006zm-.962 2.095c.379-.43.745-.573 1.116-.757-.356.127-.713.236-1.076.545l-.04.212h0zm-3.408-5.642c.154-.715-.233-1.38-.117-1.96.114-.614.714-.04.795-.512.07-.474-.61-.736-.517-1.384.105-.646.754-.672.775-1.19.02-.517-.677-.403-.594-1.035.09-.637.919-.789 1.086-1.531.161-.72.817-.9 1.084-.307.178.39-.022.855.234 1.446.252.602.809.43.769.95-.044.514-.807.51-.944 1.122-.13.606.57.836.397 1.312-.173.475-.778.166-1.074.58-.291.421.298.592-.152 1.218-.451.627-1.742 1.29-1.742 1.29h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M342.37 169.669c1.8-2.234 2.62-5.357 2.714-8.963.062 2.068-.183 6.407-2.689 9.245l-.025-.282z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M344.32 166.05c-.043-.55-.253-.844-.447-1.177.217.271.44.538.557.976l-.103.197-.007.005zm.517-2.414c-.19-.503-.476-.738-.746-1.012.281.21.578.412.793.795l-.047.217h0zm.019.595c.31-.49.638-.691.97-.934-.328.184-.655.357-.965.716l-.005.218zm-.558 2.207c.3-.473.631-.687.964-.93-.329.185-.655.358-.966.717l-.005.218.007-.005zm-4.74.115c-.819.006-1.55.552-2.212.56-.704.023-.1-.739-.643-.707-.542.033-.785.787-1.525.834-.745.042-.807-.637-1.395-.547-.591.101-.42.803-1.142.848-.72.045-.968-.776-1.804-.778-.828-.008-1.083-.646-.43-1.057.426-.275.973-.17 1.626-.563.649-.4.181-.528.767-.588.593-.084.878.554 1.577.57.697-.001.919-1.031 1.463-.962.545.069.249.773.737.98.488.209.654-.44 1.387-.11.734.33 1.595 1.52 1.595 1.52h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M340.53 167.075c-2.657-1.376-6.261-1.535-10.35-.831 2.342-.52 7.27-1.233 10.667.739l-.316.092z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M336.288 165.843c-.617.174-.944.46-1.302.728.296-.284.588-.575 1.061-.778l.241.05zm-2.765.01c-.568.3-.81.652-1.102.99.22-.338.428-.677.848-.995l.25-.002.004.007zm.672-.153c-.58-.205-.834-.518-1.139-.797.234.298.46.6.885.839l.25-.049.004.007zm2.538.09c-.573-.21-.83-.51-1.131-.801.237.304.452.604.889.845l.242-.044h0zm4.74.388c.005-.722-.522-1.296-.532-1.878-.013-.617.716-.182.682-.655-.03-.466-.754-.587-.795-1.232-.04-.646.605-.792.52-1.296-.086-.505-.76-.257-.8-.885-.044-.634.745-.946.75-1.697.005-.72.617-1.032 1.007-.508.263.343.16.83.538 1.352.377.521.897.26.96.762.066.507-.694.653-.694 1.268-.018.618.73.696.662 1.188-.068.492-.735.315-.942.785-.205.458.426.5.102 1.193-.324.694-1.462 1.596-1.462 1.596l.005.007z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M340.973 167.098c1.326-2.517 1.485-5.698.826-9.193.49 1.989 1.158 6.225-.736 9.461l-.086-.262-.004-.006z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M342.162 163.205c-.163-.511-.439-.762-.695-1.046.272.227.546.442.747.835l-.055.222.003-.011zm0-2.426c-.294-.455-.623-.626-.954-.832.335.148.654.287.959.614l-.006.218zm.147.568c.2-.53.49-.792.761-1.098-.287.25-.579.476-.801.89l.032.212.008-.004zm-.103 2.25c.193-.526.494-.786.759-1.087-.284.239-.576.465-.806.884l.047.202zm-7.72-3.312c-.1-.738-.726-1.257-.822-1.858-.098-.637.725-.281.626-.759-.096-.488-.871-.511-1.005-1.171-.134-.66.525-.899.362-1.41-.162-.511-.834-.162-.966-.805-.137-.649.655-1.085.556-1.852-.093-.742.51-1.15.989-.665.315.329.283.844.755 1.333.46.488.966.142 1.11.656.137.519-.633.763-.554 1.403.074.633.859.622.861 1.143-.001.514-.732.416-.876.92-.152.508.508.465.27 1.226-.244.754-1.312 1.844-1.312 1.844l.007-.005z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M334.088 161.298c1.027-2.77.752-6.074-.426-9.599.8 1.985 2.084 6.272.553 9.862l-.127-.263h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M334.789 157.132c-.248-.512-.564-.728-.872-.996.315.198.633.385.906.76l-.034.236h0zm-.348-2.51c-.372-.432-.744-.556-1.112-.74.356.117.723.216 1.083.516l.03.224zm.232.57c.132-.571.4-.884.653-1.234-.272.288-.542.564-.728 1.02l.075.213h0zm.21 2.328c.131-.57.399-.883.653-1.233-.27.294-.539.571-.724 1.027l.07.206z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M331.288 159.202c.029-.634-.868-1.185-.858-1.686.019-.554.656-.162.65-.578 0-.42-.468-.66-.477-1.223.002-.58.56-.52.51-.972-.06-.447-.373-.255-.39-.813-.004-.557.718-.827.764-1.482.044-.644.613-.908.95-.435.219.307.088.606.413 1.078.313.47.742.408.782.858.029.448-.598.526-.625 1.066-.042.55.353.5.266.93-.088.43-.408.402-.616.807-.203.411.429.778.104 1.389-.325.61-1.473 1.061-1.473 1.061h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M330.707 160.127c1.338-1.851 1.776-5.101 1.344-8.21.358 1.766.683 5.504-1.195 8.329l-.149-.119z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M332.053 156.59c-.121-.462-.357-.683-.573-.937.235.203.466.4.642.753l-.069.185zm.117-2.146c-.24-.405-.53-.564-.822-.758.288.14.587.265.84.56l-.018.198zm.116.503c.2-.465.48-.692.74-.953-.27.212-.548.41-.779.764l.032.194.007-.005zm-.195 1.993c.2-.465.476-.7.736-.96-.263.207-.542.405-.775.77l.034.183.005.007zm5.335 36.288c-.118-.764-.764-1.346-.88-1.962-.122-.658.725-.234.613-.73-.112-.498-.9-.588-1.05-1.274-.151-.687.511-.871.339-1.414-.187-.532-.853-.224-1.003-.893-.161-.67.623-1.054.511-1.841-.11-.77.488-1.136.989-.6.329.348.312.872.802 1.405.482.539.991.23 1.144.756.16.54-.62.736-.529 1.395.095.648.9.7.906 1.227.006.528-.727.375-.872.88-.136.498.539.51.307 1.267-.224.75-1.277 1.784-1.277 1.784h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M337.114 193.812c.986-2.754.557-5.716-.732-9.411.857 2.088 2.344 6.141.868 9.687l-.136-.276h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M337.66 190.035c-.265-.539-.595-.793-.913-1.092.322.24.657.454.933.865l-.02.227zm-.413-2.58c-.38-.474-.76-.63-1.15-.846.378.15.75.273 1.123.611l.034.23-.007.005zm.256.59c.12-.572.389-.866.628-1.207-.263.272-.54.536-.715.993l.09.221-.003-.006zm.279 2.406c.12-.572.385-.874.628-1.208-.262.272-.533.53-.712.982l.084.226zm5.192-17.597c-.849-.153-1.85.25-2.535.14-.731-.116.24-.76-.329-.833-.567-.073-1.174.636-1.946.536-.792-.096-.544-.778-1.193-.799-.641-.025-.79.715-1.55.617-.769-.092-.636-.953-1.493-1.119-.838-.169-.816-.846.05-1.134.567-.188 1.075.017 1.923-.25.864-.277.881-.848 1.512-.806.639.036.33.833 1.035.975.714.137 1.289-.588 1.817-.415.532.18-.102.812.3 1.113.411.313.873-.311 1.466.156.605.469.943 1.819.943 1.819z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M339.943 171.513c-.713.058-1.174.28-1.675.473.442-.22.864-.454 1.466-.571l.209.098zm-2.838-.522c-.727.198-1.136.5-1.597.787.39-.299.759-.601 1.338-.835l.252.052.007-.004zm.757-.022c-.495-.315-.616-.666-.795-1.008.106.342.181.686.512 1.004l.283.004h0zm2.562.58c-.488-.32-.61-.672-.788-1.014.106.343.185.693.516 1.011l.272.002h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M343.346 173.333c-2.092-1.872-5.335-2.506-9.85-2.591 2.643-.07 7.652-.043 10.215 2.56l-.365.03zm-.386 4.961c-.625-.419-2.01.083-2.526-.248-.543-.358.445-.78.019-1.038-.434-.253-1.157.372-1.753.029-.582-.353-.155-1.049-.678-1.262-.516-.218-.868.56-1.452.236-.58-.335-.188-1.26-.821-1.71-.618-.442-.36-1.205.418-1.259.526-.04.864.339 1.635.29.775-.042.983-.69 1.48-.45.491.243-.025 1.042.492 1.409.53.368 1.24-.276 1.615.08.356.358-.37.881-.145 1.343.225.462.802-.097 1.123.61.32.708.593 1.97.593 1.97h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M340.833 176.175c-.588-.153-1.34.023-1.81.103a5.356 5.356 0 011.672-.285l.142.189-.004-.007zm-1.795-1.167c-.28-.5-.265-.93-.29-1.372-.035.415-.081.828.078 1.285l.22.082-.008.005zm2.026 1.12c-.289-.495-.42-.634-.452-1.07-.035.414.077.538.236.995l.22.082-.004-.006z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M343.49 179.455c-1.051-2.729-4.275-4.561-7.865-6.008 2.137.713 6.983 2.395 8.164 6.086l-.3-.078z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M338.432 174.81c-.643.005-1.078.22-1.538.395.404-.214.811-.439 1.345-.531l.189.13.004.007zm-11.739-16.304c-.445-.366-1.235-.007-1.59-.3-.388-.31.183-.557-.119-.782-.302-.226-.68-.02-1.086-.327s-.127-.683-.47-.891c-.343-.208-.352.133-.754-.167-.402-.301-.272-.973-.723-1.364-.437-.371-.38-.93.095-.92.319.01.485.267.957.289.477.028.62-.316.955-.102.333.224.119.717.484 1.04.373.32.518.012.786.315.272.292.11.509.31.884.195.368.742.118 1.03.679.29.56.125 1.646.125 1.646h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M327.092 159.434c-.73-1.974-2.863-4.07-5.28-5.444 1.42.7 4.235 2.497 5.431 5.403l-.15.04z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M325.161 156.535c-.385-.162-.647-.115-.93-.1.253-.06.49-.13.82-.053l.11.153zm-1.49-1.26c-.393-.046-.634.082-.9.188.226-.136.446-.279.77-.31l.138.117-.008.004zm.412.2c-.24-.404-.284-.73-.36-1.074.04.32.059.625.208.986l.159.084-.007.005zm1.337 1.22c-.247-.4-.29-.727-.362-1.064.035.313.054.618.215.981l.147.083zm2.837 1.652c-.3-.45-.985-.429-1.24-.777-.27-.368.891-.976.67-1.254-.216-.271-.601-.06-.9-.427-.3-.368.057-.784-.208-1.033-.264-.25-.344.128-.639-.232-.29-.354-.38-.913-.696-1.371-.305-.457-.115-1.083.31-1.04.284.022.365.325.786.38.421.055.66-.333 1.023-.24.37.089.441.313.7.697.254.396.454.043.63.397.176.353-.028.587.065 1.022.088.428.646.162.768.82.13.654-1.262 3.053-1.262 3.053l-.007.005z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M327.933 159.526c.879-2.582.001-5.898-2.647-7.065 1.307.567 2.286 1.616 2.734 2.931.422 1.296.442 2.715.057 4.098l-.144.036z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M328.155 156.136a2.49 2.49 0 00-1.13-.346c.235-.057.787.072 1.069.17l.06.176h0zm-.845-1.957c-.356-.068-.597.059-.855.16.225-.136.46-.288.762-.305l.093.145zm.09-.039c-.123-.48-.084-.842-.067-1.235-.05.359-.1.718-.043 1.129l.11.106zm.86 2.012c-.126-.47.412-.62.691-.93-.257.165-.859.413-.817.834l.125.096h0zm-2.233 3.698c-.674.005-1.006-.817-1.543-.825-.575-.003-.331.568-.77.552-.43-.022-.564-.44-1.155-.468-.6-.025-.691.464-1.147.403-.46-.067-.167-.34-.752-.374-.58-.027-1.057.607-1.75.615-.689.014-1.113.503-.714.815.265.202.612.11 1.022.405.402.3.226.675.685.725.46.049.708-.503 1.286-.512.578-.008.423.334.906.275.483-.06.523-.337.999-.504.483-.172.7.407 1.419.149.715-.265 1.514-1.256 1.514-1.256h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M327.146 159.371c-2.29 1.103-5.806 1.354-8.946.849 1.76.386 5.566.826 9.028-.706l-.078-.136-.004-.007z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M323.09 160.418c-.449-.13-.62-.347-.832-.547.155.209.293.437.62.59l.212-.043zm-2.282.015c-.36-.234-.438-.501-.562-.758.063.259.125.517.36.768l.206-.003-.004-.007zm.501.116c-.541.162-.848.397-1.194.62.288-.232.576-.464 1.008-.65l.186.03zm2.132-.087c-.54.162-.852.39-1.198.614.292-.226.576-.465 1.008-.65l.19.036zm5.438.321c-.738.149-1.14-.702-1.739-.596-.628.125-.337.721-.811.794-.486.07-.649-.376-1.305-.279-.66.108-.734.688-1.243.707-.504.027-.19-.343-.84-.251-.649.091-1.129.914-1.908 1.08-.74.16-1.19.805-.736 1.072.302.179.677-.016 1.141.235.46.245.283.714.793.665.51-.05.755-.72 1.386-.856.643-.135.486.284 1.011.113.519-.166.562-.502 1.084-.792.518-.296.79.303 1.569-.152.776-.445 1.598-1.74 1.598-1.74h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M330.094 160c-2.472 1.743-6.331 2.803-9.806 2.924 1.95.05 6.169-.29 9.902-2.79l-.096-.134z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M325.673 162.066c-.497-.044-.694-.253-.935-.433.178.212.342.433.708.533l.227-.1zm-2.506.524c-.41-.184-.509-.466-.66-.732.087.28.155.563.44.78l.22-.048h0zm.56.012c-.586.303-.921.64-1.295.965.313-.323.621-.652 1.08-.958l.207-.002.008-.005zm2.339-.575c-.594.308-.921.64-1.291.972.308-.33.61-.654 1.08-.958l.207-.002.004-.012z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M331.155 161.565c-.739.196-1.197-.628-1.79-.48-.63.155-.286.736-.77.842-.476.102-.665-.336-1.322-.193-.658.144-.69.725-1.2.774-.506.055-.212-.33-.855-.195-.643.134-1.08.976-1.84 1.186-.754.205-1.155.875-.68 1.11.312.163.689-.061 1.162.156.478.224.339.687.844.613.505-.073.71-.756 1.335-.935.636-.177.506.252 1.022.05.509-.197.534-.53 1.034-.853.5-.322.817.248 1.563-.242.75-.502 1.497-1.833 1.497-1.833h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M332.322 160.71c-2.366 1.89-6.18 3.181-9.653 3.516 1.96-.078 6.171-.674 9.757-3.387l-.107-.118.003-.011z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M328.023 163.043c-.51-.016-.719-.209-.975-.38.193.202.372.414.744.491l.238-.116-.007.005zm-2.486.67c-.417-.162-.549-.431-.722-.684.113.273.207.548.5.743l.226-.053-.004-.007zm.562-.018c-.577.334-.88.689-1.237 1.04.296-.35.577-.69 1.027-1.026l.202-.009.008-.005zm2.31-.715c-.572.341-.88.689-1.236 1.04.3-.343.577-.69 1.03-1.02l.2-.015.006-.005zm-4.469 37.55c.303-.596.983-.932 1.236-1.412.27-.501-.518-.32-.302-.71.225-.379.886-.292 1.194-.816.307-.525-.178-.81.111-1.202.285-.398.75-.016 1.05-.536.301-.503-.23-.972.083-1.585.3-.603-.08-1.012-.63-.686-.364.226-.487.65-1.028.99-.53.342-.844-.016-1.118.385-.266.395.302.71.047 1.22-.25.516-.91.4-1.055.82-.146.42.48.437.458.872-.023.434-.566.318-.586.965-.028.653.54 1.696.54 1.696h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M323.965 201.41c-.037-2.402 1.168-5.073 3.202-7.803-1.255 1.528-3.604 4.852-3.384 8.005l.187-.195-.005-.007z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M324.624 197.906c.347-.382.676-.52 1.014-.69a3.014 3.014 0 00-.98.5l-.041.195.007-.005zm1.01-2.004c.441-.303.79-.36 1.155-.456-.334.048-.676.082-1.062.275l-.092.18zm-.355.434c.057-.494-.076-.781-.177-1.1.132.27.283.537.296.93l-.119.17zm-.873 1.879c.061-.488-.076-.782-.177-1.1.136.277.283.537.308.931l-.127.175-.004-.006zm.914 3.955c.816-.19 1.42-.916 2.08-1.089.702-.172.273.73.81.579.542-.162.605-.987 1.33-1.202.738-.214.968.45 1.54.22.567-.234.21-.9.924-1.118.714-.218 1.155.562 2.008.367.824-.177 1.24.404.686.967-.37.379-.936.407-1.487.958-.563.55-.206 1.038-.779 1.249-.573.21-.81-.579-1.52-.42-.696.15-.72.986-1.287 1.044-.571.051-.432-.72-.98-.824-.542-.098-.532.595-1.355.435-.815-.165-1.97-1.166-1.97-1.166z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M324.22 201.871c3 .773 6.646.093 10.567-1.566-2.215 1.073-6.985 2.935-10.866 1.731l.3-.165z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M328.769 202.122c.577-.317.834-.678 1.133-1.039-.238.359-.452.72-.887 1.048l-.246-.01zm2.77-.648c.49-.437.652-.849.855-1.26-.132.393-.26.792-.605 1.21l-.25.05zm-.63.314c.62.075.954.317 1.329.542-.307-.25-.607-.504-1.095-.647l-.242.11.007-.005zm-2.574.501c.617.069.955.318 1.33.543-.308-.25-.6-.51-1.095-.647l-.235.104zm-.417-2.699c.304-.597.983-.932 1.236-1.413.271-.5-.518-.319-.302-.71.225-.379.886-.291 1.194-.816.307-.525-.178-.81.111-1.201.285-.399.75-.017 1.05-.537.302-.502-.23-.972.084-1.584.298-.604-.08-1.013-.63-.686-.365.226-.487.65-1.03.99-.53.341-.843-.016-1.116.384-.266.395.301.71.046 1.22-.25.517-.909.4-1.055.82-.145.421.48.438.458.872-.022.434-.566.318-.586.966-.028.652.54 1.695.54 1.695h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M327.944 200.47c-.038-2.402 1.168-5.074 3.201-7.803-1.255 1.527-3.603 4.851-3.384 8.004l.187-.195-.004-.006z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M328.602 196.965c.348-.382.676-.52 1.014-.69a3.014 3.014 0 00-.98.5l-.041.195.007-.005zm1.01-2.004c.441-.303.79-.36 1.156-.455-.334.047-.677.081-1.063.274l-.092.18zm-.355.434c.057-.494-.076-.78-.177-1.099.132.27.283.536.297.929l-.12.17zm-.873 1.879c.061-.487-.076-.781-.177-1.1.137.277.283.537.308.931l-.126.176-.005-.007zm1.777 2.821c.816-.19 1.42-.916 2.08-1.089.702-.172.273.73.81.579.542-.163.605-.987 1.33-1.203.738-.214.968.45 1.54.221.567-.235.21-.9.924-1.118.714-.218 1.155.562 2.008.366.824-.176 1.24.405.686.967-.37.38-.936.408-1.487.959-.563.55-.206 1.038-.779 1.249-.573.21-.81-.58-1.52-.42-.696.15-.72.986-1.287 1.044-.571.05-.432-.72-.98-.825-.542-.098-.532.596-1.355.435-.815-.165-1.97-1.165-1.97-1.165z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M329.062 199.796c2.999.773 6.645.093 10.566-1.567-2.215 1.073-6.985 2.935-10.866 1.732l.3-.165z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M333.61 200.046c.577-.316.834-.678 1.133-1.038-.238.358-.452.72-.887 1.048l-.246-.01zm2.77-.647c.49-.437.652-.85.856-1.26-.133.392-.26.792-.606 1.21l-.25.05zm-.63.313c.621.075.954.318 1.329.543-.307-.25-.607-.505-1.095-.647l-.242.109.007-.005zm-2.574.502c.617.068.955.317 1.33.543-.308-.25-.6-.51-1.095-.648l-.235.105zm3.093-4.206c.764-.399 1.159-1.241 1.766-1.576.643-.36.468.612.955.317.483-.284.333-1.083.994-1.48.664-.392 1.068.17 1.57-.2.493-.365-.032-.904.622-1.298.653-.393 1.285.217 2.068-.185.768-.393 1.333.046.94.73-.263.448-.82.62-1.221 1.29-.402.67.077 1.042-.425 1.394-.511.338-.956-.336-1.617-.003-.65.334-.45 1.13-.996 1.332-.546.203-.614-.565-1.178-.519-.568.058-.377.71-1.224.77-.846.06-2.247-.576-2.247-.576l-.007.004z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M335.109 196.019c3.16-.077 6.574-1.681 10.01-4.288-1.906 1.602-6.116 4.624-10.256 4.521l.246-.233z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M339.66 195.045c.485-.443.642-.862.842-1.28-.136.405-.256.8-.59 1.22l-.248.067-.004-.007zm2.569-1.348c.36-.54.413-.976.504-1.417-.028.41-.048.815-.278 1.3l-.233.122.007-.005zm-.545.463c.63-.089 1.022.05 1.454.155-.373-.142-.733-.312-1.246-.317l-.208.162zm-2.41 1.161c.634-.1 1.03.046 1.455.155-.37-.154-.725-.317-1.246-.317l-.208.162zm-7.889 2.939c.156-.567.709-1.035.84-1.493.142-.492-.552-.13-.43-.506.121-.377.75-.484.917-1.002.17-.511-.337-.604-.164-1.014.189-.402.69-.222.858-.722.175-.504-.418-.729-.267-1.32.147-.58-.3-.805-.737-.384-.29.28-.303.662-.736 1.09-.42.43-.79.23-.948.63-.166.406.43.507.311.985-.122.489-.752.578-.804.966-.04.39.543.229.62.59.076.361-.46.418-.327.948.119.54.872 1.239.872 1.239l-.005-.007z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M331.58 198.676c-.569-1.966-.012-4.173 1.27-6.969-.822 1.585-2.286 4.666-1.387 7.175l.125-.21-.008.004z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M331.441 195.938c.245-.428.523-.627.795-.867-.27.193-.55.374-.802.694l.003.167.004.006zm.501-1.938c.337-.366.65-.512.972-.691-.302.13-.609.252-.918.517l-.054.174zm-.235.46c-.056-.411-.242-.618-.414-.853.196.191.39.364.492.682l-.078.171zm-.396 1.777c-.057-.411-.238-.612-.403-.851.184.189.38.362.491.682l-.088.169h0zm3.655-.957c.031-.598.497-1.169.534-1.66.033-.515-.606-.02-.563-.42.051-.407.677-.633.73-1.18.06-.553-.484-.557-.389-.991.099-.446.667-.356.73-.89.064-.546-.602-.658-.576-1.28.022-.613-.489-.759-.852-.255-.238.341-.168.725-.515 1.238-.343.501-.78.372-.852.81-.084.437.563.422.542.939-.014.513-.652.719-.615 1.115.04.403.61.139.77.483.16.345-.378.496-.134 1.02.247.513 1.183 1.076 1.183 1.076l.007-.005z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M335.262 195.659c-1.034-1.863-.945-4.197-.234-7.25-.506 1.754-1.345 5.123.142 7.496l.085-.241.007-.005z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M334.498 192.922c.163-.46.403-.717.634-1.005-.237.246-.487.472-.679.838l.045.167zm.097-2.031c.271-.437.557-.64.853-.877-.295.19-.574.37-.845.694l-.008.183h0zm-.156.501c-.136-.406-.38-.575-.604-.776.231.149.478.289.654.595l-.05.181zm.004 1.864c-.156-.403-.393-.577-.61-.783.237.156.472.294.655.595l-.045.188zm9.775-11.07c.388-.642.27-1.406.571-1.926.329-.557.68.197.913-.234.24-.435-.296-.91.019-1.505.323-.582.93-.385 1.132-.88.202-.494-.492-.616-.176-1.193.304-.578 1.12-.46 1.523-1.112.405-.634 1.073-.598 1.111.058.029.449-.323.825-.297 1.48.027.655.595.68.373 1.16-.222.479-.917.226-1.258.764-.337.543.224.994-.099 1.398-.327.397-.772-.1-1.19.207-.421.3.066.667-.565 1.11-.635.438-2.064.678-2.064.678l.007-.005z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M343.307 182.746c2.438-1.553 4.291-4.287 5.651-7.721-.668 2.017-2.424 6.098-5.721 8l.07-.28h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M346.38 179.916c.15-.545.054-.903.003-1.29.101.336.21.667.163 1.127l-.166.163h0zm1.32-2.157c.01-.549-.175-.868-.32-1.222.184.301.378.586.437 1.034l-.118.188h0zm-.186.586c.443-.38.822-.455 1.216-.588-.371.071-.732.126-1.138.37l-.082.211.004.007zm-1.294 1.935c.44-.367.821-.455 1.22-.58-.372.07-.74.13-1.15.367l-.07.213zm-6.568-16.12c-.1-.738-.727-1.258-.823-1.858-.098-.637.726-.281.622-.765-.103-.484-.871-.512-.994-1.17-.122-.659.518-.894.356-1.405-.163-.511-.834-.162-.971-.811-.126-.647.659-1.079.56-1.846-.093-.742.51-1.15.989-.665.316.329.283.844.75 1.327.465.494.972.148 1.115.662.137.519-.633.763-.554 1.403.075.633.86.622.862 1.143-.002.514-.732.416-.877.92-.151.508.509.465.27 1.226-.244.754-1.312 1.844-1.312 1.844l.007-.005z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M339.265 165.175c1.027-2.77.744-6.07-.434-9.594.8 1.985 2.084 6.272.55 9.855l-.124-.256.008-.005z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M339.958 161.014c-.24-.517-.563-.729-.872-.997.316.198.634.385.907.76l-.035.237h0zm-.335-2.509c-.373-.432-.749-.563-1.112-.739.356.116.722.216 1.082.516l.03.223zm.231.57c.132-.571.4-.883.65-1.24-.27.294-.54.57-.725 1.026l.075.214zm.21 2.328c.132-.57.4-.883.653-1.233-.269.295-.539.571-.724 1.027l.07.206z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M336.986 161.754c.001-.71-.514-1.283-.532-1.86-.012-.617.717-.182.683-.654-.027-.478-.758-.594-.8-1.24-.029-.643.613-.796.52-1.296-.078-.51-.76-.257-.8-.884-.044-.634.745-.947.751-1.697.016-.72.624-1.037 1.013-.513.264.343.16.83.538 1.351.37.527.898.262.96.763.064.519-.69.659-.7 1.272-.011.614.734.703.666 1.195-.069.492-.74.308-.94.774-.204.458.42.504.103 1.193-.316.69-1.47 1.6-1.47 1.6l.008-.004z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M336.49 162.68c1.319-2.511 1.477-5.693.821-9.199.49 1.99 1.143 6.235-.732 9.468l-.085-.262-.005-.006z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M337.672 158.792c-.163-.51-.44-.762-.688-1.05.264.231.545.442.747.835l-.063.227.004-.012zm-.001-2.426c-.293-.455-.615-.63-.946-.836.328.152.654.287.951.618l-.005.218zm.154.563c.193-.525.483-.787.755-1.092-.28.245-.572.47-.802.89l.04.207.007-.005zm-.098 2.257c.196-.537.486-.799.762-1.098-.284.239-.583.47-.806.884l.044.214zm3.262 9.683c-.812.001-1.543.548-2.209.566-.7.013-.093-.743-.635-.71-.546.025-.792.79-1.537.832-.737.036-.802-.631-1.39-.541-.596.094-.413.798-1.135.843-.728.05-.968-.776-1.82-.787-.816-.005-1.078-.639-.426-1.05.434-.28.973-.17 1.627-.563.66-.398.185-.521.774-.593.59-.072.87.559 1.57.575.7.005.918-1.03 1.467-.955.56.06.252.761.737.98.5.21.65-.446 1.383-.116s1.602 1.515 1.602 1.515l-.008.004z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M341.969 169.386c-2.658-1.375-6.258-1.528-10.351-.83 2.342-.521 7.27-1.234 10.66.743l-.31.087z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M337.723 168.166c-.622.167-.937.455-1.307.721.304-.289.592-.568 1.077-.787l.23.066zm-2.763-.002c-.57.312-.809.653-1.109.995.232-.336.436-.682.856-1l.253.005zm.665-.148c-.572-.21-.829-.51-1.131-.802.233.298.452.605.885.84l.242-.045.004.007zm2.546.085c-.569-.202-.825-.504-1.135-.79.241.293.46.6.885.84l.25-.05h0zm6.276 4.839c.146-.71-.233-1.38-.121-1.966.107-.61.718-.033.788-.507.076-.48-.599-.735-.506-1.383.1-.652.747-.668.775-1.19.02-.517-.677-.403-.594-1.035.09-.636.915-.795 1.075-1.533.165-.713.823-.904 1.09-.311.183.396-.021.854.239 1.452.248.595.801.435.765.944-.044.513-.803.517-.944 1.121-.142.605.563.841.397 1.312-.169.482-.779.166-1.07.587-.295.415.294.585-.157 1.212-.447.615-1.737 1.297-1.737 1.297z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M343.775 173.756c1.796-2.24 2.617-5.364 2.714-8.963.062 2.068-.183 6.408-2.689 9.245l-.025-.282z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M345.725 170.138c-.043-.551-.257-.852-.45-1.184.22.277.444.544.555.976l-.105.208zm.517-2.415c-.193-.51-.48-.745-.746-1.012.281.21.573.405.793.795l-.047.217h0zm.019.595c.305-.496.638-.691.967-.94-.33.184-.656.356-.966.715l-.001.225zm-.558 2.207c.296-.48.631-.687.96-.936-.325.19-.655.357-.966.716v.225l.006-.005zM340.67 187.273c-.443-.607-1.917-.61-2.288-1.096-.388-.524.685-.583.373-.97-.322-.385-1.214-.046-1.657-.572-.426-.531.213-1.038-.206-1.418-.41-.381-1.007.23-1.445-.275-.431-.513.255-1.248-.187-1.888-.43-.626.074-1.255.823-1.04.509.142.697.614 1.438.832.743.225 1.16-.312 1.546.083.377.397-.381.972-.02 1.493.37.527 1.258.164 1.49.626.211.46-.65.703-.596 1.214.053.51.787.183.846.958.06.774-.117 2.053-.117 2.053h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M339.397 184.554c-.5-.344-1.267-.436-1.736-.522.576.013 1.14.116 1.668.304l.07.226-.002-.008zm-1.287-1.71c-.093-.566.068-.965.196-1.388-.175.377-.36.75-.366 1.233l.178.153-.008.002zm1.52 1.746c-.102-.564-.178-.74-.058-1.161-.175.377-.113.532-.12 1.016l.179.153-.002-.008z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M340.77 188.545c-.053-2.923-2.455-5.748-5.334-8.335 1.765 1.4 5.743 4.639 5.59 8.51l-.255-.175z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M337.607 182.451c-.606-.216-1.088-.163-1.58-.155.453-.063.912-.135 1.446-.04l.133.188.001.007zM342.422 182.079c-.586-.472-2.01-.093-2.494-.467-.51-.405.51-.74.108-1.033-.41-.29-1.184.27-1.748-.124-.549-.403-.063-1.058-.565-1.316-.495-.262-.915.482-1.468.109-.549-.385-.077-1.272-.669-1.776-.577-.494-.253-1.232.526-1.217.528.005.832.412 1.604.43.776.026 1.04-.6 1.515-.319.467.286-.117 1.037.367 1.447.495.413 1.258-.167 1.6.22.324.388-.444.846-.26 1.326.183.48.807-.027 1.065.706.258.733.419 2.014.419 2.014h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M340.488 179.782c-.573-.203-1.337-.093-1.812-.055a5.356 5.356 0 011.69-.138l.125.2-.003-.007zm-1.686-1.319c-.236-.523-.184-.95-.17-1.391-.07.41-.153.817-.034 1.286l.212.101-.008.004zm1.92 1.293c-.244-.518-.363-.668-.356-1.107-.071.41.029.544.147 1.013l.212.101-.003-.007z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M342.848 183.282c-.809-2.81-3.86-4.917-7.31-6.671 2.067.896 6.748 2.995 7.602 6.774l-.292-.103z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M338.215 178.214c-.641-.052-1.093.124-1.567.259.422-.178.847-.367 1.387-.412l.176.146.004.007z"
  }), /*#__PURE__*/_react.default.createElement("g", null, /*#__PURE__*/_react.default.createElement("path", {
    d: "M339.838 192.04c.683-.525.925-1.423 1.465-1.859.571-.465.567.523.995.147.428-.363.14-1.124.722-1.63.587-.501 1.082-.018 1.511-.47.423-.445-.187-.885.388-1.385s1.304-.01 2.005-.542c.688-.52 1.32-.186 1.051.555-.18.488-.698.754-.978 1.483-.28.73.258 1.012-.176 1.446-.445.423-1-.164-1.593.278-.581.442-.246 1.19-.75 1.485-.502.295-.702-.45-1.25-.306-.548.155-.247.764-1.07.97-.824.207-2.314-.177-2.314-.177l-.006.006z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M338.697 192.253c3.098-.625 6.183-2.798 9.114-5.961-1.599 1.908-5.22 5.615-9.316 6.233l.202-.272z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M343.01 190.503c.4-.52.483-.96.607-1.406-.063.422-.113.831-.369 1.303l-.233.11-.005-.007zm2.296-1.773c.26-.595.237-1.033.25-1.483.044.408.094.81-.048 1.327l-.209.161.007-.005zm-.457.55c.606-.196 1.016-.127 1.46-.1-.393-.075-.776-.18-1.283-.095l-.177.196zm-2.17 1.562c.606-.209 1.022-.134 1.459-.1-.391-.087-.77-.186-1.283-.096l-.176.196z"
  })), /*#__PURE__*/_react.default.createElement("g", null, /*#__PURE__*/_react.default.createElement("path", {
    d: "M342.173 187.722c.494-.565.511-1.338.897-1.798.42-.491.635.312.94-.071.312-.387-.133-.948.28-1.48.42-.516.982-.217 1.267-.669.285-.451-.377-.692.035-1.205.4-.518 1.183-.26 1.693-.832.508-.554 1.16-.402 1.084.251-.05.446-.462.756-.55 1.405-.087.65.468.774.166 1.207-.302.433-.942.064-1.372.534-.426.477.048 1.018-.34 1.36-.391.335-.743-.232-1.207-.003-.468.222-.052.669-.75.996-.702.32-2.15.309-2.15.309l.007-.004z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M341.18 188.115c2.67-1.106 4.97-3.477 6.905-6.622-1.009 1.87-3.447 5.584-7.023 6.884l.117-.262h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M344.697 185.861c.242-.51.21-.88.226-1.269.042.348.092.693-.034 1.138l-.192.131h0zm1.673-1.894c.107-.539-.02-.885-.101-1.26.128.33.27.644.25 1.095l-.149.165h0zm-.283.544c.502-.296.888-.305 1.299-.367-.378.005-.743-.003-1.185.166l-.118.194.004.007zm-1.612 1.682c.498-.286.889-.306 1.303-.36-.378.005-.75 0-1.196.162l-.107.198z"
  })), /*#__PURE__*/_react.default.createElement("g", null, /*#__PURE__*/_react.default.createElement("path", {
    d: "M314.195 159.213c-3.706.69-7.487 1.529-10.54 3.582-4.81 3.405-7.786 9.12-7.432 15.181.409 5.072 2.319 10.071 5.506 14.412a21.817 21.817 0 0011.982 8.05c1.787.462 3.628.66 5.435.863.678.307.658 1.227-.05 1.21-6.318-.285-11.429-3.43-16.067-7.726-2.24-2.362-3.991-5.092-5.146-8.02-1.857-4.296-2.794-9.034-1.779-13.373 1.43-6.451 6.596-11.735 13.29-13.327a40.481 40.481 0 015.292-.984l-.498.127.007.005z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M319.288 201.356c.63.331.397 1.356-.202 1.138-.267-.265-.278-1.299.21-1.134l-.008-.004zm-4.08-42.843c.57-.156 1.155.473 1.614.359.494-.12.063-.567.447-.645.37-.089.639.253 1.16.14.508-.11.403-.56.804-.601.417-.049.275.252.78.148.504-.104.665-.757 1.254-.927.573-.162.752-.682.292-.857-.3-.118-.555.053-1.008-.118-.457-.164-.453-.525-.867-.465-.402.058-.404.579-.89.733-.484.154-.484-.201-.866-.046-.386.162-.317.412-.66.667-.341.256-.75-.194-1.26.195-.507.382-.807 1.412-.807 1.412l.008.005z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M314.439 159.174c1.518-1.466 4.41-2.477 7.25-2.746-1.636.066-5.026.54-7.374 2.647l.124.099h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M317.473 157.36c.433.008.657.162.91.287-.213-.156-.414-.313-.747-.378l-.163.09zm1.927-.532c.39.122.557.332.763.53-.155-.212-.303-.42-.592-.569l-.175.046.004-.007zm-.473.022c.4-.264.574-.535.78-.804-.16.262-.31.528-.603.788l-.177.016zm-1.763.553c.396-.258.57-.528.78-.804-.163.268-.314.535-.614.79l-.166.014zm-13.381 5.84c.743.189 1.266.815 1.861.975.64.17.285-.62.766-.477.489.147.509.86 1.174 1.056.662.202.889-.36 1.405-.159.519.214.165.779.815.983.642.2 1.075-.455 1.845-.276.748.165 1.147-.324.665-.822-.328-.332-.843-.357-1.334-.84-.49-.485-.145-.906-.662-1.09-.513-.19-.766.477-1.4.329-.635-.148-.631-.864-1.145-.924-.517-.054-.425.612-.92.685-.507.074-.477-.522-1.224-.397-.752.131-1.846.956-1.846.956h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M302.764 163.481c2.773-.6 6.073.051 9.605 1.554-1.984-.962-6.283-2.65-9.868-1.695l.263.141z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M306.929 163.357c.518.278.74.598 1 .906-.195-.312-.383-.62-.77-.907h-.23zm2.517.605c.427.388.566.738.745 1.106-.12-.348-.224-.686-.519-1.053l-.226-.053zm-.573-.276c.574-.05.894-.254 1.235-.445-.293.213-.567.428-1.015.54l-.22-.095h0zm-2.33-.475c.567-.054.879-.264 1.228-.45a2.646 2.646 0 01-1.015.54l-.213-.09zm-11.376 13.478c-.286-.688-.04-1.426-.258-1.977-.227-.585-.707.095-.865-.37-.166-.453.444-.835.223-1.462-.22-.628-.847-.528-.976-1.04-.117-.514.59-.525.379-1.137-.206-.618-1.045-.627-1.333-1.326-.298-.686-.971-.757-1.119-.124-.1.43.18.853.051 1.489-.14.638-.703.573-.57 1.079.144.503.88.362 1.131.944.25.581-.392.932-.13 1.381.248.44.777.025 1.148.386.36.362-.178.631.378 1.176a6.56 6.56 0 001.941.98h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M295.974 177.377c-2.175-1.896-3.565-4.864-4.342-8.426.332 2.07 1.394 6.34 4.37 8.705l-.028-.279h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M293.387 174.132c-.056-.559.087-.895.21-1.264-.154.32-.323.631-.352 1.08l.142.184zm-.96-2.308c.087-.54.32-.82.532-1.15-.235.268-.477.514-.615.938l.087.205-.005.007zm.096.594c-.386-.436-.753-.578-1.124-.762.356.127.713.236 1.08.538l.048.217-.004.007zm.962 2.095c-.378-.43-.745-.574-1.116-.757.356.127.713.236 1.076.545l.04.212h0zm3.408-5.642c-.154-.715.234-1.38.117-1.96-.114-.614-.714-.04-.795-.512-.07-.474.61-.736.517-1.384-.105-.646-.754-.673-.775-1.19-.02-.517.677-.403.595-1.035-.09-.637-.92-.789-1.087-1.531-.161-.72-.816-.9-1.084-.307-.178.39.022.854-.233 1.445-.253.603-.81.43-.77.951.044.514.807.51.944 1.122.13.606-.57.836-.397 1.311.173.476.779.166 1.074.58.291.422-.298.593.153 1.219.45.626 1.741 1.29 1.741 1.29h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M297.566 169.687c-1.801-2.234-2.622-5.358-2.715-8.964-.062 2.07.184 6.408 2.689 9.246l.026-.282z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M295.615 166.069c.043-.552.253-.845.447-1.178-.217.271-.44.538-.556.976l.102.197.007.005zm-.517-2.415c.19-.503.476-.738.747-1.012-.282.21-.578.411-.794.795l.047.217h0zm-.018.595c-.31-.49-.638-.692-.972-.934.33.184.656.357.966.716l.006.218zm.557 2.207c-.3-.473-.63-.687-.964-.93.33.185.655.357.966.716l.005.218-.007-.004zm4.74.115c.819.006 1.55.552 2.213.559.703.024.1-.738.642-.706.542.032.785.786 1.526.834.744.042.806-.637 1.394-.547.592.101.42.803 1.142.848.721.045.969-.776 1.804-.779.828-.007 1.083-.645.431-1.056-.427-.275-.974-.17-1.627-.564-.649-.4-.181-.527-.767-.588-.592-.083-.878.554-1.576.57-.698 0-.92-1.03-1.464-.961-.545.069-.248.773-.737.98-.488.209-.654-.44-1.387-.11-.734.33-1.595 1.52-1.595 1.52h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M299.405 167.093c2.658-1.376 6.261-1.535 10.35-.831-2.342-.52-7.27-1.234-10.666.739l.316.092z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M303.647 165.861c.617.174.944.46 1.303.728-.297-.284-.588-.575-1.062-.778l-.24.05zm2.766.01c.567.3.809.652 1.101.99-.22-.338-.428-.677-.848-.995l-.25-.002-.003.007zm-.673-.154c.58-.204.834-.517 1.14-.796-.234.297-.46.6-.886.839l-.25-.05-.004.007zm-2.538.09c.573-.209.83-.51 1.132-.8-.238.304-.453.604-.89.845l-.242-.044h0zm-4.74.388c-.004-.72.522-1.296.533-1.877.012-.617-.717-.182-.683-.655.03-.466.754-.587.795-1.233.04-.645-.605-.79-.52-1.295.086-.505.76-.257.8-.885.044-.634-.744-.946-.75-1.697-.004-.721-.617-1.032-1.006-.508-.264.343-.16.83-.538 1.351-.378.522-.898.262-.96.763-.067.507.694.652.693 1.268.018.618-.73.696-.662 1.188.069.492.735.315.943.785.204.458-.427.5-.103 1.193.324.694 1.462 1.596 1.462 1.596l-.004.006z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M298.962 167.116c-1.326-2.517-1.484-5.698-.826-9.193-.49 1.989-1.157 6.225.737 9.461l.085-.262.004-.006z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M297.773 163.222c.163-.51.44-.762.695-1.045-.271.227-.546.442-.747.835l.055.222-.003-.012zm0-2.425c.294-.455.623-.626.954-.832-.335.148-.654.287-.958.614l.005.218zm-.146.567c-.2-.53-.49-.791-.762-1.097.287.25.579.476.802.89l-.033.212-.007-.005zm.102 2.25c-.193-.525-.494-.785-.759-1.086.284.239.576.464.806.883l-.047.203zm7.72-3.311c.1-.738.727-1.258.822-1.859.098-.636-.725-.28-.626-.758.096-.488.872-.511 1.005-1.172.134-.66-.525-.898-.362-1.41.163-.51.834-.161.967-.804.137-.649-.656-1.085-.557-1.852.093-.742-.51-1.15-.988-.665-.316.328-.284.844-.755 1.333-.46.488-.967.142-1.111.656-.136.519.634.763.555 1.403-.075.633-.86.622-.862 1.143.002.514.732.416.876.92.152.508-.508.465-.27 1.225.244.755 1.313 1.845 1.313 1.845l-.008-.005z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M305.848 161.316c-1.027-2.77-.753-6.075.425-9.599-.8 1.985-2.084 6.272-.553 9.862l.128-.263h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M305.147 157.15c.247-.512.563-.728.871-.996-.315.198-.633.384-.906.76l.035.236h0zm.347-2.51c.372-.432.744-.557 1.112-.74-.356.116-.723.216-1.083.516l-.03.224zm-.232.569c-.132-.57-.4-.883-.653-1.233.273.288.542.564.728 1.02l-.075.213h0zm-.209 2.329c-.132-.57-.4-.883-.653-1.233.268.294.538.57.724 1.026l-.07.207z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M308.647 159.22c-.029-.634.868-1.185.858-1.687-.018-.553-.656-.161-.649-.577 0-.42.467-.66.476-1.223-.001-.58-.56-.52-.509-.972.06-.448.372-.255.389-.814.005-.557-.718-.826-.764-1.481-.044-.644-.613-.909-.95-.435-.218.307-.088.606-.413 1.077-.313.47-.742.408-.782.859-.029.448.598.525.626 1.066.041.549-.354.5-.266.93.087.43.407.402.615.807.204.41-.429.778-.104 1.389.326.61 1.473 1.061 1.473 1.061h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M309.228 160.145c-1.338-1.852-1.775-5.101-1.344-8.21-.358 1.766-.683 5.504 1.195 8.329l.15-.119z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M307.882 156.608c.121-.463.358-.684.573-.937-.235.203-.466.4-.642.753l.069.184zm-.117-2.147c.24-.405.53-.563.822-.757-.288.14-.587.265-.84.56l.018.197zm-.116.504c-.2-.465-.48-.692-.74-.953.27.211.549.41.78.764l-.032.194-.008-.005zm.195 1.992c-.2-.465-.476-.699-.735-.96.262.207.54.406.774.77l-.034.184-.005.006zm-5.334 36.29c.117-.765.763-1.347.879-1.963.122-.659-.725-.234-.613-.731.112-.497.9-.587 1.05-1.273.151-.687-.511-.872-.339-1.414.187-.532.853-.224 1.003-.893.162-.67-.622-1.055-.511-1.841.11-.77-.487-1.136-.989-.6-.328.348-.312.872-.802 1.405-.482.538-.991.229-1.143.756-.161.54.62.736.528 1.395-.095.648-.899.7-.906 1.227-.006.528.728.375.872.879.137.499-.538.511-.307 1.267.225.752 1.278 1.785 1.278 1.785h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M302.821 193.83c-.986-2.754-.556-5.716.732-9.412-.857 2.09-2.344 6.142-.868 9.688l.136-.276h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M302.276 190.053c.264-.54.594-.793.912-1.092-.322.24-.657.454-.932.864l.02.228zm.413-2.58c.378-.475.76-.63 1.149-.846-.377.149-.75.273-1.123.61l-.034.231.008.005zm-.256.59c-.121-.572-.39-.866-.629-1.207.263.272.541.535.715.993l-.09.221.004-.006zm-.28 2.406c-.12-.573-.385-.874-.628-1.208.263.272.534.53.712.982l-.084.226zm-5.192-17.598c.849-.153 1.85.25 2.535.141.731-.116-.239-.76.329-.833.568-.073 1.174.635 1.946.536.792-.096.544-.779 1.193-.799.641-.025.79.714 1.55.617.769-.093.636-.953 1.493-1.12.838-.168.816-.845-.05-1.133-.567-.188-1.074.017-1.923-.25-.864-.277-.881-.848-1.512-.807-.638.037-.329.834-1.035.976-.714.137-1.288-.588-1.817-.415-.532.179.102.812-.3 1.112-.41.314-.873-.31-1.466.157-.604.469-.943 1.818-.943 1.818z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M299.992 171.531c.713.058 1.174.28 1.675.473-.442-.22-.864-.454-1.465-.571l-.21.098zm2.838-.523c.727.198 1.137.5 1.597.787-.39-.298-.758-.6-1.337-.834l-.253.052-.007-.005zm-.757-.021c.495-.316.617-.666.795-1.008-.106.342-.181.685-.512 1.004l-.283.004h0zm-2.562.58c.488-.321.61-.672.789-1.014-.106.342-.186.692-.517 1.011l-.272.002h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M296.59 173.35c2.092-1.87 5.335-2.505 9.85-2.59-2.644-.071-7.653-.043-10.216 2.56l.366.03zm.386 4.962c.624-.419 2.01.083 2.525-.248.544-.359-.445-.781-.019-1.038.434-.253 1.157.372 1.753.028.582-.353.155-1.048.678-1.261.516-.218.869.56 1.452.236.581-.335.188-1.26.822-1.71.618-.442.36-1.205-.418-1.26-.527-.04-.865.34-1.636.29-.775-.042-.983-.689-1.48-.45-.491.244.025 1.043-.492 1.41-.53.368-1.24-.277-1.614.079-.356.358.369.882.144 1.344-.225.461-.802-.097-1.123.61-.32.708-.592 1.97-.592 1.97h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M299.102 176.193c.589-.153 1.34.023 1.81.102a5.356 5.356 0 00-1.672-.284l-.142.188.004-.006zm1.795-1.167c.28-.5.266-.93.29-1.372.035.415.081.827-.078 1.285l-.22.082.008.005zm-2.025 1.12c.288-.495.42-.634.45-1.071.036.414-.075.539-.235.996l-.22.082.005-.006z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M296.446 179.473c1.05-2.729 4.274-4.561 7.864-6.008-2.137.713-6.983 2.395-8.164 6.085l.3-.077z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M301.503 174.829c.643.004 1.078.219 1.538.394-.404-.214-.811-.44-1.345-.532l-.189.131-.004.007zm11.74-16.305c.444-.366 1.234-.007 1.59-.3.387-.31-.183-.557.118-.782.302-.226.68-.02 1.086-.327s.128-.683.47-.891c.343-.209.352.133.754-.168.402-.3.273-.972.723-1.363.437-.371.38-.93-.095-.92-.319.01-.484.267-.957.289-.477.028-.62-.316-.955-.103-.332.225-.118.717-.484 1.042-.373.32-.518.011-.786.314-.271.292-.109.509-.309.884-.196.368-.743.118-1.032.678-.288.561-.123 1.647-.123 1.647h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M312.843 159.452c.73-1.974 2.864-4.071 5.28-5.444-1.42.7-4.235 2.496-5.43 5.402l.15.042z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M314.774 156.553c.386-.162.647-.115.93-.1-.253-.061-.49-.13-.82-.054l-.11.154zm1.49-1.26c.393-.046.634.082.9.187-.225-.135-.446-.278-.77-.31l-.138.117.008.005zm-.411.2c.24-.404.284-.73.359-1.074-.04.32-.059.625-.208.986l-.159.084.008.005zm-1.338 1.22c.247-.4.291-.727.362-1.064-.035.313-.054.618-.215.98l-.147.083zm-2.837 1.652c.3-.45.985-.429 1.241-.777.269-.369-.892-.977-.671-1.254.216-.271.601-.06.9-.428.3-.367-.057-.783.208-1.033.265-.249.344.129.639-.231.29-.354.38-.913.696-1.371.305-.457.115-1.084-.31-1.04-.284.022-.365.325-.786.38-.42.055-.66-.333-1.023-.24-.37.089-.441.313-.7.697-.254.396-.454.043-.63.396-.175.354.028.588-.065 1.022-.088.429-.646.162-.768.82-.13.655 1.262 3.054 1.262 3.054l.007.005z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M312.002 159.544c-.878-2.582-.001-5.899 2.648-7.066-1.308.568-2.286 1.617-2.734 2.932-.423 1.295-.443 2.715-.058 4.098l.144.036z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M311.78 156.154c.334-.201.721-.32 1.13-.346-.234-.057-.787.072-1.069.17l-.06.176h0zm.845-1.957c.357-.069.598.059.856.16-.226-.136-.461-.288-.763-.305l-.093.145zm-.09-.04c.123-.48.084-.84.067-1.234.05.358.1.717.044 1.129l-.11.106zm-.86 2.013c.126-.47-.412-.62-.69-.931.257.166.858.414.816.834l-.125.097h0zm2.233 3.698c.674.005 1.006-.817 1.543-.826.575-.002.332.569.77.552.43-.02.564-.438 1.156-.468.599-.024.69.464 1.146.404.46-.068.167-.34.752-.374.58-.028 1.057.606 1.75.614.689.015 1.114.504.715.816-.266.202-.613.109-1.022.405-.403.3-.227.675-.686.724-.46.05-.708-.502-1.286-.511-.578-.009-.423.334-.906.274-.483-.059-.522-.336-.998-.503-.484-.172-.7.407-1.42.149-.715-.265-1.514-1.256-1.514-1.256h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M312.79 159.39c2.29 1.102 5.806 1.353 8.945.847-1.76.387-5.566.827-9.028-.705l.078-.136.004-.007z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M316.845 160.436c.449-.13.62-.347.832-.547-.155.208-.292.437-.62.59l-.212-.043zm2.283.015c.36-.235.438-.501.561-.758-.062.259-.125.517-.359.767l-.207-.002.005-.007zm-.502.115c.541.163.848.398 1.194.62-.288-.231-.576-.464-1.008-.65l-.186.03zm-2.132-.086c.541.162.852.39 1.198.614-.292-.226-.576-.465-1.008-.65l-.19.036zm-5.438.32c.738.15 1.14-.701 1.739-.595.628.125.337.721.812.793.486.071.648-.375 1.305-.278.66.108.734.688 1.242.707.504.027.19-.344.84-.252.649.092 1.13.915 1.908 1.081.74.16 1.19.805.736 1.072-.302.178-.677-.016-1.141.235-.46.245-.283.714-.793.665-.51-.05-.755-.72-1.386-.857-.643-.134-.486.285-1.011.114-.518-.166-.562-.502-1.084-.792-.517-.296-.79.303-1.569-.153-.776-.444-1.598-1.74-1.598-1.74h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M309.842 160.018c2.471 1.742 6.33 2.803 9.805 2.924-1.949.05-6.168-.29-9.902-2.79l.097-.134z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M314.262 162.083c.497-.043.694-.252.935-.432-.178.211-.341.433-.708.532l-.227-.1zm2.507.524c.41-.183.508-.465.659-.732-.087.28-.154.563-.44.78l-.22-.048h0zm-.56.013c.586.303.92.64 1.294.965-.312-.323-.621-.652-1.08-.958l-.207-.003-.008-.004zm-2.34-.575c.594.308.922.64 1.291.972-.308-.33-.61-.654-1.08-.958l-.207-.002-.003-.012z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M308.78 161.583c.739.196 1.197-.628 1.79-.48.63.154.286.735.77.842.476.102.665-.337 1.322-.193.658.144.69.725 1.2.774.506.055.213-.33.855-.196.643.135 1.08.976 1.84 1.187.754.205 1.156.875.681 1.11-.313.162-.69-.062-1.163.156-.478.224-.339.687-.844.613-.504-.073-.71-.757-1.335-.935-.636-.177-.506.252-1.022.05-.509-.197-.533-.53-1.034-.853-.5-.323-.816.248-1.563-.242-.75-.502-1.496-1.833-1.496-1.833h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M307.613 160.728c2.366 1.889 6.18 3.181 9.653 3.516-1.96-.079-6.171-.674-9.757-3.387l.107-.118-.003-.011z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M311.913 163.06c.51-.015.718-.208.974-.38-.193.203-.371.415-.744.492l-.238-.116.008.005zm2.486.67c.416-.16.548-.43.721-.683-.113.273-.207.548-.5.742l-.226-.052.005-.007zm-.563-.017c.577.334.88.688 1.237 1.04-.296-.35-.577-.69-1.027-1.026l-.202-.01-.008-.004zm-2.31-.715c.572.34.88.688 1.236 1.04-.3-.343-.577-.69-1.03-1.02l-.199-.015-.007-.005zm4.469 37.55c-.303-.596-.983-.932-1.236-1.412-.27-.501.519-.32.302-.71-.225-.38-.886-.292-1.193-.817-.308-.525.178-.809-.112-1.2-.285-.4-.75-.017-1.05-.538-.301-.502.23-.971-.083-1.584-.299-.603.08-1.012.63-.686.364.226.487.65 1.029.99.53.342.843-.016 1.117.384.266.396-.302.711-.047 1.22.25.517.91.4 1.055.82.146.421-.48.438-.457.872.022.435.565.319.586.966.027.652-.54 1.695-.54 1.695h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M315.97 201.428c.037-2.402-1.168-5.074-3.202-7.803 1.256 1.528 3.604 4.852 3.384 8.005l-.186-.195.004-.007z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M315.311 197.924c-.347-.383-.676-.52-1.013-.69.352.104.685.274.98.5l.04.195-.007-.005zm-1.01-2.005c-.44-.302-.79-.36-1.155-.455.334.048.677.082 1.063.275l.092.18zm.355.435c-.057-.494.077-.782.177-1.1-.132.27-.283.537-.296.93l.12.17zm.873 1.878c-.06-.487.077-.78.177-1.099-.136.276-.283.536-.308.93l.127.176.004-.007zm-.914 3.956c-.815-.19-1.42-.916-2.08-1.089-.702-.172-.272.73-.81.579-.542-.163-.605-.987-1.33-1.203-.738-.214-.967.45-1.54.222-.567-.236-.21-.902-.924-1.12-.714-.217-1.155.563-2.008.368-.824-.177-1.24.404-.686.967.37.378.936.407 1.487.958.563.55.206 1.038.779 1.249.573.21.81-.579 1.52-.42.696.15.72.986 1.287 1.044.571.051.432-.72.98-.825.542-.098.532.596 1.355.436.815-.166 1.97-1.166 1.97-1.166z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M315.715 201.889c-3 .773-6.646.093-10.567-1.567 2.215 1.074 6.986 2.935 10.866 1.732l-.3-.165z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M311.166 202.14c-.577-.317-.834-.678-1.133-1.04.238.36.452.722.888 1.049l.245-.01zm-2.77-.648c-.49-.437-.652-.85-.855-1.26.132.393.26.792.605 1.21l.25.05zm.63.313c-.62.076-.954.318-1.329.543.307-.25.607-.505 1.095-.647l.242.11-.007-.006zm2.574.502c-.617.069-.955.318-1.33.543.308-.25.6-.51 1.095-.648l.235.105zm.417-2.699c-.303-.597-.983-.932-1.236-1.413-.27-.501.518-.319.302-.71-.225-.379-.886-.291-1.194-.816-.307-.525.178-.81-.111-1.201-.285-.399-.75-.017-1.05-.537-.302-.503.23-.972-.083-1.585-.3-.603.08-1.012.63-.685.364.225.487.65 1.028.99.53.341.844-.016 1.118.384.266.395-.302.71-.047 1.22.25.516.91.4 1.055.82.146.42-.48.437-.458.872.022.434.566.318.586.966.028.652-.54 1.695-.54 1.695h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M311.992 200.487c.037-2.402-1.169-5.073-3.202-7.803 1.255 1.528 3.604 4.852 3.384 8.005l-.187-.195.005-.007z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M311.333 196.983c-.347-.382-.676-.52-1.014-.69.353.104.686.274.98.5l.041.195-.007-.005zm-1.01-2.004c-.441-.303-.79-.36-1.156-.456.335.048.677.082 1.063.275l.092.18zm.355.434c-.057-.494.076-.781.177-1.099-.132.27-.283.536-.297.929l.12.17zm.873 1.879c-.061-.488.076-.782.177-1.1-.136.277-.283.537-.308.931l.127.175.004-.006zm-1.777 2.821c-.815-.19-1.42-.916-2.08-1.09-.702-.172-.272.73-.81.58-.542-.163-.605-.987-1.33-1.203-.738-.214-.967.45-1.54.221-.567-.235-.21-.901-.924-1.119-.714-.217-1.155.563-2.008.367-.824-.176-1.24.405-.686.967.37.38.936.407 1.487.959.563.55.206 1.038.779 1.248.573.21.81-.578 1.52-.42.696.15.72.987 1.287 1.045.571.05.432-.72.98-.825.542-.098.532.596 1.355.435.815-.165 1.97-1.165 1.97-1.165z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M310.874 199.813c-3 .774-6.646.094-10.567-1.566 2.215 1.073 6.986 2.935 10.866 1.732l-.3-.166z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M306.325 200.064c-.577-.316-.834-.678-1.133-1.039.238.36.452.721.888 1.048l.245-.01zm-2.77-.648c-.49-.437-.652-.849-.855-1.26.132.393.26.793.605 1.211l.25.05zm.63.314c-.62.075-.954.318-1.329.543.307-.25.607-.505 1.095-.648l.242.11-.007-.005zm2.574.502c-.617.068-.955.317-1.33.542.308-.25.6-.51 1.095-.647l.235.105zm-3.093-4.206c-.764-.399-1.158-1.241-1.765-1.577-.644-.359-.468.613-.955.318-.484-.284-.334-1.083-.994-1.48-.665-.392-1.069.17-1.57-.2-.494-.366.03-.905-.622-1.298-.654-.393-1.286.217-2.069-.185-.768-.393-1.332.046-.939.729.263.45.819.621 1.22 1.29.403.67-.077 1.043.426 1.394.51.34.956-.335 1.616-.002.65.334.45 1.13.996 1.332.547.203.615-.565 1.179-.519.567.058.376.71 1.223.77.846.06 2.247-.577 2.247-.577l.007.005z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M304.826 196.037c-3.16-.077-6.574-1.681-10.01-4.288 1.906 1.602 6.116 4.624 10.256 4.52l-.246-.232z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M300.276 195.063c-.486-.443-.643-.862-.842-1.28.135.404.255.8.589 1.22l.248.067.005-.007zm-2.57-1.348c-.36-.54-.413-.976-.504-1.417.028.41.048.815.278 1.299l.234.122-.008-.004zm.545.463c-.63-.089-1.022.05-1.454.155.373-.143.733-.312 1.246-.317l.208.162zm2.41 1.161c-.634-.1-1.03.045-1.455.154.37-.153.725-.316 1.246-.316l.208.162zm7.889 2.939c-.156-.567-.708-1.035-.84-1.493-.141-.492.552-.13.43-.507-.121-.377-.75-.484-.917-1.001-.17-.512.337-.604.164-1.015-.189-.401-.69-.22-.858-.72-.175-.505.418-.73.268-1.321-.147-.58.3-.805.737-.384.288.28.302.662.735 1.09.42.43.79.23.948.63.166.406-.43.506-.311.984.122.49.752.579.804.967.04.39-.543.228-.62.59-.076.36.46.418.327.948-.118.54-.872 1.239-.872 1.239l.005-.007z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M308.355 198.694c.569-1.966.012-4.173-1.27-6.969.822 1.585 2.286 4.665 1.387 7.175l-.125-.211.008.005z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M308.494 195.956c-.245-.429-.523-.627-.795-.867.27.193.55.373.802.694l-.003.166-.004.007zm-.501-1.938c-.337-.366-.65-.512-.972-.691.302.13.609.252.918.516l.054.175zm.235.46c.057-.412.242-.619.414-.853-.196.19-.39.364-.491.682l.077.17zm.397 1.777c.056-.412.238-.612.402-.851-.184.189-.379.362-.491.681l.089.17h0zm-3.656-.957c-.03-.598-.496-1.17-.534-1.66-.033-.516.606-.02.563-.421-.051-.406-.676-.632-.73-1.18-.06-.552.484-.556.389-.99-.098-.446-.667-.356-.73-.89-.064-.546.602-.658.576-1.281-.022-.612.49-.758.852-.254.239.34.168.725.515 1.238.344.501.78.372.853.81.083.437-.563.421-.543.939.014.512.652.718.615 1.115-.04.403-.61.138-.77.483-.16.345.379.496.135 1.02-.247.513-1.183 1.076-1.183 1.076l-.008-.005z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M304.673 195.677c1.034-1.863.945-4.198.234-7.25.506 1.754 1.346 5.123-.142 7.495l-.085-.24-.007-.005z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M305.437 192.94c-.163-.46-.403-.717-.634-1.006.238.247.488.473.679.839l-.045.167zm-.097-2.032c-.271-.436-.557-.639-.852-.876.294.19.574.37.844.694l.008.182h0zm.156.502c.137-.406.381-.575.605-.777-.232.15-.479.29-.655.596l.05.181zm-.004 1.864c.156-.403.393-.577.61-.783-.237.156-.471.294-.655.595l.045.188zm-9.775-11.07c-.388-.642-.27-1.406-.571-1.926-.329-.557-.68.196-.912-.234-.24-.435.295-.91-.02-1.505-.323-.582-.93-.385-1.131-.88-.203-.494.49-.616.175-1.193-.304-.579-1.12-.46-1.523-1.112-.404-.634-1.073-.599-1.111.058-.029.448.323.824.297 1.48-.027.654-.595.68-.373 1.16.223.478.917.226 1.258.763.337.544-.224.994.1 1.399.326.397.772-.1 1.189.207.421.3-.065.667.565 1.11.635.438 2.064.678 2.064.678l-.007-.005z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M296.628 182.763c-2.438-1.552-4.29-4.287-5.651-7.72.669 2.017 2.425 6.098 5.721 8l-.07-.28h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M293.555 179.933c-.15-.544-.054-.902-.002-1.29-.102.337-.211.668-.164 1.127l.166.163h0zm-1.319-2.156c-.011-.549.174-.868.32-1.223-.185.302-.38.587-.438 1.034l.118.189h0zm.185.585c-.443-.379-.822-.455-1.215-.587.37.071.731.126 1.137.37l.082.21-.004.007zm1.295 1.936c-.44-.368-.822-.455-1.22-.58.37.07.739.13 1.149.367l.07.213zm6.567-16.12c.1-.738.727-1.258.823-1.859.098-.636-.725-.28-.622-.765.104-.483.872-.51.994-1.17.122-.658-.518-.893-.355-1.404.162-.511.834-.163.97-.811.126-.648-.659-1.079-.56-1.846.093-.742-.51-1.15-.989-.665-.315.328-.283.844-.75 1.326-.465.494-.971.15-1.115.663-.137.519.633.763.554 1.403-.074.633-.859.622-.861 1.143.001.514.732.416.876.92.152.508-.509.465-.27 1.225.244.755 1.312 1.845 1.312 1.845l-.007-.005z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M300.67 165.193c-1.026-2.771-.744-6.07.434-9.594-.8 1.985-2.084 6.271-.55 9.855l.124-.256-.007-.005z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M299.977 161.032c.24-.518.564-.729.872-.997-.315.198-.634.385-.907.76l.035.237h0zm.336-2.509c.372-.432.748-.563 1.112-.74-.356.117-.723.216-1.083.516l-.03.224zm-.232.57c-.132-.571-.4-.884-.65-1.24.27.294.54.57.725 1.026l-.075.213zm-.21 2.328c-.131-.57-.399-.883-.653-1.233.27.295.539.571.725 1.027l-.071.206z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M302.95 161.772c-.002-.71.513-1.283.53-1.86.013-.617-.715-.182-.682-.655.027-.477.758-.594.8-1.239.029-.644-.613-.796-.52-1.296.079-.51.76-.257.8-.884.044-.635-.745-.947-.75-1.697-.016-.72-.625-1.037-1.014-.514-.263.344-.16.83-.538 1.352-.37.527-.898.261-.96.762-.064.52.69.66.7 1.273.011.614-.734.703-.665 1.195.068.492.739.308.939.773.205.459-.42.505-.103 1.194.317.69 1.47 1.6 1.47 1.6l-.008-.004z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M303.446 162.698c-1.32-2.511-1.478-5.693-.822-9.2-.49 1.99-1.143 6.235.732 9.47l.085-.263.005-.007z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M302.264 158.81c.162-.511.439-.762.687-1.05-.264.231-.545.442-.746.835l.062.226-.003-.011zm0-2.426c.294-.455.615-.63.946-.837-.327.153-.654.288-.95.62l.004.217zm-.154.563c-.193-.525-.483-.787-.754-1.093.28.246.571.471.801.89l-.04.208-.007-.005zm.098 2.256c-.196-.536-.486-.798-.762-1.097.284.239.584.47.806.883l-.044.214zm-3.262 9.684c.812.001 1.543.547 2.209.566.7.012.093-.743.635-.71.546.025.793.79 1.537.831.737.037.803-.63 1.39-.54.596.094.414.798 1.135.843.728.05.968-.776 1.82-.787.816-.006 1.079-.639.427-1.05-.435-.28-.974-.17-1.627-.563-.66-.398-.186-.521-.775-.593-.59-.072-.87.559-1.569.575-.701.005-.92-1.031-1.468-.956-.56.06-.251.762-.736.981-.5.21-.65-.446-1.384-.117-.733.33-1.602 1.515-1.602 1.515l.008.005z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M297.967 169.404c2.658-1.376 6.257-1.528 10.35-.83-2.342-.522-7.27-1.234-10.659.743l.309.087z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M302.212 168.184c.622.167.937.454 1.307.72-.303-.288-.592-.568-1.076-.786l-.23.066zm2.763-.002c.57.312.809.652 1.109.995-.232-.336-.436-.682-.856-1l-.253.005zm-.665-.148c.573-.21.83-.511 1.131-.802-.233.298-.452.605-.884.84l-.243-.045-.004.007zm-2.546.085c.569-.203.825-.504 1.135-.79-.241.293-.46.6-.885.84l-.25-.05h0zm-6.276 4.839c-.146-.71.233-1.38.121-1.966-.107-.61-.718-.034-.787-.508-.077-.479.598-.734.505-1.382-.1-.652-.747-.668-.775-1.19-.02-.517.677-.403.594-1.035-.09-.637-.914-.795-1.074-1.533-.166-.713-.824-.904-1.092-.312-.182.396.023.855-.238 1.452-.248.596-.801.436-.764.944.044.514.802.518.944 1.122.141.605-.563.841-.398 1.312.169.482.779.166 1.07.587.296.414-.294.585.157 1.211.447.616 1.737 1.298 1.737 1.298z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M296.16 173.774c-1.796-2.24-2.617-5.364-2.714-8.964-.062 2.07.183 6.408 2.689 9.246l.026-.282z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M294.21 170.156c.043-.552.257-.852.451-1.184-.22.277-.444.544-.556.976l.105.208zm-.517-2.415c.194-.51.48-.745.746-1.012-.281.21-.573.405-.793.795l.047.217h0zm-.018.595c-.306-.496-.638-.692-.967-.94.329.183.655.356.966.715v.225zm.557 2.207c-.295-.48-.63-.687-.96-.936.325.19.656.357.966.716l.001.224-.007-.004zM299.265 187.291c.443-.607 1.917-.61 2.288-1.097.388-.523-.685-.582-.372-.97.32-.385 1.213-.045 1.657-.572.426-.53-.214-1.038.205-1.417.41-.381 1.008.229 1.446-.275.43-.513-.256-1.248.186-1.888.43-.626-.074-1.255-.823-1.04-.508.142-.697.614-1.438.832-.742.225-1.16-.312-1.545.083-.378.397.38.971.02 1.493-.372.527-1.26.164-1.49.626-.212.459.649.703.595 1.214-.053.51-.787.183-.846.957-.06.775.117 2.054.117 2.054h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M300.539 184.572c.5-.345 1.266-.436 1.735-.522a5.356 5.356 0 00-1.668.304l-.07.226.003-.008zm1.287-1.71c.092-.566-.069-.965-.197-1.388.175.377.36.75.366 1.233l-.178.153.009.002zm-1.52 1.746c.101-.564.177-.74.057-1.162.175.378.113.533.12 1.017l-.179.152.002-.007z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M299.164 188.563c.054-2.924 2.457-5.748 5.335-8.335-1.764 1.4-5.743 4.639-5.59 8.51l.255-.175z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M302.328 182.47c.606-.217 1.088-.164 1.58-.156-.453-.063-.912-.135-1.446-.04l-.132.187-.002.008z"
  }), /*#__PURE__*/_react.default.createElement("g", null, /*#__PURE__*/_react.default.createElement("path", {
    d: "M297.514 182.097c.585-.472 2.009-.093 2.493-.468.511-.404-.51-.739-.108-1.032.41-.29 1.184.27 1.748-.125.55-.402.063-1.057.566-1.315.494-.263.914.482 1.467.108.55-.384.077-1.272.669-1.775.577-.494.254-1.232-.526-1.218-.528.006-.832.413-1.604.432-.776.025-1.04-.602-1.514-.32-.468.285.116 1.037-.367 1.447-.495.413-1.259-.167-1.601.22-.324.388.444.846.26 1.325-.183.48-.807-.026-1.065.707-.258.733-.418 2.014-.418 2.014h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M299.448 179.8c.572-.203 1.336-.093 1.811-.056a5.356 5.356 0 00-1.69-.137l-.125.2.004-.007zm1.685-1.319c.236-.523.184-.95.17-1.392.07.41.153.817.034 1.287l-.211.1.007.005zm-1.92 1.293c.245-.519.363-.669.357-1.107.07.41-.03.544-.148 1.013l-.212.101.004-.007z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M297.087 183.3c.809-2.81 3.86-4.917 7.31-6.671-2.066.896-6.747 2.994-7.602 6.774l.292-.104z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M301.72 178.232c.641-.052 1.093.124 1.567.258-.421-.177-.847-.366-1.387-.412l-.176.147-.004.007z"
  })), /*#__PURE__*/_react.default.createElement("g", null, /*#__PURE__*/_react.default.createElement("path", {
    d: "M300.098 192.059c-.683-.526-.926-1.424-1.465-1.86-.572-.465-.568.522-.996.147-.427-.363-.14-1.124-.722-1.63-.587-.501-1.081-.019-1.51-.47-.424-.445.186-.885-.389-1.386-.575-.5-1.304-.01-2.005-.541-.688-.52-1.32-.186-1.051.555.18.488.698.753.978 1.483.28.729-.257 1.012.176 1.446.445.422 1-.164 1.593.278.581.442.247 1.19.75 1.485.502.295.703-.45 1.25-.306.549.155.248.764 1.07.97.824.207 2.314-.177 2.314-.177l.007.006z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M301.238 192.27c-3.098-.624-6.183-2.797-9.114-5.96 1.6 1.908 5.22 5.615 9.316 6.233l-.202-.273z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M296.926 190.521c-.401-.52-.483-.96-.607-1.407.063.422.113.832.368 1.304l.233.109.006-.006zm-2.297-1.774c-.26-.594-.237-1.032-.25-1.482-.044.408-.094.81.048 1.327l.209.161-.007-.006zm.457.551c-.605-.197-1.016-.128-1.459-.1.392-.075.775-.18 1.282-.095l.177.195zm2.17 1.562c-.606-.209-1.021-.134-1.458-.1.39-.087.769-.186 1.282-.096l.177.196z"
  })), /*#__PURE__*/_react.default.createElement("g", null, /*#__PURE__*/_react.default.createElement("path", {
    d: "M297.762 187.74c-.494-.565-.511-1.338-.897-1.798-.42-.492-.635.312-.94-.071-.312-.387.134-.949-.28-1.48-.419-.517-.982-.217-1.267-.669-.285-.452.377-.692-.034-1.206-.4-.517-1.184-.259-1.694-.83-.508-.555-1.16-.404-1.083.25.05.446.46.755.549 1.405.088.65-.468.773-.166 1.207.303.433.942.064 1.372.534.426.477-.048 1.018.34 1.36.391.334.744-.232 1.208-.003.467.222.051.668.75.996.7.32 2.15.309 2.15.309l-.008-.004z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M298.756 188.133c-2.67-1.106-4.97-3.477-6.906-6.623 1.009 1.871 3.447 5.585 7.024 6.885l-.118-.262h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M295.238 185.88c-.241-.51-.21-.88-.226-1.27-.042.348-.092.693.034 1.138l.192.131h0zm-1.673-1.896c-.106-.538.02-.885.102-1.259-.13.329-.27.644-.251 1.094l.149.165h0zm.284.545c-.503-.296-.888-.305-1.3-.367.378.005.743-.003 1.185.166l.118.194-.003.007zm1.61 1.682c-.497-.286-.887-.306-1.301-.36.377.005.75 0 1.195.162l.107.198z"
  })))), /*#__PURE__*/_react.default.createElement("g", {
    fillRule: "nonzero",
    stroke: "#D4AF37",
    strokeWidth: "0.5"
  }, /*#__PURE__*/_react.default.createElement("path", {
    fill: "#007EA8",
    d: "M291 195.6l-14 17.5a26.2 26.2 0 017.3 17.9 53.7 53.7 0 01-2.8 17.5v.2H320V196c-8.5 5.2-20.1 7.3-29-.4z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#FFF",
    d: "M349 195.6c-8.8 7.7-20.5 5.6-29 .4v52.7h38.5v-.2a53.7 53.7 0 01-2.8-17.5c0-6 2.7-13.5 7.3-17.9l-14-17.5h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#D91023",
    d: "M281.5 248.7c-2.1 6.5-4.8 12.2-5.6 21.6-1.2 14 10 21.5 14.6 23.7 7.2 3.4 14.6 2.2 22.3 3.2 3.5.5 5.5 2.7 7.2 4.5 1.7-1.8 3.7-4 7.3-4.5 7.6-1 15 .2 22.2-3.2 4.6-2.2 15.8-9.8 14.6-23.7-.8-9.4-3.5-15.1-5.6-21.6h-77 0z"
  })), /*#__PURE__*/_react.default.createElement("g", {
    fillRule: "nonzero",
    stroke: "#D4AF37"
  }, /*#__PURE__*/_react.default.createElement("g", {
    fill: "#00A854",
    strokeWidth: "0.5"
  }, /*#__PURE__*/_react.default.createElement("path", {
    d: "M323.548 229.598s.498-1.814 1.52-2.605c1.013-.8 2.127-.507 2.803-.791-.456.604-.507 1.804-1.52 2.604s-2.803.792-2.803.792zm4.112-3.236c-.701.204-1.14-.027-2.111.356l2.11-.356zm-.642.516c-.71.195-1.19-.125-2.145.302l2.145-.302zm-.777.604c-.675.249-.988-.107-1.9.356l1.9-.356zm-.777.622c-.675.24-.81-.16-1.477.374l1.477-.374zm-.692.534c-.439.15-.633-.018-1.03.444l1.03-.444zm2.888-2.267c-.38.649-.296 1.155-.912 2.027l.912-2.027zm-.642.507c-.38.648-.236 1.235-.886 2.07l.886-2.07zm-.777.604c-.422.604-.185 1.022-.87 1.813l.87-1.813zm-.785.613c-.414.605-.084.863-.76 1.387l.76-1.387zm-.684.543c-.253.4-.169.648-.7.906l.7-.906z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M328.285 225.846l-2.044 1.6-2.668 2.134 2.702-2.09 2.044-1.6-.034-.044zm-1.909-6.524s1.41 1.155 1.731 2.444c.321 1.29-.337 2.267-.337 3.031-.372-.657-1.41-1.155-1.748-2.444-.338-1.289.346-3.031.346-3.031h.008zm1.318 5.218c.084-.765.447-1.103.481-2.187l-.481 2.187zm-.203-.827c.084-.756.54-1.12.524-2.196l-.524 2.196zm-.253-.978c.025-.746.456-.924.388-1.99l-.388 1.99zm-.254-.986c.034-.747.44-.738.211-1.592l-.21 1.592zm-.22-.88c.026-.48.254-.623-.016-1.174l.017 1.174zm.93 3.67c-.431-.622-.912-.72-1.444-1.644l1.444 1.645zm-.203-.817c-.44-.622-1.013-.693-1.503-1.636l1.503 1.636zm-.253-.987c-.38-.63-.836-.56-1.284-1.52l1.284 1.52zm-.254-.986c-.38-.632-.726-.41-.928-1.263l.928 1.263zm-.22-.88c-.252-.4-.506-.4-.54-1.023l.54 1.023z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M327.93 225.34l-.659-2.587-.895-3.404.845 3.422c.217.86.436 1.719.658 2.578m6.789-1.129s1.419 1.155 1.74 2.453c.32 1.289-.338 2.267-.338 3.022-.371-.657-1.41-1.155-1.74-2.435-.337-1.29.338-3.04.338-3.04zm1.326 5.218c.085-.756.456-1.103.481-2.187l-.48 2.187zm-.203-.818c.085-.765.54-1.12.524-2.205l-.524 2.205zm-.253-.987c.025-.747.456-.924.389-1.991l-.389 1.991zm-.253-.987c.034-.746.439-.728.21-1.582l-.21 1.582zm-.22-.87c.034-.49.254-.623-.017-1.174l.017 1.173zm.93 3.662c-.432-.614-.913-.712-1.445-1.645l1.444 1.645zm-.204-.818c-.439-.614-1.013-.685-1.503-1.627l1.503 1.627zm-.253-.987c-.38-.622-.836-.56-1.275-1.511l1.275 1.511zm-.253-.978c-.38-.64-.726-.417-.929-1.27l.929 1.27zm-.22-.88c-.253-.4-.506-.409-.54-1.022l.54 1.022z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M336.23 230.246l-.658-2.595-.895-3.396.844 3.414c.217.863.437 1.725.659 2.586l.05-.009zm-4.593 5.103s.245-1.867 1.14-2.81c.903-.941 2.043-.817 2.668-1.2-.363.659-.253 1.859-1.14 2.81-.895.942-2.668 1.2-2.668 1.2zm3.63-3.823c-.675.303-1.13.152-2.043.667l2.044-.667zm-.573.605c-.676.302-1.2.062-2.077.622l2.077-.622zm-.684.72c-.625.347-.988.044-1.833.64l1.833-.64zm-.684.729c-.633.338-.82-.036-1.41.595l1.41-.595zm-.608.63c-.422.214-.633.09-.954.605l.954-.604zm2.55-2.684c-.287.712-.144 1.192-.633 2.143l.633-2.143zm-.574.605c-.287.702-.06 1.253-.591 2.187l.59-2.187zm-.684.72c-.33.658-.042 1.04-.608 1.929l.608-1.93zm-.693.72c-.32.667.034.862-.565 1.484l.565-1.484zm-.608.64c-.202.444-.076.667-.565 1.004l.565-1.004z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M335.808 230.913l-1.798 1.902-2.356 2.507s1.596-1.636 2.39-2.471c.604-.63 1.206-1.26 1.807-1.893m-13.798-8.223s1.74-.453 2.905.08c1.165.534 1.478 1.69 2.052 2.16-.718-.106-1.731.445-2.905-.08-1.165-.515-2.043-2.16-2.043-2.16h-.009zm4.72 2.134c-.506-.534-.549-1.05-1.342-1.743l1.342 1.743zm-.743-.338c-.506-.534-.498-1.147-1.317-1.796l1.317 1.796zm-.895-.4c-.532-.49-.397-.951-1.241-1.547l1.241 1.547zm-.886-.4c-.54-.49-.28-.818-1.056-1.156l1.056 1.156zm-.794-.356c-.338-.329-.304-.595-.878-.71l.878.71zm3.318 1.494c-.726-.018-1.097.31-2.128.177l2.128-.177zm-.743-.338c-.726-.018-1.131.409-2.145.23l2.145-.23zm-.886-.4c-.71-.08-.93.346-1.926.115l1.926-.115zm-.895-.4c-.701-.08-.752.346-1.52-.01l1.52.01zm-.794-.365c-.456-.035-.608.178-1.098-.177l1.098.177z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M327.516 225.17l-2.339-1.048-3.09-1.369 3.065 1.422c.779.358 1.558.714 2.339 1.067l.025-.071zm-4.171-11.804s1.241-1.36 2.491-1.555c1.258-.205 2.111.595 2.829.675-.659.311-1.242 1.351-2.491 1.565-1.258.213-2.829-.685-2.829-.685h0zm5.066-.835c-.709-.178-.996-.587-2.018-.73l2.018.73zm-.793.133c-.71-.178-1.005-.693-2.027-.791l2.027.791zm-.963.16c-.7-.116-.819-.578-1.832-.622l1.832.622zm-.954.151c-.701-.107-.65-.533-1.478-.382l1.478.382zm-.853.151c-.456-.089-.557-.338-1.106-.115l1.106.115zm3.563-.595c-.624.39-.776.88-1.705 1.342l1.705-1.342zm-.793.133c-.625.391-.76.978-1.706 1.396l1.706-1.396zm-.963.151c-.633.338-.616.818-1.57 1.182l1.57-1.182zm-.954.16c-.633.329-.465.711-1.292.845l1.292-.845zm-.853.142c-.405.223-.439.49-1.022.454l1.022-.454z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M329.197 212.388l-2.517.41c-1.106.177-3.31.568-3.31.568l3.319-.515 2.516-.41-.008-.053zm-3.344-5.333s1.689.622 2.381 1.742c.692 1.12.355 2.267.583 2.996-.54-.507-1.68-.631-2.381-1.742-.701-1.12-.583-2.996-.583-2.996zm2.82 4.516c-.143-.756.093-1.2-.202-2.24l.202 2.24zm-.439-.711c-.143-.756.177-1.245-.169-2.267l.17 2.267zm-.532-.854c-.194-.71.152-1.03-.228-2.018l.228 2.018zm-.54-.862c-.195-.711.194-.836-.27-1.564l.27 1.564zm-.473-.747c-.11-.47.05-.675-.363-1.11l.363 1.11zm1.984 3.174c-.59-.445-1.08-.391-1.866-1.085l1.866 1.085zm-.439-.711c-.6-.445-1.165-.32-1.917-1.058l1.917 1.058zm-.532-.854c-.549-.47-.963-.258-1.672-1.022l1.672 1.022zm-.54-.853c-.55-.471-.802-.151-1.267-.889l1.267.889zm-.473-.756c-.363-.302-.6-.213-.81-.8l.81.8z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M329.146 212.264l-1.402-2.24-1.866-2.933 1.824 2.96c.462.748.927 1.494 1.393 2.24m6.19-.507s1.41 1.156 1.74 2.444c.32 1.29-.347 2.267-.347 3.032-.363-.658-1.402-1.156-1.74-2.445-.337-1.289.338-3.031.338-3.031h.009zm1.326 5.218c.084-.765.447-1.102.472-2.187l-.472 2.187zm-.203-.818c.084-.764.54-1.129.523-2.204l-.523 2.204zm-.253-.987c.025-.746.456-.924.38-1.99l-.38 1.99zm-.254-.986c.026-.747.43-.738.211-1.591l-.21 1.59zm-.228-.88c.034-.48.254-.623-.017-1.165l.017 1.165zm.938 3.67c-.44-.613-.912-.72-1.453-1.644l1.453 1.645zm-.212-.817c-.439-.622-1.004-.684-1.503-1.636l1.503 1.636zm-.244-.987c-.38-.63-.845-.56-1.284-1.52l1.284 1.52zm-.254-.986c-.38-.631-.726-.41-.937-1.263l.937 1.263zm-.228-.88c-.253-.4-.506-.4-.532-1.023l.532 1.023z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M336.839 217.802l-.66-2.587-.886-3.404s.55 2.275.845 3.422c.214.86.43 1.72.65 2.578l.05-.01zm-5.49 3.475s.693-1.733 1.8-2.4c1.097-.657 2.17-.23 2.87-.426-.515.533-.7 1.724-1.798 2.4-1.098.675-2.871.435-2.871.435v-.009zm4.442-2.693c-.717.107-1.131-.169-2.127.089l2.127-.089zm-.692.427c-.726.106-1.182-.267-2.162.035l2.162-.035zm-.844.506c-.693.17-.963-.222-1.926.125l1.926-.125zm-.836.516c-.693.16-.786-.258-1.52.196l1.52-.196zm-.752.453c-.447.09-.625-.089-1.064.32l1.064-.32zm3.124-1.902c-.447.605-.422 1.12-1.131 1.902l1.131-1.902zm-.692.427c-.456.604-.371 1.2-1.115 1.955l1.115-1.955zm-.844.506c-.482.552-.296.996-1.064 1.69l1.064-1.69zm-.836.516c-.482.542-.186.836-.92 1.271l.92-1.271zm-.752.453c-.295.356-.236.623-.794.81l.794-.81z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M336.467 218.14l-2.195 1.342-2.897 1.787 2.913-1.734c.736-.445 1.471-.892 2.204-1.342m-3.867-9.983s1.663-.71 2.888-.355c1.224.356 1.689 1.449 2.313 1.84-.726 0-1.655.693-2.879.356-1.224-.356-2.322-1.84-2.322-1.84h0zm4.957 1.414c-.583-.462-.684-.969-1.563-1.529l1.563 1.529zm-.786-.222c-.574-.462-.641-1.067-1.537-1.591l1.537 1.59zm-.929-.267c-.6-.4-.532-.889-1.435-1.351l1.435 1.351zm-.937-.267c-.59-.4-.388-.764-1.199-.986l1.2.986zm-.836-.24c-.38-.266-.38-.533-.962-.568l.962.568zm3.488.996c-.727.089-1.056.462-2.078.489l2.078-.489zm-.777-.222c-.726.089-1.073.569-2.094.542l2.094-.542zm-.938-.267c-.709.027-.878.48-1.891.4l1.891-.4zm-.937-.267c-.71.027-.7.445-1.511.214l1.511-.214zm-.836-.23c-.456.017-.59.248-1.106-.036l1.106.035z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M338.35 209.81l-2.449-.702-3.25-.888 3.233.95c.816.234 1.632.465 2.45.694l.016-.053zm-2.947-6.497s1.647.729 2.28 1.893c.625 1.156.22 2.285.405 3.022-.506-.542-1.638-.737-2.28-1.893-.633-1.156-.405-3.022-.405-3.022zm2.559 4.684c-.102-.764.168-1.19-.076-2.249l.076 2.25zm-.406-.738c-.101-.764.254-1.235-.025-2.275l.025 2.275zm-.481-.888c-.152-.73.22-1.014-.11-2.027l.11 2.027zm-.481-.89c-.152-.728.236-.826-.186-1.582l.186 1.583zm-.431-.782c-.084-.47.084-.666-.304-1.128l.304 1.128zm1.799 3.298c-.575-.48-1.064-.453-1.807-1.2l1.807 1.2zm-.406-.738c-.574-.48-1.14-.39-1.849-1.173l1.85 1.173zm-.481-.888c-.524-.507-.946-.312-1.604-1.12l1.604 1.12zm-.481-.88c-.524-.507-.803-.205-1.216-.978l1.216.978zm-.431-.8c-.338-.312-.591-.24-.768-.836l.768.836z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M338.375 208.708l-1.266-2.329-1.69-3.048 1.648 3.075c.42.778.842 1.554 1.266 2.33m-6.367 13.884s1.419 1.155 1.74 2.453c.32 1.289-.338 2.267-.338 3.022-.371-.657-1.41-1.155-1.74-2.435-.337-1.29.338-3.04.338-3.04zm1.326 5.218c.084-.756.456-1.103.481-2.187l-.481 2.187zm-.203-.818c.085-.765.54-1.12.524-2.205l-.524 2.205zm-.253-.987c.025-.747.456-.924.388-1.991l-.388 1.991zm-.253-.987c.034-.746.439-.729.21-1.582l-.21 1.582zm-.22-.87c.034-.49.254-.623-.017-1.174l.017 1.173zm.929 3.662c-.43-.614-.912-.712-1.444-1.645l1.444 1.645zm-.203-.818c-.439-.614-1.013-.685-1.503-1.627l1.503 1.627zm-.253-.987c-.38-.622-.836-.56-1.275-1.511l1.275 1.511zm-.253-.978c-.38-.64-.726-.418-.93-1.27l.93 1.27zm-.22-.88c-.253-.4-.506-.409-.54-1.022l.54 1.022z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M333.528 228.646l-.658-2.595-.895-3.396.844 3.414c.217.863.437 1.725.659 2.586l.05-.009zm-4.593 5.103s.245-1.867 1.14-2.81c.903-.941 2.043-.817 2.668-1.2-.363.659-.253 1.859-1.14 2.81-.895.942-2.668 1.2-2.668 1.2zm3.63-3.823c-.675.303-1.13.152-2.043.667l2.044-.667zm-.573.605c-.676.302-1.2.062-2.078.622l2.078-.622zm-.684.72c-.625.347-.988.044-1.833.64l1.833-.64zm-.684.729c-.634.338-.82-.036-1.41.595l1.41-.595zm-.608.63c-.422.214-.634.09-.954.605l.954-.604zm2.55-2.684c-.287.712-.144 1.192-.633 2.143l.633-2.143zm-.574.605c-.287.702-.06 1.253-.591 2.187l.59-2.187zm-.684.72c-.33.658-.043 1.04-.608 1.929l.608-1.93zm-.693.72c-.32.667.034.862-.565 1.484l.565-1.484zm-.608.64c-.202.444-.076.667-.565 1.004l.565-1.004z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M333.106 229.313l-1.798 1.902-2.356 2.507s1.596-1.636 2.39-2.471c.604-.63 1.206-1.26 1.806-1.893m-3.884-8.338s1.419 1.155 1.74 2.453c.32 1.289-.338 2.267-.338 3.022-.372-.657-1.41-1.155-1.74-2.435-.337-1.29.338-3.04.338-3.04h0zm1.326 5.218c.084-.756.456-1.103.481-2.187l-.481 2.187zm-.203-.818c.085-.765.54-1.12.524-2.205l-.524 2.205zm-.253-.987c.025-.747.456-.924.388-1.991l-.388 1.991zm-.253-.987c.033-.746.439-.729.21-1.582l-.21 1.582zm-.22-.87c.034-.49.253-.623-.017-1.174l.017 1.173zm.929 3.662c-.43-.614-.912-.712-1.444-1.645l1.444 1.645zm-.203-.818c-.439-.614-1.013-.685-1.503-1.627l1.503 1.627zm-.253-.987c-.38-.622-.836-.56-1.275-1.511l1.275 1.511zm-.253-.978c-.38-.64-.727-.418-.93-1.27l.93 1.27zm-.22-.88c-.253-.4-.507-.409-.54-1.022l.54 1.022z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M330.826 227.046l-.658-2.595-.895-3.396.844 3.414c.217.863.437 1.725.659 2.586l.05-.009zm-4.593 5.103s.245-1.867 1.14-2.81c.903-.941 2.043-.817 2.668-1.2-.363.659-.253 1.859-1.14 2.81-.895.942-2.668 1.2-2.668 1.2zm3.63-3.823c-.675.303-1.13.152-2.043.667l2.044-.667zm-.573.605c-.676.302-1.2.062-2.078.622l2.078-.622zm-.684.72c-.625.347-.988.044-1.833.64l1.833-.64zm-.684.729c-.634.338-.82-.036-1.41.595l1.41-.595zm-.608.63c-.423.214-.634.09-.954.605l.954-.604zm2.55-2.684c-.287.712-.144 1.192-.634 2.143l.634-2.143zm-.574.605c-.288.702-.06 1.253-.591 2.187l.59-2.187zm-.684.72c-.33.658-.043 1.04-.608 1.929l.608-1.93zm-.693.72c-.32.667.034.862-.566 1.484l.566-1.484zm-.608.64c-.202.444-.076.667-.565 1.004l.565-1.004z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M330.404 227.713l-1.798 1.902-2.356 2.507s1.596-1.636 2.39-2.471c.604-.63 1.206-1.26 1.806-1.893M330.05 208.228s1.41 1.156 1.739 2.445c.32 1.289-.346 2.267-.346 3.031-.363-.658-1.402-1.156-1.74-2.444-.337-1.29.338-3.032.338-3.032h.009zm1.325 5.218c.085-.764.448-1.102.473-2.186l-.473 2.186zm-.202-.818c.084-.764.54-1.128.523-2.204l-.523 2.204zm-.254-.986c.026-.747.456-.925.38-1.991l-.38 1.99zm-.253-.987c.025-.747.43-.738.211-1.591l-.211 1.591zm-.228-.88c.034-.48.253-.622-.017-1.164l.017 1.164zm.937 3.671c-.439-.613-.912-.72-1.452-1.644l1.452 1.644zm-.21-.818c-.44-.622-1.006-.684-1.504-1.635l1.503 1.635zm-.246-.986c-.38-.631-.844-.56-1.283-1.52l1.283 1.52zm-.253-.987c-.38-.631-.726-.409-.937-1.262l.937 1.262zm-.228-.88c-.253-.4-.507-.4-.532-1.022l.532 1.022z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M331.603 214.246l-.658-2.586-.887-3.405s.549 2.276.844 3.422c.215.86.431 1.72.65 2.578l.051-.009zm-5.488 3.476s.692-1.734 1.798-2.4c1.098-.658 2.17-.231 2.871-.427-.515.533-.7 1.725-1.798 2.4-1.098.676-2.871.436-2.871.436v-.01zm4.441-2.694c-.718.107-1.131-.168-2.128.09l2.128-.09zm-.692.427c-.726.107-1.182-.267-2.162.036l2.162-.036zm-.845.507c-.692.169-.962-.222-1.925.124l1.925-.124zm-.836.515c-.692.16-.785-.257-1.52.196l1.52-.196zm-.751.454c-.448.089-.625-.09-1.064.32l1.064-.32zm3.124-1.903c-.447.605-.422 1.12-1.131 1.903l1.131-1.903zm-.692.427c-.456.605-.372 1.2-1.115 1.956l1.115-1.956zm-.845.507c-.48.55-.295.995-1.064 1.689l1.064-1.69zm-.836.515c-.48.543-.185.836-.92 1.272l.92-1.272zm-.751.454c-.296.355-.237.622-.794.809l.794-.81z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M331.232 214.584l-2.196 1.342-2.896 1.787 2.913-1.733c.736-.446 1.47-.893 2.204-1.343"
  }), /*#__PURE__*/_react.default.createElement("g", null, /*#__PURE__*/_react.default.createElement("path", {
    d: "M332.667 210.006s1.41 1.156 1.74 2.445c.32 1.289-.347 2.266-.347 3.03-.363-.657-1.401-1.155-1.739-2.444-.338-1.289.338-3.03.338-3.03h.008zm1.326 5.218c.084-.764.447-1.102.473-2.187l-.473 2.187zm-.203-.818c.085-.764.54-1.129.524-2.204l-.524 2.204zm-.253-.986c.025-.747.456-.925.38-1.992l-.38 1.992zm-.253-.987c.025-.747.43-.738.21-1.591l-.21 1.59zm-.228-.88c.033-.48.253-.622-.017-1.165l.017 1.165zm.937 3.671c-.44-.613-.912-.72-1.452-1.644l1.452 1.644zm-.211-.818c-.44-.622-1.005-.684-1.503-1.635l1.503 1.635zm-.245-.986c-.38-.632-.844-.56-1.284-1.52l1.284 1.52zm-.253-.987c-.38-.631-.727-.409-.938-1.262l.938 1.262zm-.228-.88c-.254-.4-.507-.4-.532-1.022l.532 1.022z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M334.22 216.024l-.658-2.587-.886-3.404s.548 2.275.844 3.422c.214.86.431 1.72.65 2.578l.05-.009zm-5.488 3.476s.693-1.734 1.799-2.4c1.098-.658 2.17-.231 2.87-.427-.514.533-.7 1.724-1.798 2.4-1.097.676-2.87.436-2.87.436v-.01zm4.442-2.694c-.718.107-1.132-.169-2.128.09l2.128-.09zm-.693.427c-.726.107-1.182-.267-2.161.036l2.161-.036zm-.844.507c-.692.169-.963-.223-1.925.124l1.925-.124zm-.836.515c-.692.16-.785-.258-1.52.196l1.52-.196zm-.751.454c-.448.088-.625-.09-1.064.32l1.064-.32zm3.124-1.903c-.448.605-.422 1.12-1.132 1.903l1.132-1.903zm-.693.427c-.456.604-.371 1.2-1.114 1.956l1.114-1.956zm-.844.507c-.481.55-.296.995-1.064 1.689l1.064-1.69zm-.836.515c-.481.542-.186.836-.92 1.271l.92-1.27zm-.751.454c-.296.355-.237.622-.794.808l.794-.808z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M333.85 216.362l-2.196 1.342-2.896 1.787 2.913-1.734c.736-.445 1.47-.892 2.204-1.342"
  }))), /*#__PURE__*/_react.default.createElement("g", {
    fill: "#00A854",
    strokeWidth: "0.5"
  }, /*#__PURE__*/_react.default.createElement("path", {
    d: "M353.237 229.598s-.498-1.814-1.52-2.605c-1.013-.8-2.128-.507-2.804-.791.456.604.507 1.804 1.52 2.604 1.014.8 2.804.792 2.804.792zm-4.112-3.236c.7.204 1.14-.027 2.11.356l-2.11-.356zm.641.516c.71.195 1.19-.125 2.145.302l-2.145-.302zm.777.604c.676.249.988-.107 1.9.356l-1.9-.356zm.777.622c.676.24.81-.16 1.478.374l-1.478-.374zm.692.534c.44.15.634-.018 1.03.444l-1.03-.444zm-2.887-2.267c.38.649.295 1.155.911 2.027l-.911-2.027zm.641.507c.38.648.237 1.235.887 2.07l-.887-2.07zm.777.604c.422.604.186 1.022.87 1.813l-.87-1.813zm.785.613c.414.605.085.863.76 1.387l-.76-1.387zm.684.543c.254.4.17.648.701.906l-.7-.906z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M348.5 225.846l2.043 1.6 2.668 2.134-2.702-2.09-2.043-1.6.034-.044zm1.908-6.524s-1.41 1.155-1.731 2.444c-.32 1.29.338 2.267.338 3.031.371-.657 1.41-1.155 1.748-2.444.337-1.289-.347-3.031-.347-3.031h-.008zm-1.317 5.218c-.085-.765-.448-1.103-.482-2.187l.482 2.187zm.202-.827c-.084-.756-.54-1.12-.523-2.196l.523 2.196zm.254-.978c-.026-.746-.456-.924-.389-1.99l.389 1.99zm.253-.986c-.034-.747-.439-.738-.211-1.592l.211 1.592zm.22-.88c-.026-.48-.254-.623.016-1.174l-.016 1.174zm-.93 3.67c.431-.622.913-.72 1.445-1.644l-1.444 1.645zm.203-.817c.44-.622 1.014-.693 1.503-1.636l-1.503 1.636zm.254-.987c.38-.63.836-.56 1.283-1.52l-1.283 1.52zm.253-.986c.38-.632.726-.41.929-1.263l-.929 1.263zm.22-.88c.253-.4.506-.4.54-1.023l-.54 1.023z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M348.854 225.34l.659-2.587.895-3.404-.844 3.422c-.217.86-.437 1.719-.659 2.578m-6.789-1.129s-1.419 1.155-1.74 2.453c-.32 1.289.338 2.267.338 3.022.372-.657 1.41-1.155 1.74-2.435.338-1.29-.338-3.04-.338-3.04zm-1.326 5.218c-.084-.756-.456-1.103-.481-2.187l.481 2.187zm.203-.818c-.084-.765-.54-1.12-.524-2.205l.524 2.205zm.253-.987c-.025-.747-.456-.924-.388-1.991l.388 1.991zm.254-.987c-.034-.746-.44-.728-.211-1.582l.21 1.582zm.22-.87c-.035-.49-.254-.623.016-1.174l-.017 1.173zm-.93 3.662c.431-.614.912-.712 1.444-1.645l-1.444 1.645zm.203-.818c.44-.614 1.013-.685 1.503-1.627l-1.503 1.627zm.253-.987c.38-.622.836-.56 1.275-1.511l-1.275 1.511zm.254-.978c.38-.64.726-.417.928-1.27l-.928 1.27zm.22-.88c.252-.4.506-.409.54-1.022l-.54 1.022z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M340.554 230.246l.659-2.595.895-3.396-.845 3.414a477.65 477.65 0 01-.658 2.586l-.051-.009zm4.593 5.103s-.244-1.867-1.14-2.81c-.903-.941-2.043-.817-2.668-1.2.363.659.253 1.859 1.14 2.81.895.942 2.668 1.2 2.668 1.2zm-3.63-3.823c.675.303 1.131.152 2.043.667l-2.044-.667zm.574.605c.675.302 1.199.062 2.077.622l-2.077-.622zm.684.72c.625.347.988.044 1.832.64l-1.832-.64zm.684.729c.633.338.819-.036 1.41.595l-1.41-.595zm.608.63c.422.214.633.09.954.605l-.954-.604zm-2.55-2.684c.287.712.143 1.192.633 2.143l-.634-2.143zm.574.605c.287.702.059 1.253.59 2.187l-.59-2.187zm.684.72c.329.658.042 1.04.608 1.929l-.608-1.93zm.692.72c.32.667-.034.862.566 1.484l-.566-1.484zm.608.64c.203.444.076.667.566 1.004l-.566-1.004z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M340.976 230.913l1.799 1.902 2.356 2.507s-1.596-1.636-2.39-2.471a440.34 440.34 0 01-1.807-1.893m13.797-8.223s-1.74-.453-2.904.08c-1.166.534-1.478 1.69-2.052 2.16.717-.106 1.73.445 2.904-.08 1.166-.515 2.044-2.16 2.044-2.16h.008zm-4.72 2.134c.507-.534.549-1.05 1.343-1.743l-1.343 1.743zm.743-.338c.507-.534.498-1.147 1.317-1.796l-1.317 1.796zm.895-.4c.532-.49.397-.951 1.242-1.547l-1.242 1.547zm.887-.4c.54-.49.279-.818 1.055-1.156l-1.055 1.156zm.794-.356c.337-.329.304-.595.878-.71l-.878.71zm-3.319 1.494c.726-.018 1.098.31 2.128.177l-2.128-.177zm.743-.338c.726-.018 1.132.409 2.145.23l-2.145-.23zm.887-.4c.71-.08.929.346 1.925.115l-1.925-.115zm.895-.4c.7-.08.751.346 1.52-.01l-1.52.01zm.794-.365c.456-.035.608.178 1.097-.177l-1.097.177z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M349.268 225.17l2.34-1.048 3.09-1.369-3.066 1.422c-.778.358-1.558.714-2.339 1.067l-.025-.071zm4.171-11.804s-1.24-1.36-2.49-1.555c-1.259-.205-2.112.595-2.83.675.66.311 1.242 1.351 2.492 1.565 1.258.213 2.828-.685 2.828-.685h0zm-5.066-.835c.71-.178.996-.587 2.018-.73l-2.018.73zm.794.133c.71-.178 1.005-.693 2.026-.791l-2.026.791zm.962.16c.701-.116.82-.578 1.833-.622l-1.833.622zm.955.151c.7-.107.65-.533 1.477-.382l-1.477.382zm.852.151c.456-.089.558-.338 1.107-.115l-1.107.115zm-3.563-.595c.625.39.777.88 1.706 1.342l-1.706-1.342zm.794.133c.625.391.76.978 1.705 1.396l-1.705-1.396zm.962.151c.634.338.617.818 1.571 1.182l-1.57-1.182zm.955.16c.633.329.464.711 1.291.845l-1.291-.845zm.852.142c.406.223.44.49 1.022.454l-1.022-.454z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M347.588 212.388l2.516.41c1.106.177 3.31.568 3.31.568l-3.318-.515-2.517-.41.009-.053zm3.344-5.333s-1.69.622-2.382 1.742c-.692 1.12-.354 2.267-.582 2.996.54-.507 1.68-.631 2.38-1.742.702-1.12.584-2.996.584-2.996zm-2.82 4.516c.143-.756-.094-1.2.202-2.24l-.203 2.24zm.438-.711c.144-.756-.177-1.245.17-2.267l-.17 2.267zm.532-.854c.195-.71-.152-1.03.228-2.018l-.228 2.018zm.54-.862c.195-.711-.193-.836.27-1.564l-.27 1.564zm.474-.747c.11-.47-.051-.675.363-1.11l-.363 1.11zm-1.985 3.174c.591-.445 1.081-.391 1.866-1.085l-1.866 1.085zm.44-.711c.599-.445 1.165-.32 1.916-1.058l-1.917 1.058zm.531-.854c.55-.47.963-.258 1.672-1.022l-1.672 1.022zm.54-.853c.55-.471.803-.151 1.267-.889l-1.266.889zm.474-.756c.363-.302.6-.213.81-.8l-.81.8z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M347.638 212.264l1.402-2.24 1.866-2.933-1.824 2.96c-.462.748-.926 1.494-1.393 2.24m-6.189-.507s-1.41 1.156-1.74 2.444c-.32 1.29.346 2.267.346 3.032.363-.658 1.402-1.156 1.74-2.445.338-1.289-.338-3.031-.338-3.031h-.008zm-1.326 5.218c-.085-.765-.448-1.102-.473-2.187l.473 2.187zm.203-.818c-.085-.764-.54-1.129-.524-2.204l.524 2.204zm.253-.987c-.025-.746-.456-.924-.38-1.99l.38 1.99zm.253-.986c-.025-.747-.43-.738-.21-1.591l.21 1.59zm.228-.88c-.034-.48-.253-.623.017-1.165l-.017 1.165zm-.937 3.67c.439-.613.912-.72 1.452-1.644l-1.452 1.645zm.211-.817c.44-.622 1.005-.684 1.503-1.636l-1.503 1.636zm.245-.987c.38-.63.844-.56 1.283-1.52l-1.283 1.52zm.253-.986c.38-.631.726-.41.937-1.263l-.937 1.263zm.228-.88c.254-.4.507-.4.532-1.023l-.532 1.023z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M339.946 217.802l.659-2.587.886-3.404s-.549 2.275-.844 3.422c-.215.86-.431 1.72-.65 2.578l-.051-.01zm5.489 3.475s-.693-1.733-1.8-2.4c-1.097-.657-2.17-.23-2.87-.426.515.533.7 1.724 1.799 2.4 1.097.675 2.87.435 2.87.435v-.009zm-4.442-2.693c.718.107 1.131-.169 2.128.089l-2.128-.089zm.692.427c.727.106 1.183-.267 2.162.035l-2.162-.035zm.845.506c.692.17.962-.222 1.925.125l-1.925-.125zm.836.516c.692.16.785-.258 1.52.196l-1.52-.196zm.751.453c.448.09.625-.089 1.064.32l-1.064-.32zm-3.124-1.902c.448.605.422 1.12 1.131 1.902l-1.131-1.902zm.692.427c.456.604.372 1.2 1.115 1.955l-1.115-1.955zm.845.506c.481.552.295.996 1.064 1.69l-1.064-1.69zm.836.516c.481.542.186.836.92 1.271l-.92-1.271zm.751.453c.296.356.237.623.794.81l-.794-.81z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M340.317 218.14l2.196 1.342 2.896 1.787-2.913-1.734c-.736-.445-1.47-.892-2.204-1.342m3.868-9.983s-1.664-.71-2.888-.355c-1.225.356-1.69 1.449-2.314 1.84.726 0 1.655.693 2.88.356 1.224-.356 2.321-1.84 2.321-1.84h0zm-4.957 1.414c.582-.462.684-.969 1.562-1.529l-1.562 1.529zm.785-.222c.574-.462.642-1.067 1.537-1.591l-1.537 1.59zm.929-.267c.6-.4.532-.889 1.435-1.351l-1.435 1.351zm.937-.267c.591-.4.389-.764 1.2-.986l-1.2.986zm.836-.24c.38-.266.38-.533.963-.568l-.963.568zm-3.487.996c.726.089 1.055.462 2.077.489l-2.077-.489zm.777-.222c.726.089 1.072.569 2.094.542l-2.094-.542zm.937-.267c.71.027.878.48 1.891.4l-1.891-.4zm.937-.267c.71.027.701.445 1.512.214l-1.512-.214zm.836-.23c.456.017.591.248 1.106-.036l-1.106.035z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M338.434 209.81l2.45-.702 3.25-.888-3.234.95c-.816.234-1.632.465-2.449.694l-.017-.053zm2.947-6.497s-1.646.729-2.28 1.893c-.624 1.156-.219 2.285-.405 3.022.507-.542 1.638-.737 2.28-1.893.633-1.156.405-3.022.405-3.022zm-2.558 4.684c.101-.764-.169-1.19.076-2.249l-.076 2.25zm.405-.738c.102-.764-.253-1.235.026-2.275l-.026 2.275zm.481-.888c.152-.73-.22-1.014.11-2.027l-.11 2.027zm.482-.89c.152-.728-.237-.826.186-1.582l-.186 1.583zm.43-.782c.085-.47-.084-.666.304-1.128l-.304 1.128zm-1.798 3.298c.574-.48 1.064-.453 1.807-1.2l-1.807 1.2zm.405-.738c.574-.48 1.14-.39 1.85-1.173l-1.85 1.173zm.481-.888c.524-.507.946-.312 1.605-1.12l-1.605 1.12zm.482-.88c.523-.507.802-.205 1.216-.978l-1.216.978zm.43-.8c.338-.312.592-.24.769-.836l-.769.836z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M338.41 208.708l1.266-2.329 1.689-3.048-1.647 3.075c-.42.778-.842 1.554-1.267 2.33m6.367 13.884s-1.418 1.155-1.74 2.453c-.32 1.289.338 2.267.338 3.022.372-.657 1.41-1.155 1.74-2.435.338-1.29-.338-3.04-.338-3.04zm-1.326 5.218c-.084-.756-.456-1.103-.48-2.187l.48 2.187zm.203-.818c-.084-.765-.54-1.12-.523-2.205l.523 2.205zm.253-.987c-.025-.747-.456-.924-.388-1.991l.388 1.991zm.254-.987c-.034-.746-.44-.729-.211-1.582l.21 1.582zm.22-.87c-.035-.49-.254-.623.016-1.174l-.017 1.173zm-.93 3.662c.431-.614.912-.712 1.444-1.645l-1.444 1.645zm.203-.818c.44-.614 1.013-.685 1.503-1.627l-1.503 1.627zm.253-.987c.38-.622.836-.56 1.275-1.511l-1.275 1.511zm.254-.978c.38-.64.726-.418.929-1.27l-.93 1.27zm.22-.88c.253-.4.506-.409.54-1.022l-.54 1.022z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M343.256 228.646l.659-2.595.895-3.396-.845 3.414a477.65 477.65 0 01-.658 2.586l-.051-.009zm4.594 5.103s-.245-1.867-1.14-2.81c-.904-.941-2.044-.817-2.669-1.2.363.659.254 1.859 1.14 2.81.895.942 2.669 1.2 2.669 1.2zm-3.631-3.823c.675.303 1.131.152 2.043.667l-2.043-.667zm.574.605c.675.302 1.199.062 2.077.622l-2.077-.622zm.684.72c.625.347.988.044 1.832.64l-1.832-.64zm.684.729c.633.338.819-.036 1.41.595l-1.41-.595zm.608.63c.422.214.633.09.954.605l-.954-.604zm-2.55-2.684c.287.712.143 1.192.633 2.143l-.633-2.143zm.574.605c.287.702.059 1.253.59 2.187l-.59-2.187zm.684.72c.33.658.042 1.04.608 1.929l-.608-1.93zm.692.72c.321.667-.034.862.566 1.484l-.566-1.484zm.608.64c.203.444.076.667.566 1.004l-.566-1.004z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M343.678 229.313l1.799 1.902 2.356 2.507s-1.596-1.636-2.39-2.471a440.34 440.34 0 01-1.807-1.893m3.884-8.338s-1.418 1.155-1.74 2.453c-.32 1.289.338 2.267.338 3.022.372-.657 1.41-1.155 1.74-2.435.338-1.29-.338-3.04-.338-3.04h0zm-1.326 5.218c-.084-.756-.456-1.103-.48-2.187l.48 2.187zm.203-.818c-.084-.765-.54-1.12-.523-2.205l.523 2.205zm.253-.987c-.025-.747-.456-.924-.388-1.991l.388 1.991zm.254-.987c-.034-.746-.44-.729-.211-1.582l.21 1.582zm.22-.87c-.034-.49-.254-.623.016-1.174l-.017 1.173zm-.93 3.662c.431-.614.912-.712 1.444-1.645l-1.444 1.645zm.203-.818c.44-.614 1.013-.685 1.503-1.627l-1.503 1.627zm.253-.987c.38-.622.836-.56 1.275-1.511l-1.275 1.511zm.254-.978c.38-.64.726-.418.929-1.27l-.93 1.27zm.22-.88c.253-.4.506-.409.54-1.022l-.54 1.022z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M345.958 227.046l.659-2.595.895-3.396-.845 3.414a477.65 477.65 0 01-.658 2.586l-.051-.009zm4.594 5.103s-.245-1.867-1.14-2.81c-.904-.941-2.044-.817-2.669-1.2.363.659.254 1.859 1.14 2.81.895.942 2.669 1.2 2.669 1.2zm-3.631-3.823c.675.303 1.131.152 2.043.667l-2.043-.667zm.574.605c.675.302 1.199.062 2.077.622l-2.077-.622zm.684.72c.625.347.988.044 1.832.64l-1.832-.64zm.684.729c.633.338.819-.036 1.41.595l-1.41-.595zm.608.63c.422.214.633.09.954.605l-.954-.604zm-2.55-2.684c.287.712.143 1.192.633 2.143l-.633-2.143zm.574.605c.287.702.059 1.253.59 2.187l-.59-2.187zm.684.72c.33.658.042 1.04.608 1.929l-.608-1.93zm.692.72c.321.667-.034.862.566 1.484l-.566-1.484zm.608.64c.203.444.076.667.566 1.004l-.566-1.004z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M346.38 227.713l1.799 1.902 2.356 2.507s-1.596-1.636-2.39-2.471a440.34 440.34 0 01-1.807-1.893M346.735 208.228s-1.41 1.156-1.74 2.445c-.32 1.289.347 2.267.347 3.031.363-.658 1.401-1.156 1.74-2.444.337-1.29-.339-3.032-.339-3.032h-.008zm-1.326 5.218c-.084-.764-.447-1.102-.473-2.186l.473 2.186zm.203-.818c-.085-.764-.54-1.128-.524-2.204l.524 2.204zm.253-.986c-.025-.747-.456-.925-.38-1.991l.38 1.99zm.253-.987c-.025-.747-.43-.738-.21-1.591l.21 1.591zm.228-.88c-.033-.48-.253-.622.017-1.164l-.017 1.164zm-.937 3.671c.44-.613.912-.72 1.453-1.644l-1.453 1.644zm.211-.818c.44-.622 1.005-.684 1.503-1.635l-1.503 1.635zm.245-.986c.38-.631.845-.56 1.284-1.52l-1.284 1.52zm.253-.987c.38-.631.727-.409.938-1.262l-.938 1.262zm.228-.88c.254-.4.507-.4.532-1.022l-.532 1.022z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M345.181 214.246l.659-2.586.886-3.405s-.548 2.276-.844 3.422c-.214.86-.431 1.72-.65 2.578l-.05-.009zm5.489 3.476s-.693-1.734-1.799-2.4c-1.097-.658-2.17-.231-2.87-.427.514.533.7 1.725 1.798 2.4 1.098.676 2.87.436 2.87.436v-.01zm-4.442-2.694c.718.107 1.132-.168 2.128.09l-2.128-.09zm.693.427c.726.107 1.182-.267 2.161.036l-2.161-.036zm.844.507c.692.169.963-.222 1.925.124l-1.925-.124zm.836.515c.692.16.785-.257 1.52.196l-1.52-.196zm.752.454c.447.089.624-.09 1.063.32l-1.063-.32zm-3.125-1.903c.448.605.422 1.12 1.132 1.903l-1.132-1.903zm.693.427c.456.605.371 1.2 1.114 1.956l-1.114-1.956zm.844.507c.481.55.296.995 1.064 1.689l-1.064-1.69zm.836.515c.481.543.186.836.92 1.272l-.92-1.272zm.752.454c.295.355.236.622.793.809l-.793-.81z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M345.553 214.584l2.195 1.342 2.896 1.787-2.913-1.733c-.736-.446-1.47-.893-2.204-1.343"
  }), /*#__PURE__*/_react.default.createElement("g", null, /*#__PURE__*/_react.default.createElement("path", {
    d: "M344.117 210.006s-1.41 1.156-1.74 2.445c-.32 1.289.347 2.266.347 3.03.363-.657 1.402-1.155 1.74-2.444.337-1.289-.338-3.03-.338-3.03h-.009zm-1.325 5.218c-.085-.764-.448-1.102-.473-2.187l.473 2.187zm.202-.818c-.084-.764-.54-1.129-.523-2.204l.523 2.204zm.254-.986c-.026-.747-.456-.925-.38-1.992l.38 1.992zm.253-.987c-.025-.747-.43-.738-.211-1.591l.21 1.59zm.228-.88c-.034-.48-.253-.622.017-1.165l-.017 1.165zm-.937 3.671c.439-.613.911-.72 1.452-1.644l-1.452 1.644zm.21-.818c.44-.622 1.005-.684 1.504-1.635l-1.503 1.635zm.246-.986c.38-.632.844-.56 1.283-1.52l-1.283 1.52zm.253-.987c.38-.631.726-.409.937-1.262l-.937 1.262zm.228-.88c.253-.4.506-.4.532-1.022l-.532 1.022z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M342.564 216.024l.658-2.587.887-3.404s-.55 2.275-.845 3.422c-.214.86-.43 1.72-.65 2.578l-.05-.009zm5.488 3.476s-.692-1.734-1.798-2.4c-1.098-.658-2.17-.231-2.871-.427.515.533.7 1.724 1.798 2.4 1.098.676 2.871.436 2.871.436v-.01zm-4.441-2.694c.717.107 1.131-.169 2.128.09l-2.128-.09zm.692.427c.726.107 1.182-.267 2.162.036l-2.162-.036zm.844.507c.693.169.963-.223 1.926.124l-1.926-.124zm.836.515c.693.16.786-.258 1.52.196l-1.52-.196zm.752.454c.447.088.625-.09 1.064.32l-1.064-.32zm-3.124-1.903c.447.605.422 1.12 1.131 1.903l-1.131-1.903zm.692.427c.456.604.372 1.2 1.115 1.956l-1.115-1.956zm.844.507c.482.55.296.995 1.064 1.689l-1.064-1.69zm.836.515c.482.542.186.836.92 1.271l-.92-1.27zm.752.454c.295.355.236.622.794.808l-.794-.808z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M342.935 216.362l2.196 1.342 2.896 1.787-2.913-1.734c-.736-.445-1.47-.892-2.204-1.342"
  }))), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#947245",
    strokeWidth: "0.538",
    d: "M338.392 208.646c-.726 3.698-.726 7.031-.726 7.031-.042 1.245-.625 2.107-1.165 1.778-4.636-2.818-5.092-3.333-7.524-5.298 2.052 2.347 2.635 3.396 7.321 6.24.904.552 1.013 1.458.98 2.623l-.135 5.484c-.026.8.48 4.454-1.909 3.04-5.522-3.253-5.387-2.986-8.03-4.587 3.209 2.872 2.06 2.08 7.65 5.485 1.013.613 2.069 2.178 2.069 2.916 0 11.049.16 9.022-1.08 12.364h5.1c-1.242-3.342-1.082-1.315-1.082-12.356 0-.746 1.064-2.31 2.07-2.933 5.59-3.395 4.348-2.604 7.565-5.476-2.643 1.6-2.423 1.334-7.946 4.587-2.39 1.414-1.883-2.24-1.908-3.04l-.135-5.484c-.042-1.165.076-2.071.98-2.623 4.686-2.844 5.268-3.893 7.32-6.24-2.432 1.956-2.888 2.49-7.523 5.298-.54.33-1.123-.533-1.166-1.778 0 0 0-3.333-.726-7.03h0z"
  })), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#E3E4E5",
    fillRule: "nonzero",
    stroke: "#D4AF37",
    strokeLinecap: "square",
    strokeWidth: "0.528",
    d: "M293.942 225.307c-.039.196.312 2.432.117 3.08-.097.883-.117 1.02-.331 2.178-.195 1.157-.468 3.394-.858 4.748a7.364 7.364 0 00-.136 2.433l.701 3.806s.312.392.351.53c.059.157-.02.392 0 .45.195.256.215.53.43.746.038.04.194.02.213.079.04.04.293.059.351.078.156.157.117.255.195.471h-1.228c.04-.55-.39-.765-.39-.765-.058-.059-.565-.196-.623-.53-.078-.47 0-.549 0-.549s-.43-1.766-.585-2.237c-.117-.333-.137-.51-.195-.784-.137-.844-.195-1.217-.624-2.453-.117-.196-.39-.275-.37-.569l.136-.275v-.235l.214-3.041a.374.374 0 00.059-.138c.117-1.726-.8-3.335-1.384-4.905-.117-.274-.02-.588-.137-.863-.623-.196-1.052-1.255-1.286-1.923a4.54 4.54 0 01-.137-2.275.985.985 0 01.195-.491m12.32 7.2c.158-.05.322-.077.488-.078l.195.294c.292.55.663 3.022.858 4.16l.292 1.55s-.078.392.058.843l.117.412c.156.59.332.746.332.746.039.157.273 1.334.331 1.472.29 1.07.46 2.168.507 3.276-.02.922-.02.824.058.903.195.196.293.078.741 1.196 0 .099.04-.039.098.04.039.117.136.098.214.117.156 0 .117.04.234.06.104.013.208.013.312 0h1.072a1.053 1.053 0 00-.955-.668c-.156-.098-.35-.235-.41-.451l-.448-.648c.02-.137-.078-.333-.117-.49l-.39-4.552s.078-.451.078-.922c-.039-2.511.117-5.023.195-7.554.04-.196.78-.922.78-.922"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#FFF",
    fillRule: "nonzero",
    stroke: "#D4AF37",
    strokeLinecap: "square",
    strokeWidth: "0.528",
    d: "M311.955 205.53a1.42 1.42 0 00-1.073.49 4.337 4.337 0 00-.584 2.08c-.02.157.039.274 0 .431-.121.324-.232.651-.332.981-.136.824-.175 3.866-.39 5.023-.195 1.177-1.17 2.865-1.56 3.414a1.88 1.88 0 01-.876.432c-.156.039-1.404-.098-1.404-.098-1.637-.118-4.094-1.02-5.75-1.256-1.638-.216-3.646-.118-5.186-.275 0 0-1.95-.726-3.723-.196-1.755.51-2.75 1.471-4.29 3.826 0 0-.662.804-.662 1.079a3.346 3.346 0 001.014 2.511c.214.197.156.02.136-.02.078.138.137.472.234.59.231.324.44.665.624 1.02.156.294.078.647.214.941.76 1.629.39 3.296.39 5.2a.395.395 0 01-.02.157c-.019 1.118-1.11 2.61-1.11 3.727v.236l-.137.314c0 .314-.41.373-.292.588.585 1.315.663 1.707.877 2.59.078.334.117.51.253.883.195.471.78 2.354.78 2.354s-.058.118.059.628c.078.353.643.452.701.51.02.375.215.717.527.923 0 .078.487.058.546.058l.584-.039c0-.255-.078-.392-.253-.55-.059-.019-.292-.097-.331-.136l-.117-.197c-.254-.216-.293-.51-.507-.784-.04-.04.02-.314-.04-.471-.058-.177-.428-.55-.428-.55l-1.014-4.1c-.136-.922.546-1.452.624-2.217 0-.157.897-2.394.936-2.512.643-1.746 1.715-4.473 1.696-5.63-.02-1.296-.059.254.058-.727.098-.745-.331-2.707-.292-2.903 2.417 4.061 4.776 5.532 8.675 5.14.161-.023.325-.023.487 0 0 0 .097.216.097.314.156.569-.195 3.002-.331 4.16l-.156 1.53s-.195.392-.195.824v.412c-.02.588.117.785.117.785l-.097 1.452a12.02 12.02 0 01-.449 3.021c-.039.118-.136.294-.253.314-.117.098-.293.275-.312.432 0 .117 0 .235.039.353 0 .098.097.235.156.314.078.353.039.706.039 1.06l.058.333c.02.098.117.098.195.117.137.04.098.118.195.157l.312.02h1.053c-.02-.392-.39-.589-.682-.785-.137-.118-.117-.157-.117-.353l-.02-.785c0-.137.059-.196.098-.294.058-.137.019-.334.019-.49.195-1.354.429-2.747.78-4.042.292-.393.41-.844.487-1.315 0 0 .234-.628.156-.98l.975-5.887a.762.762 0 01.468-.451c1.189-.53 2.397-.903 3.509-1.687 1.247-.864 1.988-2.276 2.865-3.532.195-.392.41-.706.624-1.06a18.321 18.321 0 001.95-5.336c.292-1.668.194-3.316.662-5.298.098-.412.468-.745.546-1.177v-.098l.234-.02.74-.098h.625l.35.02c.098 0 .273.118.37.118.098 0 .196-.02.254-.118.137-.157.137-.098.176-.255 0-.04.058 0 .078 0 .097-.04.175-.157.273-.196.078 0 .136-.04.156-.098v-.314c0-.157 0-.157-.098-.196h-.039c-.117-.04 0-.275 0-.393a.75.75 0 00-.02-.314.47.47 0 00-.175-.216l-.175-.196c-.546-.451-.78-.804-1.17-1.177.059-.078.059-.118.039-.255-.195-.53-.526-.628-1.092-1.06a4.97 4.97 0 00-1.969-.725h-.389 0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#D18219",
    fillRule: "nonzero",
    d: "M311.9 205.5a1.4 1.4 0 00-1 .5 4.6 4.6 0 00-.7 2v.5l-.3 1c-.1.8-.2 3.8-.4 5a10.9 10.9 0 01-1.5 3.4c-.2.3-.8.4-.9.4h-1.4c-1.6-.2-4.1-1-5.8-1.3-1.6-.2-3.6-.1-5.1-.3 0 0-2-.7-3.8-.2-1.7.5-2.7 1.5-4.3 3.8 0 0-.6.8-.6 1.1a3.4 3.4 0 001 2.5l.2.2c0-1.4.2-2 .2-2a5.7 5.7 0 00.4 2l.7 1.1c.3 1 .6 3.7.8 4.8 0 .6-.4 2.6-.7 3.5-.5 1.7-.8 3.2-.1 2 .3-.4 1.4-2.6 2-4.6.6-2 1.2-3.2 1-3.6l-.3-3.1a1.7 1.7 0 010-.2v-.3l.2-1.5c2.9 5.4 7.5 6 10.5 2.3a15.6 15.6 0 00-.4 4.7v.8l-.5 5.1v.1l-.2.6v.8l.1.1v.8-.1c.3-.2.4-.6.4-1v-.1l.2-.3v-.5l1-6a.6.6 0 010-.2l.8-.7c.1-.2.7-2.6.6-4-.2-3.5 4.3-4.5 5.8-2.8.6-.3 1-.7 1.5-1.2a7.8 7.8 0 001-1.8v-.4a11.7 11.7 0 00.2-.8 14.6 14.6 0 00.2-1.3l.1-1.3.1-1.3a14.8 14.8 0 01.3-1.4l.1-.3.2-.3.1-.3.1-.3v-.1h.2-1.7a2.1 2.1 0 01-.8-1l.3-1.7c.4-.8.8-.2 1.7 0a7.6 7.6 0 012.5 1.4h.9v-.3a1.7 1.7 0 000-.2v-.2a.5.5 0 00-.1-.1l-.2-.2-1.2-1.2v-.2c-.1-.6-.5-.7-1-1.1a5 5 0 00-2-.7h-.3a1.3 1.3 0 00-.1 0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    stroke: "#D4AF37",
    strokeLinecap: "square",
    strokeWidth: "0.528",
    d: "M311.955 205.53a1.42 1.42 0 00-1.073.49 4.337 4.337 0 00-.584 2.08c-.02.157.039.274 0 .431-.121.324-.232.651-.332.981-.136.824-.175 3.866-.39 5.023-.195 1.177-1.17 2.865-1.56 3.414a1.88 1.88 0 01-.876.432c-.156.039-1.404-.098-1.404-.098-1.637-.118-4.094-1.02-5.75-1.256-1.638-.216-3.646-.118-5.186-.275 0 0-1.95-.726-3.723-.196-1.755.51-2.75 1.471-4.29 3.826 0 0-.662.804-.662 1.079a3.346 3.346 0 001.014 2.511c.214.197.156.02.136-.02.078.138.137.472.234.59.231.324.44.665.624 1.02.156.294.078.647.214.941.76 1.629.39 3.296.39 5.2a.395.395 0 01-.02.157c-.019 1.118-1.11 2.61-1.11 3.727v.236l-.137.314c0 .314-.41.373-.292.588.585 1.315.663 1.707.877 2.59.078.334.117.51.253.883.195.471.78 2.354.78 2.354s-.058.118.059.628c.078.353.643.452.701.51.02.375.215.717.527.923 0 .078.487.058.546.058l.584-.039c0-.255-.078-.392-.253-.55-.059-.019-.292-.097-.331-.136l-.117-.197c-.254-.216-.293-.51-.507-.784-.04-.04.02-.314-.04-.471-.058-.177-.428-.55-.428-.55l-1.014-4.1c-.136-.922.546-1.452.624-2.217 0-.157.897-2.394.936-2.512.643-1.746 1.715-4.473 1.696-5.63-.02-1.296-.059.254.058-.727.098-.745-.331-2.707-.292-2.903 2.417 4.061 4.776 5.532 8.675 5.14.161-.023.325-.023.487 0 0 0 .097.216.097.314.156.569-.195 3.002-.331 4.16l-.156 1.53s-.195.392-.195.824v.412c-.02.588.117.785.117.785l-.097 1.452a12.02 12.02 0 01-.449 3.021c-.039.118-.136.294-.253.314-.117.098-.293.275-.312.432 0 .117 0 .235.039.353 0 .098.097.235.156.314.078.353.039.706.039 1.06l.058.333c.02.098.117.098.195.117.137.04.098.118.195.157l.312.02h1.053c-.02-.392-.39-.589-.682-.785-.137-.118-.117-.157-.117-.353l-.02-.785c0-.137.059-.196.098-.294.058-.137.019-.334.019-.49.195-1.354.429-2.747.78-4.042.292-.393.41-.844.487-1.315 0 0 .234-.628.156-.98l.975-5.887a.762.762 0 01.468-.451c1.189-.53 2.397-.903 3.509-1.687 1.247-.864 1.988-2.276 2.865-3.532.195-.392.41-.706.624-1.06a18.321 18.321 0 001.95-5.336c.292-1.668.194-3.316.662-5.298.098-.412.468-.745.546-1.177v-.098l.234-.02.74-.098h.625l.35.02c.098 0 .273.118.37.118.098 0 .196-.02.254-.118.137-.157.137-.098.176-.255 0-.04.058 0 .078 0 .097-.04.175-.157.273-.196.078 0 .136-.04.156-.098v-.314c0-.157 0-.157-.098-.196h-.039c-.117-.04 0-.275 0-.393a.75.75 0 00-.02-.314.47.47 0 00-.175-.216l-.175-.196c-.546-.451-.78-.804-1.17-1.177.059-.078.059-.118.039-.255-.195-.53-.526-.628-1.092-1.06a4.97 4.97 0 00-1.969-.725h-.389 0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#D39044",
    fillRule: "nonzero",
    stroke: "#D4AF37",
    strokeLinecap: "square",
    strokeWidth: "0.528",
    d: "M316.926 209.454l-.059.235v.04l.059-.236z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#FFF",
    stroke: "#D4AF37",
    strokeWidth: "0.528",
    d: "M307.705 226.935c-.41 1.628-1.404 1.962-.682 3.335 0 0-.312 0-.507-.549-.122-.4-.169-.82-.137-1.236.027-.562.106-1.12.234-1.668"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#FFF",
    stroke: "#D4AF37",
    strokeWidth: "0.528",
    d: "M308.446 226.248c-.41 1.648-1.404 1.962-.683 3.355 0 0-.39 0-.584-.53a3.75 3.75 0 01-.156-1.059c0-.333.078-.922.156-1.177.066-.214.144-.423.233-.628"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#FFF",
    stroke: "#D4AF37",
    strokeWidth: "0.528",
    d: "M309.81 224.09c-.585 1.08-1.033 2.001-1.286 2.806-.234.785-.39 1.236.078 2.08 0 0-.312-.158-.722-.903a2.566 2.566 0 01-.156-1.295 6.039 6.039 0 01.312-1.373"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#FFF",
    stroke: "#D4AF37",
    strokeWidth: "0.528",
    d: "M310.337 223.403c-.351.55-.468 1.08-.663 1.511a5.717 5.717 0 00-.605 2.06c0 .393-.058.726.37 1.393 0 0-.194-.02-.33-.098a1.214 1.214 0 01-.449-.53 2.96 2.96 0 01-.253-1.275c0-.294.097-.726.175-1.02.078-.294.351-.883.351-.883"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#D18219",
    stroke: "#D4AF37",
    strokeWidth: "0.5",
    d: "M311.272 207.629c0-.04-2.261-.706-2.592-2.708.448-.431 2.787 1.119 2.826 2.55"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#000",
    fillOpacity: "0.5",
    stroke: "#D4AF37",
    strokeWidth: "0.5",
    d: "M308.758 204.941c.02.04 1.228.04 2.183 2.08-.215-.236-1.17.333-2.164-2.002"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#000",
    fillRule: "nonzero",
    stroke: "#D4AF37",
    strokeWidth: "0.5",
    d: "M314.274 207.845c.04-.04.078-.098.02-.157-.975-.628-.936.137-1.638.137.332 0 .332.04.449.196.448.471.78.432 1.17-.039"
  }), /*#__PURE__*/_react.default.createElement("path", {
    stroke: "#D4AF37",
    strokeLinecap: "square",
    strokeWidth: "0.528",
    d: "M316.711 210.63c-.117.118-.487-.156-.78-.195"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#000",
    fillRule: "nonzero",
    stroke: "#D4AF37",
    strokeLinecap: "square",
    strokeWidth: "0.528",
    d: "M316.926 209.885s-.098-.098-.839-.196c0 0 .507-.53.546.059"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#FFF",
    stroke: "#D4AF37",
    strokeWidth: "0.528",
    d: "M301.408 227.72a6.605 6.605 0 00-.195.353c-.195.451-.273.883.098 1.57 0 0-.312 0-.507-.55-.097-.255-.156-.647-.136-1.236l.039-.47"
  }), /*#__PURE__*/_react.default.createElement("path", {
    stroke: "#D4AF37",
    strokeWidth: "0.528",
    d: "M287.373 224.227s-.293-1.216.409-2.55"
  }), /*#__PURE__*/_react.default.createElement("g", {
    fill: "#E7CA00",
    fillRule: "nonzero",
    stroke: "#D4AF37"
  }, /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.536",
    d: "M346.456 261.499c-.39.46-1.466.865-2.024.626-.537.62.301 2.4 1.777 1.682 1.475-.694 1.432-1.848.247-2.308zm1.686-4.547c-.782-.208-2.153.003-2.515 1.518-.337 1.468.863 2.027 2.141 1.858-.664-1.155-.13-2.877.376-3.4l-.002.024z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.536",
    d: "M347.122 260.074c-1.018-.324-1.212-1.54-1.034-2.677-.785.674-2.056 1.31-1.431 2.411.489.847 1.261 1.47 2.465.266z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.536",
    d: "M346.472 260.726c-.785-.183-1.816-.631-2.183-1.615-.726.776-.685 2.812.671 3.065 1.357.253 1.712-.601 1.512-1.45h0zm8.52 4.584c.324-1.298-.14-3.048-2.803-2.766-2.529.268-3.282 2.242-2.72 2.433.467-1.14 3.983-.693 5.547.31l-.024.023z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.536",
    d: "M354.875 263.392c.321-1.274-.203-3.372-2.856-2.648-2.608.703-2.438 2.798-1.832 2.992.509-1.111 2.992-1.358 4.686-.32l.002-.024z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.536",
    d: "M354.515 268.292c.825-.891 1.301-3.304-1.199-4.258-2.348-.918-3.171-.32-3.62.6 1.273-.391 4.67 1.588 4.82 3.658zm.264-6.226c-.336-.81-.902-2.667-3.42-1.687-2.061.819-1.339 2.37-1.04 2.809.479-1.016 2.69-1.774 4.46-1.122z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.536",
    d: "M354.34 260.298c-.385-.765-1.342-2.725-3.84-1.426-2.432 1.304-1.042 3.397-.424 3.445.287-.835 2.388-2.165 4.265-2.043l-.001.024z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.536",
    d: "M352.873 258.327c-.58-.535-2.025-1.922-3.72-.119-.54.393-.796 1.12-.631 1.803.164.683.71 1.164 1.352 1.193-.05-.788 1.349-2.492 2.999-2.877h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.536",
    d: "M350.531 257.05c-.784-.183-2.741-.703-3.376 1.452-.612 2.157 1.715 2.485 2.141 2.151-.44-.622-.021-2.574 1.233-3.578l.002-.024zm3.149 12.567c.99-.755 1.798-3.142-.55-4.623-2.265-1.402-3.191-.91-3.813-.053 1.364-.138 4.528 2.558 4.363 4.676h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.536",
    d: "M351.682 271.906c1.517-.665 3.453-4.433.925-6.174-2.447-1.636-4.878-.625-5.856.523 2.649-.38 6.325 3.433 4.929 5.676l.002-.025z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.536",
    d: "M349.691 273.812c3.943-1.604 3.59-5.624.937-7.178-2.504-1.469-4.075-1.249-5.424.116 3.277 1.235 4.997 3.378 4.485 7.086l.002-.024z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.536",
    d: "M346.32 276.069c4.855-1.067 4.704-6.247 2.14-8.652-1.799-1.707-3.252-1.282-4.174-.57 1.699 1.847 3.081 4.894 2.032 9.246l.002-.024z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.536",
    d: "M343.379 276.785c4.82.23 5.854-5.912 3.29-8.904-1.789-2.1-3.258-2.042-4.158-1.598 1.693 2.19 3.579 6.476.845 10.5l.023.002z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.536",
    d: "M338.693 277.672c6.192 1.439 8.848-6.438 5.393-10.234-1.84-2.03-3.259-2.043-4.16-1.598 1.935 3.653 1.727 9.736-1.233 11.832h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.536",
    d: "M332.749 277.91c6.592 2.842 9.542-3.958 9.237-8.587-.246-3.67-3.972-5.993-4.85-5.547 2.537 4.754-.655 13.52-4.367 14.16l-.02-.026z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.536",
    d: "M327.495 277.546c6.358 3.582 10.75-2.934 10.815-8.612.026-3.745-1.038-6.89-3.807-6.96 1.334 5.665-2.297 14.078-7.008 15.572z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.536",
    d: "M322.071 276.805c6.488 3.616 12.546-2.623 13.245-9.598.345-3.574-.388-5.272-2.418-6.851.38 5.1-7.41 15.319-10.827 16.449z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.536",
    d: "M319.927 276.694c7.704 3.393 19.262-18.167 9.049-20.115 2.12 5.554-6.12 19.56-9.049 20.115z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.536",
    d: "M317.751 276.99c4.076 4.09 19.018-21.297 8.08-22.762.918 2.448-.412 7.267-2.722 11.84-2.31 4.571-5.682 7.688-5.358 10.922z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.536",
    d: "M316.45 280.878c.483-4.764 8.003-14.392 9.638-21.123 1.066-4.277-.312-7.96-7.374-6.478 5.878 7.44-5.503 19.902-3.623 27.103-.366.706 1.866-.026 1.36.498z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.536",
    d: "M317.498 279.97c-2.242-4.83 3.337-14.045 4.13-20.793.477-4.127-3.374-9.67-9.906-6.75 7.88 5.98.08 20.313 3.961 26.91.91.562 2.189.392 1.815.632h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.536",
    d: "M317.647 281.77c-2.881-5.173-.198-15.105-.182-21.57.025-4.31-6.228-11.215-12.308-5.835 11.609 4.555 4.798 16.174 10.825 27.128 1.173.606 1.979-.042 1.643.275l.022.001z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.536",
    d: "M316.732 279.85c-3.147-4.337-2.15-14.278-4.422-20.432-1.523-4.087-8.996-8.735-13.464-2.103 12.452 1.706 7.556 14.11 16.209 22.697 1.31.274 1.906-.537 1.677-.163z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.536",
    d: "M315.115 279.252c-4.64-3.399-5.134-12.721-8.804-18.029-3.291-4.763-9.793-6.495-12.5.887 13.034 1.654 9.494 11.47 17.005 16.195 1.66.913 4.492.742 4.299.947z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.536",
    d: "M310.336 276.505c-4.216-3.44-2.513-5.634-6.696-10.908-3.577-4.517-12.874-6.54-13.672.844 11.447-.21 11.181 4.62 17.028 8.48 1.356-.016 3.462 1.152 3.317 1.582l.023.002z"
  }), /*#__PURE__*/_react.default.createElement("g", {
    strokeWidth: "0.536"
  }, /*#__PURE__*/_react.default.createElement("path", {
    d: "M286.65 274.348l.725 2.15 23.022 11.498 6.391-3.21.624-3.405.007-4.147-20.901-7.513-8.583-2.302-2.181 4.065.88 2.863z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M285.83 274.534l.956-.198c-.919-2.023.235-4.072 2.704-4.492 2.47-.42 5.963.99 8.548 3.301 2.59 1.96 5.444 3.299 8.429 3.956 2.87.547 6.442.039 9.606 1.066 1.505.62 1.297 1.668 1.071 3.716 1.1-.75 1.752-1.749 1.793-3.088-.305-2.906-2.157-5.09-6.524-6.136-3.825.817-7.705-.131-10.954-2.677-1.851-2.956-4.443-4.982-7.353-5.748-2.096-.53-4.297.016-6.143 1.523-2.827 2.12-3.04 3.97-2.908 5.741l.774 3.056.002-.02z"
  })), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.534",
    d: "M308.768 283.056c-1.286 3.062-.357 6.357 2.1 7.388 2.457 1.032 5.46-.613 6.745-3.675l-8.845-3.713z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.536",
    d: "M311.162 280.08c1.534 1.052 2.118 2.939 1.334 4.204-.807 1.263-2.702 1.435-4.238.407-1.535-1.052-2.119-2.939-1.31-4.226.784-1.266 2.701-1.436 4.236-.384l-.022-.002zm-18.406 3.237c-.817.55-1.373 1.44-1.295 2.428a3.01 3.01 0 00.733 1.678l-.224.032c-1.72.21-3.606-1.459-3.745-3.09-.053-.741.24-1.381.746-1.907a3.06 3.06 0 001.913.443 3.13 3.13 0 00.812-.182 3.82 3.82 0 001.062.573l-.002.025z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.536",
    d: "M291.307 277.462c-.847.646-1.403 1.536-1.352 2.596.034.985.64 2.014 1.491 2.743-.3.105-.61.171-.923.199-2.007.188-4.09-1.791-4.186-3.69-.027-.47.07-.94.283-1.352.289.064.584.087.88.068a3.9 3.9 0 002.34-1.046c.455.262.953.425 1.467.482h0zm9.102 11.093l.125.108a3.669 3.669 0 01-1.196 1.994c.58-.54.955-1.3 1.051-2.128l.02.026zm-2.864-1.892c-.669 1.035-1.721 1.686-2.86 1.767-1.941.193-3.984-1.733-4.062-3.581-.013-.18-.006-.36.02-.539.762.754 1.763 1.149 2.793 1.101a3.785 3.785 0 001.729-.602c.58.887 1.407 1.538 2.358 1.852l.022.002z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.536",
    d: "M303.018 288.58c.095.499.013.983-.285 1.402-.722 1.025-2.417 1.188-3.79.345-1.33-.84-1.855-2.354-1.135-3.354a2.07 2.07 0 011.19-.792 2.02 2.02 0 00-.014 1.325c.395 1.185 1.758 1.88 3.045 1.562.357-.079.695-.246.99-.488h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.536",
    d: "M304.159 287.57c-.277.715-.88 1.355-1.747 1.681-1.597.613-3.45-.047-4.136-1.475a2.571 2.571 0 01-.028-2.212c.71.193 1.458.157 2.156-.103.666-.234 1.233-.733 1.592-1.399a2.566 2.566 0 00.14 1.902c.43.825 1.156 1.407 2.001 1.604l.022.002zm10.775 2.088c-1.123 1.632-3.297 2.543-4.827 2.007-1.294-.444-1.722-1.779-1.172-3.16a5.202 5.202 0 003.979.652c1.05-.195 2-.823 2.66-1.758.103.671-.114 1.465-.64 2.259h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.536",
    d: "M320.692 291.32a2.569 2.569 0 01-.239.228c-1.536 1.256-3.851 1.42-5.122.388-1.206-1.002-1.117-2.714.155-3.99 1.374.843 3.345.824 4.916-.012a3.201 3.201 0 00-.151 2.518c.1.31.242.603.42.867l.021.002z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.536",
    d: "M324.034 287.64c-.167 1.29-1.587 2.48-3.426 2.78-2.04.333-3.849-.618-4.021-2.105l.006-.073c1.087-.603 1.785-1.605 1.916-2.724l.044.003c.887 1.69 3.181 2.654 5.369 2.136l.114-.04-.002.024zm-14.622-.446c.315 1.645-.867 3.468-2.686 4.088-1.817.596-3.587-.278-3.926-1.9a3.201 3.201 0 01.034-1.299c1.063-.286 1.93-.906 2.455-1.676a5.215 5.215 0 003.87.055c.117.228.203.475.253.732h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.536",
    d: "M311.765 286.265c-1.122 1.631-3.296 2.543-4.827 2.007-1.532-.512-1.882-2.283-.759-3.914.335-.484.742-.9 1.203-1.233 1.392 1.273 3.273 1.695 5.027 1.127.038.641-.17 1.337-.645 2.037l.001-.024z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.536",
    d: "M317.106 283.065c1.602 1.033 2.098 2.913 1.07 4.183-.985 1.275-3.148 1.475-4.75.442-1.625-1.034-2.099-2.913-1.092-4.185 1.006-1.273 3.147-1.475 4.772-.44zm-10.696 1.453a3.277 3.277 0 01-.124 2.74c-.865 1.456-2.895 1.642-4.55.434-1.071-.747-1.746-2.023-1.815-3.432.483-.48.748-1.172.722-1.884l.12-.113c.596 2.01 2.696 3.205 4.663 2.67a3.37 3.37 0 00.984-.415h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.536",
    d: "M298.402 281.89c1.783-.157 3.29 1.261 3.366 2.839.079 1.553-1.291 2.944-3.076 3.125-1.253.05-2.441-.573-3.191-1.672.997-.586 1.65-1.59 1.602-2.675a3.004 3.004 0 00-.331-1.155 4.762 4.762 0 011.63-.463h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.536",
    d: "M307.2 281.764c.553 1.443-.539 2.954-2.387 3.375-1.87.42-3.841-.42-4.372-1.861a2.147 2.147 0 01-.074-1.332c.242.18.496.34.76.476 1.917.984 4.37.757 5.42-.512a2.16 2.16 0 00.383-.658c.11.157.2.33.27.512h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.536",
    d: "M299.227 276.968a2.814 2.814 0 011.698.377c-.805 1.239-.232 2.978 1.303 4.03-.575 1.071-1.594 1.759-2.71 1.828-1.717.161-3.514-1.5-3.608-3.153l.22.017c1.652-.167 2.976-1.537 2.987-3.108l.088.007.022.002z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.536",
    d: "M305.52 277.749c1.944 1.206 2.683 3.376 1.662 4.843-1.044 1.466-3.475 1.695-5.44.487-1.945-1.183-2.705-3.378-1.661-4.844 1.044-1.466 3.474-1.695 5.44-.486zm-9.4 2.733a3.418 3.418 0 011.398 1.68c.563 1.59-.331 3.412-2.038 4.016-1.688.63-4.053-.56-4.64-2.128a2.474 2.474 0 01.156-2.002l.13.035c2.102.58 4.241-.162 4.993-1.577l.002-.024zm-8.431-8.316a2.811 2.811 0 011.611.346c-.73.557-1.21 1.33-1.168 2.218.049 1.084.85 2.177 1.866 2.772a3.395 3.395 0 01-2.02.924c-1.74.16-3.555-1.553-3.648-3.206-.073-1.626 1.598-2.896 3.337-3.056l.022.002z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.536",
    d: "M291.328 272.078c1.47-.131 2.758.975 3.073 2.326-.815.526-1.366 1.342-1.304 2.256.006.246.047.49.121.721-.479.35-1.028.56-1.597.613-1.627.144-3.36-1.489-3.439-3.042-.079-1.553 1.52-2.755 3.147-2.898l-.001.024z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.536",
    d: "M296.03 279.354a2.272 2.272 0 01-.135 2.298c-.844 1.187-2.83 1.376-4.414.394-1.564-.956-2.18-2.723-1.335-3.91.525-.661 1.284-1.034 2.072-1.018.74 1.31 2.272 2.387 3.743 2.255l.068-.019h0zm31.06 11.422c.33 1.45-.757 2.912-2.583 3.335-1.96.438-4.016-.458-4.585-1.976-.53-1.44.451-2.96 2.155-3.516.873 1.59 2.949 2.512 4.991 2.155l.022.002z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.536",
    d: "M328.496 287.177c.497 1.586-.492 3.203-2.23 3.633-1.738.43-3.568-.522-4.087-2.11-.448-1.36.216-2.782 1.527-3.417 1.116 1.612 2.982 2.35 4.79 1.894h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.536",
    d: "M331.572 288.048c.442 1.434-.447 2.912-2.004 3.282-1.015.256-2.073.003-2.89-.69.823-.919 1.138-2.122.723-3.333a3.6 3.6 0 00-.383-.766c.273-.163.565-.28.868-.35a2.962 2.962 0 011.594 0 4.43 4.43 0 001.783 1.269c.12.18.214.384.287.587l.022.001zm6.609-1.574c.517 1.612-.476 3.278-2.236 3.706-1.76.428-3.612-.526-4.131-2.113l-.082-.375a5.32 5.32 0 002.086-.059c1.622-.365 2.772-1.479 3.094-2.78.58.361 1.027.933 1.269 1.62h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.536",
    d: "M338.599 284.223c.499 1.561-.466 3.156-2.136 3.567a3.541 3.541 0 01-2.201-.17c.868-.916 1.208-2.166.793-3.377a3.783 3.783 0 00-1.24-1.717c.263-.145.539-.256.823-.329 1.672-.435 3.46.49 3.961 2.026h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.536",
    d: "M342.03 282.83c.5 1.537-.466 3.156-2.158 3.565a3.56 3.56 0 01-1.376.04c.132-.554.09-1.171-.084-1.774-.441-1.122-1.29-1.98-2.34-2.367.365-.708 1.074-1.292 1.977-1.516 1.693-.41 3.459.514 3.983 2.028l-.002.024zm-17.414 3.584c-.449.653-1.15 1.139-2.012 1.391-1.872.444-3.832-.543-4.385-2.255-.576-1.715.49-3.474 2.365-3.942 1.4-.358 2.868.124 3.762 1.151a2.948 2.948 0 00-.374 2.55c.143.428.359.789.644 1.105zm-28.712-13.72c1.471-.13 3.637 1.633 3.82 3.268.181 1.66-.627 2.653-1.63 3.311-1.025.657-2.282.88-3.394.375-1.112-.503-2.175-1.642-2.51-2.748-.357-1.108-.124-1.827.583-2.656.726-.803 1.66-1.418 3.13-1.55h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.536",
    d: "M329.83 283.679c.5 1.561-.466 3.156-2.158 3.565-1.694.433-3.46-.49-3.982-2.028-.479-1.535.466-3.156 2.158-3.565 1.692-.409 3.48.516 3.983 2.028z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.536",
    d: "M335.43 284.547c.481 1.51-.462 3.107-2.132 3.518-1.648.412-3.414-.51-3.917-2.023-.502-1.512.463-3.107 2.133-3.518 1.648-.412 3.416.486 3.916 2.023z"
  })), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#E7CA00",
    fillRule: "nonzero",
    stroke: "#D4AF37",
    strokeWidth: "0.5",
    d: "M291 194.8l-.4.5-14 17.5-.4.3.4.4a25.8 25.8 0 017.1 17.5 53.1 53.1 0 01-2.7 17.4c-2 6.5-4.8 12.3-5.6 21.9a22.5 22.5 0 005.2 16.6 29 29 0 009.7 7.6c7.3 3.5 14.8 2.3 22.4 3.2 3.3.5 5.2 2.6 7 4.4l.3.4.4-.4c1.7-1.8 3.6-4 7-4.4 7.4-1 15 .3 22.3-3.2a29.4 29.4 0 009.7-7.6c3.3-4 5.8-9.5 5.2-16.6-.8-9.6-3.5-15.4-5.6-22a53 53 0 01-2.7-17.3c0-5.9 2.6-13.2 7.1-17.5l.4-.4-.3-.3-14.1-17.5-.4-.5-.4.4a19.8 19.8 0 01-14.2 5c-5-.3-10-2.1-14.1-4.7l-.3-.2-.3.2a29.8 29.8 0 01-14 4.6 19.8 19.8 0 01-14.3-4.9l-.5-.4h.1zm.1 1.5a21 21 0 0014.6 4.9 30.4 30.4 0 0013.8-4.3V248h-37.3a54 54 0 002.6-17.1c0-6-2.6-13.3-7.1-18l13.4-16.7v.1zm57.8 0l13.4 16.8a26.9 26.9 0 00-7.1 17.9 54 54 0 002.6 17.1h-37.3V197a30.4 30.4 0 0013.8 4.3 21 21 0 0014.6-4.8v-.2zm-67 52.9H358c2.1 6.4 4.6 12 5.4 21.1a21.4 21.4 0 01-5 16 28.4 28.4 0 01-9.3 7.2c-7 3.3-14.3 2.2-22 3.2-3.5.4-5.6 2.5-7.2 4.3-1.7-1.8-3.7-3.9-7.2-4.3-7.7-1-15 .1-22-3.2-2.3-1-6.2-3.4-9.4-7.3s-5.6-9-5-15.9c.8-9.1 3.4-14.7 5.4-21.1h.2z"
  }), /*#__PURE__*/_react.default.createElement("g", {
    fillRule: "nonzero"
  }, /*#__PURE__*/_react.default.createElement("path", {
    fill: "#00A854",
    d: "M373.3 171.4l-.1.1-.6 4.2-.5 3.6-2.4-1c-3.1-1.4-9.5-2.1-10-1.2-.1.6.6 4 1.7 8 .3.8 0 1-1.8 1.6-1.3.4-2.6 1-3.1 1.4-1 .6-.8.8 1.4 2.8l2.4 2.1-1.2 1c-1 .8-1 .8 2.8 4.5 4.3 4 6.5 5.2 9.4 5.2.9 0 1.9.2 2.6 0 1-.2 1.7-.5 4-.7 2.6.2 5 1.4 6 2l.6 1.4c-1.8-2-5.8-2.7-6.6-2.8-.8 0-1.2.2-2.1.5-.9.3-1.3.7-2.1 1.9-.6 1.5.6 3.1 2 3.3 1.9.3 3.2-.7 3.2-2.4 0-1.3-.7-2.3-.1-2.3 2.2.2 5.6 2 6.2 4.2.8 2.8.6 3-.7 1a12.8 12.8 0 00-3.9-3.4c-.4 0-1.5 2.5-1.5 3.6 0 .8-.2 1-.8.7-.5-.3-1.6-.5-2.5-.6l-1.6-.3.4 2.5c.2 1.4.9 3.5 1.4 4.6l1.1 2-2.4-.7c-5.3-1.6-4.9-1.7-4.5 1 .1 1.4.4 3 .6 3.4.3.7 0 .9-1.8.9-1.1 0-2 .1-2 .3 0 1.1 4 6.6 6.1 8.2 2.5 2 7.2 4 9 4 .7 0 2.3.5 3.9 1l2.8 1v3.1c0 3.3-1 10-1.6 10-.1 0-1-1.4-2-3.2-2-3.8-2-3.7-2.5-2.8-.4.6-.5.5-.5-.3a17 17 0 00-3.8-7.3l-1.2-1.1-.7 1.3-.6 1.3-2.7-3c-1.5-1.6-3-2.9-3.1-2.7-.3 0-.6 1.4-.8 3-.5 4.3-.7 4.6-2.4 3l-1.4-1.4-.4 1.3a40 40 0 001.2 13.9 48.8 48.8 0 011.7 6.4c.6 3.8 2.8 8 5.5 10.8 1 1 1 1.4.5 1.4-.4 0-1.2.4-1.6.9-2 2.1-.2 5 2.8 4.4 1.5-.2 1.8-.1 2.3 1 .8 1.6.8 4.5.1 5.7-.5 1-3.5 2.2-4 1.7-.1-.1-.2-1.8-.2-3.7v-3.5l-2.5 1.4a29.7 29.7 0 00-12.9 18.4c-.4 2.2-1.7 2.4-3.3 5a20.1 20.1 0 00-4.5 3.6c-2.5 2.4-3.2 2.8-7 3.7-4.7 1.2-14.7 2.8-22.2 3.6-6.5.6-27.1 4-28.4 4.5a90 90 0 01-3 1.2 6.8 6.8 0 00-2.6 2c-.8 1.1-.8 1.5-.2 2.5 1.3 2.6 4 2.5 9.6-.2a31 31 0 017.8-2.5c2-.3 4.9-1 6.4-1.3 1.5-.4 5.8-1.1 9.4-1.7a199 199 0 0036.4-7.8c5.6-2 5.5-2 10.7-1.5 5.8.6 13-1.2 16-4 .7-.5 2.4-2.6 4-4.6 1.4-2 3.3-4 4-4.5 1.9-1.3.8-1.7-4.2-1.7h-4.2l1.5-3.1c1.6-3.6 3.3-8.4 3-8.7-.1-.1-1.6 0-3.2.5-1.7.3-3.1.6-3.2.5l.4-1.7c.4-1 1-1.7 1.9-1.9l2-.5a7 7 0 012.7.3c1.8.5 1.9.6 1.6 2.2-.2 2 .8 3.3 2.6 3.3 1.4 0 2.9-1.4 2.9-2.6 0-1.4-2-3-3.2-2.7a11 11 0 01-3.9-.6l-2.7-1 2.6-.5c4-.9 5.3-.7 6 .5.3.8 1 1.2 2 1.3 3.2.3 4.3-4.2 1.2-5.2-1.1-.3-3.6.9-3.6 1.8 0 .3-.8.5-1.8.5a17.3 17.3 0 00-6 1.1l3.9-1.9a60 60 0 006.7-2.5c4.6-2 9-7.3 10.7-12.3a54 54 0 002.2-13c-.3 0-2 .6-3.7 1.4-3.3 1.5-3.3 1.5-3.3.4 0-2 .9-8.1 1.2-9 .3-.5.2-.8-.3-.8a28 28 0 00-9.7 5.3c-3 2.5-3.4 2.6-3.4 1.6 0-.7.5-2 1-2.8 1-1.5 1.2-1.6 3-1.3 1.8.3 2 .1 2.8-1 1.1-1.6.5-3.6-1.2-4.1-1-.3-.9-.5 1-1.4a16 16 0 006.5-7l1.2-2-1.8.2c-1 0-1.8.2-1.8 0l.7-2.1c.4-1.2.8-3 .8-4.2 0-2-1.9-9.8-2.6-10.6-.3-.3-1.3.2-2.4 1.1l-2 1.6-1.9-4.1a58.7 58.7 0 00-2-4.3c-.2-.2-.8.3-1.6 1-1.5 1.4-1.6.6-.3-2.4 1.3-2.6 1.8-3 3.2-2 1.8 1 3.7 0 3.9-2 .1-1.3-.1-1.8-1-2.5-.7-.4-1.6-.6-2-.5-.5.2-1-.2-1.3-1.2a2.9 2.9 0 00-1.9-1.8c-2.6-.7-4.5 2.6-2.5 4.5.7.7.7 1.3.2 5-1 5.9-1.3 6.4-2 3.8-.8-3-.4-11.2.6-13.6 1.9-4.2.8-10.8-2.2-14.2a35.4 35.4 0 00-10.7-7.7zm-3.5 13.8a21 21 0 015.4 5.2c2.6 3 5.6 8.3 7.6 12.3-.7-.8-1.1-.9-3.2-3.7-1.6-2.3-4.4-7.4-7-10-2.3-2.4-3.2-3.8-2.9-3.8h.1z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#008F4C",
    d: "M382.5 239c-.5 2-.9 2.3.1 3.8.5.7 1.3 1 2.2 1 1.4 0 2.1 1 3.3 4.6.1.6.3.6.3-.1 0-.6-.4-1.8-1-3-.6-1.1-.8-2-.5-2.2 1-.6.5-3.1-.6-4-1.6-1-2.1-.7-3.8 0v-.1z"
  })), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#9EAB05",
    fillRule: "nonzero",
    d: "M288.6 321.4c-1 .9-1.3 2.2-.5 3 1.1 1.2 5.1.1 5.6-1.4.5-2.2-2.9-3.3-5-1.6h-.1z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#75B52B",
    fillRule: "nonzero",
    d: "M374.5 175.6a27 27 0 004.7 9.7c.7 1 1.4 1.6 1.6 1.5 0-.2-1.3-3.2-3.2-6.7-2.6-5-3.4-6-3.1-4.5zm-17 13.5a27 27 0 008.2 2.3c0-.9-2.4-2-5.3-2.3-1.7-.2-3-.2-2.8 0h-.1zm3.2 6.1c.6.6 9.5 4.7 12 5.5 1.4.5 3.4.8 4.3.7 1.5-.2 1.3-.3-1.9-1.3a53 53 0 01-5.8-2.4c-3-1.5-9.5-3.4-8.6-2.5zm29 13a93 93 0 00-2.4 15c-.3 3.3-.2 4.4.4 5.1.6.9.8.5 1.3-4a194 194 0 001.4-17.7c-.1 0-.5.6-.8 1.5l.1.1zm-8.6 4c.2 4.1 2 8.4 2.6 6.5a15 15 0 00-1.2-5.5l-1.6-4.4.2 3.5v-.1zm-5.7.2l1.8 2.3 1.2 1.5v-1.3a3 3 0 00-1.3-2.3c-1.6-1.3-2.6-1.4-1.7-.2zm-7.2 12.4a76 76 0 007.4 5.6c1.5 1 1.5 1-.4-1.3-2-2.3-5-4.5-6.3-4.5-.4 0-.7 0-.7.2zm2.8 10.8c1.4 5.6 2.4 8.8 3 9.1.3.2.6.4.7.3.2-.3-2.4-8-3.2-9.3l-.8-1.3.3 1.2zm5.9 4.4c0 .8.4 2.3 1 3.4.5 1.1.9 1.7.8 1.2l-.6-3.1c-.4-2.7-1.2-3.7-1.2-1.5zm-10.3 3.8c1 3.2 3.4 8.2 7 14 2.5 4.2 2.5 4.2 2.7 2.4 0-1.4-.4-2.6-2.3-5.8a534.894 534.894 0 01-5-8.6 22.5 22.5 0 00-2.9-4.6c-.2 0 0 1.2.5 2.6zm31.5.7a75.5 75.5 0 00-8.2 11.5c-.5 1-.6 2-.4 2.8.3 1.2 1 .3 6-7.7 3.1-5 5.5-9 5.3-9-.3 0-1.4 1.1-2.7 2.4zm-8 37.3a2 2 0 001.8 3c1.5 0 2.4-1.7 1.6-3.1-.6-1.2-2.8-1.1-3.4.1z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#D91023",
    fillRule: "nonzero",
    d: "M375.1 205.2c-1.9 1.3.1 4.7 2.2 3.5 1.2-.8 1.4-2.7.3-3.5a4.2 4.2 0 00-1.2-.7l-1.3.7zm13.3-10.9c-1.1.3-1.6 1.9-.8 3.2 1 1.8 3.5 1 3.5-1 0-1.6-1.2-2.5-2.6-2.2h-.1zm3.4 3.9c-.2.4-.2 1.2 0 1.9 0 .9.4 1.1 1.5 1.1 1.9 0 2.9-1.3 2-2.6-.7-1.1-3-1.4-3.5-.4zm-19 75c-2 1.5-.1 4.2 2.2 3.3 1-.4 1.5-1.6.9-2.7-.7-1.4-1.9-1.6-3.1-.6zm10.3-33.6c-.6.5-.4 2.4.2 3 1.6 1.6 3.8 0 3.3-2.1-.3-1-.7-1.3-1.8-1.3-.7 0-1.6.2-1.7.4zm9.4 0c-.4 1.4.5 2.7 1.8 2.7s2.2-1.2 2-2.6c-.1-1-.5-1.2-1.8-1.3-1.4-.2-1.7 0-2 1.1v.1zm1.3 37c-.3 1.4.5 2.7 1.9 2.7 1.2 0 2.1-1.2 1.9-2.6-.1-.9-.5-1.2-1.8-1.3-1.4-.1-1.7 0-2 1.2zm-3 4.6c-2 1.5-.2 4.2 2.2 3.3 1-.4 1.4-1.6.8-2.7-.7-1.4-1.8-1.6-3-.6z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#75B52B",
    fillRule: "nonzero",
    d: "M369.7 185.6l2.2 2.6a59 59 0 016.2 8.5c2 3.2 4.5 6.4 4.5 5.8 0-.6-4.5-8.2-6.2-10.5-2.4-3.2-6.1-7-6.8-7-.2 0-.1.2.1.6z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#EAC102",
    fillOpacity: "0.5",
    fillRule: "nonzero",
    d: "M382.7 249c0 .4-.6 3.8-.8 7.7a157.5 157.5 0 01-3 25.7l.1.9.9-1.2c.9-1.2 1.8-2.1 3.1-3a145.4 145.4 0 0017-19.4c5.2-6.8 6.4-8.6 6.3-8.7-.2-.2-1.8 1.4-8.2 9.3a244.001 244.001 0 01-6.6 7.7c-4.5 5-9.5 9.5-10.8 11.3l.4-2.1a93 93 0 001.8-20.6v-8.2l-.2.6zM370 282.2l-2.7 4.7a69 69 0 01-10.4 14.6c-1 1-.7 1.2-1 1.4-1.2 1.2 3.6 2 7.3 2.5 4.9.4 7.6-.5 20.7-7.5 3-1.6 3.9-2 3.3-2a35 35 0 00-8.8 3.4c-5.6 2.6-8 3.8-10.6 4.3-2 .5-4.8.5-6.5.1h-1.2l.6-.3c.6 0 1.3-.1 1.6-.3.3-.3 1.3-1 2.3-1.5a82.5 82.5 0 0016-14 39 39 0 00-5.5 4.3 46.9 46.9 0 01-15 10.1l-.9.2.8-.8 2.3-3.3a63.5 63.5 0 008.5-17l-.8 1.1zm.2-64.8a55 55 0 005.7 7.2c3.2 3.6 5 5 7.5 8.2 2.6 3.2 2.8 3.4 5.6 6 3.5-4.7 5.7-11 7.2-15 1.4-3.9 2.6-7.3 2.7-12.5-2 4.4-2.1 6-3.7 10.7-1.6 4.8-5 13-6.4 14.8-.1.2-7.4-8.8-10.6-12.5-3.4-4-8-7.3-8-6.9z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#CAB313",
    fillOpacity: "0.5",
    fillRule: "nonzero",
    d: "M372.7 174.8l-.6 4.5-1.9-.9c-1.9-.9-6.9-2-9.3-2-1.3 0-1.4.2-1.1 1.7.3 1.6 1.6 6.2 2 7.2.1.3-.7.8-2 1.1a11 11 0 00-3 1.4c-1 .7-.8.8 1.1 2.5 2.3 2 2.5 2.7 1.2 3.6-.7.5-.4 1 3 4.2 2 2 4.6 4 5.6 4.6 2.6 1.3 7.7 1.3 10.4 0 1.9-1 2-1 3.2-.2 1.3.8 1.3.8.7 0a30 30 0 00-5.3-3.2 32 32 0 01-15.3-17c-1.2-3.5-1.2-5.3 0-5.3 2.2 0 6.6 1 9 2.2 3.8 1.7 10.4 8 12.3 11.7 1.3 2.6 1.4 3.5 1.5 7.3 0 4.5.7 6.3.8 2.3.2-5 .4-6.2 1.1-8.2 1.6-3.7.8-9.4-1.7-12.8a36 36 0 00-6-5.1 41 41 0 01-4.7-3.6c-.2-.3-.7 1.5-1 4zm6.5.8c3.4 2.3 4.4 3.3 5.5 5.5 1.6 3.4 2 7.5 1.2 10.5l-.7 2.2-1.4-2.8a27 27 0 00-5.7-7.1 30.5 30.5 0 00-5-4.4c-.5 0-.3-3.4.5-6.4.3-1.3 0-1.5 5.6 2.5zm-16.4 12.3a8 8 0 001.8 2c.5.4 1 1.1 1.1 1.7.3.9 0 1-2.3 1-2.4 0-2.8-.2-4.7-2-1-1.1-1.9-2.1-1.7-2.2.4-.4 3.7-1.8 4.3-1.9.4 0 1 .6 1.5 1.4zm6.8 7.8c3 2.7 3.8 3.3 7.4 4.7 1.9.8 2 .9 1.2 1.6-1.1 1.1-6.7 1.5-9.3.7-2.2-.7-10.1-7.9-9.3-8.4a14 14 0 015.4-1.2c1.4 0 2.3.5 4.6 2.6zm14.7 9.3c-.2.2 0 1.4.4 2.5 1 2.5 1 3.3 0 5a10 10 0 00-.8 3.5 12 12 0 01-.6 3.6l-.5 1.6-1.7-1a5 5 0 01-2-2.2c-.4-1.5-.2-4.7.4-7.8.5-2.1.8-2.7 1.5-2.7.8.1.8 0 .3-.6-.5-.7-.7-.7-1.3.1a7 7 0 00-1 2.5c-.3 1.7-.3 1.7-1.7 1-2.2-1.2-3-1-3 .7s.8 4.3 1.9 6c1.2 1.7 1.2 1 0-1.3-1.3-2.7-1.8-5.7-.9-5.7.4 0 1.2.4 1.9.8.9.6 1 1.2 1 4.2-.1 4-.5 4.2-5.3 2.6-1.5-.6-3-1-3.1-.8-.2.2.6 4.5 1.1 5.8.3.6-.1.8-2 .6l-2.4-.2 1.4 2.4a20 20 0 0014 10.1c2 .4 4.4 1.1 5.3 1.6 1.2.6 1.4.6 1 0-.3-.3-1.5-1-2.6-1.3-2.9-1-5.7-3.1-9.4-7s-5.5-7.1-5.5-9.6c0-1.4.2-1.7.8-1.4l3.9 1c4.3 1.2 5.4 1.8 8.1 4.7 3 3.1 3.9 5 4.8 9 .4 1.9.8 3.4 1 3.6.6.7.8-1.6.2-3.6-.9-3.3.5-9.8 3.4-15.5 1.3-2.5 5.2-6.3 5.8-5.6.2.2.9 2.4 1.5 4.8 1.4 5.1 1.2 6.6-1.2 11.7a18.5 18.5 0 01-6.1 7.7c-2 1.4-1.5 1.8 1.3 1.1 2.4-.6 6.4-4.2 8.5-7.7l1.1-2-2 .4-2 .3 1-2.7c1.2-3.4 1.2-4.7 0-8.8l-1.3-4.8-.3-1.4-1.7 1.1a9.4 9.4 0 00-1.9 1.6c-.6.9-1.3-.1-3-4l-2-3.7c-.3 0-1.1.6-1.9 1.4l-1.3 1.4.3-1.4c.3-1 .2-1.4-.2-1.1-.2 0-.5.8-.5 1.4 0 2.4-.9 2.4-1.6 0-.4-1.3-.9-2.2-1-2l-.1.1zm7.4 12.7a31.5 31.5 0 00-2.9 8.3l-.6 3.6-.8-2a17.6 17.6 0 00-2.2-3.7c-1.4-1.6-1.4-1.7-.8-5.3.9-5.7 2-8.7 4-11l1.9-2 1.8 3.7 2 3.7-2.4 4.7zm-19.3 8.3c6.2 6.5 8.4 9 7.3 8.6a17.4 17.4 0 01-10.3-7.5 19.5 19.5 0 01-1.8-3c0-.2.6-.3 1.4-.3.9 0 2 .7 3.4 2.2zm29 4c-2 3.2-3.3 4.4-5.5 5.5l-2 1 2-2.1a32.5 32.5 0 003.2-4.1c1-1.6 1.7-2.1 3.3-2.4.2 0-.2 1-1 2v.1z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#005000",
    fillRule: "nonzero",
    d: "M382.9 209c.7 1.5 2 3 2 2.5 0-.3-.5-1.2-1.3-2-.7-.9-1-1-.7-.5z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#CAB313",
    fillOpacity: "0.5",
    fillRule: "nonzero",
    d: "M369.4 235.3l-.8 3.8-.5 2-1.5-1.4-1.4-1.4-.4 2.4a32 32 0 001.5 12.8 52 52 0 011.6 6.4c.6 4.6 4.4 10 9.4 13.4.9.7 1.2 1.5 1.5 3.8l.4 3v-2.9a64.6 64.6 0 00-1.4-8.3c-1.6-7.3-1-10.4 2.6-17.8l2.6-5.4 2.7 5.4c3.6 7.2 4 9.7 2 15.6a33.4 33.4 0 01-1.8 4.8c-.3.4-.4.8-.3 1.1.2.2 0 .7-.2 1.1-.4.6-.5.6-.2-.2.2-.6-.5 0-1.7 1.2a13.6 13.6 0 00-2.3 3.3c-.3.9-.2.9.6-.1l1.8-2.4c.5-.7 1.1-1.2 1.3-1 .8.4 1.5-1 3.2-5.6a28 28 0 017-12.4 27 27 0 017.8-5.2l5-2.3c.5 0-1 8.8-2 11.4a26.1 26.1 0 01-5.8 9.4c-2.2 2-6.4 4-10.5 5.2-1.7.5-3.3 1-3.4 1.3-.3.4 3.7-.7 7.5-2 5.4-2 10.5-7.3 12.5-12.8 1-2.5 3-13 2.5-13.3 0 0-1.7.6-3.8 1.6l-3.6 1.7.3-3.4c.2-1.9.6-4.4 1-5.8.5-2.3.5-2.4-.5-2a32 32 0 00-10 6l-3 2.7.2-4.7c.2-3 0-4.3-.2-3.6-.3.6-.5 2-.5 3.3 0 2.5-1.2 7.5-1.7 7.5-.2 0-1-1.4-2-3.2-1.7-3.2-2.4-4-2.5-2.7 0 .3-.5-.7-1.2-2.4a22.5 22.5 0 00-2.6-5l-1.5-1.9-.8 1.6-.8 1.5-2-2.5c-1-1.4-2.4-2.7-2.9-3-.8-.5-1-.2-1.2 1.4zm3.5 1.5c2 2.4 6.2 10.4 6.7 12.7l.3 1.3-.9-1.3c-1.6-2.3-6-6.3-8.8-7.8-1.3-.8-1.3-1-1-2.7l.7-3.2c.2-.8.5-1.4.7-1.4a13 13 0 012.3 2.4zm7 5c1.5 3 1.8 5 1 6.2-.6 1-4.8-7.7-4.4-9.4.3-1 .5-1.2 1.2-.6.4.4 1.4 2 2.3 3.7l-.1.1zm-9 1.5a25 25 0 017.5 7.4c.4 1 .3 1.7-.5 3.3a24 24 0 00-1.6 11.8v2.9c-.7 0-4.4-4.7-6-7.6a38.3 38.3 0 01-5-19.8l.4-2 1 1c.7.6 2.6 2 4.3 3h-.1zm30.8 0a75.1 75.1 0 00-.7 5.2c-.3 2.7-.4 2.8-3.3 4.7a23.9 23.9 0 00-5.2 4.6c-1.2 1.5-2.3 2.7-2.5 2.5-.3 0-.6-1.3-.8-2.6a20.8 20.8 0 00-1-4c-.6-1.6-.6-2 .4-3.3 2.1-3 11.2-9.4 13.2-9.4.2 0 .1 1 0 2.3h-.1zM374.4 268c1.8 1.9 3 3.4 2.8 4 0 .7-.7.4-2.7-1.6a19 19 0 01-5.6-8.5c-.3-1.3-.1-1.2 1 .7a30 30 0 004.5 5.4z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#CAB313",
    fillOpacity: "0.5",
    fillRule: "nonzero",
    d: "M369.4 280.5a31.6 31.6 0 00-11.6 17.4c0 1.6-1.8 3-1.5 2.8.2.7 1.8 0 2.5-2.5 1.3-4.7 5-13.2 9.9-16.6 1.4-1 3-1.8 3.2-1.8.2 0 .3 1.9.2 4.3 0 3.4-.4 5-1.4 6.9a28 28 0 01-8.5 9.3c-2.5 1.4-2.7 2-.4 1.1 2.5-1 8.4-7 10-10.3.8-1.7 1.4-3.3 1.4-3.7 0-.3.7-.9 1.5-1.2 1.8-.7 11-3 11.1-2.7.4.4-3.5 8.6-4.7 10.2-2 2.5-6.6 6-8.9 6.7-1 .3-3.4 1.6-5 1.9l-4.6.6-1.8 1 1.8-.3 5.3-.6c5.6-2 7.8-3.2 11.4-6l2.4-2 4.6.2 3.7.3-1.7 2.1a481.398 481.398 0 00-4 4.8 17.5 17.5 0 01-3.7 3.7 29.4 29.4 0 01-12.3 2.5c-4 0-4.2 0-6.2-1.8-2.1-1.8-3-2.2-3.2-1.4 0 .3-1.9 1-3.8 1.8-4 1.3-4.9 1-2.6-1.1.9-.8 1.8-.8 3.6-1 0 0 3.9 1 4 .1 0-.8-4-.7-4-.7-1.7.1-2.2 0-.7-1.8 1.6-1 2.3-3.1 1.4-2.7-2.2 2.7-3.7 3.8-7 7a18.3 18.3 0 01-8 3.6c-2.8.7-7.5 1.4-10.2 1.8-5.4.6-7.6 2-2.5 1 2.6-.5 6-.8 10.3-1.6 6.1-1.5 6.5-1.6 9.6-3.2 2.5-2.6 2.9-2.9 1.6-.8-.5 1.6.3 1.5 5.2-.3 3.8-1.5 4-1.5 5-.6.9 1 .8 1-1.1 1.8a124 124 0 01-20.4 5.6c-4.7 1-8.6 1.8-8.8 2-.4.4 5.6-.2 6.8-.8.6-.2 4.8-1.3 9.5-2.3 4.6-1.1 9.9-2.7 11.8-3.4 3.1-1.3 3.6-1.3 6.3-.8 3.4.6 9.1 0 13.2-1.3 3.2-1 5.4-2.9 8.6-7.4 1.3-1.9 3-3.8 3.7-4.3l1.3-1-4.4-.3c-2.5-.1-4.6-.4-4.7-.5a87 87 0 003-7.4l1.4-4.2-1.8.4-3.5.6-1.8.3.7-1.8c.4-1 .7-1.8.5-1.8l-1 1.7c-.8 2-1.8 2.4-1.5.6.2-.8 0-.6-.6.5a5.5 5.5 0 01-2.2 2.1l-2.2.8c-1 .5-1 .2-.8-3.4.1-2.4 0-3.9-.3-3.9s-1.7.8-3.1 1.8z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#CAB313",
    fillOpacity: "0.5",
    fillRule: "nonzero",
    d: "M321.8 313.9c-3 .2-9 1.1-18.9 2.7l-10 1.6c-.4 0-.5.2-.4.4.1.2-.6.5-1.5.7-2.3.4-4.9 2.5-4.9 4 0 1.4 1.7 3 3 2.7.7-.2.7-.3-.2-.3-2.2-.1-3-2.8-1.4-4.3 1.5-1.3 8.2-3.3 12-3.6a212.6 212.6 0 0023.6-3.6c3.3-.5 2.7-.7-1.3-.3z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#CAB313",
    fillOpacity: "0.5",
    fillRule: "nonzero",
    d: "M313.4 318.8a80.2 80.2 0 00-17.6 4.6c-3.6 1.8-3.1 2 .7.2a32 32 0 016.8-2l9.3-1.8 8.7-1.7 2.8-.4h-2.3c-1.3 0-5 .4-8.4 1v.1z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#FFF",
    fillRule: "nonzero",
    d: "M353.6 305.4c-1.7 1-3.3 2.8-1.5 2.6 1.4-.2 6.4-1.7 6.8-2.7-2 .2-3.5-.3-5.3 0v.1z"
  }), /*#__PURE__*/_react.default.createElement("g", {
    fillRule: "nonzero",
    stroke: "#D4AF37",
    strokeWidth: "0.531"
  }, /*#__PURE__*/_react.default.createElement("path", {
    fill: "#FFF",
    d: "M360.358 315.707c-.893.292-1.489.585-5.36.292-2.739-.175-6.133-.643-7.86-.701-3.334 0-3.334.175-9.23 4.15-4.168 2.807-9.527 2.573-13.517 1.755-2.382-1.17-3.454-1.345-3.096-.76.655 1.052 5.359 2.572 7.979 2.572 4.168 0 7.265-1.052 12.326-4.15 3.93-2.456 5.657-2.632 11.017-1.463 6.312 1.228 7.265.702 12.445-1.578-1.548 0-1.905 0-2.382.234.834-.936.894-1.871 1.072-2.456.238-.35-.476.117-1.25.702l-2.144 1.403h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#D91023",
    d: "M352.2 314.187c-2.918-.41-4.883-.819-6.729-.585-2.025.176-3.454 1.17-5.895 2.631-2.382 1.579-4.585 2.69-4.824 2.69-.357 0-3.453.701-5.835.701-1.072 0-3.514-.76-5.121-1.345-3.395-1.227-4.645.819-1.072 2.28a20.233 20.233 0 009.29 1.053c2.977-.468 5.716-1.754 7.979-3.391 4.585-3.274 1.905-1.754 3.692-2.456 1.786-.76 3.513-.526 3.513-.526 2.382.117 7.086.877 9.468.936 4.287-.41 3.573-.41 5.002-1.17.476-.35 2.084-1.344 2.144-1.578.119-.234.833-1.579.714-1.637-4.466 2.982-6.669 2.982-12.326 2.397h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#D91023",
    d: "M344.459 317.461l-4.228 2.339c-3.692 2.221-7.146 3.274-11.195 3.274-1.787.292-7.741-2.105-6.848-1.813.952 1.754 2.382 1.988 5.716 2.631 2.382.468 3.93.059 6.61-.468 2.978-.35 4.169-1.753 5.36-2.514a20.169 20.169 0 018.336-3.157c.596 0 2.799 1.228 5.3 1.754 2.441.526 3.632.643 6.193.234 2.56-.41 5.18-2.455 7.622-4.034-.357.117-1.19.117-2.382.175-3.573 2.047-9.527 2.807-12.624 1.404-3.216-.76-6.253-.585-7.86.175h0z"
  })), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#00A854",
    fillRule: "nonzero",
    d: "M276.4 176.3a37.7 37.7 0 00-17.5 13.2c-1 1.2-1.8 2.2-1.9 2.1 0 0 .4-2.7 1.2-5.7.7-3 1.2-6.1 1.2-6.8 0-1.2-.1-1.1-2 1a41 41 0 00-7 13c-.7 2.2-1 4.7-1 9.3l.1 6.3-1.2-4.5c-1.3-4.7-2.6-8-4-9.6-.6-1-.8-1-1.3-.3-1 1.5-.3 7.8 1.4 12.4.1.6-.5-.2-1.4-1.7-1-1.6-2-2.7-2.3-2.6-.6.3-.6 5.3 0 7.4.4 1.4.4 1.4-1.3-.5-2.9-3.3-3.5-3.6-3.5-1.3 0 .9.3 2.4.7 3.4l.8 2-1.6.4c-2.3.4-3 1.1-3 3 0 2 1.4 6.8 2 7.2.9.5 1.1 0 1.8-3l.6-2.6 1.9 2.5a76.7 76.7 0 018.8 17.7c2.2 6.4 2.3 7.7.3 3.7a72 72 0 00-3.2-5.2c-2-2.8-12.6-13.9-13.3-13.9-.8 0 0 3.5 1.3 6.4.7 1.4 2.7 4.2 4.4 6.2l2.9 3.6c-.2 0-1.4-.8-2.7-1.7-2.6-2-5.3-3.5-5.6-3.2-.1.1.9 2.3 2.3 4.8l2.4 4.6-1.6-.3a6 6 0 00-2.8.3c-1 .6-1 1.1-1 3.5 0 3.3.8 6.7 1.5 6.7.8 0 2-3.2 2-4.9 0-1.3 0-1.3 2.6 1.1 3.7 3.6 8.6 9.6 13.4 16.6l4 6-4.7-3.6c-4.6-3.3-14-8.6-15.5-8.6-.4 0-.8.2-.8.5 0 .2 3 3.3 6.7 6.8l6.7 6.3-3.5-1.1a71 71 0 00-5.3-1.5c-1.7-.4-1.7-.3 2.2 3.3a68 68 0 008.7 6.7c2.6 1.6 4.3 2.8 3.7 2.7a35.1 35.1 0 00-11.5-1.9c0 .7 3.5 3.5 6 4.8 1.4.7 5 2 7.8 3 6 2.1 9.6 4 12.6 6.6l2 1.9-3.5-1.6c-4.1-1.8-15.3-5.5-16.5-5.5-1.2 0 3.8 5 8.8 8.7a80.2 80.2 0 0019.5 9.7c5.2 1.7 9.6 2.6 18 3.6 3.6.5 7 1 7.8 1.3.6.3 5 1 10 1.5a99.7 99.7 0 0130.7 7.2c1.7.8 3.5 1.1 7.2 1.3 5.5.3 5.8.1 4.2-2.9-1.3-2.5-3.7-3.9-8.7-4.8l-9.2-1.8a726.101 726.101 0 00-29-5c-14-2.3-20.1-4.7-26.7-10.7A43.3 43.3 0 01269 263c.4-3 .6-5.5.5-5.6-.5-.4-3.7 6.3-4.6 9.4l-1 3.3.3-5.4c.3-8.3 3.5-16.1 8.2-20.6 1-1 1.8-2 1.8-2.2 0-.2-1 0-2.1.2-1.6.4-3 1.3-5 3.2l-2.6 2.7 1.3-2.4a27 27 0 018.3-9.6l2.9-1.9-1.7-.1c-3.4-.4-9.5 4-12.9 9.3-2 3-2 2.1 0-2.6a41.8 41.8 0 018-12.5c1.9-1.8 2.2-2.5 1.5-2.5-2.7 0-7.2 3.5-11 8.4-1 1.5-1 1.4.2-1.5a40 40 0 016.1-9.7c1.6-1.9 1.2-2.1-1.5-1a26.4 26.4 0 00-8.6 9.7c-1 2-1.8 3-1.7 2.5a61 61 0 00.8-3.3 46.4 46.4 0 0112.8-22.7c2.4-2.2 3-3.2 2.3-3.2-2 0-6.5 2.6-9.5 5.5-3.1 3-3.2 3-2 .9a57 57 0 0118.3-18.6l4.3-3c0-.8-7.8 1.6-11.3 3.3a42.3 42.3 0 00-4.4 3.2c-2.5 2-2.7 2.1-1.8.8 1.7-2.4 7.6-7.7 10-8.9 1.7-.9 2-1.2 1-1.3-2.3-.4-8.9 3-14 7.4l-2.2 1.9 1.2-2a48 48 0 0114.7-15.6 60.5 60.5 0 014.4-2.6c.3-.1.5-.4.4-.5-.2-.2-2 .2-4 1v-.1zm77 145a6 6 0 011.4 1.9c0 .2-1.1.4-2.5.4-2.5 0-2.6 0-2.6-1.4 0-2.6 1.6-2.9 3.8-.8l-.1-.1z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#9EAB05",
    fillRule: "nonzero",
    d: "M350.3 320.5c-1.3 1.2-1 3 .3 3.4 2.2.6 5 .4 5-.4s-3.3-3.8-4.1-3.8c-.3 0-.8.3-1.2.8z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#CAB313",
    fillOpacity: "0.5",
    fillRule: "nonzero",
    d: "M279 175.5a31.6 31.6 0 00-15 8.5c-.3.3-3 2.8-4.8 5.2-.8 1-2 2.5-2.5 3.5 0-1 .8-3.8 1.5-7 .9-4 1.2-7 1.1-7.2-.5-.5-4.2 4.4-6 8a30.9 30.9 0 00-3.6 16.7v6.4l-1.3-4.8c-1.3-5-3.6-10.3-4.7-10.6-.4-.1-.8.6-1 1.7-.3 1.6 0 3.3 2.1 12 .2.6-.4 0-1.2-1.6-2-3.4-2.7-4.1-3.2-3.8l1.4 2a44 44 0 013 6 85 85 0 015.7 19.1c-.1.1-.5-.3-.7-1l-1.6-4.2a74 74 0 00-3-6.7 38.2 38.2 0 01-4.6-12.7l-.3-2.5c-.7.6-.4 3.5.6 6.8l.9 3c-.1 0-1.3-1.3-2.6-3-1.8-2.4-2.6-3-3-2.5-.4.8-.1 2.3 1 5.2l.7 2H236c-1 0-2.1.2-2.7.6-.8.6-.9 1-.4 3.7.6 3.3 1.4 5.8 2 5.8 1.1 0 1-1 1.6-3.9l.6-1.8c.2.3.5.7 1 1.1a78 78 0 0110 19.4 111 111 0 013.8 16c0 .2-.7-1.7-1.3-4.2-2-8.7-5-13.8-14-22.6 0 0-3-3.7-5.5-5.2 0 2.1.4 2.5.4 2.5.7 3.1 2.2 5.9 7 11.4a43 43 0 013.8 5l-2.7-2.2c-2.7-2.4-7-5.1-7.3-4.7-.2.1.8 2.3 2.2 5 1.8 3.2 2.3 4.5 1.7 4.3-2-.8-2.7-.8-4 0-1.3.9-1.3 1-1 4.4.1 2 .6 4 .9 4.7.6 1 .6 1 1.2-.2.3-.7.8-2.1 1-3.2.2-1 .5-1.9.6-1.9a48 48 0 014 4c.588.71 1.188 1.41 1.8 2.1a332 332 0 0113.6 17.8l1 1.8-1.7-1.3a74.7 74.7 0 00-19-11.7c-1-.3-1.2 0-.7.6 2.4 3.3 9.6 9.4 11.6 11 1.9 1.6 1.8 2.2 1.8 2.3-.1 0-1.4-.6-3.7-1.3-5.8-2-7.3-2.1-6.6-1.2a4 4 0 002.1.8 43 43 0 0115.8 6.8c3.4 2.3 11.5 10 12.6 12 .6 1.2.4 1.1-1.7-.6a43.7 43.7 0 00-11-6.2c-.3.1-2.1-.2-4-.7-2-.5-5-1.1-6.8-1.3l-3-.4 1.8 1.7c2.4 2.1 6.3 4 13 6.3a58.6 58.6 0 017.3 3c2.5 1.5 7.6 5.5 7.3 5.7a123.6 123.6 0 00-20-7.1c-1.2-.3-.8.2 2.3 3.3a75.9 75.9 0 007.9 6.3c10.9 7.2 20.8 10.3 39.2 12.5 3 .3 5.1.8 5 1-.2.3 4.4 1 9.4 1.5 13.4 1.6 21.8 3.4 29.4 6.5a23.4 23.4 0 008.9 2c3.4.2 4.5.2 4.5-.3 0-1.2-1.4-3.4-3.2-5-1.5-1.3-2.6-2-8.6-3.1-3.8-.6-7.3-1.4-7.7-1.7-.5-.3-8.1-1.3-16.8-2.7-19.1-3-25-4.5-30-7a40.3 40.3 0 01-22-34.7 56.1 56.1 0 01.3-9.2c.3-2 .5-3.6.4-3.7-.5-.5-4.4 7.3-5 10.3l-.3 2-.2-3.6a33.9 33.9 0 016.8-20.6s2.9-2.8 3.3-3.6v-.1c-2.1-.7-4.3 1-7.3 3.6-1.8 1.8-2 2.3-2.2 2.2.2-1.4 5.5-9.5 6.6-9.5.2 0 1.5-1.5 2-2 .6-1.5-3.2 2-5.9 5.7-6 8-7.4 16.1-7 26.9a36 36 0 01-.3 5.9c-.2 0-1.8-3.9-2.5-6.4-2-6.3 1-19.4 6.1-26.1l3.3-4.1c.8-1.4-3.5 3.4-5 5.7-.4.7-.8 1.2-1 1l.7-2.2a45.4 45.4 0 019.3-15.7c1.6-1.7 1.6-1.7.3-1.3-3 .9-5.8 3.2-8.7 6.6l-2.2 2.6c.3-1.3 3-7 5.2-10.1 1.4-1.9 2.7-3.2 2.7-3.6 0-.4-1.5 0-3.6 1.6a28 28 0 00-7.6 9c-1.3 2.6-1 1.9-1.5 2.3a43 43 0 0112.8-25.9c2.8-2.9 3.4-3.7 2.4-3.4-3 1-6.3 3-9.2 5.9-1.7 1.7-2.4 2.2-2.4 2 0-.2.8-1.7 2.5-4.3a53.8 53.8 0 0114.1-14.7c2.7-1.8 6.8-3.8 6.3-4a.5.5 0 00-.2-.1c.3-.5-1.1-.2-4.8 1a37.6 37.6 0 00-11.6 6.3c-1.5 1.4-1.2.3 2.6-3.5 2-2 5-4.5 6.6-5.3 2.6-1.6 2.4-2 .7-1.6a32 32 0 00-13.4 7.7l-.3.2c-1.2.7-2.3 2.3-2 1.6.3-.7.8-1.3 2.1-3.5a46.8 46.8 0 0116.8-15.8c1.7-1 1.8-1.6.6-1.4zm-4 1.9h.2a73 73 0 00-12 11.6 60 60 0 00-7.3 13.2c-1 2.4-1.6 4-1.6 3.6a85.6 85.6 0 012.3-12l1.3-1.8a42 42 0 012.6-3.5c1.1-1.4 4.7-5.1 4.6-5.2l1.2-1c3.4-2.4 7.8-5 8.7-5v.1zm-16.9 2.7h.1c.1.4-.5 4.8-1.7 10a230.5 230.5 0 00-4.6 25c-.4 3.7-.5 4-.8 2.4-.3-1-.6-6-.8-11-.3-10 0-12.8 2.6-18.4a29 29 0 015.2-8zm13.9 8.4l-3 3a57 57 0 00-15.9 27.3l-1 3.5.4-3.3a44.8 44.8 0 013.5-14.8c1.1-3 2.2-5.5 4.5-7.8.4-.5 1.5-1.4 1.7-1.8l2.8-2.1c2-1.7 6.2-4 7-4zm6 2.5c.3 0 .4 0 .4.2l-3 2.1a70 70 0 00-13.8 14 83.8 83.8 0 00-7.8 15.5c-1.5 4.2-1.4 2 .2-4a68.6 68.6 0 017.4-17.3l1.5-2c.7-.8.9-1.2 1.2-1 .2.1 1.4-.6 2.6-1.6 2.7-2.3 9.7-5.8 11.4-5.9h-.1zm-34.4 3.9c.1-.1.3.1.6.6a38 38 0 012.2 5.2A93.8 93.8 0 01251 226a82.5 82.5 0 00-2.8-9.6c-4.1-12.4-5.5-18.4-5-20.6l.4-1v.1zm26.5 10.9s-1 1.2-2.5 2.6a49 49 0 00-13.1 27.7c-.5 2.8-1 5.3-1.3 5.5-.2.2-.6-1-.8-2.5a41.3 41.3 0 014.2-20.2l1.3-2.9c.4-.3.7-1 1.3-1.8 2.3-2.6 6.1-6.3 8.6-7.5l2.3-1v.1zm-33.4 1.2l1 1.3a84.5 84.5 0 013.2 4.3c2.2 3.2 7.8 14.4 8.4 16.6.2.7-.5-.4-1.6-2.4a68.8 68.8 0 00-5.3-8c-4.2-5.6-5.7-8.2-5.7-10.2V207zm-1.1 7.4h.5c1.5 0 4.7 2.8 7.5 6.6a69 69 0 018.8 21.4c.9 4 2.4 14.2 2.4 16.5v1.6l-.9-1.5c-.4-.9-1.1-3.5-1.5-5.8a101.1 101.1 0 00-5.3-19c-2.3-5.8-7.1-14-9.3-16a2.5 2.5 0 00-.7-.6 7 7 0 00-1.5-1.5c-1.1-1-1.2-1.5 0-1.7zm-2.6.9l1.3.8c1.7 1.2 2.3 1.7 2 3.2-.3 1.5-.5 3-.8 3.4-.4.8-.8.2-1.2-1.4l-1-4-.3-2zm33.8 6.8c.2 0 .2.2 0 .6-.5.4-1.7 1.9-2.3 2.7a68.9 68.9 0 00-9 23.7c-.5 3.7-1.2 2-1.2-3a30.1 30.1 0 018.1-20.5c2-2.1 4-3.5 4.4-3.5zm-34.3 3.2c.5 0 2 1.5 5.4 5a72 72 0 017.6 8.7c1.9 3.3 4 8.2 4.5 10.7.2 1.4-.3.8-3.2-3.2a174.5 174.5 0 00-6.2-7.9c-5.5-6.4-7.6-9.5-8.2-12.7-.1-.4-.1-.7.1-.6zm38 1.3c.2 0-1 1.6-2.6 3.5a52.3 52.3 0 00-4.7 7c-2 4-5.1 13.3-6.2 19-1.1 6-1.2 5.9-1-.7.5-12.6 5-22.8 12-27.3l2.6-1.5h-.1zm-37.5 9.1l1.6.8c.9.5 3 2 4.6 3.3 1.7 1.5 3.2 2.4 3.4 2.2.3-.2.4-.1.2.2a16 16 0 003 4.8 68.3 68.3 0 019 16.5c.5 1.7 1 3 .8 3.2l-3.4-5.2a61.1 61.1 0 00-11.8-14.8 19.6 19.6 0 01-5-6.5l-2.4-4.5zm40.6 6.7c-.9.8-2.8 3-2.8 3a31.7 31.7 0 00-6.6 12.7 75 75 0 001.7 28.5 48 48 0 01-4-11c-.9-4.5-.8-14.9 0-18.4 1-4 3.2-8.6 5.2-10.8 1.7-2 5-4 6.5-4zm-39.4 1.8c.8 0 1.7.4 3.1 1.3 5.5 3.5 12.5 12.6 20.5 27 6.4 11.5 10.1 20.2 4.9 11.5a265.6 265.6 0 00-25.2-34.4l-.1-.2a20.3 20.3 0 00-3.6-3c-2-1.2-2.1-1.7-.4-2.1l.8-.1zm-2 2.3c.5 0 1 .3 1.4.7.6.8.3 4.7-.5 5.1-.6.4-.8-.1-1.3-3.1-.3-2.2-.2-2.7.5-2.7h-.1zm36.1 13.7v6a43 43 0 0014 34.7c5.9 5.2 12.5 8 23 9.8 3.5.6 6.7 1 7 1.3.5.1 5.3.6 5 1.1-.1.2.3.3 1 .2 2.1-.4 8.5 1 10.2 1a186 186 0 0123.7 5c1.4.6 4.4 4.1 4.4 5.2 0 .3-1.6.4-4.4.2a21 21 0 01-8.5-2.2c-6.7-3-16-5-27.2-6-5.8-.5-24.7-3.8-30.1-5a68.2 68.2 0 01-17.8-6 52 52 0 01-14.4-9.5l-3.3-3.2 2.8.8c8.3 2.4 15 5.4 23.4 10.7 6.7 4 8.9 5.2 12.5 6 3.3 1 4.3 1 4.3.4 0-.2-1.7-.9-3.8-1.5-17.188-5.908-27.59-23.372-24.6-41.3a54 54 0 012.8-7.7zM235 262l.7.2c3 .5 15.2 8.2 19.4 12.3a30.4 30.4 0 014.3 5.8l1.6 3-2.8-2.2a66.5 66.5 0 00-6.4-4.4 86 86 0 01-10-8.5L235 262zm8.4 21.4l1.1.2c1 .1 3.6.7 5.9 1.2 8 1.9 17.8 8 22.8 14.4l2.2 2.9-2.3-1.2c-1.2-.6-2.2-1.3-2-1.5.2-.5-5-4.8-7.7-6.2a92.8 92.8 0 00-8.8-3.6c-6.2-2.3-10-4.1-11.2-5.6-.3-.4-.4-.6 0-.6z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#CAB313",
    fillOpacity: "0.5",
    fillRule: "nonzero",
    d: "M272.2 234.2c-1.1.4-2.9 2-4 2.9-2.2 1.6-2.5 2.2-.4.7 1.6-1 4.3-3 6.6-3.4.3 0-.9 1.2-1.5 1.8-.9 1-.6 1 1.3-.3l2.4-1.8c0-.4-2.4-.6-4.4.1zm-34.7 38c0 1.2 15.8 12.9 16.5 12.1.1 0-2-1.5-4.6-3.1a65 65 0 01-7.8-5.8c-1.7-1.6-3.9-4-4.1-3.3v.1z"
  }), /*#__PURE__*/_react.default.createElement("g", {
    fillRule: "nonzero",
    stroke: "#D4AF37"
  }, /*#__PURE__*/_react.default.createElement("path", {
    fill: "#FFF",
    strokeWidth: "0.531",
    d: "M288.007 315.649a18.788 18.788 0 01-9.766.409 12.734 12.734 0 00-3.692 0l1.668 1.052c.774.468.476.351 1.846.994-.239.234-.358.35-1.43.76 1.43.292 3.216.468 4.943.35a22.407 22.407 0 005.18-.818 28.444 28.444 0 015.36-1.052c.715 0 3.216.76 5.598 1.988 5.12 2.748 8.694 3.508 12.266 3.508 2.442 0 5.002-.585 7.92-2.456 2.144-1.344.358-1.286-1.786-.409-2.978 1.17-9.051 1.754-16.078-1.87a26.737 26.737 0 00-8.694-3.275c-.238 0-1.787.35-3.335.819h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#D91023",
    strokeWidth: "0.531",
    d: "M272.346 314.011c.834.702.715.877 2.263 2.047 2.084.234 6.312.643 7.86.643 1.43 0 4.05-.234 5.955-.702 3.692-.76 5.478-.584 12.207 2.339 7.801 3.976 12.208 3.274 16.257 1.345 5.597-2.105.12-1.17-1.906-1.754-.655.175-1.488 1.052-3.096 1.578-2.263.819-3.454.819-6.134-.584-1.726-.819-3.215-1.17-4.763-2.047-1.49-.877-1.846-.76-4.347-1.578l-3.692-.702-5.598-.292c-4.266.792-8.665.53-12.803-.76-3.215-.994-3.81-.819-2.203.467h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#D91023",
    strokeWidth: "0.531",
    d: "M286.876 318.28a21.212 21.212 0 01-10.242.584l-2.323.76c-2.977.994-2.977 1.053-1.727 1.403.774.234 3.752.41 6.73.351 5.06 0 5.537-.058 8.336-1.403a14.465 14.465 0 014.168-1.462c.596 0 2.68 1.17 4.585 2.164 5.24 2.689 7.206 3.508 11.553 3.45 4.347 0 9.944-3.1 10.659-4.094a16.903 16.903 0 01-10.302 2.807 24.706 24.706 0 01-11.79-4.093c-3.454-1.812-4.645-1.87-9.588-.468h-.06z"
  }), /*#__PURE__*/_react.default.createElement("g", {
    strokeWidth: "0.593"
  }, /*#__PURE__*/_react.default.createElement("path", {
    fill: "#FFF",
    d: "M303.098 303.647c.953-1.061 1.542-1.117 2.532.172 2.912 3.186 7.692 5.233 13.815 5.915 2.388.08 2.736.397 1.206 1.087-1.699.766-8.202.177-11.292-1.006-2.907-1.073-5.224-2.606-6.852-4.534-.158-.35.05-1.022.591-1.634z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#D91023",
    d: "M300.361 305.78c.3-.24 2.118-.745 3.16.205 2.725 2.492 6.885 4.059 12.072 4.546 3.684.23 4.359.82 1.403 1.523-4.223 1.064-12.164-2.032-14.51-3.603-2.345-1.572-2.901-1.9-2.125-2.67h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#ED1C24",
    d: "M304.735 302.194l1.031-.886 2.998.75c1.436 1.824 5.622 4.301 9.36 5.56 1.371.373 2.522.936 3.411 1.669.296.655.316.699-1.634.684-5.828-.606-10.378-2.525-13.134-5.539-.793-.851-2.626-1.287-2.032-2.238h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#FFF",
    d: "M338.123 304.363c-.893-1.112-1.477-1.199-2.537.034-3.084 3.024-7.969 4.808-14.12 5.156-2.388-.051-2.752.246-1.264 1.019 1.654.859 8.179.625 11.329-.388 2.961-.914 5.359-2.319 7.092-4.156.176-.34.006-1.023-.5-1.665z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#D91023",
    d: "M339.622 307.145c-.165-.086-1.057-1.198-2.128-.349-2.858 2.341-7.098 3.679-12.304 3.882-4.731-.187-6.022.278-1.485 1.445 4.157 1.294 12.257-1.366 14.685-2.807 2.428-1.442 2.047-1.316 1.21-2.129l.022-.042z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#ED1C24",
    d: "M336.582 302.813l-.98-.942-3.035.587c-1.535 1.744-5.85 3.99-9.651 5.043-1.39.298-2.57.797-3.499 1.48-.331.64-.354.682 1.593.774 5.852-.288 10.5-1.956 13.419-4.817.839-.807 2.692-1.142 2.153-2.125h0z"
  })), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#FFF",
    strokeWidth: "0.531",
    d: "M332.632 301.648c-4.177 1.176-7.789 3.776-10.187 7.333-1.248 1.714-2.465 2.494-1.643 2.871.878.497 1.75-.703 3.41-2.229 4.298-3.955 7.628-5.602 12.092-5.457l3.57.116-1.023-1.496c-1.193-1.793-2.675-2.017-6.219-1.138h0zm-30.1.427c-.741.795-.574 1.151 1.5 1.51a29.654 29.654 0 0114.186 7.13c1.323 1.447 1.914 1.584 1.95.473.038-1.169-4.064-5.104-7.052-6.664-2.573-1.487-7.166-3.157-8.892-3.213-.595-.02-1.2.253-1.693.764h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#D91023",
    strokeWidth: "0.531",
    d: "M332.039 299.75a31.275 31.275 0 00-3.258 1.24 28.353 28.353 0 00-6.074 5.418l-1.865 2.397c-.812 1.143-.954 1.84-.54 1.912.354.129 1.205-.37 2.135-1.51 3.73-4.792 7.136-6.905 12.048-7.74 2.515-.386 2.872-.374 3.736.531.695.608-.174-.122-.338-.596-.263-1.061-1.02-1.612-2.617-1.957a8.056 8.056 0 00-3.227.305h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#D91023",
    strokeWidth: "0.531",
    d: "M304.232 301.078c-.127.23 1.049.736 2.646 1.08a25.17 25.17 0 0111.12 6.152c2.017 2.113 3.082 2.323 2.37.428-.808-2.658-8.243-6.702-11.19-7.675-2.946-1.032-4.508-.615-4.946.015zm28.79 3.275a23.454 23.454 0 00-8.2 4.823c-2.455 2.201-3.572 3.569-2.62 3.6.179.006 1.643-1.058 2.622-1.845 4.28-3.371 11.962-5.11 15.255-3.775 1.648.638.931-1.14-.147-2.813-.622-1.015-4.747-.564-6.855.128l-.056-.118zm-31.54-1.142l-2.083 1.746 2.96.623c2.963.447 8.434 2.613 12.06 4.72 1.576.987 3.396 1.807 3.932 1.824 1.012.033 1.071.035-.02-1.229a29.221 29.221 0 00-14.063-7.242c-1.6-.286-1.99-1.118-2.846-.444l.06.002z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#D91023",
    strokeWidth: "0.531",
    d: "M322.124 311.66a19.301 19.301 0 00-.596 8.244c.953-.117 1.608-.117 3.156-.41.179-1.285.417-2.747.358-4.326.178-2.163 0-1.052 1.25-2.806-1.37-.877-1.786-.935-4.168-.702h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#FFF",
    strokeWidth: "0.531",
    d: "M317.181 315.285c0 2.456.179 3.04.179 4.21 1.37.175 4.406.584 4.168.117v-4.678l.596-3.215-2.204-.35-1.905.233-.834 3.683h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#D91023",
    strokeWidth: "0.531",
    d: "M314.085 315.402c.06 1.988-.298 2.631-.06 3.8.596.176 2.978.117 3.752.293-.12-2.514-.12-.293-.358-3.625l.715-4.268-2.144.175s-1.31-.409-2.203-.409c.774 1.345.298 4.093.298 4.093v-.059z"
  }))), /*#__PURE__*/_react.default.createElement("rect", {
    width: "640",
    height: "480",
    stroke: "#FFF",
    strokeOpacity: "0.3",
    strokeWidth: "80",
    mask: "url(#b)",
    rx: "48"
  })));
};

var _default = PeSvg;
exports.default = _default;