"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var KySvg = function KySvg() {
  return /*#__PURE__*/_react.default.createElement("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    xmlnsXlink: "http://www.w3.org/1999/xlink",
    width: "1em",
    height: "1em",
    viewBox: "0 0 640 480"
  }, /*#__PURE__*/_react.default.createElement("defs", null, /*#__PURE__*/_react.default.createElement("rect", {
    id: "a",
    width: "640",
    height: "480",
    x: "0",
    y: "0",
    rx: "48"
  })), /*#__PURE__*/_react.default.createElement("g", {
    fill: "none",
    fillRule: "evenodd"
  }, /*#__PURE__*/_react.default.createElement("mask", {
    id: "b",
    fill: "#fff"
  }, /*#__PURE__*/_react.default.createElement("use", {
    xlinkHref: "#a"
  })), /*#__PURE__*/_react.default.createElement("use", {
    fill: "#D8D8D8",
    xlinkHref: "#a"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#006",
    fillRule: "nonzero",
    d: "M0 0h640v480H0z",
    mask: "url(#b)"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#006",
    d: "M0 0h400v200H0z",
    mask: "url(#b)"
  }), /*#__PURE__*/_react.default.createElement("g", {
    mask: "url(#b)"
  }, /*#__PURE__*/_react.default.createElement("g", {
    fillRule: "nonzero"
  }, /*#__PURE__*/_react.default.createElement("path", {
    fill: "#FFF",
    d: "M0 0v27l334.4 215.3h42.1v-27L42.1 0H0zm376.5 0v27L42.1 242.4H0v-27L334.4 0h42.1z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#FFF",
    d: "M156.9 0v242.3h62.7V0h-62.7zM0 80.8v80.7h376.5V80.8H0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#C00",
    d: "M0 97v48.4h376.5V96.9H0v.1zM169.4 0v242.3h37.7V0h-37.7zM0 242.3l125.5-80.8h28L28.2 242.3H0zM0 0l125.5 80.8h-28L0 18V0zm223 80.8L348.3 0h28.1L251 80.8h-28zm153.5 161.5L251 161.5h28l97.5 62.7v18.1z"
  })), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#FFF",
    d: "M448.3 179.1c-1 .6-3 2.5-5 1.9-2-.6-6.6-8.6-11.6-7.4-5 1.3-8.1 3.1-10.1 3.1s-7.6 1.8-7.6 6.7.5 8.6 1.5 8.6 2.5-3.1 2.5-3.1.5 6.1 4 6.1 11.2.6 11.7 2.5c.5 1.8-3.5 6-2.5 9.7 1 3.7 5.5 9.8 5.5 9.8s-6.5 4.8-6.5 8 1 6 1 6l-29.3 1.2s-2 86.7-1 93.4l3.5 23.2s-6.6-2.2-12.1 3.3c-5.6 5.5-25 15-25.5 19.2-.5 4.3-2.3 8-.3 11 2 3 9.2 11.4 7.1 11-6.8-1.1-9.3-10.8-13.9-14.3-4.5-3.5-13.3-2.8-14.4.9-1 3.7-.5 9.8 0 11 .5 1.2 6.1 20.7 7.6 25 1.5 4.3 17.4 10.7 24.5 10 13.4.4 19.4-5.7 20-5.1.4.6 28.7 29.8 86.8 29.9 45.2 0 79.2-29.3 79.2-28.7 0 .6 18.7 6.1 25.3 4.3 6.5-1.9 16.1-6.1 18.1-10.4 2-4.3 7.6-26.2 8.1-29.9.5-3.7 0-8-4.5-9.2-4.5-1.2-7-.9-9.6.3-2.6 1.2-3.3 4.6-7 10.7-2.1 1.9-7.4 6.7-5.9 5.5 1.5-1.2 4.8-10.3 5.3-13.4.5-3 2-8.5-1.5-11.6-3.5-3-9-4.3-15.1-8.8-6-4-10.6-10.7-14.2-10.7-3.5 0-7.5-1.8-7-1.8s4.5-9 3.5-18c-1-9.2.5-96.8 0-96.8s-25.2 1.9-25.2.6c0-1.3 2-9.7 0-15.2s-10.7-9.2-8.1-10.4c2.5-1.2 13.6-4.3 13-9.1-.4-5-7.5-4.3-10.5-6.1-3-1.9-12.1-10.4-13.1-10.4s26.2-16.5 24.2-16.5-12.6-3-16.2-1.2c0-3 14.7-12.2 12.2-13.4-2.6-1.3-14.2-2.5-11.1-3 3-.7 4-8 3.5-8l-13.1 1.8s-3-4.3-4-4.3-5.6 2.5-5.6 2.5l-2.6-6.7-5.5 3.6-2.5-3s-4.6 1.2-4.6 0c.2 0-.5-3-1.2-3s-5.7 3.8-5.9 3.6c-.2-.2-5.7-8-5.7-7.8l-4.1 14.7c-.2 0-4 .4-4.1.6-.2.3-20-11.4-19.8-11.2l5.1 11.2s-4.2 2.4-4.2 2.6l.7 5-13.2-4.5s5 10 4.6 10l-9.6.5 4.4 8.4-1.6 5s14.2 10 13.2 10.6zm84.3 212.4c1.3 1.8 8.1 10.4 7.1 10.4s-18 11.3-24.7 13.4a351 351 0 01-27.8 5.8c1.3-.3 20-10.5 27.5-15.4a119 119 0 0018-14.2h-.1zm-105.5-.3c-1 1.2-5.8 10.7-5.8 10.7s13.9 9.7 24.2 13.4c10.4 3.6 28 4.9 27 4.6-1-.3-22.1-9.8-28.2-14.7-6-4.9-17-14-17.2-14z"
  }), /*#__PURE__*/_react.default.createElement("g", {
    fill: "#FEC500",
    stroke: "#6D6666"
  }, /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.5",
    d: "M438.142 165.26l10.868 7.941c2.026 1.522 8.596 8.238 9.087 7.941.491-.297 4.053-3.674 4.053-3.674s-7.338-7.013-11.912-8.497c-4.574-1.485-12.127-3.043-12.127-3.674l.031-.037z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.5",
    d: "M436.884 158.247c.767 0 14.643 8.534 18.941 12.839 4.298 4.304 6.048 9.76 6.57 9.76.491 0 7.061-1.225 6.816-1.225-.246 0-3.04-10.984-9.333-14.361-6.324-3.34-22.718-7.013-22.995-7.013zm65.39-22.087c-.245 0-2.763 9.166-3.53 11.875-.768 2.783-2.026 8.535-2.026 8.535s-11.114 1.261-10.592-.26c.491-1.559 16.885-20.15 16.148-20.15z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.5",
    d: "M439.432 147.263s13.108 10.687 17.652 16.772c4.544 6.123 9.087 16.81 9.333 16.81.276 0 12.372-3.08 12.372-2.746 0 .334-14.122-17.07-20.937-22.264-6.816-5.196-18.175-7.942-18.42-8.535v-.037z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.5",
    d: "M453.062 144.398s6.54 12.209 7.829 16.476a565.155 565.155 0 005.035 15.215h10.346s-5.035-13.73-10.592-20.41-12.372-10.687-12.618-11.28h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.5",
    d: "M456.593 137.682c.245.927 9.578 11.577 11.85 18.59a172.911 172.911 0 014.052 15.883l9.088-2.746s-8.074-17.997-13.14-22.896c-5.035-4.86-11.359-8.238-11.85-8.831h0zm75.46 28.803s-18.941 2.449-25.757 4.564c-6.815 2.115-10.591 10.093-10.591 10.093s8.841 3.97 9.333 3.34c.49-.63 5.833-7.014 11.604-9.463 5.833-2.412 15.933-8.238 15.411-8.534z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.5",
    d: "M531.286 151.53c-.491.334-15.657 15.251-20.446 20.15-4.79 4.86-9.333 10.056-9.824 10.39-.522.297-9.855-1.559-9.364-2.152.522-.594 13.907-13.73 22.718-19.52 8.842-5.825 16.18-8.237 16.916-8.868z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.5",
    d: "M527.51 140.843c-1.535 2.152-16.394 16.81-20.446 22.005-4.053 5.195-10.592 14.287-10.592 14.287s-7.828-4.268-7.337-6.123c.522-1.819 11.113-12.506 18.696-18.591 7.552-6.123 20.446-10.984 19.679-11.615v.037z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.5",
    d: "M512.375 139.655a258.91 258.91 0 00-10.868 14.621c-1.75 3.043-7.061 16.476-7.061 16.476s-7.828-8.238-7.828-8.535c0-.297 9.824-12.802 15.657-17.7 5.833-4.899 10.345-3.971 10.1-4.862h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.511",
    d: "M490.455 156.273c.173 1.506-.395 2.997-1.454 3.817-1.06.82-2.418.82-3.477 0-1.06-.82-1.628-2.31-1.455-3.817.162-1.995 1.55-3.517 3.209-3.517 1.658 0 3.046 1.522 3.208 3.517h-.031zm6.447 5.195c0 1.892-1.443 3.451-3.193 3.451s-3.223-1.559-3.223-3.451c0-1.893 1.443-3.451 3.193-3.451s3.223 1.521 3.223 3.451zm-14.276-3.896c0 1.93-1.75 3.45-3.93 3.45-2.148 0-3.929-1.52-3.929-3.45 0-1.93 1.78-3.451 3.93-3.451 2.149 0 3.93 1.558 3.93 3.45z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.511",
    d: "M492.972 164.733c0 3.674-1.995 6.68-4.451 6.68-2.456 0-4.452-3.006-4.452-6.68 0-3.673 1.996-6.716 4.452-6.716s4.451 2.969 4.451 6.68v.036zm-12.126.186c0 2.857-1.996 5.195-4.452 5.195s-4.482-2.338-4.482-5.195 1.996-5.195 4.482-5.195c2.456 0 4.452 2.338 4.452 5.195z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.511",
    d: "M474.798 169c0 2.524-1.535 4.528-3.408 4.528-1.872 0-3.377-2.004-3.377-4.527 0-2.486 1.505-4.527 3.377-4.527 1.842 0 3.377 2.04 3.377 4.527h.031zm24.96-.407c0 2.968-2.303 5.38-5.159 5.38-2.885 0-5.188-2.412-5.188-5.38 0-2.969 2.303-5.418 5.189-5.418 2.855 0 5.157 2.412 5.157 5.418zm-12.496-7.793c0 1.818-1.842 3.266-4.083 3.266s-4.114-1.485-4.114-3.266 1.842-3.228 4.114-3.228 4.083 1.484 4.083 3.228z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.511",
    d: "M487.999 167.925c0 2.597-2.579 4.75-5.71 4.75-3.132 0-5.71-2.116-5.71-4.75 0-2.598 2.548-4.75 5.71-4.75s5.71 2.152 5.71 4.75zm14.613 8.423c0 3.229-2.394 5.826-5.342 5.826-2.947 0-5.372-2.597-5.372-5.826 0-3.228 2.395-5.826 5.372-5.826 2.948 0 5.342 2.598 5.342 5.826zm-29.257-1.484c0 2.115-1.35 3.86-3.04 3.86-1.688 0-3.038-1.745-3.038-3.897 0-2.152 1.35-3.86 3.039-3.86 1.688 0 3.04 1.708 3.04 3.86v.037z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.511",
    d: "M494.753 174.196c0 2.746-2.057 4.972-4.605 4.972-2.579 0-4.666-2.226-4.666-4.972 0-2.746 2.087-5.01 4.666-5.01s4.636 2.227 4.636 4.973l-.031.037zm-14.613-.223c0 2.375-1.842 4.305-4.114 4.305s-4.114-1.93-4.114-4.305 1.842-4.304 4.114-4.304 4.114 1.93 4.114 4.304z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.511",
    d: "M487.262 175.272c0 2.598-1.903 4.75-4.298 4.75-2.333 0-4.267-2.152-4.267-4.75 0-2.597 1.934-4.75 4.298-4.75s4.298 2.115 4.298 4.75h-.03zm-18.543-28.499c1.044 0 8.566 3.043 8.566 3.043s-9.302 4.305-7.86 3.86c1.443-.446 10.346-1.708 9.64-1.708-.706 0-7.859 8.201-5.71 7.793 2.15-.445 6.416-5.64 6.754-5.64.369 0 4.667 8.2 5.035 7.792.338-.445 0-8.238.338-8.238.337 0 8.903 5.195 8.196 4.75a42.704 42.704 0 01-5.341-6.457c.368 0 11.789 1.3 11.052.854l-7.491-4.305s5.004-5.603 3.93-5.603c-1.075 0-9.272 5.603-8.566 5.195.706-.445 8.903-11.689 8.903-11.689L488 141.17s1.443-6.902.737-6.457c-.737.445-6.447 9.054-6.785 9.054-.338 0-1.78-8.609-1.78-8.609s.337 9.463-1.812 9.908c-2.149.446-9.609 2.153-9.609 1.744l-.03-.037z"
  })), /*#__PURE__*/_react.default.createElement("g", {
    fillRule: "nonzero"
  }, /*#__PURE__*/_react.default.createElement("path", {
    fill: "#00389B",
    d: "M445.5 216.5c.2.9 5.9 16.4 14.7 16 8.8-.4 12.3-3 11.9-3.2a18 18 0 01-6.2-8.5 44 44 0 01-2.5-8l-17.9 3.7zm31.2-6s6.5 15.3 9.3 17.5c2.9 2.1 9.5 3.8 12.3 3.6 2.9-.2 6.3 0 6.3 0s-2.9-1.5-5.2-9.9l-3-11.2h-19.7zm39.3 5.6s-1.2 11.2 0 14c1.3 2.8 7.5 8 7.5 8s7.5-1 7.7-8a36 36 0 00-2.5-13.3L516 216v.1z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#005120",
    stroke: "#000",
    strokeWidth: "0.511",
    d: "M439.423 196.493s.338 1.744 0 3.043c-.338 1.298-3.408 4.75-3.408 7.532 0 2.82 3.562 11.43 14.43 11.652 10.929.223 24.651-7.124 24.467-7.347-.184-.186-26.064-21.152-26.402-20.929-.368.223-9.118 6.494-9.118 6.049h.031zm71.9 14.88s2.333 7.57 3.223 8.424c.89.853 1.228 2.597 1.443 2.597.215 0 14.981 3.86 14.981 3.86s1.413-4.936-.706-8.832c-2.149-3.897-10.192-14.027-10.192-14.027l-8.75 7.978zm10.192-9.277c.338 0 3.93 3.71 6.754 1.744 2.886-1.93 7.521-7.125 7.521-7.125s-3.93 1.485-6.784 1.3c-2.855-.224-7.307 4.304-7.491 4.081h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#005120",
    stroke: "#000",
    strokeWidth: "0.511",
    d: "M438.87 197.346s-1.074-3.636-3.93-3.86c-2.854-.222-8.043.41-9.823-1.298-1.78-1.744-2.272-5.826-3.193-5.603-.921.185-3.223 0-3.377 0-.154 0-1.105-3.451 1.412-5.195 2.518-1.744 4.605-.223 6.048-1.485 1.443-1.261 3.592-2.189 6.447-2.412 2.855-.185 7.49 4.342 9.64 5.418 2.149 1.076 6.754 2.375 8.565 1.299 1.78-1.113 11.758-5.826 15.35-6.049 3.561-.222 11.052-.445 13.907-.222 2.855.222 14.122 1.966 17.5 3.896 3.376 1.93 21.428 9.463 23.915 11.207 2.486 1.744 8.043 4.304 8.043 4.304s-9.824 11.652-14.675 13.619c-9.556 3.033-19.408 4.481-29.287 4.304-9.088-.63-16.24-1.744-23.179-6.048-6.969-4.305-14.46-8.424-14.828-10.576-.368-2.152-.184-4.935-.184-4.935l-8.381 3.636h.03z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#005120",
    stroke: "#000",
    strokeWidth: "0.511",
    d: "M427.818 183.356c-.368.186-2.149 1.077-1.81 1.485.367.445 1.074 1.744 3.223 1.484 2.149-.185 4.451-1.707 4.451-1.707s-2.67-1.484-5.864-1.262h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#000",
    stroke: "#000",
    strokeWidth: "0.511",
    d: "M427.634 183.765v2.375s2.487.853 2.487.222c0-.63.184-2.152-.368-2.152-.553 0-1.965-.223-2.15-.445h.031z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#001707",
    stroke: "#000007",
    strokeWidth: "0.511",
    d: "M452.624 185.583c.614-1.373 0-3.228 3.653-5.344 3.654-2.152 10.04-1.558 10.04-1.558s-1.843 1.707-1.904 3.45c-.062 1.745.123 2.524.123 2.524s-3.47-1.373-6.14-.556c-2.671.816-5.71 1.707-5.803 1.484h.031zm16.394-7.496c-.369.223-3.162 3.97-2.855 5.121.307 1.113 4.052 3.896 5.25 3.637 1.227-.223 6.692-3.414 6.999-5.01.307-1.596.583-3.748.123-4.193-.43-.483-9.456.594-9.517.445zm12.065-.594c-.706.817-.46 4.862-.215 5.307.276.482 4.605 5.752 5.557 6.048.951.297 7.982-.556 8.534-1.484.553-.928 2.272-4.787 1.75-5.677-.491-.928-1.995-2.153-6.692-3.34-4.697-1.188-7.43-1.113-8.934-.854zm17.837 5.084c1.135.705 7.767 4.602 11.666 7.719 3.93 3.117 5.526 6.68 6.63 7.013 1.137.297 5.742-3.043 5.926-3.97.215-.928-5.618-5.79-9.517-8.016-3.899-2.226-14.705-2.486-14.705-2.746h0zm-1.382 3.303c-.583.594 7.061 16.698 8.504 17.218 1.474.557 10.162-3.117 10.039-4.342-.123-1.224-2.395-3.673-7.767-7.236-5.342-3.6-9.701-5.937-10.776-5.64h0zm-9.456 5.863c-1.228.853-3.1 15.251-1.903 15.956 1.197.668 15.964-1.78 16.547-3.34.553-1.67-6.078-14.397-8.043-14.397-1.965 0-5.526.593-6.631 1.744l.03.037zm-15.288-3.043c-1.566 1.744-1.228 15.177-.553 15.994.676.853 9.456 3.599 10.408 2.597.92-.965 2.21-16.068 1.32-17.218-.89-1.15-3.347-3.896-5.22-4.119-1.903-.223-5.065 2.226-5.955 2.746zm-19.802-.223c-1.442 1.373-1.535 4.936.062 5.567 1.566.593 5.495 2.671 9.148 4.564 3.684 1.892 5.741 4.193 6.816 4.119 1.074-.074 2.087-13.507.92-14.25-2.43-1.037-5.01-1.466-7.582-1.261a39.984 39.984 0 00-9.333 1.224l-.03.037z"
  })), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#D40F0F",
    d: "M388 359.2c2.6-2.5 6.6-8.7 12-9 5.5-.2 11.3 4.8 11.3 4.8s5.7 23.5 5.4 23.5c-.2 0-9.5 6.7-9.7 6.7-.3 0-4-9.2-7.5-8.3-3.5.8-3.2 13.4-3.8 12.6-.5-.9-15.2-18.2-14.6-18.8.5-.6 7.2-10.7 6.9-11.5zm151.9-3c1.7-.4 9.5-6.2 15-6 5.4.3 8.6 2.8 11.4 5.4 3 2.5 6.4 9 6.4 9s-7 19-7.5 19-3.5 1.6-4 .2c-.5-1.4-2.3-5.8-5.8-6.4-3.4-.6-4.3 6.2-4.3 6.2L539.9 356v.2z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#FDDC59",
    d: "M543.6 362c0 1.7 10.7 28 27.9 33 17.3 5.1 22.7-4.7 24.7-8 2-3.4 9.2-3.1 9.2-3.1s-1.7 24.6-4.6 27.7c-2.8 3-5.1 9.8-21.2 10-16.1.3-30.8-15-35.7-19.5a91.6 91.6 0 01-13.8-21.6c-2.6-5.3 13.8-18 13.5-18.5zM356 414.4c.3 0 7.8 8.1 18.8 7.3 10.9-.9 29.6-7.3 38.2-18.5a96 96 0 0013-23.3s-12.7-22.4-13-22.4c-.3 0-1.4 7.3-3.7 12-2.3 4.8-8.7 18.3-19.3 22.5-10.6 4.2-10.6 5.9-15 5.3a59.3 59.3 0 01-15.5-7.6L354 403s-1.1 8.7 2 11.5v-.1z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#FDDC59",
    d: "M387.8 358.4c-.8 0-21.2 11.1-20.4 15.9.9 4.7 35 72 108.2 72.9 73.3.8 118-61 114.8-71.3-3.3-10.3-26-22.2-26-22.2s5.6 4.7 4.8 11c-.8 6.4-26 61-89.5 59.5-63.4-1.6-93.5-50-93.5-55.5s3.2-8.7 1.6-10.3z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#D40F0F",
    d: "M586.2 407.4c1.7-1.4 12.3-30.5 18.4-29.7 6 .8 4 9.5 3.4 11.8-.5 2.2-6.6 22.4-6.6 22.4s.3-4.8-3.7-6c-4-1.2-10.7 2-11.5 1.5zM356 414.7c0-1.6-4.8-7.2.9-8.7 5.7-1.6 13 1.5 13 1.5s-4-11.8-9-21.4c-4.9-9.5-6.5-7.9-10.6-6.3-4 1.6-4 5.8-1.5 12.1 2.5 6.4 7.2 24.4 7.2 22.8z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#FDC400",
    d: "M423.2 360.4l7-24-19.6-15 24.6-.6 8-23.6 8.1 23.6 24.6.4-19.6 15.2 7.2 23.9-20.2-14.3z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#FFF",
    d: "M555.6 235.8v92c.2 45-45.7 84.4-76.1 92.1-30.5-7.6-76.3-47-76.2-92v-92h152.3v-.1z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#D40F0F",
    stroke: "#000",
    strokeWidth: "0.5",
    d: "M403.4 235.803l.123 57.577s.737-1.183 10.745-.466c10.008.717 10.868 12.72 21.767 12.72 10.867 0 10.867-12.72 21.735-12.72 10.868 0 10.899 12.72 21.766 12.72 10.868 0 10.868-12.72 21.767-12.72 10.898 0 10.867 12.72 22.35 13.436 10.284-.717 10.284-13.436 21.182-14.153l10.837.717v-57.111H403.4z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#0062BB",
    d: "M403.3 312v19h11c10 .8 10.8 12.8 21.7 12.8 10.9 0 10.8-12.8 21.7-12.8 10.9 0 11 12.8 21.8 12.8s10.9-12.8 21.7-12.8c10.8 0 10.3 12 21.8 12.8 10.3-.8 10.8-12 21.8-12.8h10.8v-19h-10.8c-11 0-11 12.7-21.8 12.7S512.1 312 501.2 312s-10.8 12.7-21.7 12.7c-10.9 0-10.9-12.7-21.8-12.7s-10.8 12.7-21.7 12.7c-10.9 0-11-12.7-21.8-12.7h-10.9zm3.3 38l7.6 19.1c10 .8 10.9 12.7 21.8 12.7 10.8 0 10.8-12.7 21.7-12.7 10.9 0 11 12.7 21.8 12.7s10.9-12.7 21.7-12.7c10.8 0 10.3 12 21.8 12.7 10.3-.7 10.6-12 21.5-12.7l7.8-19.3-7.5.3c-11 0-11 12.7-21.8 12.7S512.1 350 501.2 350s-10.8 12.7-21.7 12.7c-10.9 0-10.9-12.7-21.8-12.7s-10.8 12.7-21.7 12.7c-10.9 0-11-12.7-21.8-12.7h-7.6zm72.9 70c10.9 0 35.8-19.1 35.5-19.1.3 0-2.9-12.7-13.8-12.7s-10.8 12.7-21.7 12.7c-10.9 0-10.9-12.7-21.8-12.7s-13.6 12.7-13.7 12.7c-.5 0 24.6 19 35.5 19v.1z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#FDC400",
    stroke: "#000",
    strokeWidth: "0.984",
    d: "M423.245 279.815c1.35 0 12.455 1.567 20.407 1.044 8.103-.522 11.104-3.263 11.104-3.785v-1.567h10.503s1.801 7.441.6 7.963c-1.2.522-4.35 2.741-4.951 2.741-.6 0 0-3.785-1.2-2.61-1.2 1.175-1.801 2.61-1.801 2.61s-1.35-1.566-1.95-1.566c-.6 0-1.801 1.567-1.801 1.567s0-1.567-.6-1.567-3.752 2.61-3.752 2.61l-3-2.088s-1.951 2.611-2.552 2.611c-.6 0-4.351-2.089-4.351-2.089l-6.002 3.264s0-4.83-1.35-4.308c-1.2.522-7.953.522-7.953.522s-1.95 3.003-2.551 3.003c-.6 0-3.001-2.611-2.4-2.611.6 0 1.8-1.567 1.2-2.22-.6-.522-3.752 0-3.752-.522s-1.2-3.655-.6-3.655l3.001.523v-3.264h3.151l.6 3.264v.13z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#FDC400",
    stroke: "#000",
    strokeWidth: "0.984",
    d: "M434.5 249.138c-.751 0-4.952 4.308-4.502 9.138.75 4.83 11.253 11.749 11.253 11.749s5.552-2.09 7.353 0c1.8 2.088 1.8 8.615 1.2 8.615-.6 0-7.952 1.697-7.952.653 0-1.175 0-2.22-.6-2.22l-7.503.523.6-2.089-6.002-1.044 2.4-2.22s-9.902-3.785-9.302-3.785c.6 0 4.351-2.089 4.351-2.089l-7.502-4.307h4.501s-6.302-4.308-5.702-4.308l3.752.522-1.801-4.308h1.8l-1.8-3.133 3.001-1.175 1.95 2.742-.75-6.527 4.502.652v5.222s1.8-3.133 1.8-3.655c0-.522 5.552 2.219 4.802 1.044h.15z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#000",
    fillRule: "nonzero",
    d: "M530 282.4c-.8.7-3.1 2.2-3.1 2.2l5-.4a7 7 0 01-2-1.8h.1zm4.4 2.6c-.3.4-1.2 4.6-.6 4.3a29 29 0 003.1-3.4l-2.5-.9zm7.1.5c.8.7 4.3 3.8 3.9 3.1-.5-.7-1-3.5-1.3-3.6-.3-.1-2.3.8-2.6.5zm-62.1-4.4c-.5.1-4.3 2.7-4.3 2.7l6.1-1c-.3 0-2-1.3-1.8-1.7zm4 3.2c-.6.6-2.6 4.3-1.9 4.2a27 27 0 004.2-2.6l-2.3-1.6zm-2.5-5.2l-3.5-1.5 4.3-1-.8 2.5zm-61-1.7l-4.7-3.3 5.9 1.6-1.2 1.7zm-4 2.1c-.7 0-6.5 3.2-6.4 3.2.1 0 8.2.2 8 0-.1-.1-1.3-3-1.7-3.2h.1zm3.7 4.7a40 40 0 00-5 3.4h7l-2-3.4zm-.7-33.4s-1.7-3.8-1.5-3.8l4.3 3-2.8.8zm4.7-4.7l.4-2.4s4.2 2.8 4 2.8c-.1 0-4.1 0-4.4-.4zm6.4 1.7l.5-3.5s3.9 4.6 3.5 4.7c-.3.2-3.7-.6-4-1.2z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#FDC400",
    stroke: "#000",
    strokeWidth: "0.984",
    d: "M492.019 271.369c0 .26 6.452 4.83 6.602 5.874 0 1.044-11.704 1.306-11.704 1.306s-3.451-2.22-4.502-2.09c-1.05 0-1.5 2.35-1.5 2.35l2.7 1.306-5.25.261 1.5 2.61 4.051-.26-.9 2.35s2.4 1.697 3 1.305c.45-.13 1.951-2.61 3.152-3.002 1.2-.392 3.901-.392 3.901-.392s-2.1 3.002-1.05 3.002c.9 0 5.101-3.133 5.101-3.133l1.05 2.872 3.002-3.263s0 2.61.45 2.61 4.801-3.263 4.801-3.263 3.452 3.655 3.902 3.394c.45-.261.9-3.916 1.5-3.916s3.301-.392 3.301-.653c0-.26-1.95-1.305-2.25-3.263-.3-1.958.3-6.266.15-6.266s-20.707.652-21.007.26h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#FDC400",
    stroke: "#000",
    strokeWidth: "0.984",
    d: "M459.158 263.145h60.47c6.002 0 11.704-2.089 11.704-5.352 0-3.264-9.904-3.786-13.505-2.611-3.751 1.044-19.806 7.44-26.559 6.919-6.752-.523-13.054-4.308-13.654-8.094-.6-3.786 3-6.919 9.903-6.919 6.902 0 15.455 2.09 17.256 1.567 1.8-.522 6.152-4.83 7.953-5.352 1.95-.522 7.502-1.045 7.502-1.045l-2.55 1.567 8.102-1.567s-6.152 5.875-12.454 7.441c-6.002 1.697-19.057 1.045-24.008 1.045-4.952 0-7.503-.523-6.752 2.74.6 3.264 4.351 5.353 7.502 4.83 3.001-.521 12.154-3.263 12.154-3.263l-2.4-1.566 11.103-.522s-.6-1.567 0-1.567l6.152.522s-3.751-1.697-3.001-1.697 3.001 0 7.953.523c4.951.522 15.455 2.219 14.855 6.527-.75 4.307-4.502 7.962-8.703 7.962-4.202 0-7.953-1.044-7.953.653 0 1.567 4.952 2.611 7.953 2.611 3 0 6.752-2.089 7.502-2.089s1.8 3.133 2.401 3.133c.6 0 4.351-1.044 4.351-1.044l-2.55 5.874 4.351 1.045s-2.4 2.219-1.8 2.219c.6 0 4.2 0 4.2.522s-4.8 3.786-4.8 4.308c0 .522 3.6 2.088 3.6 2.088s-2.4 3.264-3 2.742l-3.002-3.264s-.75 2.22-1.95 2.22-3.751-.523-3.751-.523 1.8-3.263 1.2-3.263c-.6 0-3.601 2.088-3.601 1.566l-1.95-1.566s4.95-1.697 4.95-4.308c0-2.61-1.95-5.091-10.953-5.483-9.003-.391-9.003 1.828-15.755 1.567-6.602-.261-6.602-2.611-11.554-2.611s-20.107 5.483-27.31 5.222c-7.051 0-15.904-.392-15.604-.653.3-.261 5.852-12.663 6.002-13.054h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#FDC400",
    stroke: "#000",
    strokeWidth: "0.984",
    d: "M447.403 260.103c-.6.262-6.002.914-6.302 5.875-.3 4.96.45 4.96 1.05 4.7.6-.262 1.801-4.57 1.801-4.57s-1.8 5.875.15 7.18a14.736 14.736 0 004.202 1.958l.75-4.7s-1.5 4.57 2.25 6.136c3.602 1.567 5.102.392 4.652-.783a82.166 82.166 0 00-1.35-4.308l3 3.133c.301.261 1.501 2.35 5.403 1.305 3.6-.783 1.05-3.002 1.05-3.002l-4.502-3.133s4.502 4.047 6.603 2.61c2.1-1.435-1.5-4.699-1.5-4.568 0 .13 3 4.569 4.2 1.827 1.201-2.74-1.8-3.655-2.7-6.396-.9-2.61-1.65-2.872-.75-4.569.9-1.566 1.05-4.7 1.05-4.7s3.901.914 3.601-1.957c-.3-2.872-4.201-3.525-4.952-3.656-.75 0-.6-2.871-.9-2.74-.3 0-2.85 1.696-2.85 1.696s-2.102-4.438-2.552-4.177c-.45.26-3 2.61-4.801 2.61-1.8.262-3.001 2.611-3.001 2.611s-6.452-2.74-6.302 1.697c.15 4.439 3.9 3.264 3.9 3.395 0 .13-.6 6.265-1.2 6.526h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#000",
    fillRule: "nonzero",
    d: "M450.9 253.3c.7-.3 1.8-1.2 3-1.1 1.2.1 3.4 1 2.4 1.6-1 .5-1.8.8-3 .5-1-.3-2-.8-2.4-1zm12.6-.2c-.8-.2-1.9-1.1-3.2-1-1.3.1-3.2 1-2.2 1.6a4 4 0 002.8.5c1.2-.3 2-.9 2.6-1v-.1z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#000039",
    stroke: "#000",
    strokeWidth: "0.563",
    d: "M453.656 261.117c0 .653.6 6.266.9 5.875l2.55-5.744-3.45-.13z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    stroke: "#000",
    strokeWidth: "1.125",
    d: "M452.155 261.317c0-1.697 1.2-1.566 3.601-1.305 2.551.261 3.751 1.305 3.601 1.697-.15.261-2.25.914-3.9.783-1.952-.522-3.452 0-3.302-1.305v.13z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    stroke: "#000",
    strokeWidth: "2.11",
    d: "M455.756 257.14l-.3 2.61m10.654-9.398s2.1.914 1.8 1.697c-.3.783-1.8 1.175-1.8 1.175m-16.806-3.525c-.45.13-1.05.392-1.5 1.567-.15 1.044 1.5 1.697 1.5 1.697m4.952 2.302s-2.251 1.958 1.5 1.958 1.05-1.697 1.05-1.697"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#FDC400",
    d: "M462.4 403.8l6.4-21.1-17.9-13.2 22.4-.5 7.2-20.8 7.4 20.7 22.3.4-17.7 13.3 6.4 21-18.3-12.4z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#003017",
    d: "M465.4 398.1l5.3-16.7-14.8-10.5 18.6-.4 6-16.5 6.2 16.4 18.5.4-14.7 10.5 5.4 16.7-15.3-9.9z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#FDC400",
    d: "M425.7 361.1l6.3-19.9-17.6-12.5 22-.5 7.2-19.7 7.3 19.7 22 .3-17.5 12.6 6.5 20-18.2-11.9z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#003017",
    d: "M428.7 355.8l5.3-15.9-14.7-9.9 18.4-.4 6-15.6 6 15.6 18.4.3-14.6 10 5.4 15.8-15.2-9.4z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#FDC400",
    d: "M499.6 361.1l6.4-20-17.8-12.4 22.3-.5 7.3-19.7 7.4 19.7 22.3.3-17.8 12.6 6.5 20-18.3-12z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#003017",
    d: "M502.6 355.8l5.4-15.9-15-9.9 18.6-.4 6-15.6 6.3 15.6 18.6.3-14.8 10 5.4 15.8-15.3-9.4z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M373.3 372.6c8 34.5 41.9 60.1 87.5 66.2 58.6 7.8 114.5-21.9 124.8-66.3"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#000",
    fillRule: "nonzero",
    d: "M373.1 377.9l11-6.2 1 2.2-4.3 2.5 1.5 3.1 4.3-2.4 1 2.2-11 6.2-1-2.2 5-2.8-1.5-3.2-5 2.9-1-2.3m4.6 9.6L388 380l3.5 5.9-1.7 1.2-2.2-3.7-2.4 1.8 2 3.4-1.5 1.2-2.1-3.4-2.9 2 2.3 3.9-1.7 1.3-3.6-6m7.2 11l9-9.2 1.6 1.8-3.5 3.7 2.1 2.5 3.5-3.6 1.6 1.9-9 9.3-1.6-1.9 4-4.2-2-2.6-4.1 4.2-1.6-1.8m11.8 5.5l1.5 1.4 2.7-5-4.2 3.6m-5.7 1.7l10.2-8.3 2.3 2.3-6 12.4-1.9-1.9 1.6-3-2-2-2.5 2.2-1.7-1.7m9 8.3l6-9.2-2.1-1.8 1.2-1.8 6.1 5-1.2 1.8-2.1-1.7-6.1 9.2-1.9-1.5m5 4l6.5-11.7 1.9 1.3-2.5 4.6 2.7 1.8 2.5-4.6 2 1.4-6.5 11.7-2-1.3 3-5.4-2.7-1.8-3 5.3-1.9-1.3m12.1 7.7l5.2-12.5 5.9 3-.9 2-3.8-1.9-1.2 3 3.6 1.8-.9 2-3.5-1.9-2.3 5.5-2-1m11.4-2a15 15 0 00-1 4.2c0 .6.3 1 .9 1.3.6.3 1 .2 1.5-.3.4-.4 1-1.7 1.7-3.8.7-2.1 1-3.5 1-4.2a1.4 1.4 0 00-1-1.3c-.5-.3-1-.2-1.4.3-.4.4-1 1.7-1.7 3.9m-2.2-1a16 16 0 012.4-4.8 3 3 0 011.7-.7c.5 0 1.2 0 2 .4s1.2.7 1.6 1.1c.4.5.7 1 .8 1.8.1.5 0 1.2-.1 2a25.2 25.2 0 01-1 3.4l-1.2 3.2c-.4.7-.8 1.3-1.2 1.6-.5.4-1 .7-1.6.7-.6.1-1.2 0-2-.4s-1.3-.7-1.7-1.1a3.7 3.7 0 01-.8-1.8l.1-2 1-3.4m10.6-2.9l2.2.8-2.4 8.8a4.7 4.7 0 00-.2 2.2c.1.4.5.7 1 1 .6.1 1 0 1.4-.2.3-.3.6-1 .9-2l2.3-8.8 2.2.7-2.4 9a9.8 9.8 0 01-.7 2 2.9 2.9 0 01-.7.9 2.9 2.9 0 01-1.6.6 4.8 4.8 0 01-2-.3c-1.3-.4-2.1-1-2.5-1.9-.4-.8-.4-2 0-3.7l2.5-9m5.9 16.1l2.7-13.4 2.3.6 1.3 10.1 1.8-9.3 2 .5-2.6 13.4-2.3-.6-1.3-10.2-1.8 9.4-2.1-.5m12 .7l1 .2h1.2a1 1 0 00.5-.3c.3-.3.5-.8.7-1.4a24.1 24.1 0 00.8-5.8 3 3 0 00-.4-1.4 1 1 0 00-.4-.5l-1-.2-1-.2-1.3 9.6m-2.5 1.6l1.9-13.6 3.6.7c.8.1 1.3.3 1.8.5.4.2.7.5 1 .9.3.5.5 1.2.6 1.9 0 .7 0 1.8-.2 3.3a31 31 0 01-.7 4 6.4 6.4 0 01-1 2c-.3.5-.7.8-1.3 1-.5.1-1.4 0-2.6-.2l-3.1-.5m9.5 1.6l1.2-13.7 6.3.7-.2 2.3-4-.5-.3 3.2 3.8.4-.2 2.1-3.8-.4-.3 3.8 4.1.4-.2 2.3-6.4-.6m10.4-1.1h2.2a1 1 0 00.5-.5c.2-.3.4-.8.5-1.4a23 23 0 00.2-3v-3a3 3 0 00-.6-1.3 1 1 0 00-.5-.3l-1-.2h-1l-.3 9.7M470 441l.5-13.7 3.7.1a6 6 0 011.7.3c.5.2.8.4 1.1.8a4 4 0 01.9 1.8l.2 3.3a31.6 31.6 0 01-.4 4.1 4 4 0 01-.7 2c-.3.6-.7 1-1.2 1.2-.5.2-1.4.3-2.6.2l-3.2-.1m13.8.2l-.5-13.7 2.3-.1.5 13.7h-2.3m6.1-.3l-.8-11.4-2.7.2-.1-2.2 7.5-.7.2 2.2-2.6.3.8 11.4-2.3.2M498 426l2.3-.4 1.4 9c.2 1.1.4 1.8.7 2.1.3.4.7.5 1.3.3.6 0 1-.3 1.1-.8.2-.4.2-1.1 0-2.2l-1.4-9 2.2-.5 1.5 9.4.2 2-.3 1.2a3.3 3.3 0 01-1.2 1.3 5 5 0 01-1.8.7c-1.4.3-2.4.1-3.1-.4-.7-.6-1.2-1.7-1.4-3.4L498 426m12.3 3.5l1-.3c.6-.2 1-.4 1.3-.8.2-.4.2-1 0-1.7 0-.7-.3-1.2-.7-1.4-.3-.2-.8-.3-1.5 0l-1 .2.9 4m-.5 8l-3-13.3 4-1c1.1-.3 2-.3 2.7.2.6.4 1.1 1.3 1.4 2.6.3 1.4.2 2.4-.2 3.2-.4.8-1.2 1.4-2.3 1.7l-1.7.4 1.3 5.7-2.2.6m8.8-9.7a15 15 0 001.5 4c.4.4.9.5 1.5.3s1-.6 1-1.2-.2-2-.9-4.2-1-3.5-1.5-4c-.3-.5-.8-.6-1.4-.4-.6.2-1 .7-1 1.3-.1.6.2 2 .8 4.2m-2.3.8c-.4-1.4-.6-2.5-.7-3.4a5.6 5.6 0 010-2c.2-.8.4-1.3.8-1.8a5 5 0 011.8-1 4.1 4.1 0 012-.3c.5.1 1 .4 1.6.9.4.3.7.9 1 1.6a24.7 24.7 0 011.9 6.6 6 6 0 010 2.1 3.7 3.7 0 01-.8 1.7 4 4 0 01-1.8 1.1c-.8.3-1.4.4-2 .3a3 3 0 01-1.5-.9 5 5 0 01-1.1-1.6c-.4-.8-.8-2-1.2-3.3m11.3 3.1l-4.6-12.7 2.2-1 6.2 7.6-3.2-8.9 2-.9 4.6 12.7-2.2 1-6.2-7.6 3.2 9-2 .8m14.3-7l-4.8-10.1-2.3 1.3-1-2 6.7-3.9 1 2-2.3 1.4 4.8 10.1-2 1.2m5.4-3.2l-6.6-11.6 2-1.4 2.5 4.6 2.7-2-2.6-4.5 2-1.3 6.5 11.6-2 1.3-3-5.2-2.6 1.8 3 5.3-2 1.4m8.3-6l-7.4-11 5-4.2 1.3 1.9-3.3 2.7 1.7 2.5 3-2.5 1.2 1.7-3 2.5 2 3 3.4-2.7 1.2 1.8-5 4.3M562 404l1.6-1.8.6.6c.5.6 1 1 1.2 1 .4 0 .7 0 1-.4.4-.4.6-.8.6-1.2a2 2 0 00-.5-1.2 2 2 0 00-.9-.5 4.2 4.2 0 00-1.5 0l-1.4.3a6.4 6.4 0 01-2.6.2 3.3 3.3 0 01-1.5-1 3.8 3.8 0 01-1.1-2.7 4.1 4.1 0 011.2-2.7c.8-1 1.7-1.3 2.5-1.3s1.7.5 2.6 1.4a3.8 3.8 0 01.3.4l-1.6 1.7-.2-.3a3 3 0 00-1.3-.9c-.3 0-.7.1-1 .5-.3.3-.4.6-.4 1 0 .3.1.6.4 1 .3.3 1 .4 2.2.2l1.5-.3a5.3 5.3 0 012.5-.1c.6.1 1.2.6 1.8 1.2a4 4 0 011.1 2.8 4.5 4.5 0 01-1.3 2.9c-.9 1-1.8 1.4-2.6 1.4-1 0-1.8-.6-2.7-1.6l-.5-.6m9.5-3.9l-9.5-8.8 4.1-5.4 1.6 1.5-2.6 3.4 2.2 2 2.4-3.2 1.5 1.4-2.4 3.2 2.6 2.5 2.6-3.6 1.6 1.5-4 5.5m2.3-12.3l1.1-1.8-4.8-2.3 3.7 4.1m2.3 6.1l-8.7-10.2 1.7-2.8 11.8 5-1.4 2.3-2.9-1.3-1.5 2.4 2.3 2.5-1.3 2.1m1.4-11.1l1.1-2.3.7.4c.7.4 1.2.6 1.5.5.3 0 .6-.3.8-.7.2-.5.3-1 .2-1.3 0-.4-.4-.7-.8-1a1.5 1.5 0 00-1-.2c-.3 0-.8.3-1.4.6l-1.3.8a6.6 6.6 0 01-2.4 1 3 3 0 01-1.7-.5 3.5 3.5 0 01-1.8-2.1 4.3 4.3 0 01.4-3c.5-1.1 1.2-1.8 2-2 .9-.4 1.8-.2 2.8.4a3.5 3.5 0 01.4.2l-1 2.2-.3-.2c-.6-.3-1-.5-1.4-.4-.3 0-.6.3-.9.8-.1.4-.2.7 0 1 0 .4.2.6.6.8.4.3 1.2.1 2.2-.5l1.3-.8c1-.6 1.8-1 2.4-1 .6 0 1.3.2 2 .6 1 .5 1.6 1.3 1.9 2.2.2 1 0 2-.5 3.2-.5 1.3-1.2 2-2 2.3-1 .3-2 0-3.1-.6a11.5 11.5 0 01-.6-.4"
  })), /*#__PURE__*/_react.default.createElement("rect", {
    width: "640",
    height: "480",
    stroke: "#FFF",
    strokeOpacity: "0.3",
    strokeWidth: "80",
    mask: "url(#b)",
    rx: "48"
  })));
};

var _default = KySvg;
exports.default = _default;