"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var AdSvg = function AdSvg() {
  return /*#__PURE__*/_react.default.createElement("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    xmlnsXlink: "http://www.w3.org/1999/xlink",
    width: "1em",
    height: "1em",
    viewBox: "0 0 640 480"
  }, /*#__PURE__*/_react.default.createElement("defs", null, /*#__PURE__*/_react.default.createElement("rect", {
    id: "a",
    width: "640",
    height: "480",
    x: "0",
    y: "0",
    rx: "48"
  })), /*#__PURE__*/_react.default.createElement("g", {
    fill: "none",
    fillRule: "evenodd"
  }, /*#__PURE__*/_react.default.createElement("mask", {
    id: "b",
    fill: "#fff"
  }, /*#__PURE__*/_react.default.createElement("use", {
    xlinkHref: "#a"
  })), /*#__PURE__*/_react.default.createElement("use", {
    fill: "#D8D8D8",
    xlinkHref: "#a"
  }), /*#__PURE__*/_react.default.createElement("g", {
    mask: "url(#b)"
  }, /*#__PURE__*/_react.default.createElement("path", {
    fill: "#D0103A",
    fillRule: "nonzero",
    d: "M0 0h640v480H0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#FEDF00",
    fillRule: "nonzero",
    d: "M0 0h435.2v480H0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#0018A8",
    fillRule: "nonzero",
    d: "M0 0h204.8v480H0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#C7B37F",
    fillRule: "nonzero",
    d: "M300.4 136.6c7.7 0 10.9 6.6 18.6 6.6 4.7 0 7.5-1.5 11.7-3.9 2.9-1.6 4.7-2.5 8-2.5 3.4 0 5.5 1 7.3 4 1 1.6 1.8 4.9 1.3 6.7a40 40 0 01-2.7 8.3c-.7 1.6-1.3 2.5-1.3 4.2 0 4.1 5.6 5.5 9.4 5.6.8 0 7.7 0 12-4.2-2.3-.1-4.9-2-4.9-4.3 0-2.6 1.8-4.3 4.3-5.1.5-.1 1.3.3 1.7 0 .7-.3.4-1 1-1.4 1.2-1 2-1.6 3.6-1.6 1 0 1.6.1 2.5.7.4.4.6.8 1 .8 1.2 0 1.8-.8 3-.8a5 5 0 012.3.6c.6.3.6 1.5 1.4 1.5.4 0 2.4-.9 3.5-.9 2.2 0 3.4.8 4.8 2.5.4.5.6 1.4 1 1.4a6.2 6.2 0 014.8 3c.3.4.7 1.4 1.1 1.5.6.3 1 .2 1.7.7a6 6 0 012.8 4.8c0 .7-.3 1.6-.5 2.2-1.8 6.5-6.3 8.6-10.8 14.3-2 2.4-3.5 4.3-3.5 7.4 0 .7 1 2.1 1.3 2.7-.2-1.4.5-3.2 2-3.3a4 4 0 014 3.6 4.5 4.5 0 01-.3 1.8 9.6 9.6 0 014-1.4h1.9c3.3 0 7 1.9 9.3 3.8a21 21 0 017.3 16.8c-.8 5.2-.3 14.8-13.8 18.6 2.5 1 4.2 3 4.2 5.2a4.5 4.5 0 01-4.4 4.7 4.4 4.4 0 01-3.5-1.4c-2.8 2.8-3.3 5.7-3.3 9.7 0 2.4.4 3.8 1.4 6 1 2.2 1.8 3.5 3.7 5.1 1-1.5 2.1-2.6 4-2.6 1.7 0 3.2.6 3.9 2.2.2.5 0 .9.3 1.4.3.6.8.7 1.1 1.3.5 1 0 1.8.5 2.7.3.7.9.8 1.2 1.4.4 1 .5 1.6.5 2.7 0 3-2.7 5.2-5.7 5.2-1 0-1.4-.4-2.3-.3 1.7 1.7 3 2.5 4.3 4.5a17.7 17.7 0 013 10.3 22 22 0 01-2.8 11.2 20 20 0 01-7 8.5 35 35 0 01-16 6.4 74.4 74.4 0 01-11 1.4l-14.1.8c-7.2.4-12.2 1.5-17.3 6.6 2.4 1.7 4 3.5 4 6.4 0 3-1.8 5.3-4.7 6.2-.7.2-1.2 0-1.9.4s-.7 1.3-1.4 1.7a6.2 6.2 0 01-3.8 1 8 8 0 01-6.4-2.5c-2.2 1.8-3 3.4-5.5 4.9-.8.4-1.2 1-2.1 1-1.5 0-2.2-1-3.4-1.8a23 23 0 01-4.4-4c-2.3 1.3-3.6 2.4-6.3 2.4a7 7 0 01-4-1c-.6-.5-.8-1.2-1.5-1.6-.7-.5-1.3-.3-2.1-.7-3-1.3-5-3.5-5-6.8 0-2.9 1.8-4.7 4.4-6-5-5-10-5.8-17-6.2l-14-.8c-4.4-.3-6.8-.7-11-1.4-3.3-.5-5.2-.7-8.2-2.1-10.2-4.8-16.8-11.3-18-22.5-.2-1-.2-1.5-.2-2.5 0-5.8 2.3-9.4 6.4-13.5-1-.3-1.7 0-2.8-.3-2.5-1-4.4-2.7-4.4-5.5 0-1 0-1.7.5-2.6.4-.6 1-.7 1.2-1.4.2-1 0-1.6.4-2.5.3-.5.8-.6 1-1.2 1-1.9 2-3.4 4.1-3.4 1.8 0 3 1 3.8 2.5 1.8-.8 2.2-2.1 3.2-3.7a15.5 15.5 0 001.4-13.3c-.4-1.5-.6-2.5-1.8-3.7-1 1-2 1.4-3.4 1.4-2.9 0-5-2.5-5-5.3a4.8 4.8 0 013-4.6c-1.6-1.4-3-1.5-4.7-2.6-2.6-1.6-3.5-3.4-5.2-6-1.2-1.6-1.5-2.8-2-4.7a19 19 0 01-1-7.8c.6-5 1.5-8 4.6-11.9 1.8-2.3 3-3.7 5.8-4.9 2.3-1 3.7-1.7 6.2-1.7l2 .1a6.9 6.9 0 012.8.8c.4.2 1.1.9 1.1.4s-.3-.8-.3-1.3c0-2 1.5-4 3.6-4 1.5 0 2.1 1.4 2.9 2.7.4-.8.7-1.4.7-2.3 0-3.4-1.9-5.2-4-7.9-4.7-5.8-10.5-8.5-10.5-16 0-2.2 1-3.7 3-4.9.5-.3 1.3 0 1.8-.3s.4-1 .7-1.4c.5-.7 1-1 1.6-1.6 1-1 2-.6 3.1-1.5.6-.4.8-1 1.2-1.4 1.3-1.6 2.5-2.4 4.6-2.4 1 0 1.6 0 2.5.4l1 .5c.3-.2.8-.8 1.5-1.1a4 4 0 012.2-.6c1.1 0 1.8.6 3 .6.3 0 .4-.4.8-.6 1-.7 1.5-1 2.7-1 1.2 0 1.8.3 2.8 1 1 .5 1 1.3 2 1.8.5.3 1 .2 1.5.4 2.6.9 4.5 2.6 4.5 5.3 0 1.5-.3 2.5-1.4 3.5-.9.7-1.7.6-2.8 1a16 16 0 0011.3 3.5c4.2 0 9.3-1.7 9.3-5.9 0-2-1-3-1.8-4.8a18.8 18.8 0 01-2.1-8.5c0-2.8.3-4.5 1.9-6.7 1.6-2.3 3.6-2.9 6.5-2.9z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    stroke: "#703D29",
    strokeLinejoin: "round",
    strokeWidth: "0.7",
    d: "M272.4 159a3.6 3.6 0 002.4 2.4c.8.3 2.7.2 3.8-1.4 1-1.2 1-2.8.6-4a4.7 4.7 0 00-1.7-2.2l-5.1 5.2h0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    stroke: "#703D29",
    strokeLinecap: "round",
    strokeWidth: "0.7",
    d: "M401 236.1c-1.2-2.9-4.3-1.6-4.4 0-.5 3.7 2.7 4.8 5 4.2a4 4 0 002.5-2c.6-1 .8-2.4.4-3.7a4.9 4.9 0 00-.8-1.6 5 5 0 00-1.3-1.2c-.9-.6-1.9-.6-3.4-.6-5.5 0-10.4 6.5-12 13.4-.6 2.2-1.3 7.3-.3 12a22.4 22.4 0 005.9 11.3 25.7 25.7 0 009.9 5.8 7.9 7.9 0 004 .1c3.2-.7 4.7-3.8 3-7-1.3-2.5-5.3-4-7.2-.6-.1.3-.4.9-.4 1.5 0 .9.4 2 1 2.4 1.5.9 3.8.6 3.7-2"
  }), /*#__PURE__*/_react.default.createElement("path", {
    stroke: "#703D29",
    strokeWidth: "0.8",
    d: "M383.8 274a11.3 11.3 0 016.6-3.7c3-.4 5.6.5 8.2 2a18.5 18.5 0 0110.8 17c0 3.6-1 7.5-2 9.4-.8 1.7-3 9-15.3 14-7.1 3-18 3.6-25.7 4-10.4.3-20 .7-25.5 7.6"
  }), /*#__PURE__*/_react.default.createElement("g", {
    stroke: "#703D29",
    strokeWidth: "0.7"
  }, /*#__PURE__*/_react.default.createElement("path", {
    d: "M386.4 285.7c-.3-1 0-2.1.8-3.3 1.2-1.6 3.7-2.1 6-1a7.4 7.4 0 012.5 2.2l1.1 1.6c.7 1.1 1 2 1 2.5 2.5 7-1.4 14.5-6.5 17.6-4 2.4-8.7 3.4-14.4 4-2.5.4-4 .3-6.5.5h-9.6a70.1 70.1 0 00-7.2 0c-2.9.3-5 .4-7.6.8-1.6.2-3.4.5-5.4 1-.6 0-1.2.2-1.8.4l-1.2.3c-3.6 1.1-7 2.4-9.8 4.2-.8.5-1.8 1-2.5 1.7l-1.3 1.2c-2 2-3.9 4-4.4 6.7v1.6c0 1.8 1.4 4.3 5.4 5m5.5-170c.8 1.4 1.3 2.3.8 3.9-.6 1.7-1.8 2.8-3.6 2.8-4 0-6.3-4.8-4.5-7.8 3.2-5.3 9.3-2.3 15 .3-.3-1.3-.8-1.8-.7-3.5.1-4.2 3.2-6 4.5-10 .7-2.3 1-4.3-.7-6-1.5-1.3-3.2-1.3-5.1-.6-3.8 1.5-8.5 5.9-16.6 6-8.2-.1-12.8-4.5-16.7-6-2-.7-3.6-.7-5.1.7-1.7 1.6-1.4 3.6-.7 6 1.3 3.8 4.4 5.7 4.5 10 0 1.6-.4 2-.7 3.4 5.7-2.6 12-5.9 15-.3 1.7 3.2-.5 7.7-4.5 7.7-1.8 0-3-1-3.6-2.7-.4-1.5 0-2.8.8-4"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeLinecap: "round",
    d: "M314.6 159.9a5.3 5.3 0 012.4 5c-.2 2.5-.8 3.1-2.8 4.5m2.4-3.8c-.1 1.5-.7 2.5-2.3 3.1"
  })), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#C7B37F",
    fillRule: "nonzero",
    d: "M276.7 153.3l.7.5.8.8.5 1 .2.8v1.9l-.2.8-.5.6-.6.6-.9.5-1 .2-1 .2-1-.5-.9-.6-.5-.8-.4-1v-.4l4.8-4.6z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    stroke: "#703D29",
    strokeLinecap: "round",
    strokeWidth: "0.7",
    d: "M275.2 157.2c-.3-1.7-2.2-2-3-1-1.1 1.5-.3 4 2 4.7a4 4 0 003.9-1.4c1-1.3.9-2.8.5-4a4.5 4.5 0 00-1.7-2.2c-2.7-2-7.1-1.6-8.6 2-1.8 4.4 2.2 7.8 6 10.3 4.6 3.2 10 3.8 14 3.8 9.2-.1 16.2-4.5 20.7-7 1-.6 2.1-.5 2.7.2a2 2 0 01-.3 2.7"
  }), /*#__PURE__*/_react.default.createElement("path", {
    stroke: "#703D29",
    strokeWidth: "0.7",
    d: "M248 281.2l-2 .7-2 1.6-1 1.3-1.1 2-.5 1.5-.4 1.8-.2 1.4m19-10.1l-.1 1.8-.3 1.2-1 2.2-1.3 1.8-1.5 1.2-1.1.5-1.6.4"
  }), /*#__PURE__*/_react.default.createElement("path", {
    stroke: "#703D29",
    strokeWidth: "0.8",
    d: "M319.7 329.1c-.3 1.7-1.9 3.6-5.3 4.2l-.6.2"
  }), /*#__PURE__*/_react.default.createElement("path", {
    stroke: "#703D29",
    strokeWidth: "0.9",
    d: "M404.2 276.2a18.3 18.3 0 015.6 13.5c0 3.6-1 7.5-2 9.4-.8 1.7-3 9-15.3 14a85 85 0 01-25.6 4c-10.3.3-19.8.7-25.4 7.3"
  }), /*#__PURE__*/_react.default.createElement("path", {
    stroke: "#703D29",
    strokeWidth: "0.6",
    d: "M387.5 282.9c.8-1 3.5-2.4 5.8-1.1a6.2 6.2 0 012.3 2"
  }), /*#__PURE__*/_react.default.createElement("path", {
    stroke: "#703D29",
    strokeWidth: "0.9",
    d: "M401.6 273.8l1.4.5a7 7 0 004 0c2.8-.8 4.6-3.4 3.2-6.9a6 6 0 00-1.8-2.1"
  }), /*#__PURE__*/_react.default.createElement("path", {
    stroke: "#703D29",
    strokeLinecap: "round",
    strokeWidth: "0.7",
    d: "M240.3 199.8c-2 1.1-3.3 1.4-4.8 3.1a28.1 28.1 0 00-2.6 6.8m46-51.7c0 1.8-1.2 2.8-3 3.2"
  }), /*#__PURE__*/_react.default.createElement("path", {
    stroke: "#703D29",
    strokeWidth: "0.6",
    d: "M397.1 192a19 19 0 0118.6 19.8c0 16-9.9 18.5-13.8 19.6"
  }), /*#__PURE__*/_react.default.createElement("path", {
    stroke: "#703D29",
    strokeWidth: "0.7",
    d: "M398.4 192c8.1-.3 16.5 5.7 16.9 20.7.3 11.7-8 17-12 18"
  }), /*#__PURE__*/_react.default.createElement("path", {
    stroke: "#703D29",
    strokeWidth: "0.6",
    d: "M393.8 248.4l.1-1.6.6-2.5.7-2 .9-1.6 1-1.3m7.8-3.4v1.5l-.5 1-.7 1.1-.8.6-1.2.5h-1.1l-.8-.1m-14.3-52.8l.3-1.7.8-1.6 1-1.5 1.6-2.2 1.4-1.4 2-2.2 2-1.9 1.1-1.3 1.5-1.9 1.4-2 .8-1.7.5-2.2.1-2.7-.2-.8m-12.3 128.2l1.6-.4 1.2-.6.7-.7.5-.8.3-1.2v-.9m-158.2-12.1h2.7l1.6-.6m5-36.5l-.2 1.4-.4.6-.4.6-.7.5-.7.3-1 .1h-.6m9.9-15.5l-.3 2.1-.5 1-.8 1.2-1.2.9-1.2.6-2.3.5m15.3-39.7l-.5 1.3-.5 1-.8 1-1 1-1.2.5-1.1.3-.6-.1m.3-6.2v1"
  }), /*#__PURE__*/_react.default.createElement("g", {
    stroke: "#703D29",
    strokeWidth: "0.6"
  }, /*#__PURE__*/_react.default.createElement("path", {
    strokeLinecap: "round",
    d: "M254.3 224a6.9 6.9 0 01-2.1 1.4m150.5 44.8l.5.2c1.4.8 4.2-.2 3.4-2.4"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M397.8 239.6c1 1.3 2.9 1.7 4.4 1.3a4 4 0 002.5-2c.6-1 .8-2.4.4-3.7a4.9 4.9 0 00-.9-1.6 6.8 6.8 0 00-1.3-1.5l-.4-.2m6.4 34a4 4 0 00.1-.7 4 4 0 00-1.3-3l-.8-.8m.4.5c0-1.8-1.5-3.2-3.4-3.5m-4.2 2.8l-1.3-1a15.7 15.7 0 01-4.3-10.7c0-4.2 1.6-8.4 3.6-10M341.2 324l1.8-1.6 1.2-1 2.3-1.4 2.2-1 1.6-.5 3-.6 3.6-.6m-29.5 19.4a17 17 0 01-7.6 6.1 17.7 17.7 0 01-7.6-6.1"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeLinecap: "round",
    d: "M314.4 332.6a10 10 0 01-2.2 4.2"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M314.7 330.5l-.4 2.2M312 337l-1 1-1.7.9-2 .6m-5.6-177.8c.3-.8.5-1.4.5-2.6-.1-4.2-3.2-6.1-4.5-10-.7-2.3-1-4.3.7-6 1.4-1.4 3.2-1.4 5-.6 4 1.5 8.6 5.8 16.7 6-8.1-.2-12.8-4.5-16.6-6-2-.8-3.8-1-5.3.5-1.7 1.6-1.2 3.8-.5 6.1 1.3 3.9 4.2 5.8 4.3 10 0 1.2-.3 1.8-.5 2.6M320 148c8-.4 14.9-5.8 17.1-6.3 2-.4 3-.2 4.5 1.1-1.4-1.3-3-1.2-5-.5-3.8 1.5-8.4 5.8-16.6 6m79.6 112.9a15.5 15.5 0 01-6.2-12.4c0-4.1 1.7-8.4 3.6-10m-70 97.6c-1.3 2-4.3 5-7.6 6.2a17.7 17.7 0 01-7.6-6.2"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeLinecap: "round",
    d: "M306.7 163.7l2.3-1.3c1-.6 2.3-.5 2.9.2.6.7.7 2-.2 2.8"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M294.7 169.3c5.5-1.2 10-3.6 13.4-5.5M340.3 328c.5.3.8 1 .8 1 .1.2.3.5.3.8.3 1.5-.7 2.4-2 2.6-1.7.2-3-.8-3.5-2M294.4 169c5.5-1.1 10-3.6 13.4-5.5m97.6 106.9c-1 .4-1.6.3-3-.2l-1.8-1a20.7 20.7 0 01-8.4-9 18.8 18.8 0 01-1.7-4.6 12 12 0 01-.5-3.3 25.6 25.6 0 014.7-15.3c1.1-1.6 2.1-2.5 4.2-2.6m-143.7-39.3a7.1 7.1 0 012.7 5.7c0 3.1-2.6 8.2-9 10a8.3 8.3 0 01-6.3-.8"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M256.3 205.6c1.1.8 1.6 1.7 1.6 3.3 0 1-.7 2.4-1.9 3.7a12.4 12.4 0 01-8.8 4c-2 0-4-.4-6-1.7a9 9 0 01-3.8-5.4"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M256.2 212.3c1.3 1.2 1.7 2.7 1.7 4.6 0 2.7-1.1 4.8-3.7 7-.6.6-1.2 1-2 1.5m129.5-22.1v3.5m-.3-4.4v5m.3-15.8v6.6m-.3-8v8.9m-1.9 82a18.7 18.7 0 01-4.2 5.6 19.6 19.6 0 01-5.8 4.1 24.6 24.6 0 01-6.6 2.2 33 33 0 01-6.8.9c-2.5 0-3.9 0-6.4-.2-2.6-.2-4-.6-6.7-.8-2.2-.2-3.4-.4-5.6-.3a28.3 28.3 0 00-11 1.8c-2.6 1-5.7 3-6.3 3.8a22 22 0 00-6.4-3.8 22 22 0 00-5.1-1.4c-2.3-.4-3.5-.4-5.8-.4-2.2 0-3.4.1-5.6.3-2.6.3-4 .6-6.7.8-2.5.2-3.9.3-6.4.2a33 33 0 01-13.4-3 19.5 19.5 0 01-6.4-4.8m42.1 53.4l1.8-.2m30.3-2.4l1.8-.1 1.7-.7 1.2-.8 1.7-2 .3-.6.3-1.7v-.8m47-136.7c.7-2.6-.2-5.4-2.8-5.3m-132 46.5a8.2 8.2 0 01-3.5 4.7m3.6-46.7a6.5 6.5 0 01-3.6 4c-1.9.8-4 0-5.2-.8"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeLinecap: "round",
    d: "M243.8 202.4c1.5.8 3.1-.4 2.8-2.4a2.9 2.9 0 00-2.5-2.2"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M250.2 286.6c.3.3.4.7.8.8.7.2 1.2.4 1.9-.5.8-1.1.3-2.8-.5-3.9a5 5 0 00-5.8-1c-.8.5-1.7 1-2.6 2.2l-1.1 1.6c-.7 1.1-1 2-1.1 2.4-2 5.9.4 12 4.1 15.7"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeLinecap: "round",
    d: "M340.2 327.8l.7.8.2.9c.3 1.5-.7 2.4-2 2.6-1.6.2-2.8-.8-3.3-2"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M389.4 154.8a7.4 7.4 0 016.3 7c0 4.4-1.5 6-3.8 9.2-2.5 3.4-10.7 9.6-10.7 16.7 0 4.3 1.2 7 4.3 8.4 2 1 4.3 0 5.4-1 2.6-2.4 1.5-6.5-1.2-7-3.2-.6-3.9 4.6-.7 4.3m17.9 69a3.7 3.7 0 00-3.6-3 3.7 3.7 0 00-3.7 3.7c0 1 .4 2 1 2.6"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M383.9 195.1a7.1 7.1 0 00-2.7 5.7c0 3.1 2.6 8.2 9 10 2.4.7 4.8.6 6.2-.3m-156-10.3a9.4 9.4 0 00-4.8 3.5 16.9 16.9 0 00-2.2 12.7 15.8 15.8 0 002.3 5.6 8 8 0 001 1.2l1.2 1m64 92c4.9 2.1 8.4 3.7 11.4 8.5a10 10 0 011.2 4.9c0 2.7-1 5.7-3.3 7.6a8.3 8.3 0 01-6.7 2c-1.9-.2-3.7-1.6-4-2.6M254 224.1c2.7 2.2 3.9 4.2 3.9 7.5a8.4 8.4 0 01-4 7.5"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeLinecap: "round",
    d: "M251.5 236.4c4 5.1 6.3 8.1 6.4 14.1.1 5.7-1.7 9.6-5 13.7"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M329.8 169.3a4.1 4.1 0 001.5-2.2c.5-1.5.5-2.8-.2-4 1 1.4 1 2.5.7 4-.1 1-.8 1.5-1.6 2.3m51.5 86.1v16.2l-.1 2.5a34.4 34.4 0 01-.3 1.7"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M381.4 254v19.9l-.5 2.6m.5-43v14.6m.3-13.4v11.8m0-26.8v8.8m-.3-9.9v11m.3-19v3.5m-.3-4.2v5m-1.8 65.2l-.4.7a18.7 18.7 0 01-4.1 5.7 19.6 19.6 0 01-5.9 4 24.6 24.6 0 01-6.5 2.2c-2.7.6-4.2.8-6.9.9-2.5 0-3.9 0-6.3-.2-2.7-.2-4.1-.5-6.8-.8-2.2-.2-3.4-.3-5.6-.3-2.2 0-3.5 0-5.7.4a22 22 0 00-5.2 1.4c-2.7 1.1-5.7 3-6.4 3.8-.6-.8-3.7-2.7-6.3-3.8a22 22 0 00-5.2-1.4c-2.2-.4-3.5-.4-5.8-.4-2.2 0-3.4.1-5.6.3-2.6.3-4 .6-6.7.8-2.5.2-3.9.3-6.3.2a33 33 0 01-13.5-3 19.5 19.5 0 01-5.8-4.1 22 22 0 01-2.5-2.8m-2-3.2a10.1 10.1 0 01-2.3 7.7c-.8.9-2.6 2.6-5 2.6-3.7 0-4.8-2.5-5-3.2"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M255.6 278.9c.7.7 1.3 1.5 1.9 2.5 1 1.8.6 4.8-.1 6.2a4.4 4.4 0 01-.3.4m-20.3 18c2.3 2.4 5.7 5 10.9 7.1 7.1 3 18.1 3.6 25.7 4 10 .3 19.3.7 25 7m17.3-4a12 12 0 014 5.5m-7.3 11.5a8.2 8.2 0 01-.7.7 8.3 8.3 0 01-6.6 2c-2-.2-3.8-1.6-4.3-2.6m-5.4-2.9l.3.4a7.6 7.6 0 005.1 2.4m27 0a18 18 0 01-7.7 6.1 17.7 17.7 0 01-7.6-6.1l-.3-.5m15.6.4l.7.7a8.3 8.3 0 006.7 2 5.5 5.5 0 004-2.5l.5-.7"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M339 336.6l-.7 1.2-1.1 1-1.7.7h-1.6"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M343 325.3a7.7 7.7 0 012.4 2.9c.3.7.4 1.5.5 2.3a5.8 5.8 0 01-1.5 4.2 7.5 7.5 0 01-5.4 2.4 5.5 5.5 0 01-.4 0m.2-.2a6.8 6.8 0 01-5.2-2.2m63.7-67.9a23.8 23.8 0 01-4.8-6.4 18.8 18.8 0 01-1.7-4.5 12 12 0 01-.5-3.3 26 26 0 014.6-15.3c.7-.8 1.4-1.8 2.1-2.2m-1.3-75.9c2.5.2 4.8 3 4.8 5.7 0 3.8-1.3 5.5-4.4 9.3-2.6 3.2-10.6 9-10.3 14.5 0 1 .5 2 1.1 2.8m-3.2 3.5a7 7 0 002 1.4 5 5 0 004.3-.3M369 153a6 6 0 012.2 2.6c1.8 4.5-2.2 7.9-6 10.4a21.3 21.3 0 01-8.3 3.3"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M364.6 161.6a4.2 4.2 0 01-3.1-1.5 3.4 3.4 0 01-.7-1m-15 4.9a4.6 4.6 0 01-1.2-1c-1-1-1.5-2.3-.8-4.4.6-1.9 3.7-7.2 3.8-10.9.2-5.6-2-9-5.3-10.2"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeLinecap: "round",
    d: "M347.3 146.5l-.1 2-.6 2.2-1 3-1 1.9-.8 1.9-.4 1.3-.2 1 .1.9m38 126.3l.6.8c.7 1 3.2 3 5.5 3 3.7 0 4.6-2.6 4.7-3.2.5-2.9-.5-3.6-2-4.5 0 0-.8-.4-1.9-.2"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M237 274.4a6.9 6.9 0 01-3.7 0c-2.9-.9-5.2-3.6-4-7m13.4-31.8c.3.3.4.7.4 1 .4 3.8-2.8 4.8-5 4.2a5.6 5.6 0 01-3-2.3 4.7 4.7 0 01-.7-2.3m22-23.6c.6.5 1 1 1.3 1.7m-1.1-8.5c.5.4.9.9 1.1 1.3"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeLinecap: "round",
    d: "M257.9 210.5a8.5 8.5 0 01-1.6 2.4 12.4 12.4 0 01-8.8 4c-2 0-4-.4-6-1.7a9.5 9.5 0 01-4-5.6"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M255.4 195.3a7.8 7.8 0 012.4 3.4"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeLinecap: "round",
    d: "M257.8 203.2c-.9 3-3.5 6.6-8.6 7.9-2.4.6-5.6-.2-6.6-1"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M240 202.6c.3 2.6 2 4.6 5.4 4.6 4.7.1 7.6-6.7 3.4-11.5"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeLinecap: "round",
    d: "M229.4 225.5c.7.9 1.5 1.7 2.4 2.4a16.8 16.8 0 006 3.3m5.2.5c4.2-.5 6.6-3.7 6-7.3-.3-2.8-2.8-5-4.6-5.1"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M249.8 188.1c1.9 0 3 1.6 2.9 3"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeLinecap: "round",
    d: "M249.4 163a11.5 11.5 0 005 5.9m144.2 31c1.7 2.3.6 7-4 7a5.2 5.2 0 01-4.5-2.5"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M381.7 169.1V185"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeLinecap: "round",
    d: "M243.8 202.3c1.4 1 3.3-.7 2.5-2.6-.5-1.2-2.2-2.6-4.7-.9-2.8 1.9-2 7.8 3.2 7.9 4.7 0 7.6-6.8 3.4-11.6-4-4.6-11.3-3.6-16 .2A21.4 21.4 0 00225 207a22.5 22.5 0 000 9.2 20.9 20.9 0 003 7.5l1.3 1.7c.8.8 1 1.2 2 2a15 15 0 0010.4 3.7c4.6-.2 7.3-3.4 6.8-7.3-.4-3.8-4.2-5.7-6.7-3.9-1.7 1.2-2.3 4.9.7 5.8 1.6.5 3.1-1.7 2-3M374 150.9c2.7-1.4 4.8-1.2 6.3 1a9.9 9.9 0 011.6 7.2 9.2 9.2 0 01-3.5 5.8"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeLinecap: "round",
    d: "M380.5 152c3.1-2 6.5-1.1 8.3 1.6 1.3 2 1.7 3.6 1.6 6.1a11.2 11.2 0 01-5.7 9.2"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M395 159.2c2.6.2 4.6 2.5 4.6 5.1 0 3.8-1 5.5-4 9.3-2.7 3.3-10.6 9-10.4 14.6 0 2.1 1.8 4 3.3 4.2"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeLinecap: "round",
    d: "M395.4 202.3c-1.5 1-3.3-.6-2.5-2.4.5-1.2 2.2-2.8 4.7-1.1 2.7 1.9 2 7.8-3.3 7.9-4.7 0-8-6.6-3.4-11.6 4-4.6 11.7-3.7 16.5.1 2 1.6 6.1 6 7 12 1 7 .9 15.6-6.4 21-3 2.1-7 3.1-10.6 3-4.6-.2-7.3-3.5-6.8-7.4.5-3.8 4-5.4 6.7-3.9 2.8 1.5 2.3 5.4-.7 5.8-1.7.2-3.1-1.7-2-3"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M392.9 199.9c.8-3.5 3.7-3.8 6.2-3.8 6.5.1 11.1 8 11.2 15.5 0 9.5-4 15.2-11 15.5-1.9 0-5-.8-5-3"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeLinecap: "square",
    d: "M397 198.3c6.9 1.6 9.3 7.8 9.3 13.8 0 4.9-.5 11.6-10 13.9"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M408.4 265.3a3.9 3.9 0 10-6.3 2.4"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeLinecap: "round",
    d: "M394.4 259.4c1.4 2 3 4.1 6.3 6m-1.3 10.5c-3.2-2.2-9.5-5-15-2.2a7.6 7.6 0 00-4.4 4.4 10 10 0 001.8 9.5c.9 1 2.7 2.6 5 2.7 3.8 0 4.7-2.6 4.8-3.2.4-2.8-1.2-3.9-2-4.1-.7-.3-2.8-.2-3.2 1.3-.2.5-.2 1.3.2 2"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeLinecap: "round",
    d: "M340.5 328.4c1 2.2-.2 3.2-1.6 3.4-2.2.3-3.3-1.4-3.4-3a4.4 4.4 0 014.3-4.7c2.3 0 4.1 1.5 5 3.5.3.7.5 1.5.5 2.4a5.8 5.8 0 01-1.4 4.1 7.5 7.5 0 01-5.4 2.5c-4.2.1-7.5-3.8-7.5-7.8 0-7.7 11.4-12 16-13a84 84 0 0117.9-2.4c3.5-.1 6.2 0 10.1-.5 3.5-.3 5.4-.5 9-1.3a27.2 27.2 0 0012.6-6.4c2.9-2.7 4.5-4.5 5.9-8.2a17 17 0 00-1.3-13.9 14.3 14.3 0 00-10.3-6.8c-3.7-.5-7 1.1-9 4.8-1 1.8-.6 4.8.1 6.2a6 6 0 004.8 3c3.8 0 4.7-2.6 4.8-3.2.4-2.8-1.2-3.9-2-4.2-.7-.2-2.8-.1-3.2 1.4-.2.5-.2 1.3.2 2"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeLinecap: "round",
    d: "M337.2 316.2c-4.8 2.1-8.4 3.7-11.4 8.5a9.9 9.9 0 00-1.2 4.9c0 2.7 1.1 5.7 3.3 7.6a8.3 8.3 0 006.7 2c2-.2 3.7-1.6 4-2.6"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M385.1 224.1c-2.3.8-3.9 4.2-3.9 7.5a8.4 8.4 0 004 7.5"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeLinecap: "round",
    d: "M387.6 236.4c-4 5.1-6.3 8.1-6.4 14.1 0 5.7 1.7 9.6 5.1 13.7"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M365.9 152l.3-.5c1.7-2.4 4.7-3.1 6.9-1.5 2.6 2 3.3 5.4 2.6 9-.5 2.2-2 4.1-4 5.5"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeLinecap: "round",
    d: "M265.1 150.8c-2.6-1.2-4.7-1-6.3 1a8.7 8.7 0 00-1.6 7.2c.6 2.7 1.4 3.8 3.5 5.8"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M258.6 152a5.8 5.8 0 00-8.3 1.6 9.1 9.1 0 00-1.6 6.1c.2 4.2 2.8 7.6 5.8 9.2"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M249.7 154.8a6.8 6.8 0 00-6 6.6c0 4.5 1 6.3 3.5 9.6 2.5 3.4 10.7 9.6 10.7 16.7 0 4.3-1.2 7-4.3 8.4-2 1-4.3 0-5.4-1-2.6-2.4-1.5-6.5 1.2-7 3.3-.6 3.9 4.6.7 4.3"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M244 159.2c-2.5.2-5 2.3-5 5 0 3.8 1.5 5.6 4.6 9.4 2.6 3.3 10.1 9 9.9 14.5 0 2-1.5 4.6-2.9 4.3"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeLinecap: "round",
    d: "M238 236.1c1.3-2.9 4.4-1.6 4.6 0 .4 3.7-2.8 4.8-5.1 4.2a4 4 0 01-2.5-2 4.8 4.8 0 01-.4-3.7 4.9 4.9 0 01.9-1.6 5 5 0 011.2-1.2c1-.6 1.9-.6 3.4-.6 5.5 0 10.4 6.5 12 13.4.6 2.2 1.3 7.3.3 12a22.4 22.4 0 01-5.8 11.3 25.8 25.8 0 01-10 5.8 7 7 0 01-3.9.1c-2.8-.9-4.6-3.5-3.2-7 1.2-2.6 5.4-4 7.3-.6.2.3.4.9.4 1.5 0 .9-.4 2-1 2.4-1.4.9-3.7.6-3.6-2"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M233.8 270.4c1 .4 1.6.3 2.9-.2l1.8-1c2.6-1.5 5.6-3.8 8.4-9.1a18.8 18.8 0 001.7-4.5c.3-1 .5-2.2.6-3.3a25.6 25.6 0 00-4.8-15.3c-1.1-1.6-2-2.5-4.2-2.6m-9.5 31a3.9 3.9 0 116.3 2.3"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M232.2 261.4a3.7 3.7 0 013.7-3 3.7 3.7 0 013.6 3.7 3.8 3.8 0 01-1 2.6"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M239.4 261.3a15.5 15.5 0 006.2-12.4c0-4.1-1.6-8.4-3.6-10"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeLinecap: "round",
    d: "M244.7 259.4a16.5 16.5 0 01-6.3 6"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M254.6 273.7c-1-2.2-2.8-3.2-5.8-3.5-3-.3-5.5.5-8.2 1.9a18.6 18.6 0 00-10.8 17c.04 3.267.719 6.494 2 9.5.9 1.6 3 9 15.3 14a86.1 86.1 0 0025.7 3.9c10.4.4 20 .8 25.6 7.6"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeLinecap: "round",
    d: "M239.7 275.9c3.3-2.2 9.5-5 15.1-2.2a8 8 0 014.3 4.4 10 10 0 01-1.8 9.5c-.9 1-2.7 2.6-5 2.7-3.8 0-4.7-2.6-4.8-3.2-.4-2.8 1.2-3.9 2-4.2.7-.2 2.8-.1 3.2 1.4.2.5.2 1.3-.2 2"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M252.7 285.7c.3-1 .2-2.2-.8-3.3a5.1 5.1 0 00-6-1c-.7.5-1.6 1-2.4 2.2-.4.4-1 1.1-1.2 1.6-.7 1.1-1 2-1 2.5-2.5 7 1.5 14.4 6.5 17.6 4.4 2.8 8.8 3.6 14.4 4 2.5.3 4 .3 6.5.5h9.6a70.1 70.1 0 017.2 0c3 .3 5.1.4 7.6.8 1.6.2 3.5.5 5.4 1 .6 0 1.2.2 1.8.4l1.2.3c3.6 1.1 7 2.4 9.8 4.2.8.5 1.8 1 2.5 1.7l1.3 1.2c2 2 4 4 4.4 6.7v1.6c0 1.8-1.4 4.3-5.3 5"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M298.6 328.4c-1 2.2.2 3.2 1.6 3.4 2.2.3 3.3-1.4 3.5-3a4.4 4.4 0 00-4.4-4.7 5.5 5.5 0 00-5 3.5 6.9 6.9 0 00-.5 2.4 5.8 5.8 0 001.4 4.1 7.5 7.5 0 005.4 2.5c4.2.1 7.5-3.8 7.5-7.8 0-7.7-11.4-12-16-13a84 84 0 00-17.9-2.4c-3.5-.1-6.2 0-10.1-.5-3.5-.3-5.4-.5-9-1.3a27.2 27.2 0 01-12.5-6.4c-6.889-5.1-8.903-14.53-4.7-22a14.3 14.3 0 0110.3-6.9c3.8-.5 7 1.1 9 4.8 1 1.8.6 4.8-.1 6.2a6 6 0 01-4.8 3c-3.8 0-4.7-2.6-4.8-3.2-.4-2.8 1.2-3.9 2-4.2.7-.2 2.8-.1 3.2 1.4.2.5.2 1.3-.2 2"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeLinecap: "round",
    d: "M273.3 152l-.4-.5c-1.7-2.4-4.7-3.1-6.9-1.5-2.6 2-3.3 5.4-2.5 9a9 9 0 004 5.5"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M366.8 159.6c-4 4.4-8.1 5.8-14.1 6-2 0-5.5-.6-7.6-2.1-1.3-1-2.8-2.6-1.9-5.5.6-1.9 3.7-7.2 3.8-10.9.3-5.6-1.9-8.7-5.3-9.9-6.2-2.2-13 4-17 5.4-2.1.7-3.2.8-5.1.8-2 0-3-.1-5.2-.8-4-1.4-10.7-7.6-17-5.4-3.4 1.2-5.5 4.3-5.3 10 .1 3.6 3.2 9 3.8 10.8 1 2.9-.5 4.5-1.9 5.5-2 1.5-5.7 2.1-7.5 2-6-.1-10.1-1.5-14.1-5.9"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeLinecap: "round",
    d: "M297.3 314.4c.8.3.2-.2 5.3 2a22 22 0 0111.3 8.9 10.5 10.5 0 01.9 7.3"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M297.7 336a8 8 0 003.2.9c4.2.1 7.5-3.8 7.5-7.8 0-2.8-1.5-5.2-3.6-7"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeLinecap: "round",
    d: "M298.6 328.4c-1 2.3.4 3.5 1.8 3.7 2.2.2 3.4-1.4 3.6-3a4.5 4.5 0 00-2.2-4.2"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M390.1 154.8c3.2 0 6 3.6 6 7.2 0 4.3-2.2 6.9-3.9 8.8-1.3 1.6-2.7 3-4.4 4.7"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeLinecap: "round",
    d: "M386.3 151.4a9 9 0 012.8 2.4c1.3 2 1.7 3.7 1.6 6.2-.2 4.2-3.2 7.1-6 9m-4.7-17.6l.6.7c1.9 2.2 2 5.4 1.6 7.2a8.2 8.2 0 01-3.8 5.4m-5-14.4c2.6 2 3.4 5.4 2.5 9-.6 2.5-2.2 4-4.2 5.2m11.1 41.1c.3 1 .9 1.3 1.5 2a13.5 13.5 0 006.2 3.5c2.4.7 4.6.2 6.3-.9m-163 54c1.2 0 2.5.9 3.3 2.3.1.2.4.8.4 1.5 0 .9-.4 1.8-1 2.2-1.5 1-4 .5-4-2"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M241.5 231.3c5 1 9.7 6.9 11.2 13.3.6 2.3 1.3 7.3.3 12a22.4 22.4 0 01-6 11.4 16.5 16.5 0 01-2.1 1.9l-1 .7m-8-12.1c2 0 3.8 1.9 3.8 4a3.8 3.8 0 01-1 2.6"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M234.6 260.7c2.1 0 4.1 2 4.1 4.2a3.9 3.9 0 01-1.4 3"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeLinecap: "round",
    d: "M254 239.5a18 18 0 013.8 7.7m0 8.5a17.3 17.3 0 01-1.5 4 17.8 17.8 0 01-3.6 4.7"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M254.3 224.3c1.8 1.5 3 3 3.5 4.8"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeLinecap: "round",
    d: "M257.9 219.5a10 10 0 01-3.4 4.6m-9.2-17.2l2.2-.6 1.3-1 .8-1.1.7-1.8.3-1.5"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M241 199.3c-.7.2-1.6.4-2.5.8a9 9 0 00-3.5 3 17 17 0 00-2.2 12.7 15.8 15.8 0 002.3 5.6l1 1.4c1.4 1.3 2.6 2 4.6 1.7"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeLinecap: "round",
    d: "M253 189.8c-.3 1.3-1 2.9-3 2.7"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M245.7 198.5c-2-1.9-6-2.4-10.1.2L234 200a8.8 8.8 0 00-1.4 1.6 17.5 17.5 0 00-2.4 5c-.7 3-.7 5.6-.6 6.3 0 1 .2 1.9.3 2.7.6 2.8 1.4 4.8 2.3 6.2.9 1.5 3 5 7.7 5.4 1.8.1 4.8-.7 5-3"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeLinecap: "round",
    d: "M363.8 157c.3-1.6 2.3-1.9 3-1 1.2 1.6.4 4.2-2 4.9a4 4 0 01-3.8-1.4c-1-1.3-.9-2.8-.5-4 .2-.8.9-1.5 1.7-2.2 2.7-2 7.1-1.6 8.6 2 1.8 4.4-2.2 7.8-6 10.3-4.6 3.2-10 3.8-14 3.7-9.2 0-16.1-4.4-20.7-7-1-.5-2.1-.4-2.7.3a2 2 0 00.3 2.7"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeLinecap: "round",
    d: "M365.6 155.5c1 0 1.2.4 1.5.8 1.2 1.5.3 4.1-2 4.9m17.8 51.5c-3.5 3.8-.2 10.3 2.4 11.8.9.7 1.3.3 2 .7"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M383.1 205.4c-1.1.8-1.5 1.7-1.6 3.3a5.3 5.3 0 001.4 4 14 14 0 009.3 3.7c2 0 4-.4 6-1.7a9 9 0 003.8-5.4l-18.9-3.9zm-1.9 65.7l-.2 2.5a18.9 18.9 0 01-2 7 18.7 18.7 0 01-4.2 5.6 19.6 19.6 0 01-5.9 4 24.6 24.6 0 01-6.5 2.3 43.8 43.8 0 01-13.2.6c-2.7-.2-4.1-.5-6.8-.8-2.2-.1-3.4-.3-5.6-.3a28.3 28.3 0 00-10.9 1.9c-2.7 1-5.7 3-6.4 3.8-.6-.9-3.7-2.8-6.3-3.8a22 22 0 00-5.2-1.5c-2.2-.4-3.5-.4-5.8-.4-2.2 0-3.4.2-5.6.4-2.6.2-4 .6-6.7.7-2.5.2-3.9.3-6.3.2a33 33 0 01-7-.8 24.6 24.6 0 01-6.5-2.2 19.6 19.6 0 01-5.8-4.1 18.7 18.7 0 01-4.2-5.7 19 19 0 01-2-6.9c-.2-1-.2-2.5-.2-2.5V169.3h123.2v101.8h.1z"
  })), /*#__PURE__*/_react.default.createElement("g", {
    fill: "#C7B37F",
    fillRule: "nonzero"
  }, /*#__PURE__*/_react.default.createElement("path", {
    stroke: "#C7B37F",
    strokeWidth: "0.3",
    d: "M248 285.6a2.5 2.5 0 115 0 2.5 2.5 0 01-5 0zM232.5 268c0-1.3.8-2.3 1.8-2.3s1.7 1 1.7 2.3c0 1.2-.8 2.2-1.7 2.2-1 0-1.8-1-1.8-2.2z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M241.3 223.6c0-1 .8-1.8 1.7-1.8 1 0 1.7.8 1.7 1.8s-.7 1.8-1.7 1.8-1.7-.8-1.7-1.8zM272 158c0-1 .5-2 1.4-2 .9-.1 1.7.6 1.8 1.6 0 1-.5 2-1.4 2-.9.1-1.6-.6-1.8-1.6z"
  })), /*#__PURE__*/_react.default.createElement("path", {
    stroke: "#C7B37F",
    strokeLinecap: "round",
    strokeWidth: "0.6",
    d: "M239.3 234c-.4.1-.6.2-.8.5-.3.3-.4.4-.6.9l-.2 1.2m4.7 26.7l1-1 .6-1 .5-1 .7-1.3m-1.3 14l-1.5.7-1.1.6a17.4 17.4 0 00-1.3.8l-1.2 1m15-37.9l-.8-.8-1-.8-.9-.8m3.1-10.8l-1.2.5a5.1 5.1 0 01-1.5.3m-14.1-17.4c.2.6.2 1 .5 1.5.2.7.5 1.1.9 1.7a8.3 8.3 0 002.6 2.7l1.5.8m-1-5.8l1.3.6a7.4 7.4 0 003 .6l1.8-.1m7.2-40.7l-2-1.2c-.9-.5-1.3-.9-2-1.5a9.3 9.3 0 01-1.1-1.3l-.8-1.3m7.5-4.6l.6 1.7a7.8 7.8 0 001.4 2c1 1 1.7 1.3 2.8 2.2m1.4-6c.3.7.3 1 .7 1.6.2.5.4.8.8 1.2l1.3 1.3c.7.6 1.2.7 2 1.1"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#703D29",
    fillRule: "nonzero",
    stroke: "#703D29",
    strokeWidth: "0.2",
    d: "M333.3 151.6c0-1.7-1.7-1.8-2.4-1.8-1.8 0-2.3 1.1-4.6 2.3a11.9 11.9 0 01-6.7 2 12 12 0 01-6.7-2c-2.3-1.2-2.7-2.3-4.6-2.3a2.3 2.3 0 00-2.2 2.4v.9l.3.2c0-.8.1-1.2.5-1.7a2.2 2.2 0 011.6-.8c1.8 0 2.5 1.2 4.8 2.4 3 1.6 4.2 1.9 6.7 2a12 12 0 006.8-2c2.3-1.2 3-2.5 4.8-2.5.6 0 1 .4 1.3 1v.9l.2.1c0-.3.2-.4.2-1v-.1z"
  }), /*#__PURE__*/_react.default.createElement("g", {
    fill: "#703D29",
    fillRule: "nonzero"
  }, /*#__PURE__*/_react.default.createElement("path", {
    d: "M264.4 294c.5-.5.9-.3 1-.6 0-.2 0-.2-.3-.3l-.9-.2-.8-.4c-.1 0-.4-.2-.5 0-.1.4 1 .4.6 1.4a3.7 3.7 0 01-.8 1.2l-2.6 3-.2.1v-4.3l.1-1.8c.2-.4.8 0 .9-.4 0-.1 0-.2-.3-.3-.2 0-.5 0-1.1-.3l-1-.5c-.2 0-.5-.2-.6 0l.1.3c.4.2.5.4.5 1v7.4c0 .5.1.6.2.7.1 0 .2 0 .4-.3l5.3-5.7z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M267.5 295.2c.3-1.1 1-.4 1-.8.1-.2 0-.2-.2-.3l-1.3-.4c-.4 0-.8-.3-1.2-.4 0 0-.3-.1-.4 0-.1.5 1.1.5.8 1.5l-1.7 5.5c-.3 1-1 .6-1.1 1v.1l1.2.4 1.6.5h.3c.2-.4-1.2-.3-.7-1.7l1.7-5.4zm3.7 1c.2-.6.5-.5.9-.4 1 .3 1.4 1.3 1 2.5-.2.6-.4 1.2-2 .8-.3-.1-.7-.2-.6-.5l.7-2.3v-.1zm-2.8 5c-.5 1.4-1.2.8-1.3 1.2 0 .2.2.2.3.3l1.6.4.8.3h.4c.1-.5-1-.3-.7-1.5l.6-2c.1-.4.1-.5.6-.3.6.1.7.3.8.8l.3 2c.2.9.3 1.7 1 2 .5 0 1.2 0 1.4-.4l-.2-.2h-.3s-.3 0-.3-.3l-.7-3.6c0-.2.4-.2.8-.3a2 2 0 001-1.3c.1-.5.4-2.2-1.8-2.9l-2.1-.5-1.2-.4h-.3c-.1.5 1.1.4.7 1.7l-1.5 5h.1zm8.4 2.5c-.4 1.4-1.4.5-1.5 1 0 .2.1.3.3.3l1.5.3 1.4.4c.3 0 .5.2.6-.1 0-.3-1.3-.3-1-1.8l1.3-5.2c0-.6.2-.6.6-.5l1 .2c1.1.3.5 1.5 1 1.6.2 0 .2-.4.2-.6l.1-1v-.4l-3.3-.7-3.2-.8c-.1 0-.2 0-.2.2l-.5 1.5c-.1.1-.2.4 0 .4.5.1.5-1.5 1.7-1.2l.9.2c.4.1.5.2.4.8l-1.3 5.4zm12.7-3.3c.4-.6.8-.5.9-.7 0-.2-.2-.2-.4-.3h-.9l-.9-.3c-.1 0-.4-.1-.4.1-.1.4 1 .2.8 1.3 0 .2-.1.6-.6 1.3l-2 3.3-.3.2v-.2l-.7-4a5.4 5.4 0 01-.1-1.8c0-.5.7-.2.7-.5 0-.2 0-.2-.4-.3l-1.1-.1c-.4 0-.7-.2-1-.3-.2 0-.5-.1-.6.1l.1.2c.5.2.6.4.7.9l1.3 7.3c.1.5.2.7.3.7.1 0 .2 0 .4-.3l4.2-6.6zm.6 6.8c0 .3 0 .3.2.5.6.2 1 .6 1.7.7 1.4.2 2.6-.7 2.8-2.2.3-1.5-.3-2.1-1.4-2.9-1.3-.9-1.8-1.1-1.7-2 .1-.7.7-1 1.4-1 1.8.3 1.6 2.6 1.8 2.6.3 0 .3-.1.3-.4l.2-1.6v-.4h-.6c-.4 0-.7-.5-1.6-.7-1.2-.2-2.3.7-2.5 2-.2 1.2.4 1.8 1.2 2.4 1.6 1.1 2.2 1.4 2 2.4-.1 1-.9 1.4-1.7 1.3-1.2-.2-1.6-1.4-1.8-2.6 0-.2 0-.3-.2-.3s-.2.3-.2.5v1.7h.1zm15.8-4.5c.3-.7.8-.6.8-.9 0-.2-.1-.1-.4-.2h-.9l-.9-.1c-.1 0-.4 0-.4.2 0 .4 1 0 1 1.1 0 .2-.1.6-.5 1.4l-1.8 3.5-.1.3-.1-.3-1.1-4a5.4 5.4 0 01-.3-1.6c0-.5.7-.3.7-.6 0-.2 0-.2-.4-.2h-1.2l-1-.2c-.2 0-.5-.1-.6.1l.2.2c.4.2.6.3.7.8l2.1 7.1.4.7c.1 0 .2 0 .3-.4l3.5-7v.1z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M307.6 308.5c0 1.2-1 1-1 1.5 0 .2.1.1.3.1h2.2l.4-.1c0-.6-1.4.2-1.4-2v-4.2l.1-.1.2.1 5.1 6.3.3.1.2-.3v-6.7c0-1.3 1-1 1-1.3 0 0 0-.2-.3-.2h-2.3c-.2 0-.2.1-.2.2 0 .4 1.3.2 1.3 1.3v4l-.1.4-.4-.3-4.2-5.3c-.2-.3-.1-.3-.4-.3h-1.8l-.2.1c0 .6 1.2-.2 1.2 2.1v4.6zM318 303c0-1.1.8-.7.8-1.1 0-.1 0-.2-.4-.2h-2.6s-.3 0-.3.2c0 .4 1.1 0 1.1 1.2v5.7c0 1.1-.8.8-.8 1.2 0 0 0 .2.2.2h2.8c.2 0 .3 0 .3-.2 0-.4-1.2.2-1.2-1.3l.1-5.7zm4.5 5.5c0 1.5-1.2 1-1.2 1.4 0 .2.2.2.4.2h3c.3 0 .5 0 .5-.3s-1.4 0-1.4-1.4V303c0-.6 0-.6.5-.6h1c1.2-.1.8 1.2 1.3 1.2.2 0 .1-.4.1-.6l-.1-1c0-.2 0-.4-.2-.4l-3.3.1h-3.3l-.2.3-.1 1.6.1.4c.5 0 .2-1.6 1.4-1.6h.9c.4 0 .5 0 .6.6v5.6-.1zm6.3-2.2h-.4l.1-.5.7-2.2v-.2l.2.1 1 2.1.2.4c0 .2-.2.2-.4.2h-1.4v.1zm1.8.5c.3 0 .3 0 .8 1l.2.8c0 .7-.7.6-.7 1 0 .1.2.1.4 0h1.2l1.3-.1c.3 0 .4 0 .4-.2 0-.4-.6 0-1-.7l-3.4-7-.3-.4c-.2 0-.2.2-.3.4L327 309c-.2.7-.8.7-.7 1h2.3c.2-.1.5 0 .5-.3s-1.2 0-1.3-.9l.2-1c.2-.8.4-.8.6-.8l2.1-.2h-.1zm8.3-5c-.1-.8 0-.8 1.2-1 2-.2 1.4 1.3 2 1.2.2 0 0-.4 0-.6l-.1-1.1c0-.1-.1-.2-.3-.2-1 0-1.7.2-2.4.3l-2.8.4c-.2 0-.3 0-.3.2.1.5 1.3 0 1.4 1l.7 5.5c.2 1.5-.7 1-.6 1.5 0 0 0 .1.2 0l1.4-.1 1.2-.1c.3 0 .5 0 .5-.3s-1.2.1-1.4-1.2l-.2-1.7c-.1-.7-.1-.9.3-1h.8c1.1-.2 1 1.1 1.3 1 .3 0 .2-.4.1-.5l-.3-2.1c0-.3-.2-.3-.2-.3-.3 0-.1 1.1-1 1.2l-.7.1c-.5.1-.5 0-.6-.5l-.2-1.7zm4 2.8c.4 2.3 2.1 3.7 4.2 3.3 3.4-.7 3.5-3.6 3.2-5.3-.5-2.5-2.3-3.7-4.4-3.3-2.5.5-3.5 2.7-3 5.3zm1.1-1c-.3-1.6 0-3.4 1.7-3.7 1.4-.3 3 .8 3.4 3.4.3 2 0 3.6-1.8 4-1.9.4-3-2-3.3-3.6v-.1zm8.3-4.1c-.1-.7.2-.8.6-.9 1-.2 1.8.5 2.1 1.6.2.7.3 1.4-1.3 1.8-.3 0-.7.1-.8-.2l-.5-2.3h-.1zm0 5.7c.4 1.4-.5 1.3-.5 1.6.1.3.3.2.4.1.6 0 1-.3 1.6-.4l1-.2c.2 0 .2-.1.2-.2 0-.4-1 .3-1.3-1l-.5-2c0-.4-.2-.4.4-.5.5-.2.7-.1 1.1.3l1.3 1.6c.5.6 1 1.3 1.8 1.1.5-.1 1-.5 1-.9l-.2-.1-.3.1s-.3.1-.4 0l-2.4-2.9.5-.6c.2-.4.4-.9.2-1.6-.1-.5-.7-2.1-3-1.6l-2.1.6-1.2.2c-.2 0-.3.1-.2.2 0 .5 1.1-.2 1.4 1l1.2 5.2zm8.7-2c.3 1.4-1 1.2-.9 1.6 0 .3.3.2.5.2l1.4-.5 1.5-.3c.3 0 .5 0 .4-.4 0-.3-1.3.4-1.7-1l-1.3-5.3c-.2-.5 0-.6.3-.7l1-.2c1.1-.4 1.1 1 1.5.9.3 0 0-.5 0-.7l-.4-1s0-.3-.2-.2l-3.2.9-3.2.7v.3l.1 1.6c0 .2 0 .4.3.4.5-.1-.3-1.6 1-1.9l.8-.2c.4-.1.6 0 .7.5l1.4 5.3zm5.5-7.3c-.3-1 .6-.9.4-1.3h-.3l-1.4.4-1.2.3s-.3 0-.3.2c.1.4 1.2-.2 1.5.8l1.6 5.6c.2 1-.6 1-.5 1.3 0 .1 0 .2.2.1l1.1-.3 1.6-.4c.3 0 .3-.1.3-.3-.1-.3-1.1.5-1.5-.9l-1.5-5.5zm2.3 2.7c.7 2.3 2.6 3.4 4.7 2.7 3.2-1.1 3-4.1 2.4-5.7-.8-2.4-2.8-3.3-4.8-2.7-2.4.9-3.2 3.2-2.3 5.7zm1-1c-.6-1.7-.6-3.5 1.1-4 1.3-.5 3 .4 3.9 2.9.6 1.8.5 3.6-1.2 4.2-1.8.6-3.2-1.5-3.8-3.2v.1zm7.6-5.5c-.2-.7 0-.8.4-1 1-.3 2 .3 2.4 1.4.2.6.4 1.3-1.1 1.9-.3 0-.7.2-.8 0l-.9-2.3zm.8 5.6c.6 1.4-.4 1.4-.2 1.7 0 .3.2.1.4.1l1.5-.7.9-.2c.2-.1.2-.2.2-.3-.2-.4-1 .4-1.4-.8l-.8-1.9c-.2-.4-.2-.5.3-.7.5-.2.7-.1 1.1.3l1.6 1.4c.5.5 1.1 1.1 2 .8.3-.2.9-.7.7-1l-.2-.1-.2.2h-.5l-2.8-2.5.4-.7a2 2 0 000-1.6c-.1-.6-1-2-3.1-1.2l-2 .9-1.2.4-.2.2c.2.4 1.1-.4 1.6.8l2 5-.1-.1z"
  })), /*#__PURE__*/_react.default.createElement("g", {
    fillRule: "nonzero"
  }, /*#__PURE__*/_react.default.createElement("path", {
    fill: "#D52B1E",
    d: "M264.128 175.552h52.544v52.48h-52.544z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#FFF",
    d: "M288.768 216.832s0 1.92-.512 3.392c-.64 1.728-.64 1.728-1.216 2.56a8.448 8.448 0 01-2.432 2.56c-1.28.768-2.56 1.152-3.84 1.024-3.456-.256-5.12-4.096-5.888-7.168-.832-3.264-3.2-5.12-4.8-3.84-.896.64-.896 1.792-.192 2.944a5.76 5.76 0 002.624 1.792l-1.856 2.368s-4.032-.512-4.8-4.736c-.32-1.6.448-4.544 3.136-5.44 3.392-1.152 5.504 1.28 6.592 3.328 1.408 2.816 2.048 7.936 6.016 7.168 2.176-.448 3.2-3.584 3.2-5.056l1.536-1.664 2.368.768h.064zm3.264 0s0 1.92.512 3.392c.64 1.728.64 1.728 1.216 2.56a8.448 8.448 0 002.432 2.56c1.28.768 2.56 1.152 3.84 1.024 3.456-.256 5.12-4.096 5.888-7.168.832-3.264 3.2-5.12 4.8-3.84.896.64.896 1.792.192 2.944a5.76 5.76 0 01-2.624 1.792l1.856 2.368s4.032-.512 4.8-4.736c.32-1.6-.448-4.544-3.136-5.44-3.392-1.152-5.504 1.28-6.592 3.328-1.408 2.816-2.048 7.936-6.016 7.168-2.176-.448-3.2-3.584-3.2-5.056l-1.536-1.664-2.368.768h-.064z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#FEDF00",
    d: "M295.104 194.56l6.912-7.488s1.024-.832 1.024-2.176l-1.408.256-.32-.768-.064-.704 1.92-.448v-.832l.192-.832-2.048.128.192-.896.32-.64 1.216-.256h1.216c1.152-2.176 5.888-4.096 9.216-.64 2.432 2.56 1.92 7.168-1.28 8.448a4.032 4.032 0 01-4.352-.704l1.28-2.56c1.728 1.088 3.2-.192 3.072-1.536-.128-1.728-1.28-2.752-2.752-2.88-1.472-.128-2.56.64-3.2 1.92-.384.832-.192 1.408-.32 2.304-.128.96 0 1.472-.32 2.432a5.632 5.632 0 01-1.536 2.304l-7.04 7.68-27.52 29.696-2.048-1.92 27.648-29.888z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#FFF",
    d: "M274.88 197.12s1.728 8.576 7.616 21.44c3.008-1.088 4.736-1.792 7.936-1.792 3.136 0 4.864.64 7.872 1.792a109.44 109.44 0 007.616-21.44l-15.488-19.84-15.616 19.84h.064z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#FEDF00",
    d: "M291.904 183.936l10.752 13.888s-1.408 6.72-5.76 16.832c-1.728-.384-3.2-.704-4.992-.832v-29.888zm-3.008 0l-10.752 13.888s1.408 6.72 5.76 16.832c1.728-.384 3.2-.704 4.992-.832v-29.888z"
  })), /*#__PURE__*/_react.default.createElement("g", {
    fillRule: "nonzero"
  }, /*#__PURE__*/_react.default.createElement("path", {
    fill: "#FEDF00",
    d: "M322.3 175.5h52.6V228h-52.6z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#D52B1E",
    d: "M329.7 175.5h7.8V228h-7.8v-52.5zm15 0h7.8V228h-7.8v-52.5zm15 0h7.9V228h-7.9v-52.5z"
  })), /*#__PURE__*/_react.default.createElement("g", {
    fillRule: "nonzero"
  }, /*#__PURE__*/_react.default.createElement("path", {
    fill: "#FEDF00",
    d: "M264.3 273.5c.1 1 .5 2.6 1.4 4.3 1 1.5.6 1.4 2.7 3.8a15.3 15.3 0 004 2.9 32.7 32.7 0 0015 2.6c2.7-.1 4.8-.4 6.6-.7a71 71 0 0111-.6c1.5 0 3 .3 4.7.6 3.5.7 7 2 7 2v-54.7h-52.6V271l.2 2.4v.1z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#D52B1E",
    stroke: "#D52B1E",
    strokeWidth: "0.3",
    d: "M270.4 283.1l2.5 1.5 3.4 1.2v-52.2h-5.9v49.5zm29.2 2.4v-51.9h-5.8v52.8l5.8-.7v-.2zm11.7-51.9h-5.8v52.1c1.9.2 3.8.6 5.8 1v-53.1zm-23.4 0V287s-3.8.2-5.8 0v-53.4h5.8z"
  })), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#FEDF00",
    fillRule: "nonzero",
    d: "M374.72 273.536a13.312 13.312 0 01-1.408 4.224c-.96 1.472-.64 1.472-2.752 3.84a16.832 16.832 0 01-8.32 4.48 33.152 33.152 0 01-10.624 1.024c-2.752-.128-4.8-.448-6.592-.64-2.432-.384-4.288-.576-7.04-.64a40.256 40.256 0 00-3.968 0 53.312 53.312 0 00-11.712 2.688V233.6h52.608v37.44l-.192 2.432v.064z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#D52B1E",
    fillRule: "nonzero",
    d: "M335.744 238.08l-.384.128-.512.512c-.256.256-.448.32-.768.512l-.384.32c-.192.192 0 .384-.192.64-.064.256-.192.384-.384.64-.256.256-.448.32-.64.64l-.768.64-.192.064h-.384c-.256.128-.32.384-.512.512l.192.384.512.896c.128.192.128.448.32.512.32.128.576.128.832.064.512.128.832.128 1.28.32l.96.512c.32.192.512.256.832.32h1.152v.192l1.28.64a1.088 1.088 0 00-.064.256c-.064.192-.128.448-.064.512.384 1.216.768 1.92.96 2.048.384.128.512.576.704.96l-.192.192c-.384.384-.768.64-1.088 1.152-.448.768-.768.768-.192 1.792l.96 1.536c.256.448.384.768.512 1.28.128.448.192.768.192 1.28l.64.192.448-.384.384-.768v-.64c-.128-.064-.192-.256-.128-.448 0-.256.32-.192.448-.384.192-.32-.256-.512-.448-.704-.384-.448-.896-.576-1.024-1.216 0-.128 0-.256.256-.448l1.28-1.152a.994.994 0 00.64.064l.832.256c.384.128.576 0 .768 0h.256l.064.384c.064.64-.064 1.92.128 2.24l.192.384.128.384v1.28l-.128 1.088c0 .256-.128.448-.32.64-.128.256-.384.256-.64.448v.64l.704.32.832.192.448-.192.064-.384.32-.32c.256-.128.512 0 .576-.064.128-.192 0-.256 0-.512 0-.384-.128-.64-.192-1.024a7.552 7.552 0 01-.064-1.792c0-.384 0-.64.128-.96.064-.64.256-.896.384-1.408.192-.64.192-1.024.256-1.6a15.62 15.62 0 006.464-.384c.512.448 1.088.768 1.728 1.024v.64c0 .192 0 .256.128.448l.192.192c.192 0 .32 0 .448-.128s.128-.256.128-.448v-.448h1.152v.704c.064.192.192.256.32.256a.448.448 0 00.384 0c.192-.128.128-.384.192-.64v-.448l.64-.256a3.26 3.26 0 010 .576l-.192.576c-.128.384-.32.512-.512.896-.256.384-.32.64-.64.96l-.384.448-.384.576-.576.64c-.448.384-.768.128-1.28.576l-.192.64.896.384.832.128.256-.128c0-.192 0-.384.192-.512.128-.192.256-.192.448-.256.256 0 .512 0 .64-.128.256-.192.256-.64.448-.96a8.128 8.128 0 011.92-2.496l1.088-.896c.128-.256.32-.32.32-.64l-.128-.384-.128-.64c.96.448.64.448.768.896.192.384 0 .64.064 1.088.064.512.32.704.32 1.216.064.576-.064.896-.192 1.472-.064.512-.064.832-.32 1.28a2.432 2.432 0 01-.704.96l-.384.32-.064.64.704.256 1.024.256.256-.192c.128-.448 0-1.088.256-1.088.256-.064.448 0 .512-.192v-.448l.448-2.88.256-1.216.256-1.088c.448-1.28-.128-1.472-.64-2.304-.32-.448-.448-.64-.448-.96v-1.856c-.02-.597-.02-1.195 0-1.792l.256-.128c.768-.448 1.088-.576 1.536-1.6.136-.301.202-.63.192-.96v-.64l-.256-.64c-.1-.19-.23-.363-.384-.512-.448-.64-1.088-.704-1.728-.96-.96-.32-1.6-.256-2.56-.32-1.152-.128-1.728-.128-2.816 0-1.28 0-1.984.256-3.264.448l-3.136.256c-1.472 0-2.816-.32-3.712-.256-1.536.128-1.6.512-3.968.704-.81.066-1.62.108-2.432.128l-1.408-.448c.576-.192.704-.32.96-.64.192-.256.128-.448.384-.704l.448-.64a1.408 1.408 0 00-.576-.256h-.64a1.92 1.92 0 00-.768.192l-.512.384-1.408-.768c-.6-.305-1.25-.5-1.92-.576v.128z"
  }), /*#__PURE__*/_react.default.createElement("g", {
    stroke: "#FEDF00",
    strokeLinecap: "round"
  }, /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.64",
    d: "M364.032 246.08l-.512.192c-.576.256-1.024.256-1.664.32-1.664.128-2.752-.704-4.48-.576-.896.064-1.28.768-2.24 1.024a5.952 5.952 0 01-1.088.128l.32-.64s-.768.192-1.28.192a4.8 4.8 0 01-1.024-.128l.64-.64-.832-.128a2.56 2.56 0 01-.64-.448 13.12 13.12 0 001.088-.192c.96-.256 1.28-.768 2.496-.896.704 0 1.92 0 4.864.512 1.92.32 2.816.128 3.52-.192.512-.192.64-.64.704-1.152.064-.512-.256-.896-.512-1.152-.064 0-.32-.192-.704-.256"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#FCD900",
    fillRule: "nonzero",
    strokeWidth: "0.5",
    d: "M335.872 240.384c-.32 0-.576 0-.832.192-.32.192-.384.448-.64.704.32.064.512.256.768.192.256 0 .32-.128.512-.32.192-.256.256-.448.256-.768h-.064 0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.64",
    d: "M343.04 248.832c.168.51.382 1.002.64 1.472.128.512 0 .768.128 1.28v1.024m4.352-4.48l-.192.832-.64 2.24v.448m-7.04-2.56c.576.128.384 2.112 1.216 2.56m16.96 1.024l.256-.192a5.248 5.248 0 001.728-1.152"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.64",
    d: "M353.536 251.52c2.24-.576 3.776-1.664 4.864-1.856m-2.56-.96h.512c.96-.192 1.088.384 1.728.768 1.216.64 1.344 1.472 2.752 2.176l.256.064.512.256"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#FCD900",
    fillRule: "nonzero",
    strokeWidth: "0.5",
    d: "M331.328 242.88h.448l.512-.128c.192 0 .32 0 .448.128.128 0 .128.064.192.192 0 .128.128.192.064.32 0 .128-.192.256-.384.256-.128 0-.256 0-.32-.192a.32.32 0 010-.256.64.64 0 01-.576 0 .64.64 0 01-.384-.32z"
  })), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#0065BD",
    fillRule: "nonzero",
    d: "M336.064 249.088l-1.28-.576c.256-.128.448-.128.64-.32.192-.256.192-.512.32-.832.128-.32.128-.64.448-.896.192-.128.512-.128.704-.064.256 0 .512.256.576.448 0 .384-.128.64-.192.96 0 .384-.192.576-.128.896 0 .256.128.384.256.64l-1.28-.256h-.064zm-.64.64a.384.384 0 11.448.32.384.384 0 01-.448-.384v.064zm-1.088-10.624h-.128c-.256-.256-.256-.512-.384-.768a2.56 2.56 0 01-.192-.768v-1.28c0-.192 0-.384-.128-.576 0-.128-.256-.192-.192-.256 0-.064.192 0 .256 0 .256 0 .384.064.64.256.192.192.32.384.384.64l.256.96.192.512.32.384-.448.512-.576.384zm2.304 6.784l1.408.64a5.888 5.888 0 002.24-2.432c.576-1.152.64-1.728.896-2.816l-1.152-.32h-.256c-.32 1.152-.448 1.728-1.024 2.688-.512.832-1.088 1.472-1.664 1.92l-.448.32zm3.2 11.648l.512-.832.896-.704h.256a5.568 5.568 0 01-.32 1.792l-.256.64-.32.32c-.32-.512-.832-.832-.832-1.28l.064.064zm21.12 1.152l.896.384.96.576v.32l-.96.128a5.376 5.376 0 01-.832 0h-.64l-.384-.256c.32-.448.512-1.024.896-1.152h.064zm-6.272-1.28l.896.32.96.64c0 .064.064.192 0 .256a5.76 5.76 0 01-1.728.192l-.64-.064-.448-.192c.384-.448.576-1.088.96-1.152zm-11.136 1.344l.96.32.96.64v.32a5.76 5.76 0 01-1.792.128h-.64l-.384-.256c.32-.448.512-1.024.896-1.152zm-5.76-19.072c-.384-.192-.64-.64-.384-1.024.064-.128.256-.128.384-.256.128-.192.064-.32 0-.512l-.064-.64-.128-.64c0-.384 0-.64.256-1.024.128-.192.448-.384.512-.384.128.064 0 .32 0 .512 0 .32.064.448.192.768l.448.832c.128.384.256.512.256.896 0 .32 0 .448-.128.768a1.28 1.28 0 01-.384.512 1.28 1.28 0 01-.512.256.704.704 0 01-.384 0l-.064-.064z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#D52B1E",
    fillRule: "nonzero",
    d: "M335.744 261.504l-.384.128-.512.512c-.256.256-.448.32-.768.512l-.384.32c-.192.192 0 .384-.192.64-.064.256-.192.384-.384.64-.256.256-.448.32-.64.64l-.768.64-.192.064h-.384c-.256.128-.32.384-.512.512l.192.384.512.896c.128.192.128.448.32.512.32.128.576.128.832.064.512.128.832.128 1.28.32l.96.512c.32.192.512.256.832.32h1.152v.192l1.28.64a1.088 1.088 0 00-.064.256c-.064.192-.128.448-.064.512.384 1.216.768 1.92.96 2.048.384.128.512.576.704.96l-.192.192c-.384.384-.768.64-1.088 1.152-.448.768-.768.768-.192 1.792l.96 1.536c.256.448.384.768.512 1.28.128.448.192.768.192 1.28l.64.192.448-.384.384-.768v-.64c-.128-.064-.192-.256-.128-.448 0-.256.32-.192.448-.384.192-.32-.256-.512-.448-.704-.384-.448-.896-.576-1.024-1.216 0-.128 0-.256.256-.448l1.28-1.152a.994.994 0 00.64.064l.832.256c.384.128.576 0 .768 0h.256l.064.384c.064.64-.064 1.92.128 2.24l.192.384.128.384V280l-.128 1.088c0 .256-.128.448-.32.64-.128.256-.384.256-.64.448v.64l.704.32.832.192.448-.192.064-.384.32-.32c.256-.128.512 0 .576-.064.128-.192 0-.256 0-.512 0-.384-.128-.64-.192-1.024a7.552 7.552 0 01-.064-1.792c0-.384 0-.64.128-.96.064-.64.256-.896.384-1.408.192-.64.192-1.024.256-1.6a15.62 15.62 0 006.464-.384c.512.448 1.088.768 1.728 1.024v.64c0 .192 0 .256.128.448l.192.192c.192 0 .32 0 .448-.128s.128-.256.128-.448v-.448h1.152v.704c.064.192.192.256.32.256a.448.448 0 00.384 0c.192-.128.128-.384.192-.64v-.448l.64-.256a3.26 3.26 0 010 .576l-.192.576c-.128.384-.32.512-.512.896-.256.384-.32.64-.64.96l-.384.448-.384.576-.576.64c-.448.384-.768.128-1.28.576l-.192.64.896.384.832.128.256-.128c0-.192 0-.384.192-.512.128-.192.256-.192.448-.256.256 0 .512 0 .64-.128.256-.192.256-.64.448-.96a8.128 8.128 0 011.92-2.496l1.088-.896c.128-.256.32-.32.32-.64l-.128-.384-.128-.64c.96.448.64.448.768.896.192.384 0 .64.064 1.088.064.512.32.704.32 1.216.064.576-.064.896-.192 1.472-.064.512-.064.832-.32 1.28a2.432 2.432 0 01-.704.96l-.384.32-.064.64.704.256 1.024.256.256-.192c.128-.448 0-1.088.256-1.088.256-.064.448 0 .512-.192v-.448l.448-2.88.256-1.216.256-1.088c.448-1.28-.128-1.472-.64-2.304-.32-.448-.448-.64-.448-.96v-1.856c-.02-.597-.02-1.195 0-1.792l.256-.128c.768-.448 1.088-.576 1.536-1.6.136-.301.202-.63.192-.96v-.64l-.256-.64c-.1-.19-.23-.363-.384-.512-.448-.64-1.088-.704-1.728-.96-.96-.32-1.6-.256-2.56-.32-1.152-.128-1.728-.128-2.816 0-1.28 0-1.984.256-3.264.448l-3.136.256c-1.472 0-2.816-.32-3.712-.256-1.536.128-1.6.512-3.968.704-.81.066-1.62.108-2.432.128l-1.408-.448c.576-.192.704-.32.96-.64.192-.256.128-.448.384-.704l.448-.64a1.408 1.408 0 00-.576-.256h-.64a1.92 1.92 0 00-.768.192l-.512.384-1.408-.768c-.6-.305-1.25-.5-1.92-.576v.128z"
  }), /*#__PURE__*/_react.default.createElement("g", {
    stroke: "#FEDF00",
    strokeLinecap: "round"
  }, /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.64",
    d: "M364.032 269.504l-.512.192c-.576.256-1.024.256-1.664.32-1.664.128-2.752-.704-4.48-.576-.896.064-1.28.768-2.24 1.024a5.952 5.952 0 01-1.088.128l.32-.64s-.768.192-1.28.192a4.8 4.8 0 01-1.024-.128l.64-.64-.832-.128a2.56 2.56 0 01-.64-.448 13.12 13.12 0 001.088-.192c.96-.256 1.28-.768 2.496-.896.704 0 1.92 0 4.864.512 1.92.32 2.816.128 3.52-.192.512-.192.64-.64.704-1.152.064-.512-.256-.896-.512-1.152-.064 0-.32-.192-.704-.256"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#FCD900",
    fillRule: "nonzero",
    strokeWidth: "0.5",
    d: "M335.872 263.808c-.32 0-.576 0-.832.192-.32.192-.384.448-.64.704.32.064.512.256.768.192.256 0 .32-.128.512-.32.192-.256.256-.448.256-.768h-.064 0z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.64",
    d: "M343.04 272.256c.168.51.382 1.002.64 1.472.128.512 0 .768.128 1.28v1.024m4.352-4.48l-.192.832-.64 2.24v.448m-7.04-2.56c.576.128.384 2.112 1.216 2.56m16.96 1.024l.256-.192a5.248 5.248 0 001.728-1.152"
  }), /*#__PURE__*/_react.default.createElement("path", {
    strokeWidth: "0.64",
    d: "M353.536 274.944c2.24-.576 3.776-1.664 4.864-1.856m-2.56-.96h.512c.96-.192 1.088.384 1.728.768 1.216.64 1.344 1.472 2.752 2.176l.256.064.512.256"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#FCD900",
    fillRule: "nonzero",
    strokeWidth: "0.5",
    d: "M331.328 266.304h.448l.512-.128c.192 0 .32 0 .448.128.128 0 .128.064.192.192 0 .128.128.192.064.32 0 .128-.192.256-.384.256-.128 0-.256 0-.32-.192a.32.32 0 010-.256.64.64 0 01-.576 0 .64.64 0 01-.384-.32z"
  })), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#0065BD",
    fillRule: "nonzero",
    d: "M336.064 272.512l-1.28-.576c.256-.128.448-.128.64-.32.192-.256.192-.512.32-.832.128-.32.128-.64.448-.896.192-.128.512-.128.704-.064.256 0 .512.256.576.448 0 .384-.128.64-.192.96 0 .384-.192.576-.128.896 0 .256.128.384.256.64l-1.28-.256h-.064zm-.64.64a.384.384 0 11.448.32.384.384 0 01-.448-.384v.064zm-1.088-10.624h-.128c-.256-.256-.256-.512-.384-.768a2.56 2.56 0 01-.192-.768v-1.28c0-.192 0-.384-.128-.576 0-.128-.256-.192-.192-.256 0-.064.192 0 .256 0 .256 0 .384.064.64.256.192.192.32.384.384.64l.256.96.192.512.32.384-.448.512-.576.384zm2.304 6.784l1.408.64a5.888 5.888 0 002.24-2.432c.576-1.152.64-1.728.896-2.816l-1.152-.32h-.256c-.32 1.152-.448 1.728-1.024 2.688-.512.832-1.088 1.472-1.664 1.92l-.448.32zm3.2 11.648l.512-.832.896-.704h.256a5.568 5.568 0 01-.32 1.792l-.256.64-.32.32c-.32-.512-.832-.832-.832-1.28l.064.064zm21.12 1.152l.896.384.96.576v.32l-.96.128a5.376 5.376 0 01-.832 0h-.64l-.384-.256c.32-.448.512-1.024.896-1.152h.064zm-6.272-1.28l.896.32.96.64c0 .064.064.192 0 .256a5.76 5.76 0 01-1.728.192l-.64-.064-.448-.192c.384-.448.576-1.088.96-1.152zm-11.136 1.344l.96.32.96.64v.32a5.76 5.76 0 01-1.792.128h-.64l-.384-.256c.32-.448.512-1.024.896-1.152zm-5.76-19.072c-.384-.192-.64-.64-.384-1.024.064-.128.256-.128.384-.256.128-.192.064-.32 0-.512l-.064-.64-.128-.64c0-.384 0-.64.256-1.024.128-.192.448-.384.512-.384.128.064 0 .32 0 .512 0 .32.064.448.192.768l.448.832c.128.384.256.512.256.896 0 .32 0 .448-.128.768a1.28 1.28 0 01-.384.512 1.28 1.28 0 01-.512.256.704.704 0 01-.384 0l-.064-.064z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    stroke: "#703D29",
    strokeWidth: "0.5",
    d: "M264.1 175.5h52.6V228h-52.6v-52.5zm58.2 0h52.6V228h-52.6v-52.5zm-58 98c.1 1 .5 2.6 1.4 4.3 1 1.5.6 1.4 2.7 3.8a15.3 15.3 0 004 2.9 32.7 32.7 0 0015 2.6c2.7-.1 4.8-.4 6.6-.7a71 71 0 0111-.6c1.5 0 3 .3 4.7.6 3.5.7 7 2 7 2v-54.7h-52.6V271l.2 2.4v.1zm110.4 0a13 13 0 01-1.4 4.3c-1 1.5-.6 1.4-2.7 3.8a15.4 15.4 0 01-4 2.9c-1.3.7-2.3 1-4.4 1.6a32.6 32.6 0 01-10.6 1c-2.7-.1-4.8-.5-6.5-.7a71 71 0 00-7.2-.6 40.5 40.5 0 00-3.9 0c-1.5 0-3 .3-4.7.6-3.5.7-7 2-7 2v-54.8H375v37.5l-.2 2.4h-.1z"
  })), /*#__PURE__*/_react.default.createElement("rect", {
    width: "640",
    height: "480",
    stroke: "#FFF",
    strokeOpacity: "0.3",
    strokeWidth: "80",
    mask: "url(#b)",
    rx: "48"
  })));
};

var _default = AdSvg;
exports.default = _default;