"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

require("../_global/inject-global-style");

require("./style.css");

var _react = _interopRequireDefault(require("react"));

var _collapse = _interopRequireDefault(require("antd/lib/collapse"));

var _icons = _interopRequireDefault(require("../icons"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

var DownOutlined = _icons.default.DownOutlined;
var Panel = _collapse.default.Panel;

var CustomCollapse = function CustomCollapse(props) {
  return /*#__PURE__*/_react.default.createElement(_collapse.default, _extends({
    expandIcon: function expandIcon(_ref) {
      var showArrow = _ref.showArrow,
          isActive = _ref.isActive;

      if (showArrow) {
        return /*#__PURE__*/_react.default.createElement(DownOutlined, {
          style: {
            transform: "rotate(".concat(isActive ? '0' : '-90', "deg)")
          }
        });
      }
    }
  }, props));
};

CustomCollapse.Panel = Panel;
var _default = CustomCollapse;
exports.default = _default;