"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Bar = void 0;
Object.defineProperty(exports, "Chart", {
  enumerable: true,
  get: function get() {
    return _bizcharts.Chart;
  }
});
exports.ChartCard = void 0;
Object.defineProperty(exports, "ChartTooltip", {
  enumerable: true,
  get: function get() {
    return _bizcharts.Tooltip;
  }
});
exports.Radar = exports.Pie = exports.MiniProgress = exports.MiniBar = exports.MiniArea = exports.Gauge = exports.Field = void 0;
Object.defineProperty(exports, "Schema", {
  enumerable: true,
  get: function get() {
    return _bizcharts.Schema;
  }
});
exports.WaterWave = exports.TimelineChart = exports.TagCloud = void 0;
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function get() {
    return _Charts.default;
  }
});

require("../_global/inject-global-style");

require("ant-design-pro/dist/ant-design-pro.css");

require("./style.css");

require("../trend/style.css");

var _react = _interopRequireDefault(require("react"));

var _Charts = _interopRequireWildcard(require("ant-design-pro/lib/Charts"));

var _bizcharts = require("bizcharts");

var _colors = _interopRequireDefault(require("../colors"));

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

var red = _colors.default.red,
    gray = _colors.default.gray,
    blue = _colors.default.blue,
    green = _colors.default.green,
    yellow = _colors.default.yellow,
    orange = _colors.default.orange,
    purple = _colors.default.purple;

var CustomBar = function CustomBar(props) {
  return /*#__PURE__*/_react.default.createElement(_Charts.Bar, _extends({
    color: gray[7]
  }, props));
};

exports.Bar = CustomBar;

var CustomPie = function CustomPie(props) {
  return /*#__PURE__*/_react.default.createElement(_Charts.Pie, _extends({
    colors: [red.primary, blue.primary, green.primary, yellow.primary, orange.primary, purple.primary]
  }, props));
};

exports.Pie = CustomPie;

var CustomGauge = function CustomGauge(props) {
  return /*#__PURE__*/_react.default.createElement(_Charts.Gauge, props);
};

exports.Gauge = CustomGauge;

var CustomRadar = function CustomRadar(props) {
  return /*#__PURE__*/_react.default.createElement(_Charts.Radar, _extends({}, props, {
    colors: [red.primary, yellow.primary, green.primary, blue.primary, orange.primary, purple.primary]
  }));
};

exports.Radar = CustomRadar;

var CustomMiniBar = function CustomMiniBar(props) {
  return /*#__PURE__*/_react.default.createElement(_Charts.MiniBar, _extends({
    color: gray[7]
  }, props));
};

exports.MiniBar = CustomMiniBar;

var CustomMiniArea = function CustomMiniArea(props) {
  return /*#__PURE__*/_react.default.createElement(_Charts.MiniArea, _extends({
    borderColor: red[4],
    color: red[1],
    line: true
  }, props));
};

exports.MiniArea = CustomMiniArea;

var CustomMiniProgress = function CustomMiniProgress(props) {
  return /*#__PURE__*/_react.default.createElement(_Charts.MiniProgress, _extends({
    color: gray[7],
    strokeWidth: 12
  }, props));
};

exports.MiniProgress = CustomMiniProgress;

var CustomChartCard = function CustomChartCard(_ref) {
  var children = _ref.children,
      rest = _objectWithoutProperties(_ref, ["children"]);

  return /*#__PURE__*/_react.default.createElement(_Charts.ChartCard, rest, children);
};

exports.ChartCard = CustomChartCard;

var CustomField = function CustomField(props) {
  return /*#__PURE__*/_react.default.createElement(_Charts.Field, props);
};

exports.Field = CustomField;

var CustomWaterWave = function CustomWaterWave(props) {
  return /*#__PURE__*/_react.default.createElement(_Charts.WaterWave, props);
};

exports.WaterWave = CustomWaterWave;

var CustomTagCloud = function CustomTagCloud(props) {
  return /*#__PURE__*/_react.default.createElement(_Charts.TagCloud, props);
};

exports.TagCloud = CustomTagCloud;

var CustomTimelineChart = function CustomTimelineChart(props) {
  return /*#__PURE__*/_react.default.createElement(_Charts.TimelineChart, props);
};

exports.TimelineChart = CustomTimelineChart;
_Charts.default.Chart = _bizcharts.Chart;
_Charts.default.Tooltip = _bizcharts.Tooltip;
_Charts.default.Schema = _bizcharts.Schema;
_Charts.default.Bar = CustomBar;
_Charts.default.Pie = CustomPie;
_Charts.default.Gauge = CustomGauge;
_Charts.default.Radar = CustomRadar;
_Charts.default.MiniBar = CustomMiniBar;
_Charts.default.MiniArea = CustomMiniArea;
_Charts.default.MiniProgress = CustomMiniProgress;
_Charts.default.ChartCard = CustomChartCard;
_Charts.default.Field = CustomField;
_Charts.default.WaterWave = CustomWaterWave;
_Charts.default.TagCloud = CustomTagCloud;
_Charts.default.TimelineChart = CustomTimelineChart;