"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

require("../_global/inject-global-style");

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _form = _interopRequireDefault(require("../form"));

var _input = _interopRequireDefault(require("../input"));

var _inputMask = _interopRequireDefault(require("../input-mask"));

var _button = _interopRequireDefault(require("../button"));

var _popover = _interopRequireDefault(require("../popover"));

var _icons = _interopRequireDefault(require("../icons"));

var _row = _interopRequireDefault(require("../row"));

var _col = _interopRequireDefault(require("../col"));

var _colors = _interopRequireDefault(require("../colors"));

var _ExpiryDateInput = _interopRequireDefault(require("./ExpiryDateInput"));

var _SecureCodeInput = _interopRequireDefault(require("./SecureCodeInput"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var QuestionCircleOutlined = _icons.default.QuestionCircleOutlined;
var red = _colors.default.red,
    green = _colors.default.green,
    orange = _colors.default.orange,
    blue = _colors.default.blue,
    purple = _colors.default.purple,
    yellow = _colors.default.yellow,
    gray = _colors.default.gray;

var MasterCardIcon = function MasterCardIcon(_ref) {
  var disabled = _ref.disabled;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, disabled ? /*#__PURE__*/_react.default.createElement("svg", {
    width: "40",
    height: "24",
    viewBox: "0 0 40 24",
    fill: "none"
  }, /*#__PURE__*/_react.default.createElement("path", {
    d: "M25.679 3.94189H14.6562V21.0952H25.679V3.94189Z",
    fill: "#7A7A7A"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M15.791 12.52C15.7897 10.8682 16.1827 9.23787 16.9403 7.75223C17.6979 6.26659 18.8002 4.96461 20.1639 3.94481C18.4749 2.68012 16.4465 1.89369 14.3106 1.67539C12.1747 1.45709 10.0174 1.81573 8.08535 2.71033C6.15325 3.60494 4.52429 4.9994 3.38464 6.73435C2.24499 8.4693 1.64063 10.4747 1.64062 12.5215C1.64062 14.5682 2.24499 16.5736 3.38464 18.3086C4.52429 20.0435 6.15325 21.438 8.08535 22.3326C10.0174 23.2272 12.1747 23.5858 14.3106 23.3675C16.4465 23.1492 18.4749 22.3628 20.1639 21.0981C18.7998 20.078 17.6972 18.7755 16.9396 17.2893C16.182 15.8031 15.7892 14.1722 15.791 12.52Z",
    fill: "#404040"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M37.5944 19.2799V18.9284H37.7534V18.8557H37.375V18.9284H37.5245V19.2799H37.5944ZM38.3291 19.2799V18.8557H38.2146L38.081 19.1587L37.9474 18.8557H37.833V19.2799H37.9156V18.9587L38.0397 19.2345H38.1255L38.2496 18.9587V19.2799H38.3291Z",
    fill: "#F79E1B"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M38.689 12.5202C38.689 14.5671 38.0845 16.5727 36.9446 18.3077C35.8048 20.0427 34.1755 21.4371 32.2432 22.3316C30.3109 23.2261 28.1534 23.5845 26.0173 23.3659C23.8813 23.1473 21.8529 22.3604 20.1641 21.0954C21.5272 20.0746 22.6293 18.7723 23.387 17.2866C24.1448 15.8009 24.5386 14.1706 24.5386 12.5187C24.5386 10.8668 24.1448 9.23653 23.387 7.75081C22.6293 6.26509 21.5272 4.96275 20.1641 3.94205C21.8529 2.67696 23.8813 1.89014 26.0173 1.67153C28.1534 1.45292 30.3109 1.81133 32.2432 2.7058C34.1755 3.60028 35.8048 4.99472 36.9446 6.72972C38.0845 8.46473 38.689 10.4703 38.689 12.5172V12.5202Z",
    fill: "#B8B8B8"
  })) : /*#__PURE__*/_react.default.createElement("svg", {
    width: "40",
    height: "24",
    viewBox: "0 0 40 24",
    fill: "none"
  }, /*#__PURE__*/_react.default.createElement("path", {
    fill: "#FF5F00",
    d: "M25.679 3.94189H14.6562V21.0952H25.679V3.94189Z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#EB001B",
    d: "M15.791 12.5198C15.7897 10.8681 16.1827 9.23775 16.9403 7.75211C17.6979 6.26647 18.8002 4.96449 20.1639 3.94469C18.4749 2.68 16.4465 1.89357 14.3106 1.67527C12.1747 1.45697 10.0174 1.81561 8.08535 2.71021C6.15325 3.60481 4.52429 4.99928 3.38464 6.73423C2.24499 8.46918 1.64063 10.4746 1.64062 12.5213C1.64062 14.5681 2.24499 16.5735 3.38464 18.3085C4.52429 20.0434 6.15325 21.4379 8.08535 22.3325C10.0174 23.2271 12.1747 23.5857 14.3106 23.3674C16.4465 23.1491 18.4749 22.3627 20.1639 21.098C18.7998 20.0779 17.6972 18.7754 16.9396 17.2892C16.182 15.803 15.7892 14.1721 15.791 12.5198Z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#F79E1B",
    d: "M37.5944 19.2799V18.9284H37.7534V18.8557H37.375V18.9284H37.5245V19.2799H37.5944ZM38.3291 19.2799V18.8557H38.2146L38.081 19.1587L37.9474 18.8557H37.833V19.2799H37.9156V18.9587L38.0397 19.2345H38.1255L38.2496 18.9587V19.2799H38.3291Z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#F79E1B",
    d: "M38.689 12.5202C38.689 14.5671 38.0845 16.5727 36.9446 18.3077C35.8048 20.0427 34.1755 21.4371 32.2432 22.3316C30.3109 23.2261 28.1534 23.5845 26.0173 23.3659C23.8813 23.1473 21.8529 22.3604 20.1641 21.0954C21.5272 20.0746 22.6293 18.7723 23.387 17.2866C24.1448 15.8009 24.5386 14.1706 24.5386 12.5187C24.5386 10.8668 24.1448 9.23653 23.387 7.75081C22.6293 6.26509 21.5272 4.96275 20.1641 3.94205C21.8529 2.67696 23.8813 1.89014 26.0173 1.67153C28.1534 1.45292 30.3109 1.81133 32.2432 2.7058C34.1755 3.60028 35.8048 4.99472 36.9446 6.72972C38.0845 8.46473 38.689 10.4703 38.689 12.5172V12.5202Z"
  })));
};

var VisaIcon = function VisaIcon(_ref2) {
  var disabled = _ref2.disabled;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, disabled ? /*#__PURE__*/_react.default.createElement("svg", {
    width: "40",
    height: "24",
    viewBox: "0 0 40 24",
    fill: "none"
  }, /*#__PURE__*/_react.default.createElement("path", {
    d: "M15.9614 6.64905L13.9355 18.2402H17.1755L19.203 6.64905H15.9614Z",
    fill: "#ADB0B2"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M11.2187 6.66223L8.04542 14.567L7.70708 13.3735C7.08125 11.9354 5.30458 9.86998 3.21875 8.56835L6.12042 18.2347L9.54875 18.229L14.6512 6.65979L11.2187 6.66223Z",
    fill: "#ADB0B2"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M6.47667 7.49149C6.28833 6.78543 5.7425 6.57499 5.065 6.5498H0.0416667L0 6.78056C3.90917 7.70518 6.49583 9.93306 7.56917 12.6119L6.47667 7.49149Z",
    fill: "#ADB0B2"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M25.7698 8.87157C26.8298 8.85532 27.5981 9.08119 28.1948 9.31519L28.4873 9.44925L28.9256 6.937C28.284 6.70219 27.2781 6.45032 26.0231 6.45032C22.8215 6.45032 20.5648 8.0225 20.5473 10.2756C20.5265 11.9404 22.1548 12.8699 23.3848 13.4248C24.6473 13.9936 25.0706 14.3551 25.0648 14.8629C25.0548 15.6389 24.0581 15.9948 23.1273 15.9948C21.8298 15.9948 21.1406 15.8201 20.0765 15.3878L19.659 15.2026L19.2031 17.7969C19.9615 18.1211 21.3606 18.3998 22.8131 18.4144C26.219 18.4144 28.4323 16.8609 28.4556 14.4534C28.4698 13.1364 27.6056 12.1313 25.7331 11.3066C24.5998 10.7688 23.9065 10.4113 23.9131 9.8685C23.9131 9.38669 24.5015 8.87157 25.7698 8.87157Z",
    fill: "#ADB0B2"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M37.2402 6.66211H34.7368C33.9593 6.66211 33.381 6.86848 33.0393 7.62411L28.2285 18.2467H31.631C31.631 18.2467 32.186 16.8184 32.3118 16.5055C32.6843 16.5055 35.9902 16.5104 36.461 16.5104C36.5577 16.915 36.856 18.2467 36.856 18.2467H39.8619L37.2402 6.66211ZM33.2444 14.133C33.511 13.4676 34.5352 10.8936 34.5352 10.8936C34.5177 10.9253 34.7993 10.2233 34.9668 9.78698L35.1852 10.7864C35.1852 10.7864 35.806 13.5537 35.936 14.133H33.2444Z",
    fill: "#ADB0B2"
  })) : /*#__PURE__*/_react.default.createElement("svg", {
    width: "40",
    height: "24",
    viewBox: "0 0 40 24",
    fill: "none"
  }, /*#__PURE__*/_react.default.createElement("defs", null, /*#__PURE__*/_react.default.createElement("linearGradient", {
    id: "paint0_linear",
    x1: "-5.43022e-08",
    y1: "6",
    x2: "40",
    y2: "18",
    gradientUnits: "userSpaceOnUse"
  }, /*#__PURE__*/_react.default.createElement("stop", {
    stopColor: "#1A1F59"
  }), /*#__PURE__*/_react.default.createElement("stop", {
    offset: "1",
    stopColor: "#3B4B9F"
  })), /*#__PURE__*/_react.default.createElement("linearGradient", {
    id: "paint1_linear",
    x1: "-5.43022e-08",
    y1: "6",
    x2: "40",
    y2: "18",
    gradientUnits: "userSpaceOnUse"
  }, /*#__PURE__*/_react.default.createElement("stop", {
    stopColor: "#1A1F59"
  }), /*#__PURE__*/_react.default.createElement("stop", {
    offset: "1",
    stopColor: "#3B4B9F"
  })), /*#__PURE__*/_react.default.createElement("linearGradient", {
    id: "paint2_linear",
    x1: "-5.43022e-08",
    y1: "6",
    x2: "40",
    y2: "18",
    gradientUnits: "userSpaceOnUse"
  }, /*#__PURE__*/_react.default.createElement("stop", {
    stopColor: "#1A1F59"
  }), /*#__PURE__*/_react.default.createElement("stop", {
    offset: "1",
    stopColor: "#3B4B9F"
  })), /*#__PURE__*/_react.default.createElement("linearGradient", {
    id: "paint3_linear",
    x1: "-5.43022e-08",
    y1: "6",
    x2: "40",
    y2: "18",
    gradientUnits: "userSpaceOnUse"
  }, /*#__PURE__*/_react.default.createElement("stop", {
    stopColor: "#1A1F59"
  }), /*#__PURE__*/_react.default.createElement("stop", {
    offset: "1",
    stopColor: "#3B4B9F"
  })), /*#__PURE__*/_react.default.createElement("linearGradient", {
    id: "paint4_linear",
    x1: "-5.43022e-08",
    y1: "6",
    x2: "40",
    y2: "18",
    gradientUnits: "userSpaceOnUse"
  }, /*#__PURE__*/_react.default.createElement("stop", {
    stopColor: "#1A1F59"
  }), /*#__PURE__*/_react.default.createElement("stop", {
    offset: "1",
    stopColor: "#3B4B9F"
  }))), /*#__PURE__*/_react.default.createElement("path", {
    d: "M15.961 6.64896L13.9351 18.2401H17.1751L19.2026 6.64896H15.961Z",
    fill: "url(#paint0_linear)"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M11.2182 6.66211L8.04485 14.5669L7.70651 13.3734C7.08068 11.9352 5.30401 9.86985 3.21818 8.56823L6.11985 18.2345L9.54818 18.2289L14.6507 6.65967L11.2182 6.66211Z",
    fill: "url(#paint1_linear)"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M6.47667 7.49146C6.28833 6.7854 5.7425 6.57496 5.065 6.54977H0.0416667L0 6.78052C3.90917 7.70515 6.49583 9.93302 7.56917 12.6118L6.47667 7.49146Z",
    fill: "url(#paint2_linear)"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M25.7691 8.87145C26.8291 8.8552 27.5975 9.08107 28.1941 9.31507L28.4866 9.44913L28.925 6.93688C28.2833 6.70207 27.2775 6.4502 26.0225 6.4502C22.8208 6.4502 20.5641 8.02238 20.5466 10.2754C20.5258 11.9403 22.1541 12.8698 23.3841 13.4247C24.6466 13.9934 25.07 14.355 25.0641 14.8628C25.0541 15.6388 24.0575 15.9946 23.1266 15.9946C21.8291 15.9946 21.14 15.8199 20.0758 15.3877L19.6583 15.2024L19.2025 17.7968C19.9608 18.1209 21.36 18.3996 22.8125 18.4143C26.2183 18.4143 28.4316 16.8608 28.455 14.4533C28.4691 13.1363 27.605 12.1312 25.7325 11.3065C24.5991 10.7686 23.9058 10.4111 23.9125 9.86838C23.9125 9.38657 24.5008 8.87145 25.7691 8.87145Z",
    fill: "url(#paint3_linear)"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M37.24 6.66205H34.7367C33.9592 6.66205 33.3809 6.86842 33.0392 7.62405L28.2284 18.2467H31.6309C31.6309 18.2467 32.1859 16.8183 32.3117 16.5055C32.6842 16.5055 35.99 16.5104 36.4608 16.5104C36.5575 16.915 36.8559 18.2467 36.8559 18.2467H39.8617L37.24 6.66205ZM33.2442 14.133C33.5109 13.4675 34.535 10.8935 34.535 10.8935C34.5175 10.9252 34.7992 10.2232 34.9667 9.78692L35.185 10.7863C35.185 10.7863 35.8059 13.5537 35.9359 14.133H33.2442Z",
    fill: "url(#paint4_linear)"
  })));
};

var CardTypeBlock = function CardTypeBlock(_ref3) {
  var cardType = _ref3.cardType,
      disabled = _ref3.disabled,
      rest = _objectWithoutProperties(_ref3, ["cardType", "disabled"]);

  return /*#__PURE__*/_react.default.createElement("div", _extends({
    className: 'pcb-card-icon'
  }, rest), !cardType || cardType === 'visa' ? /*#__PURE__*/_react.default.createElement(VisaIcon, {
    disabled: disabled
  }) : null, !cardType || cardType === 'master' ? /*#__PURE__*/_react.default.createElement(MasterCardIcon, {
    disabled: disabled
  }) : null);
};

var BankCard = function BankCard(_ref4) {
  var formType = _ref4.formType,
      width = _ref4.width,
      disabled = _ref4.disabled,
      showOnly = _ref4.showOnly,
      onFieldsChange = _ref4.onFieldsChange,
      onFinish = _ref4.onFinish,
      onFinishFailed = _ref4.onFinishFailed,
      onValuesChange = _ref4.onValuesChange;

  var _Form$useForm = _form.default.useForm(),
      _Form$useForm2 = _slicedToArray(_Form$useForm, 1),
      form = _Form$useForm2[0];

  var _useState = (0, _react.useState)(null),
      _useState2 = _slicedToArray(_useState, 2),
      cardType = _useState2[0],
      setCardType = _useState2[1];

  var _useState3 = (0, _react.useState)({
    number: '',
    date: '',
    code: ''
  }),
      _useState4 = _slicedToArray(_useState3, 2),
      cardInfo = _useState4[0],
      setCardInfo = _useState4[1];

  var onChangeCode = function onChangeCode(val) {
    return setCardInfo(_objectSpread(_objectSpread({}, cardInfo), {}, {
      code: val
    }));
  };

  var onChangeDate = function onChangeDate(val) {
    return setCardInfo(_objectSpread(_objectSpread({}, cardInfo), {}, {
      date: val
    }));
  };

  var validateOnChangeCardNumber = function validateOnChangeCardNumber(rule, val) {
    var temp = val || '';
    var value = temp.replace(/(X| )/gi, '');

    if (!!value && !/^[3-6](\d+)?$/.test(value)) {
      setCardType(null);
      return Promise.reject('Card number must begin with a digit 3, 4, 5 or 6. Please, try again.');
    }

    if (/^4(\d+)?$/.test(value)) {
      setCardType('visa');
      return Promise.resolve();
    }

    if (/^5[1-5](\d+)?$/.test(value)) {
      setCardType('master');
      return Promise.resolve();
    }

    if (value && value.length >= 2) {
      setCardType(null);
      return Promise.reject('Invalid card number');
    }

    setCardType(null);
    return Promise.resolve();
  };

  var checkExpiryDate = /*#__PURE__*/function () {
    var _ref5 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(rule, value) {
      var today, today_mm, today_yy, mm, yy;
      return regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              if (value) {
                _context.next = 2;
                break;
              }

              return _context.abrupt("return", Promise.reject('Expiry date is required'));

            case 2:
              today = new Date(); // gets the current date

              today_mm = today.getMonth() + 1; // extracts the month portion

              today_yy = today.getFullYear() % 100; // extracts the year portion and changes it from yyyy to yy format

              if (today_mm < 10) {
                // if today's month is less than 10
                today_mm = "0".concat(today_mm); // prefix it with a '0' to make it 2 digits
              }

              mm = value.substring(0, 2); // get the mm portion of the expiryDate (first two characters)

              yy = value.substring(3); // get the yy portion of the expiryDate (from index 3 to end)

              if (!(mm <= 0 || mm > 12 || value.indexOf('_') >= 0)) {
                _context.next = 10;
                break;
              }

              return _context.abrupt("return", Promise.reject('Invalid expiry date'));

            case 10:
              if (!(yy < today_yy || yy == today_yy && mm < today_mm)) {
                _context.next = 12;
                break;
              }

              return _context.abrupt("return", Promise.reject('Expiration date is in the past'));

            case 12:
              return _context.abrupt("return", Promise.resolve());

            case 13:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    }));

    return function checkExpiryDate(_x, _x2) {
      return _ref5.apply(this, arguments);
    };
  }();

  return /*#__PURE__*/_react.default.createElement(_form.default, {
    layout: 'vertical',
    form: form,
    onValuesChange: onValuesChange,
    onFieldsChange: onFieldsChange,
    onFinish: onFinish,
    onFinishFailed: onFinishFailed
  }, formType === 'form' ? /*#__PURE__*/_react.default.createElement("div", {
    className: 'pcb-form-type-wrap',
    style: {
      width: width
    }
  }, /*#__PURE__*/_react.default.createElement(CardTypeBlock, {
    cardType: cardType,
    disabled: disabled,
    style: {
      justifyContent: 'flex-end',
      marginBottom: 12
    }
  }), /*#__PURE__*/_react.default.createElement(_form.default.Item, {
    label: "Card number",
    name: "card-number" // normalize={value => value.replace(/(X| )/gi, '')}
    ,
    rules: [{
      validateTrigger: 'onChange',
      validator: validateOnChangeCardNumber
    }, {
      required: true,
      validateTrigger: 'onBlur',
      validator: function () {
        var _validator = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2(_, val) {
          return regeneratorRuntime.wrap(function _callee2$(_context2) {
            while (1) {
              switch (_context2.prev = _context2.next) {
                case 0:
                  if (val) {
                    _context2.next = 4;
                    break;
                  }

                  _context2.next = 3;
                  return Promise.reject('Card Number is required');

                case 3:
                  return _context2.abrupt("return", _context2.sent);

                case 4:
                  return _context2.abrupt("return", Promise.resolve());

                case 5:
                case "end":
                  return _context2.stop();
              }
            }
          }, _callee2);
        }));

        function validator(_x3, _x4) {
          return _validator.apply(this, arguments);
        }

        return validator;
      }()
    }]
  }, /*#__PURE__*/_react.default.createElement(_inputMask.default, {
    mask: "9999 9999 9999 9999",
    placeholder: "XXXX XXXX XXXX XXXX",
    maskChar: 'X',
    disabled: disabled
  })), showOnly === 'card-date' && /*#__PURE__*/_react.default.createElement(_form.default.Item, {
    label: "Expiry date",
    name: "expiry-date" // normalize={value => value.replace(/(_|\/)/gi, '')}
    ,
    rules: [{
      validateTrigger: 'onChange',
      validator: function () {
        var _validator2 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee3(rule, val) {
          var temp;
          return regeneratorRuntime.wrap(function _callee3$(_context3) {
            while (1) {
              switch (_context3.prev = _context3.next) {
                case 0:
                  temp = val || '';

                  if (!(temp.replace(/(_|\/)/gi, '').length >= 4)) {
                    _context3.next = 5;
                    break;
                  }

                  _context3.next = 4;
                  return checkExpiryDate(rule, val);

                case 4:
                  return _context3.abrupt("return", _context3.sent);

                case 5:
                  return _context3.abrupt("return", Promise.resolve());

                case 6:
                case "end":
                  return _context3.stop();
              }
            }
          }, _callee3);
        }));

        function validator(_x5, _x6) {
          return _validator2.apply(this, arguments);
        }

        return validator;
      }()
    }, {
      required: true,
      validateTrigger: 'onBlur',
      validator: function () {
        var _validator3 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee4(rule, val) {
          var temp;
          return regeneratorRuntime.wrap(function _callee4$(_context4) {
            while (1) {
              switch (_context4.prev = _context4.next) {
                case 0:
                  temp = val || '';

                  if (!(temp.replace(/(_|\/)/gi, '').length < 4)) {
                    _context4.next = 3;
                    break;
                  }

                  return _context4.abrupt("return", Promise.reject('Expiry date is required'));

                case 3:
                  return _context4.abrupt("return", Promise.resolve());

                case 4:
                case "end":
                  return _context4.stop();
              }
            }
          }, _callee4);
        }));

        function validator(_x7, _x8) {
          return _validator3.apply(this, arguments);
        }

        return validator;
      }()
    }]
  }, /*#__PURE__*/_react.default.createElement(_ExpiryDateInput.default, {
    mask: "99/99",
    placeholder: "MM/YY",
    disabled: disabled,
    maskChar: '_',
    onChange: onChangeDate,
    value: cardInfo.date
  })), showOnly !== 'card' && showOnly !== 'card-date' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_row.default, {
    gutter: [16, 0]
  }, /*#__PURE__*/_react.default.createElement(_col.default, {
    span: 12
  }, /*#__PURE__*/_react.default.createElement(_form.default.Item, {
    label: "Expiry date",
    name: "expiry-date" // normalize={value => value.replace(/(_|\/)/gi, '')}
    ,
    rules: [{
      validateTrigger: 'onChange',
      validator: function () {
        var _validator4 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee5(rule, val) {
          var temp;
          return regeneratorRuntime.wrap(function _callee5$(_context5) {
            while (1) {
              switch (_context5.prev = _context5.next) {
                case 0:
                  temp = val || '';

                  if (!(temp.replace(/(_|\/)/gi, '').length >= 4)) {
                    _context5.next = 5;
                    break;
                  }

                  _context5.next = 4;
                  return checkExpiryDate(rule, val);

                case 4:
                  return _context5.abrupt("return", _context5.sent);

                case 5:
                  return _context5.abrupt("return", Promise.resolve());

                case 6:
                case "end":
                  return _context5.stop();
              }
            }
          }, _callee5);
        }));

        function validator(_x9, _x10) {
          return _validator4.apply(this, arguments);
        }

        return validator;
      }()
    }, {
      required: true,
      validateTrigger: 'onBlur',
      validator: function () {
        var _validator5 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee6(rule, val) {
          var temp;
          return regeneratorRuntime.wrap(function _callee6$(_context6) {
            while (1) {
              switch (_context6.prev = _context6.next) {
                case 0:
                  temp = val || '';

                  if (!(temp.replace(/(_|\/)/gi, '').length < 4)) {
                    _context6.next = 3;
                    break;
                  }

                  return _context6.abrupt("return", Promise.reject('Expiry date is required'));

                case 3:
                  return _context6.abrupt("return", Promise.resolve());

                case 4:
                case "end":
                  return _context6.stop();
              }
            }
          }, _callee6);
        }));

        function validator(_x11, _x12) {
          return _validator5.apply(this, arguments);
        }

        return validator;
      }()
    }]
  }, /*#__PURE__*/_react.default.createElement(_ExpiryDateInput.default, {
    mask: "99/99",
    placeholder: "MM/YY",
    disabled: disabled,
    maskChar: '_',
    onChange: onChangeDate,
    value: cardInfo.date
  }))), /*#__PURE__*/_react.default.createElement(_col.default, {
    span: 12
  }, /*#__PURE__*/_react.default.createElement(_form.default.Item, {
    label: cardType === 'visa' ? 'CVV2' : cardType === 'master' ? 'CVC2' : 'Secure code',
    name: "cvc-code",
    className: "code-field",
    rules: [{
      required: true,
      validateTrigger: 'onBlur',
      validator: function () {
        var _validator6 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee7(_, value) {
          return regeneratorRuntime.wrap(function _callee7$(_context7) {
            while (1) {
              switch (_context7.prev = _context7.next) {
                case 0:
                  if (value) {
                    _context7.next = 2;
                    break;
                  }

                  return _context7.abrupt("return", Promise.reject('Secure code is required'));

                case 2:
                  if (!(value.length !== 3)) {
                    _context7.next = 4;
                    break;
                  }

                  return _context7.abrupt("return", Promise.reject('Secure code must have 3 digits'));

                case 4:
                case "end":
                  return _context7.stop();
              }
            }
          }, _callee7);
        }));

        function validator(_x13, _x14) {
          return _validator6.apply(this, arguments);
        }

        return validator;
      }()
    }]
  }, /*#__PURE__*/_react.default.createElement(_SecureCodeInput.default, {
    placeholder: "***",
    maxLength: 3,
    disabled: disabled,
    onChange: onChangeCode,
    value: cardInfo.code,
    code: cardInfo.code,
    suffix: /*#__PURE__*/_react.default.createElement(_popover.default, {
      placement: "bottomRight",
      content: /*#__PURE__*/_react.default.createElement("div", {
        className: 'pcb-popover-content'
      }, /*#__PURE__*/_react.default.createElement("span", null, "The 3 digits on the back of your card"), /*#__PURE__*/_react.default.createElement("div", {
        className: "back-card"
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "scan-line"
      }), /*#__PURE__*/_react.default.createElement("div", {
        className: "white-line"
      }), /*#__PURE__*/_react.default.createElement("div", {
        className: "secure-code"
      }, "123")))
    }, /*#__PURE__*/_react.default.createElement(QuestionCircleOutlined, null))
  })))), /*#__PURE__*/_react.default.createElement(_form.default.Item, {
    label: "Name on card",
    name: "card-name",
    rules: [{
      required: true,
      message: 'Name on card is required'
    }]
  }, /*#__PURE__*/_react.default.createElement(_input.default, {
    disabled: disabled
  })))) : /*#__PURE__*/_react.default.createElement("div", {
    className: "pcb-card-wrap".concat(disabled ? ' pcb-card-wrap-disabled' : '')
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: 'pcb-styled-card'
  }, /*#__PURE__*/_react.default.createElement(CardTypeBlock, {
    cardType: cardType,
    disabled: disabled,
    style: {
      position: 'absolute',
      right: 24,
      top: 24
    }
  }), /*#__PURE__*/_react.default.createElement(_form.default.Item, {
    label: "Card number",
    name: "card-number" // normalize={value => value.replace(/(X| )/gi, '')}
    ,
    rules: [{
      validateTrigger: 'onChange',
      validator: validateOnChangeCardNumber
    }, {
      required: true,
      validateTrigger: 'onBlur',
      validator: function () {
        var _validator7 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee8(_, val) {
          return regeneratorRuntime.wrap(function _callee8$(_context8) {
            while (1) {
              switch (_context8.prev = _context8.next) {
                case 0:
                  if (val) {
                    _context8.next = 4;
                    break;
                  }

                  _context8.next = 3;
                  return Promise.reject('Card Number is required');

                case 3:
                  return _context8.abrupt("return", _context8.sent);

                case 4:
                  return _context8.abrupt("return", Promise.resolve());

                case 5:
                case "end":
                  return _context8.stop();
              }
            }
          }, _callee8);
        }));

        function validator(_x15, _x16) {
          return _validator7.apply(this, arguments);
        }

        return validator;
      }()
    }]
  }, /*#__PURE__*/_react.default.createElement(_inputMask.default, {
    mask: "9999 9999 9999 9999",
    placeholder: "XXXX XXXX XXXX XXXX",
    maskChar: 'X',
    disabled: disabled
  })), /*#__PURE__*/_react.default.createElement(_form.default.Item, {
    label: "Expiry date",
    name: "expiry-date",
    disabled: disabled // normalize={value => value.replace(/(_|\/)/gi, '')}
    ,
    rules: [{
      validateTrigger: 'onChange',
      validator: function () {
        var _validator8 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee9(rule, val) {
          var temp;
          return regeneratorRuntime.wrap(function _callee9$(_context9) {
            while (1) {
              switch (_context9.prev = _context9.next) {
                case 0:
                  temp = val || '';

                  if (!(temp.replace(/(_|\/)/gi, '').length >= 4)) {
                    _context9.next = 5;
                    break;
                  }

                  _context9.next = 4;
                  return checkExpiryDate(rule, val);

                case 4:
                  return _context9.abrupt("return", _context9.sent);

                case 5:
                  return _context9.abrupt("return", Promise.resolve());

                case 6:
                case "end":
                  return _context9.stop();
              }
            }
          }, _callee9);
        }));

        function validator(_x17, _x18) {
          return _validator8.apply(this, arguments);
        }

        return validator;
      }()
    }, {
      required: true,
      validateTrigger: 'onBlur',
      validator: function () {
        var _validator9 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee10(rule, val) {
          var temp;
          return regeneratorRuntime.wrap(function _callee10$(_context10) {
            while (1) {
              switch (_context10.prev = _context10.next) {
                case 0:
                  temp = val || '';

                  if (!(temp.replace(/(_|\/)/gi, '').length < 4)) {
                    _context10.next = 3;
                    break;
                  }

                  return _context10.abrupt("return", Promise.reject('Expiry date is required'));

                case 3:
                  return _context10.abrupt("return", Promise.resolve());

                case 4:
                case "end":
                  return _context10.stop();
              }
            }
          }, _callee10);
        }));

        function validator(_x19, _x20) {
          return _validator9.apply(this, arguments);
        }

        return validator;
      }()
    }]
  }, /*#__PURE__*/_react.default.createElement(_ExpiryDateInput.default, {
    mask: "99/99",
    placeholder: "MM/YY",
    maskChar: '_',
    style: {
      width: 96
    },
    onChange: onChangeDate,
    value: cardInfo.date,
    disabled: disabled
  })), /*#__PURE__*/_react.default.createElement("svg", {
    className: "footer-line",
    viewBox: "0 0 331 8",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, /*#__PURE__*/_react.default.createElement("path", {
    d: "M0 0H56.7429V8H8.00001C3.58173 8 0 4.41828 0 0Z",
    fill: yellow.primary
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M55.5605 0H112.303V8H55.5605V0Z",
    fill: orange.primary
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M109.939 0H166.682V8H109.939V0Z",
    fill: red.primary
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M164.318 0H221.061V8H164.318V0Z",
    fill: green.primary
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M218.697 0H275.44V8H218.697V0Z",
    fill: purple.primary
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M274.258 0H331.001C331.001 4.41828 327.419 8 323.001 8H274.258V0Z",
    fill: blue.primary
  }))), /*#__PURE__*/_react.default.createElement("div", {
    className: "pcb-styled-card pcb-styled-card-back-card"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "gray-line"
  }), /*#__PURE__*/_react.default.createElement(_form.default.Item, {
    label: cardType === 'visa' ? 'CVV2' : cardType === 'master' ? 'CVC2' : 'Secure code',
    name: "cvc-code",
    className: "code-field",
    rules: [{
      required: true,
      validateTrigger: 'onBlur',
      validator: function () {
        var _validator10 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee11(_, value) {
          return regeneratorRuntime.wrap(function _callee11$(_context11) {
            while (1) {
              switch (_context11.prev = _context11.next) {
                case 0:
                  if (value) {
                    _context11.next = 2;
                    break;
                  }

                  return _context11.abrupt("return", Promise.reject('Secure code is required'));

                case 2:
                  if (!(value.length !== 3)) {
                    _context11.next = 4;
                    break;
                  }

                  return _context11.abrupt("return", Promise.reject('Secure code must have 3 digits'));

                case 4:
                case "end":
                  return _context11.stop();
              }
            }
          }, _callee11);
        }));

        function validator(_x21, _x22) {
          return _validator10.apply(this, arguments);
        }

        return validator;
      }()
    }]
  }, /*#__PURE__*/_react.default.createElement(_SecureCodeInput.default, {
    placeholder: "***",
    maxLength: 3,
    disabled: disabled,
    style: {
      width: 96
    },
    onChange: onChangeCode,
    value: cardInfo.code,
    code: cardInfo.code,
    suffix: /*#__PURE__*/_react.default.createElement(_popover.default, {
      placement: "bottomRight",
      content: /*#__PURE__*/_react.default.createElement("div", {
        className: 'pcb-popover-content'
      }, /*#__PURE__*/_react.default.createElement("span", null, "The 3 digits on the back of your card"), /*#__PURE__*/_react.default.createElement("div", {
        className: "back-card"
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "scan-line"
      }), /*#__PURE__*/_react.default.createElement("div", {
        className: "white-line"
      }), /*#__PURE__*/_react.default.createElement("div", {
        className: "secure-code"
      }, "123")))
    }, /*#__PURE__*/_react.default.createElement(QuestionCircleOutlined, null))
  })), /*#__PURE__*/_react.default.createElement("svg", {
    className: "footer-line",
    viewBox: "0 0 331 8",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, /*#__PURE__*/_react.default.createElement("path", {
    d: "M0 0H56.7429V8H8.00001C3.58173 8 0 4.41828 0 0Z",
    fill: yellow.primary
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M55.5605 0H112.303V8H55.5605V0Z",
    fill: orange.primary
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M109.939 0H166.682V8H109.939V0Z",
    fill: red.primary
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M164.318 0H221.061V8H164.318V0Z",
    fill: green.primary
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M218.697 0H275.44V8H218.697V0Z",
    fill: purple.primary
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M274.258 0H331.001C331.001 4.41828 327.419 8 323.001 8H274.258V0Z",
    fill: blue.primary
  })))), /*#__PURE__*/_react.default.createElement(_form.default.Item, null, /*#__PURE__*/_react.default.createElement(_button.default, {
    type: "primary",
    htmlType: "submit",
    disabled: disabled
  }, "Submit")));
};

BankCard.propTypes = {
  formType: _propTypes.default.oneOf(['card', 'form']),
  width: _propTypes.default.number,
  disabled: _propTypes.default.bool,
  onFieldsChange: _propTypes.default.func,
  onFinish: _propTypes.default.func,
  onFinishFailed: _propTypes.default.func,
  onValuesChange: _propTypes.default.func,
  showOnly: _propTypes.default.oneOf(['card', 'card-date'])
};
BankCard.defaultProps = {
  formType: 'card',
  width: 280,
  disabled: false
};
var _default = BankCard;
exports.default = _default;