"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _input = _interopRequireDefault(require("../input"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

var SecureCodeInput = function SecureCodeInput(props) {
  var onChange = props.onChange,
      code = props.code;

  var changeHandler = function changeHandler(e) {
    var value = e.target.value;
    var reg = /^\d{1,3}?$/;

    if (!isNaN(value) && reg.test(value) || value === '') {
      // eslint-disable-line no-restricted-globals
      onChange(value);
    }
  };

  return /*#__PURE__*/_react.default.createElement(_input.default, _extends({}, props, {
    value: code,
    onChange: changeHandler
  }));
};

var _default = SecureCodeInput;
exports.default = _default;