"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireWildcard(require("react"));

var _inputMask = _interopRequireDefault(require("../input-mask"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

var ExpiryDateInput = function ExpiryDateInput(props) {
  var onChange = props.onChange;
  var inputEl = (0, _react.useRef)(null);

  var setSelectionRange = function setSelectionRange(input, selectionStart, selectionEnd) {
    if (input.setSelectionRange) {
      input.focus();
      input.setSelectionRange(selectionStart, selectionEnd);
    } else if (input.createTextRange) {
      var range = input.createTextRange();
      range.collapse(true);
      range.moveEnd('character', selectionEnd);
      range.moveStart('character', selectionStart);
      range.select();
    }
  };

  var setCaretToPos = function setCaretToPos(input, pos) {
    setTimeout(function () {
      setSelectionRange(input, pos, pos);
    }, 0);
  };

  var changeHandler = function changeHandler(e) {
    var value = e.target.value;
    var temp = value.replace(/(_)/gi, '').split('/');
    var result = value;

    if (temp[0][0] >= 2) {
      result = "0".concat(temp[0], "/").concat(temp[1]);
      if (inputEl.current) setCaretToPos(inputEl.current.input, 3);
    }

    var temp2 = value.replace(/(_)/gi, '').split('/');

    if (temp2[0] > 12) {
      result = "12/".concat(temp[1]);
      if (inputEl.current) setCaretToPos(inputEl.current.input, 3);
    }

    onChange(result);
  };

  return /*#__PURE__*/_react.default.createElement(_inputMask.default, _extends({}, props, {
    ref: inputEl,
    onChange: changeHandler
  }));
};

var _default = ExpiryDateInput;
exports.default = _default;