# ProCredit Design System 

## Step by Step Documentation

- 🇺🇸 English: https://pcb-design-system.artkai.dev

## See more

- [antd](http://github.com/ant-design/ant-design/)
- [reactjs](https://reactjs.org/)

---

## Instruction for use:

#`IMPORTANT: You do not have to compile this package, just use it !`

This project is npm package, it can be installed from git repository or from directory.

(recommended) Using git repository `you must to add your ssh key to a repository first`
```bash
$ npm i --save procredit-bank-design-system@git+ssh://git@bitbucket.org/artkaidev/design-system.git#staging
```

or install from directory `if you got an zip or rar archive you must to unpackege this`
```bash
$ npm i --save  file:procredit-bank-design-system
```

---
### After install the package to your project you can use this.
 
#### Examples:

Button:
```bash
import { Button } from 'procredit-bank-design-system';

<Button>
  Click
</Button>  
```

Icons:
```bash
import { Icons, Button } from 'procredit-bank-design-system';
const { LoadingOutlined } = Icons;

<Button>
  <LoadingOutlined />
  Button with icon
</Button>  
```

Layout:
```bash
import { Layout, Button, Icons } from 'procredit-bank-design-system';
const { Header, Footer, Sider, Content } = Layout
const { LoadingOutlined } = Icons

<Layout>
  <Header>Header</Header>
  <Content>
    Content
    <Button><LoadingOutlined /> Button with icon</Button> 
  </Content>
  <Footer>Footer</Footer>
</Layout>
```
